/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.eg.org.slf4j.Logger;
import com.egurkha.util.EgSorter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class RedisClientTest_DD
extends EgTest_DD {
    boolean uploadStatus = false;
    protected static final Logger logger = RedisBase.logger;
    public static final Hashtable flagDiscriptionTable = new Hashtable();

    static {
        flagDiscriptionTable.put("O", "Slave in monitor mode");
        flagDiscriptionTable.put("S", "Normal slave server");
        flagDiscriptionTable.put("M", "Master");
        flagDiscriptionTable.put("x", "MULTI/EXEC context");
        flagDiscriptionTable.put("b", "Waiting in a blocking operation");
        flagDiscriptionTable.put("i", "Waiting for a VM I/O");
        flagDiscriptionTable.put("d", "A watched keys has been modified - EXEC will fail");
        flagDiscriptionTable.put("c", "Connection to be closed after writing entire reply");
        flagDiscriptionTable.put("u", "Unblocked");
        flagDiscriptionTable.put("U", "Connected via a Unix domain socket");
        flagDiscriptionTable.put("r", "Readonly mode against a cluster node");
        flagDiscriptionTable.put("A", "Connection to be closed ASAP");
        flagDiscriptionTable.put("N", "No specific flag set");
    }

    public RedisClientTest_DD(String entity) {
        super(entity);
    }

    private ArrayList getClientDetails(EgTest test, boolean blockedClients) {
        RedisClientTest clientTest = (RedisClientTest)test;
        String clientList = clientTest.getclientList();
        logger.debug("[RedisClientTest_DD] [getClientDetails] The Client List is :  \n" + clientList);
        StringTokenizer lineTokenizer = new StringTokenizer(clientList, "\n");
        ArrayList clientsDetails = new ArrayList();
        while (lineTokenizer.hasMoreTokens()) {
            String lineString = lineTokenizer.nextToken().trim();
            if (lineString.contains("cmd=replconf")) continue;
            boolean blocked = false;
            StringTokenizer spaceTokenizer = new StringTokenizer(lineString, " ");
            ArrayList<String> innerTable = new ArrayList<String>();
            while (spaceTokenizer.hasMoreTokens()) {
                String tokenString = spaceTokenizer.nextToken();
                int equal_index = tokenString.indexOf("=");
                if (equal_index <= 0) continue;
                String key = tokenString.substring(0, equal_index);
                String value = tokenString.substring(equal_index + 1);
                if (key.equals("flags") && value.equalsIgnoreCase("b")) {
                    blocked = true;
                }
                innerTable.add(value);
            }
            if (blockedClients) {
                if (!blocked) continue;
                clientsDetails.add(innerTable);
                continue;
            }
            clientsDetails.add(innerTable);
        }
        return clientsDetails;
    }

    public boolean generalClientList(EgTest test, String reportingName, String portNo, boolean isBlocked) {
        ArrayList clientsList = null;
        boolean success = false;
        try {
            clientsList = this.getClientDetails(test, isBlocked);
            if (clientsList == null || clientsList.size() == 0) {
                return success;
            }
            logger.debug("[" + reportingName + ":" + portNo + "][RedisClientTest_DD] [generalClientList] The ClientDetails are " + clientsList);
            RedisClientTest redisClientTest = (RedisClientTest)test;
            int max_client = redisClientTest.getMaxClient();
            int lineCount = clientsList.size();
            max_client = lineCount > max_client ? max_client : lineCount;
            logger.debug("[" + reportingName + ":" + portNo + "][RedisClientTest_DD] [generalClientList] max_client :" + max_client);
            int totalCols = 18;
            EgSorter egSort = new EgSorter((List)clientsList, totalCols);
            ArrayList sortList = new ArrayList();
            int sortCol = 5;
            sortList = (ArrayList)egSort.sort(sortCol, "Double", "desc");
            logger.debug("[" + reportingName + ":" + portNo + "][RedisClientTest_DD] [generalClientList] The sortList are " + sortList);
            int i = 0;
            while (i < max_client) {
                String events;
                String oll;
                String multi;
                String psub;
                String sub;
                String db;
                String idle;
                String age;
                String name;
                String fd;
                ArrayList valueList = (ArrayList)sortList.get(i);
                String id = (String)valueList.get(0);
                if (id == null || id.length() == 0) {
                    id = "-";
                }
                String ipAndPort = (String)valueList.get(1);
                String ip = ipAndPort.substring(0, ipAndPort.indexOf(58));
                String port = ipAndPort.substring(ipAndPort.indexOf(58) + 1);
                if (ipAndPort == null || ipAndPort.length() == 0) {
                    ip = "-";
                    port = "-";
                }
                if ((fd = (String)valueList.get(2)) == null || fd.length() == 0) {
                    fd = "-";
                }
                if ((name = (String)valueList.get(3)) == null || name.length() == 0) {
                    name = "-";
                }
                if ((age = (String)valueList.get(4)) == null || age.length() == 0) {
                    age = "-";
                }
                if ((idle = (String)valueList.get(5)) == null || idle.length() == 0) {
                    idle = "-";
                }
                String flags = (String)valueList.get(6);
                if ((flags = (String)flagDiscriptionTable.get(flags)) == null || flags.length() == 0) {
                    flags = "-";
                }
                if ((db = (String)valueList.get(7)) == null || db.length() == 0) {
                    db = "-";
                }
                if ((sub = (String)valueList.get(8)) == null || sub.length() == 0) {
                    sub = "-";
                }
                if ((psub = (String)valueList.get(9)) == null || psub.length() == 0) {
                    psub = "-";
                }
                String string = multi = (multi = (String)valueList.get(10)).equals("-1") ? "0" : multi;
                if (multi == null || multi.length() == 0) {
                    multi = "-";
                }
                String qbuf = (String)valueList.get(11);
                if ((qbuf = EgUtils.convertMemoryValues(qbuf, "B", "MB")) == null || qbuf.length() == 0) {
                    qbuf = "-";
                }
                String qbuf_free = (String)valueList.get(12);
                qbuf_free = EgUtils.convertMemoryValues(qbuf, "B", "MB");
                if (qbuf_free == null || qbuf_free.length() == 0) {
                    qbuf_free = "-";
                }
                String obl = (String)valueList.get(13);
                if ((obl = EgUtils.convertMemoryValues(obl, "B", "MB")) == null || obl.length() == 0) {
                    obl = "-";
                }
                if ((oll = (String)valueList.get(14)) == null || oll.length() == 0) {
                    oll = "-";
                }
                String omem = (String)valueList.get(15);
                if ((omem = EgUtils.convertMemoryValues(omem, "B", "MB")) == null || omem.length() == 0) {
                    omem = "-";
                }
                if ((events = (String)valueList.get(16)) == null || events.length() == 0) {
                    events = "-";
                } else if (events.equals("r")) {
                    events = "readable";
                } else if (events.equals("w")) {
                    events = "writable";
                }
                String cmd = (String)valueList.get(17);
                if (cmd == null || cmd.length() == 0) {
                    cmd = "-";
                }
                String comp = String.valueOf(id) + fieldSep + name + fieldSep + ip + fieldSep + port + fieldSep + fd + fieldSep + db + fieldSep + age + fieldSep + idle + fieldSep + flags + fieldSep + sub + fieldSep + psub + fieldSep + multi + fieldSep + qbuf + fieldSep + qbuf_free + fieldSep + obl + fieldSep + oll + fieldSep + omem + fieldSep + events + fieldSep + cmd + fieldSep;
                logger.info("[" + reportingName + ":" + portNo + "][RedisClientTest_DD] [generalClientList] comp" + " : " + comp);
                this.addLine(comp);
                ++i;
            }
            success = true;
        }
        catch (Exception e) {
            logger.error("[" + reportingName + ":" + portNo + "][RedisClientTest_DD] [generalClientList] Exception while fetching the values", (Throwable)e);
        }
        return success;
    }

    public void Connected_clients_dd(String methodName, String measureName, String targetHost, String reportingName, String portNo, String siteName, String info, String msmtHost, String msmtTime, String state, EgTest test) {
        logger.debug("[" + reportingName + ":" + portNo + "]  RedisClientTest_DD - Test cycle START");
        boolean isBlocked = false;
        boolean success = this.generalClientList(test, reportingName, portNo, isBlocked);
        logger.debug("[" + reportingName + ":" + portNo + "]  RedisClientTest_DD - Test cycle END ");
        if (success) {
            try {
                this.uploadStatus = this.uploadResults(methodName, measureName, reportingName, portNo, siteName, info, msmtHost, msmtTime, state);
                if (!this.uploadStatus) {
                    return;
                }
            }
            catch (Exception e) {
                logger.error("Error", (Object)"Exception while uploading RedisClientTest_DD");
                return;
            }
        }
    }

    public void Blocked_clients_dd(String methodName, String measureName, String targetHost, String reportingName, String portNo, String siteName, String info, String msmtHost, String msmtTime, String state, EgTest test) {
        boolean isBlocked = true;
        boolean success = this.generalClientList(test, reportingName, portNo, isBlocked);
        logger.debug("[" + reportingName + ":" + portNo + "][RedisClientTest_DD] [Blocked_clients_dd] getting values in dd is success=" + success);
        if (success) {
            try {
                this.uploadStatus = this.uploadResults(methodName, measureName, reportingName, portNo, siteName, info, msmtHost, msmtTime, state);
                if (!this.uploadStatus) {
                    return;
                }
            }
            catch (Exception e) {
                logger.error("Error", (Object)"Exception while uploading RedisClientTest_DD");
                return;
            }
        }
    }

    public static void main(String[] args) {
        RedisClientTest test = new RedisClientTest(args);
        RedisClientTest_DD dd = new RedisClientTest_DD(null);
        dd.getClientDetails(test, false);
        dd.generalClientList(test, "RedisClientTest_DD", "6379", false);
    }
}

