/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SAPLocksTest
extends SapControlBase {
    private static String tblFunction = "EnqGetLockTable";
    private static String statFunction = "EnqGetStatistic";
    private static final ArrayList tblElemList = new ArrayList();
    private static final ArrayList statElemList = new ArrayList();
    private static final ArrayList dummyMeasList = new ArrayList();
    String ownerCurrent = "";
    String ownerMax = "";
    String argsCurrent = "";
    String argsMax = "";
    String locksCurrent = "";
    String locksHigh = "";
    String locksMax = "";
    String enqueueRequests = "";
    String enqueueRejects = "";
    String enqErrors = "";
    String DequeueRequests = "";
    String dequeueErrors = "";
    String backupRequests = "";
    String lockTime = "";
    String lockWaitTime = "";
    String lockSrvTime = "";
    int roundingFactor = 2;
    double numOwnerCurrent = 0.0;
    double numOwnerMax = 0.0;
    double currOwnerUtil = 0.0;
    double numArgsCurrent = 0.0;
    double numArgsMax = 0.0;
    double currArgsUtil = 0.0;
    double numLocksCurrent = 0.0;
    double numLocksHigh = 0.0;
    double numLocksMax = 0.0;
    double currFillUtil = 0.0;
    double highFillUtil = 0.0;
    double numEnqueueRequests = 0.0;
    double numEnqueueRejects = 0.0;
    double numEnqErrors = 0.0;
    double numDequeueRequests = 0.0;
    double numDequeueErrors = 0.0;
    double numBackupRequests = 0.0;
    double numLockTime = 0.0;
    double numLockWaitTime = 0.0;
    double numLockSrvTime = 0.0;
    double prevNumLockTime = 0.0;
    double prevNumLockWaitTime = 0.0;
    double prevNumLockSrvTime = 0.0;
    double diffNumLockTime = 0.0;
    double diffNumLockWaitTime = 0.0;
    double diffNumLockSrvTime = 0.0;
    double pctLockTime = 0.0;
    double pctLockWaitTime = 0.0;
    double pctLockSrvTime = 0.0;
    double diffNumEnqueueRequests = -5.0;
    double rateEnqueueRequests = -5.0;
    double prevNumEnqueueRequests = -5.0;
    double diffNumEnqueueRejects = -5.0;
    double rateEnqueueRejects = -5.0;
    double pctEnqOpRejects = -5.0;
    double prevNumEnqueueRejects = -5.0;
    double prevNumDequeueRequests = -5.0;
    double rateDequeueRequests = -5.0;
    double diffNumDequeueRequests = 5.0;
    double prevNumBackupRequests = -5.0;
    double rateBackupRequests = -5.0;
    double diffNumBackupRequests = -5.0;
    double diffNumEnqueueErrors = 0.0;
    double prevNumEnqueueErrors = 0.0;
    double rateEnqueueErrors = 0.0;
    double diffNumDequeueErrors = 0.0;
    double prevNumDequeueErrors = 0.0;
    double rateDequeueErrors = 0.0;

    public SAPLocksTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(27);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, true);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.getLockTableMeasures();
        if (arrayList2 == null) {
            this.addNewMeasure(dummyMeasList);
            return;
        }
        ArrayList arrayList3 = this.getLockStatisticMeasures();
        if (arrayList3 == null) {
            this.addNewMeasure(dummyMeasList);
            return;
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        this.printOut("Adding measure : " + arrayList);
        if (bl) {
            this.addNewMeasure(arrayList);
        }
    }

    public ArrayList getLockTableMeasures() {
        this.printOut("get Lock Table :");
        int n = 0;
        String string = "";
        String string2 = "";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            ArrayList arrayList = new ArrayList();
            String string3 = this.getSoapRequest(tblFunction);
            String string4 = SAPLocksTest.invokeOperation(string3, tblFunction, this.wsdlUrl, this.os_user, this.os_pass);
            this.printOut("Response String :" + string4);
            if (string4 == null || string4.trim().length() == 0) {
                this.printOut("Error  EnqGetLockTable: cannot get soap response from invokeOperation()");
                return null;
            }
            if (string4.indexOf("faultcode") >= 0 || string4.indexOf("faultstring") >= 0) {
                this.errMsg = this.getFaultMessage(string4);
                this.printOut("inside fault code ");
                this.printOut("Error EnqGetLockTable : " + this.errMsg);
                this.logToErrorFile("ERROR", this.entity, this.errMsg);
                return null;
            }
            if (string4.indexOf("lock-mode") < 0 || string4.indexOf("use-count-owner-vb") < 0) {
                this.printOut("Error EnqGetLockTable : " + string4);
                this.logToErrorFile("ERROR", this.entity, string4);
                return null;
            }
            arrayList = this.parseXML(tblElemList, string4, this.delimiter);
            this.printOut("Parsed List  :" + arrayList);
            if (arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(i).toString(), this.delimiter);
                    n = stringTokenizer.countTokens();
                    if (n != 2) {
                        this.printOut("ERROR : No of tokens are less than the elements passed for " + arrayList.get(i));
                        this.logToErrorFile("ERROR ", "No of tokens are less than the elements passed for ", arrayList.get(i).toString());
                    }
                    if ((string = stringTokenizer.nextToken()) == null || string.trim().length() == 0) {
                        this.logToErrorFile("ERROR ", "lock Mode is null or empty for ", arrayList.get(i).toString());
                        break;
                    }
                    if (string.equalsIgnoreCase("E")) {
                        string2 = stringTokenizer.nextToken();
                        d += this.getDoubleFromString(string2);
                        continue;
                    }
                    if (string.equalsIgnoreCase("X")) {
                        string2 = stringTokenizer.nextToken();
                        d2 += this.getDoubleFromString(string2);
                        continue;
                    }
                    string2 = stringTokenizer.nextToken();
                    d3 += this.getDoubleFromString(string2);
                }
            } else {
                this.logToErrorFile("Error", "EnqGetLockTable", "FaultCode=" + this.faultcode + " and FaultString =" + this.faultstring);
                this.printOut("DEBUG : FaultCode=" + this.faultcode + " and FaultString =" + this.faultstring);
            }
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(new Double(d));
            arrayList2.add(new Double(d2));
            arrayList2.add(new Double(d3));
            d4 = d + d2 + d3;
            arrayList2.add(new Double(d4));
            this.printOut("Exclusive lock count  :" + d);
            this.printOut("eXclusive non-cumulative lock count  :" + d2);
            this.printOut("Other lock count  :" + d3);
            this.printOut("All lock count  :" + d4);
            return arrayList2;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "EnqGetLockTable:computeMeasures ", exception.toString());
            this.printOut("Error : EnqGetLockTable:computeMeasures " + exception.toString());
            return null;
        }
    }

    public ArrayList getLockStatisticMeasures() {
        this.printOut("get Lock Statistics :");
        this.ownerCurrent = "";
        this.ownerMax = "";
        this.argsCurrent = "";
        this.argsMax = "";
        this.locksCurrent = "";
        this.locksHigh = "";
        this.locksMax = "";
        this.enqueueRequests = "";
        this.enqueueRejects = "";
        this.enqErrors = "";
        this.DequeueRequests = "";
        this.dequeueErrors = "";
        this.backupRequests = "";
        this.lockTime = "";
        this.lockWaitTime = "";
        this.numOwnerCurrent = 0.0;
        this.numOwnerMax = 0.0;
        this.currOwnerUtil = 0.0;
        this.numArgsCurrent = 0.0;
        this.numArgsMax = 0.0;
        this.currArgsUtil = 0.0;
        this.numLocksCurrent = 0.0;
        this.numLocksHigh = 0.0;
        this.numLocksMax = 0.0;
        this.currFillUtil = 0.0;
        this.highFillUtil = 0.0;
        this.numEnqueueRequests = 0.0;
        this.numEnqueueRejects = 0.0;
        this.numEnqErrors = 0.0;
        this.numDequeueRequests = 0.0;
        this.numDequeueErrors = 0.0;
        this.numBackupRequests = 0.0;
        this.numLockTime = 0.0;
        this.numLockWaitTime = 0.0;
        this.diffNumEnqueueRequests = -5.0;
        this.rateEnqueueRequests = -5.0;
        this.diffNumEnqueueErrors = -5.0;
        this.prevNumEnqueueErrors = -5.0;
        this.rateEnqueueErrors = -5.0;
        this.diffNumDequeueErrors = -5.0;
        this.prevNumDequeueErrors = -5.0;
        this.rateDequeueErrors = -5.0;
        this.diffNumEnqueueRejects = -5.0;
        this.rateEnqueueRejects = -5.0;
        this.pctEnqOpRejects = -5.0;
        this.rateDequeueRequests = -5.0;
        this.diffNumDequeueRequests = 5.0;
        this.rateBackupRequests = -5.0;
        this.pctLockTime = -5.0;
        this.pctLockWaitTime = -5.0;
        this.pctLockSrvTime = -5.0;
        try {
            ArrayList arrayList = new ArrayList();
            String string = this.getSoapRequest(statFunction);
            String string2 = SAPLocksTest.invokeOperation(string, statFunction, this.wsdlUrl, this.os_user, this.os_pass);
            this.printOut("Response String :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                this.printOut("Error  EnqGetLockStat: cannot get soap response from invokeOperation()");
                return null;
            }
            if (string2.indexOf("faultcode") >= 0 || string2.indexOf("faultstring") >= 0) {
                this.errMsg = this.getFaultMessage(string2);
                this.printOut("inside fault code ");
                this.printOut("Error EnqGetLockStat : " + this.errMsg);
                this.logToErrorFile("ERROR", this.entity, this.errMsg);
                return null;
            }
            if (string2.indexOf("locks-now") < 0 || string2.indexOf("locks-high") < 0 || string2.indexOf("locks-max") < 0) {
                this.printOut("Error EnqGetLockStat : " + string2);
                this.logToErrorFile("ERROR", this.entity, string2);
                return null;
            }
            arrayList = this.parseXML(statElemList, string2, this.delimiter);
            this.printOut("parsedList  :" + arrayList);
            if (arrayList.size() > 0) {
                Object object;
                if (this.timeSinceLastTest == 0.0) {
                    this.timeSinceLastTest = 300.0;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.printOut("Parsed line is " + arrayList.get(i).toString());
                    object = new StringTokenizer(arrayList.get(i).toString(), this.delimiter);
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.ownerCurrent = ((StringTokenizer)object).nextToken();
                        this.numOwnerCurrent = this.getDoubleFromString(this.ownerCurrent);
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.ownerMax = ((StringTokenizer)object).nextToken();
                        this.numOwnerMax = this.getDoubleFromString(this.ownerMax);
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.argsCurrent = ((StringTokenizer)object).nextToken();
                        this.numArgsCurrent = this.getDoubleFromString(this.argsCurrent);
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.argsMax = ((StringTokenizer)object).nextToken();
                        this.numArgsMax = this.getDoubleFromString(this.argsMax);
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.locksCurrent = ((StringTokenizer)object).nextToken();
                        this.numLocksCurrent = this.getDoubleFromString(this.locksCurrent);
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.locksHigh = ((StringTokenizer)object).nextToken();
                        this.numLocksHigh = this.getDoubleFromString(this.locksHigh);
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.locksMax = ((StringTokenizer)object).nextToken();
                        this.numLocksMax = this.getDoubleFromString(this.locksMax);
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.enqueueRequests = ((StringTokenizer)object).nextToken();
                        this.numEnqueueRequests = this.getDoubleFromString(this.enqueueRequests);
                        if (this.prevNumEnqueueRequests <= 0.0) {
                            this.prevNumEnqueueRequests = this.numEnqueueRequests;
                            this.rateEnqueueRequests = -5.0;
                        } else {
                            this.diffNumEnqueueRequests = this.numEnqueueRequests - this.prevNumEnqueueRequests;
                            if (this.diffNumEnqueueRequests > 0.0 && this.timeSinceLastTest > 0.0) {
                                this.rateEnqueueRequests = this.roundDouble(this.diffNumEnqueueRequests / this.timeSinceLastTest);
                            }
                            this.prevNumEnqueueRequests = this.numEnqueueRequests;
                        }
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.enqueueRejects = ((StringTokenizer)object).nextToken();
                        this.numEnqueueRejects = this.getDoubleFromString(this.enqueueRejects);
                        if (this.prevNumEnqueueRejects <= 0.0) {
                            this.prevNumEnqueueRejects = this.numEnqueueRejects;
                            this.rateEnqueueRejects = -5.0;
                            this.pctEnqOpRejects = -5.0;
                        } else {
                            this.diffNumEnqueueRejects = this.numEnqueueRejects - this.prevNumEnqueueRejects;
                            if (this.diffNumEnqueueRejects > 0.0 && this.timeSinceLastTest > 0.0) {
                                this.rateEnqueueRejects = this.diffNumEnqueueRejects / this.timeSinceLastTest;
                                this.pctEnqOpRejects = this.roundDouble(this.diffNumEnqueueRejects / this.diffNumEnqueueRequests * 100.0);
                            }
                            this.prevNumEnqueueRejects = this.numEnqueueRejects;
                        }
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.enqErrors = ((StringTokenizer)object).nextToken();
                        this.numEnqErrors = this.getDoubleFromString(this.enqErrors);
                        if (this.prevNumEnqueueErrors <= 0.0) {
                            this.prevNumEnqueueErrors = this.numEnqErrors;
                            this.rateEnqueueErrors = -5.0;
                        } else {
                            this.diffNumEnqueueErrors = this.numEnqErrors - this.prevNumEnqueueErrors;
                            if (this.diffNumEnqueueErrors > 0.0 && this.timeSinceLastTest > 0.0) {
                                this.rateEnqueueErrors = this.roundDouble(this.diffNumEnqueueErrors / this.timeSinceLastTest);
                            }
                            this.prevNumEnqueueErrors = this.numEnqErrors;
                        }
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.DequeueRequests = ((StringTokenizer)object).nextToken();
                        this.numDequeueRequests = this.getDoubleFromString(this.DequeueRequests);
                        if (this.prevNumDequeueRequests <= 0.0) {
                            this.prevNumDequeueRequests = this.numDequeueRequests;
                            this.rateDequeueRequests = -5.0;
                        } else {
                            this.diffNumDequeueRequests = this.numDequeueRequests - this.prevNumDequeueRequests;
                            if (this.diffNumDequeueRequests > 0.0 && this.timeSinceLastTest > 0.0) {
                                this.rateDequeueRequests = this.roundDouble(this.diffNumDequeueRequests / this.timeSinceLastTest);
                            }
                            this.prevNumDequeueRequests = this.numDequeueRequests;
                        }
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.dequeueErrors = ((StringTokenizer)object).nextToken();
                        this.numDequeueErrors = this.getDoubleFromString(this.dequeueErrors);
                        if (this.prevNumDequeueErrors <= 0.0) {
                            this.prevNumDequeueErrors = this.numDequeueErrors;
                            this.rateDequeueErrors = -5.0;
                        } else {
                            this.diffNumDequeueErrors = this.numDequeueErrors - this.prevNumDequeueErrors;
                            if (this.diffNumDequeueErrors > 0.0 && this.timeSinceLastTest > 0.0) {
                                this.rateDequeueErrors = this.roundDouble(this.diffNumDequeueErrors / this.timeSinceLastTest);
                            }
                            this.prevNumDequeueErrors = this.numDequeueErrors;
                        }
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.backupRequests = ((StringTokenizer)object).nextToken();
                        this.numBackupRequests = this.getDoubleFromString(this.backupRequests);
                        if (this.prevNumBackupRequests <= 0.0) {
                            this.prevNumBackupRequests = this.numBackupRequests;
                            this.rateBackupRequests = -5.0;
                        } else {
                            this.diffNumBackupRequests = this.numBackupRequests - this.prevNumBackupRequests;
                            if (this.diffNumBackupRequests > 0.0 && this.timeSinceLastTest > 0.0) {
                                this.rateBackupRequests = this.roundDouble(this.diffNumBackupRequests / this.timeSinceLastTest);
                            }
                            this.prevNumBackupRequests = this.numBackupRequests;
                        }
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.lockTime = ((StringTokenizer)object).nextToken();
                        this.numLockTime = this.getDoubleFromString(this.lockTime);
                        if (this.prevNumLockTime < 0.0) {
                            this.prevNumLockTime = this.numLockTime;
                            this.pctLockTime = -5.0;
                        } else {
                            this.diffNumLockTime = this.numLockTime - this.prevNumLockTime;
                            if (this.diffNumLockTime > 0.0 && this.timeSinceLastTest > 0.0) {
                                this.pctLockTime = this.roundDouble(this.diffNumLockTime / this.timeSinceLastTest * 100.0);
                            }
                            this.prevNumLockTime = this.numLockTime;
                        }
                    }
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        this.lockWaitTime = ((StringTokenizer)object).nextToken();
                        this.numLockWaitTime = this.getDoubleFromString(this.lockWaitTime);
                        if (this.prevNumLockWaitTime < 0.0) {
                            this.prevNumLockWaitTime = this.numLockWaitTime;
                            this.pctLockWaitTime = -5.0;
                        } else {
                            this.diffNumLockWaitTime = this.numLockWaitTime - this.prevNumLockWaitTime;
                            if (this.diffNumLockWaitTime > 0.0 && this.timeSinceLastTest > 0.0) {
                                this.pctLockWaitTime = this.roundDouble(this.diffNumLockWaitTime / this.timeSinceLastTest * 100.0);
                            }
                            this.prevNumLockWaitTime = this.numLockWaitTime;
                        }
                    }
                    if (!((StringTokenizer)object).hasMoreTokens()) continue;
                    this.lockSrvTime = ((StringTokenizer)object).nextToken();
                    this.numLockSrvTime = this.getDoubleFromString(this.lockSrvTime);
                    if (this.prevNumLockSrvTime < 0.0) {
                        this.prevNumLockSrvTime = this.numLockSrvTime;
                        this.pctLockSrvTime = -5.0;
                        continue;
                    }
                    this.diffNumLockSrvTime = this.numLockSrvTime - this.prevNumLockSrvTime;
                    if (this.diffNumLockSrvTime > 0.0 && this.timeSinceLastTest > 0.0) {
                        this.pctLockSrvTime = this.roundDouble(this.diffNumLockSrvTime / this.timeSinceLastTest * 100.0);
                    }
                    this.prevNumLockSrvTime = this.numLockSrvTime;
                }
                this.printOut("Owner Current is :" + this.ownerCurrent + " Owner Max is :" + this.ownerMax);
                this.printOut("Args Current is :" + this.argsCurrent + " Args Max is :" + this.argsMax);
                this.printOut("Locks Current is :" + this.locksCurrent + " Locks High is :" + this.locksHigh + " Locks Max is :" + this.locksMax);
                this.printOut("numEnqueueRequests is :" + this.numEnqueueRequests + " numEnqueueRejects is :" + this.numEnqueueRejects + " numEnqErrors is :" + this.numEnqErrors);
                this.printOut("timeSinceLast  is :" + this.timeSinceLastTest + " prevNumEnqueueRequests :" + this.prevNumEnqueueRequests);
                this.printOut("rateEnqueueRequests is :" + this.rateEnqueueRequests);
                this.printOut("Locks Current is :" + this.locksCurrent + " numDequeueRequests is :" + this.numDequeueRequests + " numDequeueErrors is :" + this.numDequeueErrors);
                this.printOut("numBackupRequests is :" + this.numBackupRequests + " numLockTime is :" + this.numLockTime + " numLockWaitTime is :" + this.numLockWaitTime + " numLockSrvTime is : " + this.numLockSrvTime);
                this.printOut("pctLockTime is :" + this.pctLockTime + " pctLockWaitTime is :" + this.pctLockWaitTime + " pctLockSrvTime is :" + this.pctLockSrvTime);
                this.currOwnerUtil = this.numOwnerMax <= 0.0 ? -5.0 : this.roundDouble(this.numOwnerCurrent / this.numOwnerMax * 100.0);
                this.currArgsUtil = this.numArgsMax <= 0.0 ? -5.0 : this.roundDouble(this.numArgsCurrent / this.numArgsMax * 100.0);
                this.printOut("Current Owner Utilization :" + this.currOwnerUtil + "Current Arguments Utilization :" + this.currArgsUtil);
                this.currFillUtil = this.numLocksHigh == 0.0 || this.numLocksHigh == -1.0 || this.numLocksHigh == -5.0 || this.numLocksCurrent == -1.0 || this.numLocksCurrent == -5.0 ? -5.0 : this.roundDouble(this.numLocksCurrent / this.numLocksHigh * 100.0);
                this.highFillUtil = this.numLocksHigh == -1.0 || this.numLocksHigh == -5.0 || this.numLocksMax == 0.0 || this.numLocksMax == -1.0 || this.numLocksMax == -5.0 ? -5.0 : this.roundDouble(this.numLocksHigh / this.numLocksMax * 100.0);
                this.printOut("Current Fill Utilization :" + this.currFillUtil + " High Fill Utilization is :" + this.highFillUtil);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                object = new StringBuffer();
                ((StringBuffer)object).append("Enqueue statistic measures : ");
                arrayList2.add(new Double(this.numLocksMax));
                ((StringBuffer)object).append("numLocksMax = " + this.numLocksMax);
                arrayList2.add(new Double(this.currFillUtil));
                ((StringBuffer)object).append(", currFillUtil =" + this.currFillUtil);
                arrayList2.add(new Double(this.numLocksHigh));
                ((StringBuffer)object).append(", numLocksHigh = " + this.numLocksHigh);
                arrayList2.add(new Double(this.highFillUtil));
                ((StringBuffer)object).append(", highFillUtil = " + this.highFillUtil);
                arrayList2.add(new Double(this.numOwnerCurrent));
                ((StringBuffer)object).append(", numOwnerCurrent = " + this.numOwnerCurrent);
                arrayList2.add(new Double(this.currOwnerUtil));
                ((StringBuffer)object).append(", currOwnerUtil = " + this.currOwnerUtil);
                arrayList2.add(new Double(this.numArgsCurrent));
                ((StringBuffer)object).append(", numArgsCurrent = " + this.numArgsCurrent);
                arrayList2.add(new Double(this.currArgsUtil));
                ((StringBuffer)object).append(", currArgsUtil = " + this.currArgsUtil);
                arrayList2.add(new Double(this.diffNumEnqueueRequests));
                ((StringBuffer)object).append(", diffNumEnqueueRequests = " + this.diffNumEnqueueRequests);
                arrayList2.add(new Double(this.rateEnqueueRequests));
                ((StringBuffer)object).append(", rateEnqueueRequests = " + this.rateEnqueueRequests);
                arrayList2.add(new Double(this.diffNumEnqueueRejects));
                ((StringBuffer)object).append(", diffNumEnqueueRejects = " + this.diffNumEnqueueRejects);
                arrayList2.add(new Double(this.rateEnqueueRejects));
                ((StringBuffer)object).append(", rateEnqueueRejects = " + this.rateEnqueueRejects);
                arrayList2.add(new Double(this.pctEnqOpRejects));
                ((StringBuffer)object).append(", pctEnqOpRejects = " + this.pctEnqOpRejects);
                arrayList2.add(new Double(this.diffNumEnqueueErrors));
                ((StringBuffer)object).append(", diffNumEnqueueErrors = " + this.diffNumEnqueueErrors);
                arrayList2.add(new Double(this.rateEnqueueErrors));
                ((StringBuffer)object).append(", rateEnqueueErrors = " + this.rateEnqueueErrors);
                arrayList2.add(new Double(this.diffNumDequeueRequests));
                ((StringBuffer)object).append(", diffNumDequeueRequests = " + this.diffNumDequeueRequests);
                arrayList2.add(new Double(this.rateDequeueRequests));
                ((StringBuffer)object).append(", rateDequeueRequests = " + this.rateDequeueRequests);
                arrayList2.add(new Double(this.diffNumDequeueErrors));
                ((StringBuffer)object).append(", diffNumDequeueErrors = " + this.diffNumDequeueErrors);
                arrayList2.add(new Double(this.rateDequeueErrors));
                ((StringBuffer)object).append(", rateDequeueErrors = " + this.rateDequeueErrors);
                arrayList2.add(new Double(this.rateEnqueueRequests));
                ((StringBuffer)object).append(", rateEnqueueRequests = " + this.rateEnqueueRequests);
                arrayList2.add(new Double(this.pctLockTime));
                ((StringBuffer)object).append(", pctLockTime = " + this.pctLockTime);
                arrayList2.add(new Double(this.pctLockWaitTime));
                ((StringBuffer)object).append(", pctLockWaitTime = " + this.pctLockWaitTime);
                arrayList2.add(new Double(this.pctLockSrvTime));
                ((StringBuffer)object).append(", pctLockSrvTime = " + this.pctLockSrvTime + "\n");
                this.printOut(((StringBuffer)object).toString());
                return arrayList2;
            }
            this.logToErrorFile("Error", "EnqGetLockStat", "FaultCode=" + this.faultcode + " and FaultString =" + this.faultstring);
            this.printOut("DEBUG : FaultCode=" + this.faultcode + " and FaultString =" + this.faultstring);
            return null;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "EnqGetLockStat:computeMeasures ", exception.toString());
            this.printOut("Error : EnqGetLockStat:computeMeasures " + exception.toString());
            return null;
        }
    }

    private double getDoubleFromString(String string) {
        double d = 0.0;
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("none") || string.equalsIgnoreCase("null")) {
            d = 0.0;
        } else {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = 0.0;
            }
        }
        return d;
    }

    public static void main(String[] stringArray) {
        SAPLocksTest sAPLocksTest = new SAPLocksTest(stringArray);
        int n = 1;
        while (n <= 3) {
            try {
                if (n != 1) {
                    Thread.sleep(5000L);
                }
                sAPLocksTest.debugComputeMeasures(new Hashtable(), true);
                System.out.println("Completed the test cycle   " + n);
                ++n;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    static {
        tblElemList.add("lock-mode");
        tblElemList.add("use-count-owner-vb");
        statElemList.add("owner-now");
        statElemList.add("owner-max");
        statElemList.add("arguments-now");
        statElemList.add("arguments-max");
        statElemList.add("locks-now");
        statElemList.add("locks-high");
        statElemList.add("locks-max");
        statElemList.add("enqueue-requests");
        statElemList.add("enqueue-rejects");
        statElemList.add("enqueue-errors");
        statElemList.add("dequeue-requests");
        statElemList.add("dequeue-errors");
        statElemList.add("backup-requests");
        statElemList.add("lock-time");
        statElemList.add("lock-wait-time");
        statElemList.add("server-time");
        for (int i = 0; i < 27; ++i) {
            dummyMeasList.add(NaDbl);
        }
    }
}

