/*
 * Decompiled with CFR 0.152.
 */
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class SMISTest {
    private static final ArrayList arraysMainArrayList = new ArrayList();
    private static final ArrayList lunMainArrayList = new ArrayList();
    private static final ArrayList targetMainArrayList = new ArrayList();
    private static final ArrayList diskMainArrayList = new ArrayList();
    private static final ArrayList adapterMainArrayList = new ArrayList();
    private static final ArrayList portMainArrayList = new ArrayList();
    private static final ArrayList powerSupplyMainArrayList = new ArrayList();
    private static final ArrayList fanMainArrayList = new ArrayList();
    private static final ArrayList indicatorLEDMainArrayList = new ArrayList();
    private static final ArrayList batteryMainArrayList = new ArrayList();
    private static final ArrayList mainArrayList = new ArrayList();
    String smisagentIP = "";
    String port = "5989";
    String namespace = "";
    String userName = "";
    String password = "";
    String ssl = "";
    CIMClient client = null;
    Properties volumeProps = new Properties();
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    String cimClassName = "";
    public static final String USAGE = "Usage : SMISTest <SMIS_agent_IP> <SMIS_agent_CIM_Server_username> <SMIS_agent_CIM_Server_password> <ssl> <namespace> <Compenent> [instance]  >  <output_file_name.txt> \n Component have multiple choice ,\n choose any at a time, options  : Array,LUN,Disk,Adapter,Port,Fan,Power,Battery,LED,ALL\n If you want above all data, use \"ALL\" option \n Instance is optional ,\n Example : SMISTest 192.168.10.126 administrator Passw0rd true /root/ontap LUN ONTAP_StorageSystem  > output.txt \n Example : SMISTest 192.168.10.184 testing #1Password false /root/emc  Disk > output.txt ";

    public SMISTest(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.smisagentIP = string;
        this.userName = string2;
        this.password = string3 = EgCrypt.decrypt(string3);
        this.ssl = string4;
        this.namespace = string5;
        try {
            String string8 = "https";
            if (this.ssl.equalsIgnoreCase("false") || this.ssl.equalsIgnoreCase("no")) {
                string8 = "http";
                this.port = "5988";
            }
            String string9 = string8 + "://" + this.smisagentIP + ":" + this.port + "/" + this.namespace;
            CIMNameSpace cIMNameSpace = new CIMNameSpace(string9);
            SMISTest.printOut("Host - " + cIMNameSpace.getHost() + "  || Port - " + cIMNameSpace.getPort() + " || Scheme - " + cIMNameSpace.getScheme() + " || NameSpace - " + cIMNameSpace.getNameSpace());
            UserPrincipal userPrincipal = new UserPrincipal(this.userName);
            PasswordCredential passwordCredential = new PasswordCredential(this.password);
            this.client = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
            if (this.client == null) {
                SMISTest.printOut("CIMClient object is null ");
            } else {
                SMISTest.printOut("CIMClient object : " + this.client);
            }
            if (string6 == null || string6.trim().length() == 0) {
                string6 = "Array";
            } else {
                this.addMainArrayList(string6);
            }
            this.cimClassName = string7 == null || string7.trim().length() == 0 ? this.findStorageSystem() : string7;
        }
        catch (CIMException cIMException) {
            SMISTest.printOut("Exception in constructor  " + (Object)((Object)cIMException));
            cIMException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            long l = System.currentTimeMillis();
            SMISTest.printOut("Inside main method  starts  ===> " + new Date());
            SMISTest.printOut("Start Time   :" + new Date());
            SMISTest sMISTest = null;
            if (stringArray.length < 6) {
                SMISTest.printOut(USAGE);
            } else {
                String string = "";
                try {
                    string = stringArray[6].trim();
                }
                catch (Exception exception) {
                    SMISTest.printOut("Instance trim exception in main method :" + exception);
                }
                sMISTest = new SMISTest(stringArray[0].trim(), stringArray[1].trim(), stringArray[2].trim(), stringArray[3].trim(), stringArray[4].trim(), stringArray[5].trim(), string);
                SMISTest.printOut("SMISTest Constructor called and  object created sucessfully ");
            }
            if (sMISTest != null) {
                SMISTest.printOut("Going to collect performance data process from main method ");
                for (int i = 0; i < mainArrayList.size(); ++i) {
                    super.collectPerformanceData((ArrayList)mainArrayList.get(i));
                }
            } else {
                SMISTest.printOut("Class object is null,test will not get any information  ");
            }
            SMISTest.printOut("End Time   :" + new Date());
            long l2 = System.currentTimeMillis();
            SMISTest.printOut("Inside main method  ends  ===> " + new Date() + "  total time took to call  computeMeasure()(in milliseconds)" + (l2 - l));
        }
        catch (Exception exception) {
            SMISTest.printOut("Exception in main method  :" + exception);
        }
    }

    private void collectPerformanceData(ArrayList arrayList) {
        try {
            Enumeration enumeration = this.client.enumerateInstances(new CIMObjectPath(this.cimClassName), true, false);
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration != null && enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    CIMProperty cIMProperty = cIMInstance.getProperty("Name");
                    String string = null;
                    if (cIMProperty == null && cIMProperty.getValue().isNull()) {
                        SMISTest.printOut("[ SMISTest - collectPerformanceData ] Name property is null");
                        continue;
                    }
                    string = cIMProperty.getValue().toString().replaceAll("\"", "");
                    SMISTest.printOut("\n \n Storage System Unique name  : " + string);
                    CIMObjectPath cIMObjectPath = cIMInstance.getObjectPath();
                    this.getAssociatedInstances(cIMObjectPath, arrayList, 0);
                }
            } else {
                SMISTest.printOut("inside collectPerformanceData() and enumeration is null or there is no more elements ");
            }
        }
        catch (Exception exception) {
            SMISTest.printOut("Exception in collectPerformanceData method while enumerate the instances : " + exception);
            exception.printStackTrace();
        }
    }

    public static Enumeration getAssociatedInstances(CIMClient cIMClient, CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray) throws Exception {
        Enumeration enumeration = null;
        try {
            if (cIMClient != null) {
                enumeration = cIMClient.associators(cIMObjectPath, string, string2, string3, string4, bl, bl2, stringArray);
            } else {
                SMISTest.printOut("[ SMISTest - getAssociatedInstances ] CIMClient is null");
            }
        }
        catch (Exception exception) {
            SMISTest.printOut("[ SMISTest - getAssociatedInstances ] Exception while trying to associated instances " + exception);
            exception.printStackTrace();
        }
        return enumeration;
    }

    public static long getlongValue(CIMInstance cIMInstance, String string) {
        try {
            Object object;
            CIMValue cIMValue;
            CIMProperty cIMProperty = cIMInstance.getProperty(string);
            if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null && (object = cIMValue.getValue()) != null && object instanceof UnsignedInt64) {
                return new Long(object.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1L;
    }

    private void getAssociatedInstances(CIMObjectPath cIMObjectPath, ArrayList arrayList, int n) {
        SMISTest.printOut("\n\n cimObjectPath  :" + cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = null;
        ArrayList arrayList2 = (ArrayList)arrayList.get(n);
        SMISTest.printOut("Index " + n);
        String string = (String)arrayList2.get(0);
        String string2 = (String)arrayList2.get(1);
        String string3 = (String)arrayList2.get(2);
        String string4 = (String)arrayList2.get(3);
        boolean bl = (Boolean)arrayList2.get(4);
        boolean bl2 = (Boolean)arrayList2.get(5);
        String[] stringArray = (String[])arrayList2.get(6);
        Enumeration enumeration = null;
        try {
            enumeration = SMISTest.getAssociatedInstances(this.client, cIMObjectPath, string, string2, string3, string4, bl, bl2, stringArray);
        }
        catch (Exception exception) {
            SMISTest.printOut("[ getAssociatedInstances ] Exception while trying to fetch associated volume statistics instances " + exception);
            exception.printStackTrace();
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                if (cIMInstance != null) {
                    cIMObjectPath2 = cIMInstance.getObjectPath();
                    SMISTest.printOut("CIMObjectPath volumeStatCop  : " + cIMObjectPath2);
                    if (n < arrayList.size() - 1) {
                        if (arrayList.size() - 1 <= 0) continue;
                        if (arrayList.size() - 2 > 0) {
                            if (n == 0) {
                                SMISTest.printOut("Level 0 statistic  : \n " + cIMInstance);
                            } else if (n == 1) {
                                SMISTest.printOut("Level 1 statistic \n" + cIMInstance);
                            }
                        }
                        this.getAssociatedInstances(cIMObjectPath2, arrayList, n + 1);
                        continue;
                    }
                    try {
                        String[] stringArray2 = SMISTest.getPropertyValues(cIMInstance, new String[]{"InstanceID"});
                        SMISTest.printOut("Level 2 statistic and its Level 3 InstanceID  :" + stringArray2[0] + "\n" + cIMInstance);
                    }
                    catch (Exception exception) {
                        SMISTest.printOut("Exception  in getAssociatedInstances() while calling the getPropertyValues() " + exception);
                        exception.printStackTrace();
                    }
                    continue;
                }
                SMISTest.printOut("statistic  is null in getAssociatedInstances() ");
            }
        } else {
            SMISTest.printOut("Inside getAssociatedInstances() statics is null or there is no more elements ");
        }
    }

    public static String[] getPropertyValues(CIMInstance cIMInstance, String[] stringArray) throws Exception {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = "Not Available";
            if (cIMInstance.getProperty(stringArray[i]) == null || cIMInstance.getProperty(stringArray[i]).toString() == "") continue;
            try {
                CIMValue cIMValue = cIMInstance.getProperty(stringArray[i]).getValue();
                if (cIMValue == null || cIMValue.toString().equals("")) continue;
                stringArray2[i] = cIMValue.toString().replaceAll("\"", "");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringArray2;
    }

    private String findStorageSystem() {
        String string;
        block6: {
            string = "";
            SMISTest.printOut("inside findStorageSystem and starts to idendify the top level storage instance name  ");
            CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_System", this.namespace);
            SMISTest.printOut("CIMObjectPath   " + cIMObjectPath);
            CIMInstance cIMInstance = null;
            try {
                Enumeration enumeration = this.client.enumerateInstances(cIMObjectPath, true, true, true, true, null);
                try {
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        while (enumeration != null && enumeration.hasMoreElements()) {
                            cIMInstance = (CIMInstance)enumeration.nextElement();
                            System.out.println("cimInstance :" + cIMInstance);
                            string = this.checkStorageInstance(cIMInstance);
                            if (string == null || string.trim().length() <= 0) continue;
                            SMISTest.printOut("StorageName Instance in findStorageSystem    :" + string);
                            break block6;
                        }
                        break block6;
                    }
                    SMISTest.printOut("inside findStorageSystem() and enumeration is null or there is no more elements ");
                }
                catch (Exception exception) {
                    SMISTest.printOut("While Loop Exception in findStorageSystem :" + exception);
                }
            }
            catch (Exception exception) {
                SMISTest.printOut("In findStorageSystem() enumerateInstances  method iteration execption : " + exception.toString());
                exception.printStackTrace();
            }
        }
        SMISTest.printOut("finally findStorageSystem ends to idendify the top level storage instance name :" + string);
        return string;
    }

    private String checkStorageInstance(CIMInstance cIMInstance) {
        String string = null;
        String string2 = null;
        String string3 = "_StorageSystem";
        String string4 = "CMPL_ComputerSystem";
        String string5 = "FUJITSU_StorageComputerSystem";
        try {
            string2 = cIMInstance.getProperty("CreationClassName").getValue().toString().replaceAll("\"", "");
            SMISTest.printOut("[ SMISTest - checkStorageInstance ] CreationClassName = " + string2);
        }
        catch (Exception exception) {
            SMISTest.printOut("[ SMISTest - checkStorageInstance ] Exception while trying to fetch CreationClassName property " + exception);
        }
        if (string2.endsWith(string3) || string2.equalsIgnoreCase(string4) || string2.equalsIgnoreCase(string5)) {
            string = string2;
        }
        return string;
    }

    private void addMainArrayList(String string) {
        if (string.equalsIgnoreCase("ALL")) {
            mainArrayList.add(lunMainArrayList);
            mainArrayList.add(diskMainArrayList);
            mainArrayList.add(adapterMainArrayList);
            mainArrayList.add(portMainArrayList);
            mainArrayList.add(fanMainArrayList);
            mainArrayList.add(powerSupplyMainArrayList);
            mainArrayList.add(powerSupplyMainArrayList);
            mainArrayList.add(indicatorLEDMainArrayList);
            mainArrayList.add(batteryMainArrayList);
        } else if (string.equalsIgnoreCase("LUN")) {
            mainArrayList.add(lunMainArrayList);
        } else if (string.equalsIgnoreCase("Disk")) {
            mainArrayList.add(diskMainArrayList);
        } else if (string.equalsIgnoreCase("Adapter")) {
            mainArrayList.add(adapterMainArrayList);
        } else if (string.equalsIgnoreCase("Port")) {
            mainArrayList.add(portMainArrayList);
        } else if (string.equalsIgnoreCase("Fan")) {
            mainArrayList.add(fanMainArrayList);
        } else if (string.equalsIgnoreCase("Power")) {
            mainArrayList.add(powerSupplyMainArrayList);
        } else if (string.equalsIgnoreCase("LED")) {
            mainArrayList.add(indicatorLEDMainArrayList);
        } else if (string.equalsIgnoreCase("Battery")) {
            mainArrayList.add(batteryMainArrayList);
        } else {
            mainArrayList.add(arraysMainArrayList);
        }
    }

    protected static void printOut(String string) {
        System.out.println(" [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    static {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("CIM_ElementStatisticalData");
        arrayList.add("CIM_BlockStorageStatisticalData");
        arrayList.add("ManagedElement");
        arrayList.add("Stats");
        arrayList.add(Boolean.FALSE);
        arrayList.add(Boolean.FALSE);
        Object e = null;
        arrayList.add(e);
        arraysMainArrayList.add(arrayList);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add("CIM_HostedStoragePool");
        arrayList2.add("CIM_StoragePool");
        arrayList2.add("GroupComponent");
        arrayList2.add("PartComponent");
        arrayList2.add(Boolean.FALSE);
        arrayList2.add(Boolean.FALSE);
        Object e2 = null;
        arrayList2.add(e2);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add("CIM_AllocatedFromStoragePool");
        arrayList3.add("CIM_StorageVolume");
        arrayList3.add("Antecedent");
        arrayList3.add("Dependent");
        arrayList3.add(Boolean.FALSE);
        arrayList3.add(Boolean.FALSE);
        Object e3 = null;
        arrayList3.add(e3);
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        arrayList4.add("CIM_ElementStatisticalData");
        arrayList4.add("CIM_BlockStorageStatisticalData");
        arrayList4.add("ManagedElement");
        arrayList4.add("Stats");
        arrayList4.add(Boolean.FALSE);
        arrayList4.add(Boolean.FALSE);
        Object e4 = null;
        arrayList4.add(e4);
        lunMainArrayList.add(arrayList2);
        lunMainArrayList.add(arrayList3);
        lunMainArrayList.add(arrayList4);
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        arrayList5.add("CIM_SystemDevice");
        arrayList5.add("CIM_DiskDrive");
        arrayList5.add("GroupComponent");
        arrayList5.add("PartComponent");
        arrayList5.add(Boolean.FALSE);
        arrayList5.add(Boolean.FALSE);
        Object e5 = null;
        arrayList5.add(e5);
        ArrayList<Object> arrayList6 = new ArrayList<Object>();
        arrayList6.add("CIM_MediaPresent");
        arrayList6.add("CIM_StorageExtent");
        arrayList6.add("Antecedent");
        arrayList6.add("Dependent");
        arrayList6.add(Boolean.FALSE);
        arrayList6.add(Boolean.FALSE);
        Object e6 = null;
        arrayList6.add(e6);
        ArrayList<Object> arrayList7 = new ArrayList<Object>();
        arrayList7.add("CIM_ElementStatisticalData");
        arrayList7.add("CIM_BlockStorageStatisticalData");
        arrayList7.add("ManagedElement");
        arrayList7.add("Stats");
        arrayList7.add(Boolean.FALSE);
        arrayList7.add(Boolean.FALSE);
        Object e7 = null;
        arrayList7.add(e7);
        diskMainArrayList.add(arrayList5);
        diskMainArrayList.add(arrayList6);
        diskMainArrayList.add(arrayList7);
        ArrayList<Object> arrayList8 = new ArrayList<Object>();
        arrayList8.add("CIM_SystemDevice");
        arrayList8.add("CIM_SCSIProtocolController");
        arrayList8.add("GroupComponent");
        arrayList8.add("PartComponent");
        arrayList8.add(Boolean.FALSE);
        arrayList8.add(Boolean.FALSE);
        Object e8 = null;
        arrayList8.add(e8);
        ArrayList<Object> arrayList9 = new ArrayList<Object>();
        arrayList9.add("CIM_ProtocolControllerForPort");
        arrayList9.add("CIM_FCPort");
        arrayList9.add("Antecedent");
        arrayList9.add("dependent");
        arrayList9.add(Boolean.FALSE);
        arrayList9.add(Boolean.FALSE);
        Object e9 = null;
        arrayList9.add(e9);
        ArrayList<Object> arrayList10 = new ArrayList<Object>();
        arrayList10.add("CIM_ElementStatisticalData");
        arrayList10.add("CIM_BlockStorageStatisticalData");
        arrayList10.add("ManagedElement");
        arrayList10.add("Stats");
        arrayList10.add(Boolean.FALSE);
        arrayList10.add(Boolean.FALSE);
        Object e10 = null;
        arrayList10.add(e10);
        portMainArrayList.add(arrayList8);
        portMainArrayList.add(arrayList9);
        portMainArrayList.add(arrayList10);
        ArrayList<Object> arrayList11 = new ArrayList<Object>();
        arrayList11.add("CIM_ComponentCS");
        arrayList11.add("CIM_ComputerSystem");
        arrayList11.add("GroupComponent");
        arrayList11.add("PartComponent");
        arrayList11.add(Boolean.FALSE);
        arrayList11.add(Boolean.FALSE);
        Object e11 = null;
        arrayList11.add(e11);
        ArrayList<Object> arrayList12 = new ArrayList<Object>();
        arrayList12.add("CIM_ElementStatisticalData");
        arrayList12.add("CIM_BlockStorageStatisticalData");
        arrayList12.add("ManagedElement");
        arrayList12.add("Stats");
        arrayList12.add(Boolean.FALSE);
        arrayList12.add(Boolean.FALSE);
        Object e12 = null;
        arrayList12.add(e12);
        adapterMainArrayList.add(arrayList11);
        adapterMainArrayList.add(arrayList12);
        ArrayList<Object> arrayList13 = new ArrayList<Object>();
        arrayList13.add("CIM_SystemDevice");
        arrayList13.add("CIM_Fan");
        arrayList13.add("GroupComponent");
        arrayList13.add("PartComponent");
        arrayList13.add(Boolean.FALSE);
        arrayList13.add(Boolean.FALSE);
        Object e13 = null;
        arrayList13.add(e13);
        fanMainArrayList.add(arrayList13);
        ArrayList<Object> arrayList14 = new ArrayList<Object>();
        arrayList14.add("CIM_SystemDevice");
        arrayList14.add("CIM_PowerSupply");
        arrayList14.add("GroupComponent");
        arrayList14.add("PartComponent");
        arrayList14.add(Boolean.FALSE);
        arrayList14.add(Boolean.FALSE);
        Object e14 = null;
        arrayList14.add(e14);
        powerSupplyMainArrayList.add(arrayList14);
        ArrayList<Object> arrayList15 = new ArrayList<Object>();
        arrayList15.add("CIM_SystemDevice");
        arrayList15.add("CIM_IndicatorLED");
        arrayList15.add("GroupComponent");
        arrayList15.add("PartComponent");
        arrayList15.add(Boolean.FALSE);
        arrayList15.add(Boolean.FALSE);
        Object e15 = null;
        arrayList15.add(e15);
        indicatorLEDMainArrayList.add(arrayList15);
        ArrayList<Object> arrayList16 = new ArrayList<Object>();
        arrayList16.add("CIM_SystemDevice");
        arrayList16.add("CIM_Battery");
        arrayList16.add(null);
        arrayList16.add(null);
        arrayList16.add(Boolean.FALSE);
        arrayList16.add(Boolean.FALSE);
        Object e16 = null;
        arrayList16.add(e16);
        batteryMainArrayList.add(arrayList16);
    }
}

