/*
 * Decompiled with CFR 0.152.
 */
import com.sap.jmx.ObjectNameFactory;
import com.sap.jmx.remote.JmxConnectionFactory;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class SapWasKeysChecker
extends GenericTest {
    protected static final Integer ALL_TYPES = new Integer(0);
    protected static final Integer ONLY_DISPATCHER = new Integer(1);
    protected static final Integer ONLY_SERVERS = new Integer(2);
    private static Hashtable altKeysTbl = new Hashtable();
    private static Hashtable altKeyGrpsTbl;
    private static Hashtable keysTbl;
    private static Hashtable assocTest;
    protected static final String DISPATCHER = "Dispatcher";
    protected static final String SERVER = "Server";
    protected static final String SUCCESS_TRIES = "SuccessfulTries";
    protected static final String TOTAL_TRIES = "TotalTries";
    protected static final String TOTAL_TIME = "TotalTime";
    protected static final String TOTAL_NUMBER = "TotalNumber";
    protected static final int all_types = 0;
    protected static final int only_dispatcher = 1;
    protected static final int only_servers = 2;
    private static final long oneDayMillis = 86400000L;
    private static final long maxMillis = 172800000L;
    private static final int STALE_CHK_FREQ = 10;
    protected static final int MB = 1024;
    private static final double SECS = 1000.0;
    private static int numUniqKeys;
    private static final int INVALID_MONITOR_INDEX = -2;
    private static final int NAMSR_MONITOR_INDEX = -1;
    protected static final double INVALID_MONITOR_DOUBLE_VALUE = -9999.0;
    protected static final String INVALID_MONITOR_VALUE_STR = "-9999.0";
    protected static final Double INVALID_MONITOR_VALUE;
    protected static final String NAMeasureStr = "-5.0";
    protected static final Double NADbl;
    private static final String syncString;
    private static Hashtable ht_ht_Dispatcher;
    private static Hashtable ht_ht_ht_Server;
    private static Hashtable ht_ht_SrvDescriptors;
    private static Hashtable ht_Sync;
    private static Hashtable ht_LastTime;
    private static Hashtable ht_lastValidKeyCheck;
    private static Hashtable ht_DispatcherIDs;
    private static Hashtable ht_UnreachableNodes;
    private static Hashtable ht_ValidKeysPerComp;
    private static String myDatePattern;
    private static SimpleDateFormat mySDF;
    private String thisComp;
    private boolean forcedRepoll = false;
    MBeanServerConnection mbsc = null;
    MBeanServerConnection p4Conn = null;
    Properties props;
    private String username;
    private String host;
    private String connPort;
    private String instanceName;
    protected String password;
    private boolean debugFlag = true;
    private static int numStaleChecks;
    ArrayList missingKeysList = new ArrayList();
    ArrayList zeroValKeysList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SapWasKeysChecker(String[] stringArray) {
        super(stringArray);
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.instanceName = this.getValueForParam("instancename").toUpperCase();
        this.connPort = this.getValueForParam("connectorport");
        String string = this.getValueForParam("DispatcherID");
        String string2 = this.getValueForParam("ServerIDs");
        this.host = this.targetHost;
        this.fixedTestPeriod = true;
        this.thisComp = this.targetHost + ":" + this.connPort + "#" + this.instanceName + "#" + string;
        Hashtable hashtable = null;
        String string3 = (String)ht_DispatcherIDs.get(this.thisComp);
        hashtable = (Hashtable)ht_ht_SrvDescriptors.get(this.thisComp);
        String string4 = this.thisComp;
        synchronized (string4) {
            Object object;
            if (string3 == null || hashtable == null) {
                if (string.equalsIgnoreCase("default") || string2.equalsIgnoreCase("default")) {
                    object = this.populateClusterIDs(string, string2);
                    int n = ((String)object).indexOf("|");
                    string = ((String)object).substring(0, n);
                    string2 = ((String)object).substring(n + 1);
                } else {
                    this.printOut("Non-default Dispatcher ID : " + string + " server IDs : " + string2);
                }
                ht_DispatcherIDs.put(this.thisComp, string);
                hashtable = (Hashtable)ht_ht_SrvDescriptors.get(this.thisComp);
                if (hashtable == null) {
                    this.parseAndStoreSrvIDs(string2);
                    hashtable = (Hashtable)ht_ht_SrvDescriptors.get(this.thisComp);
                }
            }
            this.printOut("Cluster IDs : dispatcher ID = " + (String)ht_DispatcherIDs.get(this.thisComp) + " server IDs = " + hashtable.toString());
            object = (Hashtable)ht_ht_ht_Server.get(this.thisComp);
            if (object == null) {
                ht_ht_ht_Server.put(this.thisComp, new Hashtable());
            }
        }
        string4 = "";
        string4 = this.getValueForParam("debug");
        this.debugFlag = string4 != null && (string4.trim().equalsIgnoreCase("true") || string4.equalsIgnoreCase("yes"));
        this.printOut("DEBUG : Number of alt key groups = " + altKeyGrpsTbl.size());
        this.printOut("SapWasKeysChecker Constructor over.");
    }

    public String populateClusterIDs(String string, String string2) {
        ObjectName objectName = null;
        String string3 = null;
        String string4 = null;
        boolean bl = true;
        if (!string2.equalsIgnoreCase("default")) {
            bl = false;
            string4 = string2;
        }
        this.appServerConnect();
        try {
            objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)"ssl", null, (String)this.instanceName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            this.printOut("Could not determine dispatcher and serverIDs! Exception while getting server children : " + malformedObjectNameException.toString());
            this.logToErrorFile("ERROR", this.entity, "Could not determine dispatcher and serverIDs! Exception while getting server children : " + malformedObjectNameException.toString());
            this.appServerDisconnect();
            return string + "|" + string2;
        }
        Set<ObjectName> set = null;
        try {
            set = this.mbsc.queryNames(objectName, null);
        }
        catch (IOException iOException) {
            this.printOut("Could not determine dispatcher and serverIDs! Exception while querying names : " + iOException.toString());
            this.logToErrorFile("ERROR", this.entity, "Could not determine dispatcher and serverIDs! Exception while querying names : " + iOException.toString());
            this.appServerDisconnect();
            return string + "|" + string2;
        }
        Iterator<ObjectName> iterator = set.iterator();
        ObjectName objectName2 = null;
        AttributeList attributeList = null;
        Attribute attribute = null;
        String[] stringArray = new String[]{"RuntimeControlClassName"};
        String string5 = null;
        Object object = null;
        String string6 = null;
        block8: while (iterator.hasNext()) {
            objectName2 = iterator.next();
            string6 = ObjectNameFactory.getClusterNode((ObjectName)objectName2);
            try {
                attributeList = this.mbsc.getAttributes(objectName2, stringArray);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                this.printOut("Could not determine dispatcher and serverIDs! Exception while getting attributes : " + instanceNotFoundException.toString());
                this.logToErrorFile("ERROR", this.entity, "Could not determine dispatcher and serverIDs! Exception while getting attributes : " + instanceNotFoundException.toString());
                String string7 = string3 == null ? string : string3;
                String string8 = string4 == null ? string2 : string4;
                this.appServerDisconnect();
                return string7 + "|" + string8;
            }
            catch (ReflectionException reflectionException) {
                this.printOut("Could not determine dispatcher and serverIDs! Exception while getting attributes : " + reflectionException.toString());
                this.logToErrorFile("ERROR", this.entity, "Could not determine dispatcher and serverIDs! Exception while getting attributes : " + reflectionException.toString());
                String string9 = string3 == null ? string : string3;
                String string10 = string4 == null ? string2 : string4;
                this.appServerDisconnect();
                return string9 + "|" + string10;
            }
            catch (IOException iOException) {
                this.printOut("Could not determine dispatcher and serverIDs! Exception while getting attributes : " + iOException.toString());
                this.logToErrorFile("ERROR", this.entity, "Could not determine dispatcher and serverIDs! Exception while getting attributes : " + iOException.toString());
                String string11 = string3 == null ? string : string3;
                String string12 = string4 == null ? string2 : string4;
                this.appServerDisconnect();
                return string11 + "|" + string12;
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                attribute = (Attribute)attributeList.get(i);
                string5 = attribute.getName();
                object = attribute.getValue();
                if (object.toString().toLowerCase().indexOf(DISPATCHER.toLowerCase()) != -1) {
                    string3 = string6;
                    if (bl) continue;
                    continue block8;
                }
                if (!bl) continue;
                if (string4 == null) {
                    string4 = string6;
                    continue;
                }
                if (string4.indexOf(string6) != -1) continue;
                string4 = string4 + "," + string6;
            }
        }
        this.printOut("Autodetermined Dispatcher ID = " + string3 + " Server IDs = " + string4);
        this.appServerDisconnect();
        if (string.equalsIgnoreCase("none")) {
            string3 = string;
            this.printOut("Dispatcher ID retained as none");
        }
        return string3 + "|" + string4;
    }

    protected void decryptPassword() {
        this.password = EgCrypt.decrypt(this.password);
    }

    protected boolean isDispatcherNone() {
        String string = (String)ht_DispatcherIDs.get(this.thisComp);
        return string.equalsIgnoreCase("none");
    }

    public void parseAndStoreSrvIDs(String string) {
        this.printOut("New serverIDs is " + string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.printOut("Got server " + string2);
            int n = string2.indexOf(58);
            if (n != -1) {
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                this.printOut("Server descriptor = " + string3);
                this.printOut("Server ID = " + string4);
                hashtable.put(string4, string3);
                continue;
            }
            hashtable.put(string2, string2);
        }
        if (ht_ht_SrvDescriptors.get(this.thisComp) == null) {
            ht_ht_SrvDescriptors.put(this.thisComp, hashtable);
            this.printOut("Server descriptors and IDs: " + hashtable);
        }
    }

    protected void appServerConnect() {
        try {
            if (this.mbsc == null) {
                this.props = new Properties();
                this.props.setProperty("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                this.props.setProperty("java.naming.security.principal", this.username);
                this.props.setProperty("java.naming.security.credentials", this.password);
                this.props.setProperty("java.naming.provider.url", this.host + ":" + this.connPort);
                this.mbsc = JmxConnectionFactory.getMBeanServerConnection((String)"service:jmx:com.sap.engine.services.jmx.connector.p4:", (Hashtable)this.props);
                this.printOut("connected to Sap WebApplication Server");
            }
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to connect to Sap WebApplication Server : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, exception.toString());
            exception.printStackTrace();
        }
    }

    protected boolean isP4Connected() {
        boolean bl = false;
        try {
            Properties properties = new Properties();
            properties.setProperty("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            properties.setProperty("java.naming.security.principal", this.username);
            properties.setProperty("java.naming.security.credentials", this.password);
            properties.setProperty("java.naming.provider.url", this.host + ":" + this.connPort);
            this.p4Conn = JmxConnectionFactory.getMBeanServerConnection((String)"service:jmx:com.sap.engine.services.jmx.connector.p4:", (Hashtable)properties);
            if (this.p4Conn != null) {
                bl = true;
                this.p4Conn = null;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    protected void appServerDisconnect() {
        if (this.mbsc != null) {
            this.mbsc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void storeMeasures() {
        String string;
        boolean bl = true;
        String string2 = (String)ht_Sync.get(this.thisComp);
        if (string2 == null) {
            string = syncString;
            synchronized (string) {
                string2 = (String)ht_Sync.get(this.thisComp);
                if (string2 == null) {
                    ht_Sync.put(this.thisComp, new String(this.thisComp));
                    string2 = (String)ht_Sync.get(this.thisComp);
                }
            }
        }
        string = string2;
        synchronized (string) {
            long l;
            this.printOut(this.entity + " has started with sync block in storeMeasures.");
            long l2 = System.currentTimeMillis();
            long l3 = 0L;
            Long l4 = (Long)ht_LastTime.get(this.thisComp);
            if (l4 != null) {
                l3 = l4;
            }
            bl = !((double)(l = l2 - l3) >= 0.9 * (double)this.measurePeriod);
            this.printOut("sapwasdatastatus: " + bl);
            if (!bl || this.forcedRepoll) {
                block18: {
                    this.forcedRepoll = false;
                    String string3 = (String)ht_DispatcherIDs.get(this.thisComp);
                    Hashtable hashtable = (Hashtable)ht_ht_SrvDescriptors.get(this.thisComp);
                    try {
                        try {
                            this.appServerConnect();
                            Object var13_10 = null;
                            if (this.mbsc != null) {
                                if (string3.equalsIgnoreCase("none")) {
                                    this.printOut("Not querying dispatcher for AS JAVA type SAP system");
                                } else {
                                    this.printOut("About to populateMeasures for the dispatcher");
                                    this.populateMeasures(string3, false);
                                }
                                Enumeration enumeration = hashtable.keys();
                                while (enumeration.hasMoreElements()) {
                                    String string4 = (String)enumeration.nextElement();
                                    String string5 = (String)hashtable.get(string4);
                                    this.printOut("About to populateMeasures for server " + string5 + " with ID " + string4);
                                    this.populateMeasures(string4, true);
                                }
                            }
                            Object var18_15 = null;
                            this.appServerDisconnect();
                            ht_LastTime.put(this.thisComp, new Long(System.currentTimeMillis()));
                        }
                        catch (Exception exception) {
                            this.logToErrorFile("ERROR", this.entity, "Error in storeMeasures() : " + exception.toString());
                            exception.printStackTrace();
                            Object var18_16 = null;
                            this.appServerDisconnect();
                            ht_LastTime.put(this.thisComp, new Long(System.currentTimeMillis()));
                            this.printOut("Updated lastTime to " + System.currentTimeMillis());
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_17 = null;
                        this.appServerDisconnect();
                        ht_LastTime.put(this.thisComp, new Long(System.currentTimeMillis()));
                        this.printOut("Updated lastTime to " + System.currentTimeMillis());
                        throw throwable;
                    }
                    this.printOut("Updated lastTime to " + System.currentTimeMillis());
                }
                this.displayResults();
                if (numStaleChecks == 10) {
                    this.removeStaleData();
                    numStaleChecks = 0;
                }
                ++numStaleChecks;
            }
            this.printOut(this.entity + " has done with sync block in storeMeasures.");
            return;
        }
    }

    private void populateMeasures(String string, boolean bl) {
        Cloneable cloneable;
        int n;
        String string2 = null;
        String string3 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n2 = 0;
        Integer n3 = new Integer(-2);
        Integer n4 = new Integer(-1);
        Enumeration enumeration = keysTbl.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            n = (Integer)keysTbl.get(string2);
            if (n == 1 && bl || n == 2 && !bl) {
                if (bl) {
                    this.printOut("No need to query any server node for monitor " + string2);
                    continue;
                }
                this.printOut("No need to query dispatcher node for monitor " + string2);
                continue;
            }
            string3 = this.getAttrVal(string2, string);
            if ((string3 = string3.trim()).equals(INVALID_MONITOR_VALUE_STR) || string3.equals(NAMeasureStr)) {
                this.printOut("Error : monitor " + string2 + " has value " + string3);
                if (string3.equals(INVALID_MONITOR_VALUE_STR)) {
                    this.printOut("Error : monitor " + string2 + " seems to be invalid");
                } else {
                    this.printOut("Error : monitor " + string2 + " has -5 measure. Marking as invalid");
                }
                this.missingKeysList.add(string2 + "," + (String)assocTest.get(string2));
                ++n2;
            } else if (string3.equals("0")) {
                this.zeroValKeysList.add(string2 + "," + (String)assocTest.get(string2));
            } else {
                this.printOut("monitor " + string2 + " has valid result " + string3);
            }
            hashtable.put(string2, string3);
        }
        int n5 = -1;
        Hashtable hashtable2 = (Hashtable)ht_ValidKeysPerComp.get(this.thisComp);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            ht_ValidKeysPerComp.put(this.thisComp, hashtable2);
        }
        this.printOut("DEBUG: Getting valid keys List for " + string);
        ArrayList<Integer> arrayList = (ArrayList<Integer>)hashtable2.get(string);
        boolean bl2 = false;
        if (arrayList == null) {
            bl2 = true;
            arrayList = new ArrayList<Integer>();
            this.printOut("DEBUG: Need to store valid keys list for " + string);
        }
        Integer n6 = null;
        String string4 = null;
        ArrayList arrayList2 = null;
        enumeration = altKeyGrpsTbl.keys();
        int n7 = 0;
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            n = (Integer)altKeyGrpsTbl.get(string4);
            arrayList2 = (ArrayList)altKeysTbl.get(string4);
            this.printOut("Processing key group " + string4);
            if (n == 1 && bl || n == 2 && !bl) {
                if (bl) {
                    this.printOut("No need to query any server node for group " + string4);
                    continue;
                }
                this.printOut("No need to query dispatcher node for group " + string4);
                continue;
            }
            ++n7;
            int n8 = 0;
            if (!bl2) {
                if ((n6 = (Integer)arrayList.get(++n5)) < 0) {
                    if (n6.intValue() == n3.intValue()) {
                        string3 = INVALID_MONITOR_VALUE_STR;
                        this.printOut("DEBUG: key group " + string4 + " has no valid monitors");
                    } else {
                        string3 = NAMeasureStr;
                        this.printOut("DEBUG: key group " + string4 + " has NA Measure monitors only");
                    }
                    ++n2;
                } else {
                    string2 = (String)arrayList2.get(n6);
                    this.printOut("DEBUG: Valid key for group " + string4 + " is " + string2);
                    string3 = this.getAttrVal(string2, string);
                    if (!string3.equals(INVALID_MONITOR_VALUE_STR) && !string3.equals(NAMeasureStr)) {
                        this.printOut("DEBUG : Got result " + string3 + " for monitor " + string2 + " for cluster node " + string);
                    }
                }
            } else {
                for (n8 = 0; n8 < arrayList2.size(); ++n8) {
                    string2 = (String)arrayList2.get(n8);
                    string3 = this.getAttrVal(string2, string);
                    if (string3.equals(INVALID_MONITOR_VALUE_STR)) {
                        n6 = n3;
                        continue;
                    }
                    if (string3.equals(NAMeasureStr)) {
                        n6 = n4;
                        continue;
                    }
                    this.printOut("DEBUG : Got result " + string3 + " for monitor " + string2 + " for cluster node " + string);
                    n6 = new Integer(n8);
                    break;
                }
                if (n8 == arrayList2.size()) {
                    this.printOut("No data could be found for key group " + string4);
                    this.missingKeysList.add(string2 + "," + (String)assocTest.get(string4));
                    ++n2;
                }
                if ((string3 = string3.trim()).equals("0")) {
                    this.zeroValKeysList.add(string2 + "," + (String)assocTest.get(string4));
                }
                arrayList.add(n6);
            }
            hashtable.put(string4, string3);
        }
        if (bl2) {
            hashtable2.put(string, arrayList);
            ht_ValidKeysPerComp.put(this.thisComp, hashtable2);
            ht_lastValidKeyCheck.put(this.thisComp, new Long(System.currentTimeMillis()));
            this.printOut("DEBUG: size of ht_ValidKeysPerNode AL value for " + this.thisComp + " is " + arrayList.size());
            this.printOut("DEBUG: Number of applicable key groups for (isServer = " + bl + " ) type node " + string + " is " + n7);
        }
        this.printOut("Number of keys with no data is " + n2);
        if (n2 == numUniqKeys) {
            cloneable = (ArrayList<String>)ht_UnreachableNodes.get(this.thisComp);
            if (cloneable == null) {
                cloneable = new ArrayList<String>();
                ((ArrayList)cloneable).add(string);
                ht_UnreachableNodes.put(this.thisComp, cloneable);
                this.printOut("Node with ID " + string + " could not be reached. Could not query any key in it");
                this.logToErrorFile("ERROR", this.entity, this.thisComp + " : Node with ID " + string + " could not be reached. Could not query any key in it");
            } else if (!((ArrayList)cloneable).contains(string)) {
                this.printOut("Node with ID " + string + " could not be reached. Could not query any key in it");
                this.logToErrorFile("ERROR", this.entity, this.thisComp + " : Node with ID " + string + " could not be reached. Could not query any key in it");
                ((ArrayList)cloneable).add(string);
            }
        } else {
            cloneable = (ArrayList)ht_UnreachableNodes.get(this.thisComp);
            if (cloneable != null) {
                ((ArrayList)cloneable).remove(string);
                this.printOut("Node with ID " + string + " is now online.");
            }
        }
        if (bl) {
            cloneable = (Hashtable)ht_ht_ht_Server.get(this.thisComp);
            ((Hashtable)cloneable).put(string, hashtable);
            this.printOut("Setting entry into ht_ht_ht_Server with ID" + string + " with hashtable of size = " + hashtable.size());
        } else {
            ht_ht_Dispatcher.put(this.thisComp, hashtable);
            this.printOut("Setting entry into ht_ht_Dispatchers for component with hashtable of size = " + hashtable.size());
        }
    }

    private String getAttrVal(String string, String string2) {
        MBeanInfo mBeanInfo = null;
        String string3 = null;
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        ObjectName objectName = null;
        try {
            try {
                objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_MonitorPerNode", (String)string, (String)string2, (String)this.instanceName);
                mBeanInfo = this.mbsc.getMBeanInfo(objectName);
            }
            catch (Exception exception) {
                this.printOut("Exception " + exception.toString() + " while getting object name or mbean info from the object name for key " + string + " for cluster node " + string2);
                return INVALID_MONITOR_VALUE_STR;
            }
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            this.printOut("Monitor/key : " + string + ". Number of MBeanAttributeInfos = " + mBeanAttributeInfoArray.length);
            boolean bl = false;
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                string3 = mBeanAttributeInfoArray[i].getName();
                if (string3.equalsIgnoreCase("Value")) {
                    string4 = this.mbsc.getAttribute(objectName, string3).toString();
                    bl = true;
                } else if (string3.equalsIgnoreCase(SUCCESS_TRIES) || string3.equalsIgnoreCase(TOTAL_TRIES)) {
                    if (string3.equalsIgnoreCase(SUCCESS_TRIES)) {
                        string6 = this.mbsc.getAttribute(objectName, string3).toString();
                    } else if (string3.equalsIgnoreCase(TOTAL_TRIES)) {
                        string5 = this.mbsc.getAttribute(objectName, string3).toString();
                    }
                    if (string6 != null && string5 != null) {
                        string4 = string6 + "#" + string5;
                        string6 = null;
                        string5 = null;
                        bl = true;
                    }
                } else if (string3.equalsIgnoreCase(TOTAL_TIME) || string3.equalsIgnoreCase(TOTAL_NUMBER)) {
                    if (string3.equalsIgnoreCase(TOTAL_TIME)) {
                        string7 = this.mbsc.getAttribute(objectName, string3).toString();
                    } else if (string3.equalsIgnoreCase(TOTAL_NUMBER)) {
                        string8 = this.mbsc.getAttribute(objectName, string3).toString();
                    }
                    if (string7 != null && string8 != null) {
                        string4 = string7 + "#" + string8;
                        string7 = null;
                        string8 = null;
                        bl = true;
                    }
                }
                if (bl) break;
            }
            if (bl) {
                return string4.trim();
            }
            this.printOut("Returning NA Measure value for monitor " + string);
            return NAMeasureStr;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Exception getting mbeaninfo : " + exception.toString());
            exception.printStackTrace();
            return NAMeasureStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getMeasures(ArrayList arrayList, int n) {
        String string;
        String string2 = string = (String)ht_Sync.get(this.thisComp);
        synchronized (string2) {
            ArrayList arrayList2;
            Object object;
            Object object2;
            this.printOut("Size of testKeysList for " + this.entity + " is " + arrayList.size());
            Hashtable hashtable = new Hashtable();
            if (n == 0 || n == 1) {
                object2 = (String)ht_DispatcherIDs.get(this.thisComp);
                if (!this.isDispatcherNone()) {
                    object = (Hashtable)ht_ht_Dispatcher.get(this.thisComp);
                    arrayList2 = new ArrayList();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        arrayList2.add(((Hashtable)object).get((String)arrayList.get(i)));
                    }
                    hashtable.put(DISPATCHER, arrayList2);
                    this.printOut("getMeasures() returning dispatcher-type Measures for " + this.entity + " " + arrayList2);
                }
            }
            if (n == 0 || n == 2) {
                object2 = (Hashtable)ht_ht_ht_Server.get(this.thisComp);
                object = ((Hashtable)object2).keySet().iterator();
                Hashtable hashtable2 = (Hashtable)ht_ht_SrvDescriptors.get(this.thisComp);
                while (object.hasNext()) {
                    Hashtable hashtable3;
                    String string3 = (String)object.next();
                    String string4 = (String)hashtable2.get(string3);
                    if (string4 == null) {
                        hashtable3 = (Hashtable)((Hashtable)object2).get(string3);
                        hashtable3.clear();
                        object.remove();
                        this.printOut("Removed old server ID from ht_ht_server : " + string3 + " : " + string4);
                        continue;
                    }
                    hashtable3 = (Hashtable)((Hashtable)object2).get(string3);
                    arrayList2 = new ArrayList();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        arrayList2.add(hashtable3.get((String)arrayList.get(i)));
                    }
                    this.printOut("getMeasures() returning server-type Measures for " + this.entity + " cluster " + string4 + "(" + string3 + ") : " + arrayList2);
                    hashtable.put(string4, arrayList2);
                }
            }
            return hashtable;
        }
    }

    protected double getValue(String string) {
        double d = -5.0;
        if (string == null || string.length() <= 0) {
            return d;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            this.printOut("getValue() parse error");
            exception.printStackTrace();
            d = -5.0;
        }
        return d;
    }

    protected void forceRepoll() {
        this.forcedRepoll = true;
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void displayResults() {
        this.printOut("*****************************************");
        Hashtable hashtable = (Hashtable)ht_ht_Dispatcher.get(this.thisComp);
        this.printMeasureTable(hashtable, "dispatcher", (String)ht_DispatcherIDs.get(this.thisComp));
        Hashtable hashtable2 = (Hashtable)ht_ht_ht_Server.get(this.thisComp);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string);
            this.printMeasureTable(hashtable3, "server", string);
        }
        this.printOut("*****************************************");
    }

    public void printMeasureTable(Hashtable hashtable, String string, String string2) {
        this.printOut("------ Result for " + string + " with ID " + string2 + "------");
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)hashtable.get(string3);
                this.printOut("Key: " + string3 + " Value: " + string4);
            }
        }
        this.printOut("====================================");
    }

    public static void main(String[] stringArray) {
        int n;
        String string;
        SapWasKeysChecker sapWasKeysChecker = new SapWasKeysChecker(stringArray);
        sapWasKeysChecker.password = EgCrypt.decrypt(sapWasKeysChecker.password);
        sapWasKeysChecker.storeMeasures();
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter("MissingKeysInfo.csv")));
            printWriter2 = new PrintWriter(new BufferedWriter(new FileWriter("DisabledKeysInfo.csv")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        ArrayList arrayList = sapWasKeysChecker.missingKeysList;
        if (arrayList.size() == 0) {
            printWriter.println("No missing keys found. All keys accounted for.");
        } else {
            string = null;
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                printWriter.println(string);
            }
        }
        printWriter.close();
        arrayList = sapWasKeysChecker.zeroValKeysList;
        if (arrayList.size() == 0) {
            printWriter2.println("No disabled keys found. All keys accounted for.");
        } else {
            string = null;
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                printWriter2.println(string);
            }
        }
        printWriter2.close();
    }

    protected void printOut(String string) {
        System.out.println(">> " + this.thisComp + " " + this.entity + " : [ " + mySDF.format(new Date()) + " ] : " + string);
    }

    protected void procList(ArrayList arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            double d = this.getValue(string);
            if (d < 0.0 && (bl || d == -9999.0)) {
                d = -5.0;
            }
            arrayList.set(i, new Double(d));
        }
    }

    protected void procHash(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable.get(string);
            this.procList(arrayList, false);
        }
    }

    public ArrayList returnDiffMeasures(ArrayList arrayList, ArrayList arrayList2) {
        return this.returnDiffMeasures(arrayList, arrayList2, null);
    }

    public ArrayList returnDiffMeasures(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        try {
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            double d = 0.0;
            if (arrayList == null || arrayList2 == null) {
                this.logToErrorFile("ERROR", this.entity, "returnDiffMeasures() : at least 1 list is null");
                return null;
            }
            if (arrayList2.size() != arrayList.size()) {
                this.logToErrorFile("ERROR", this.entity, "returnDiffMeasures() : Cannot diff lists of unequal sizes.");
                return null;
            }
            int n = arrayList2.size();
            if (arrayList3 == null) {
                for (int i = 0; i < n; ++i) {
                    double d2 = (Double)arrayList2.get(i);
                    double d3 = d2 - (d = ((Double)arrayList.get(i)).doubleValue());
                    if (d3 < 0.0) {
                        d3 = -5.0;
                    }
                    arrayList4.add(new Double(d3));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    double d4 = (Double)arrayList2.get(i);
                    d = (Double)arrayList.get(i);
                    if (arrayList3.contains(new Integer(i))) {
                        this.printOut("Skipping diff logic for index " + i);
                        arrayList4.add(new Double(d4));
                        continue;
                    }
                    double d5 = d4 - d;
                    if (d5 < 0.0) {
                        d5 = -5.0;
                    }
                    arrayList4.add(new Double(d5));
                }
            }
            return arrayList4;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Error in returnDiffMeasures() : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList tokenizeAndProcList(ArrayList arrayList, char c, boolean bl) {
        Double d = new Double(-5.0);
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) {
                arrayList2.add(d);
                arrayList2.add(d);
                continue;
            }
            int n = string.indexOf(c);
            if (n == -1 || n != string.lastIndexOf(c)) {
                arrayList2.add(d);
                arrayList2.add(d);
                continue;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            double d2 = this.getValue(string2);
            arrayList2.add(new Double(d2));
            d2 = this.getValue(string3);
            if (bl) {
                d2 /= 1000.0;
            }
            arrayList2.add(new Double(d2));
        }
        return arrayList2;
    }

    private void removeStaleData() {
        long l;
        long l2;
        String string;
        Enumeration enumeration = ht_LastTime.keys();
        long l3 = System.currentTimeMillis();
        Long l4 = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            l4 = (Long)ht_LastTime.get(string);
            if (l4 == null || (l2 = l3 - (l = l4.longValue())) <= 172800000L) continue;
            this.removeCompData(string);
        }
        enumeration = ht_lastValidKeyCheck.keys();
        Object var10_7 = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            l4 = (Long)ht_lastValidKeyCheck.get(string);
            if (l4 == null || (l2 = l3 - (l = l4.longValue())) <= 86400000L) continue;
            ht_ValidKeysPerComp.remove(string);
            this.printOut("Removed valid keys cache from test for " + string);
        }
    }

    private void removeCompData(String string) {
        Object v;
        Hashtable hashtable = (Hashtable)ht_ht_Dispatcher.remove(string);
        if (hashtable != null) {
            hashtable.clear();
            this.printOut("Removed data for dispatcher for component " + string);
        }
        if ((hashtable = (Hashtable)ht_ht_ht_Server.remove(string)) != null) {
            hashtable.clear();
            this.printOut("Removed data for Servers for component " + string);
        }
        if ((v = ht_DispatcherIDs.remove(string)) != null) {
            this.printOut("Removed dispatcher ID from list for component " + string);
        }
        if ((v = ht_Sync.remove(string)) != null) {
            this.printOut("Removed Sync Object from list for component " + string);
        }
        if ((v = ht_LastTime.remove(string)) != null) {
            this.printOut("Removed lastTime obj from list for component " + string);
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\"/Kernel/Application Threads Pool/ThreadPoolPercentageUsage\"");
        arrayList.add("\"/Kernel/Application Threads Pool/Thread Pool Usage Rate\"");
        arrayList.add("\"/Kernel/Application Threads Pool/ThreadPoolUsageRate\"");
        altKeysTbl.put("ATP/ThreadPoolPercentageUsage", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/Application Threads Pool/WaitingTasksQueueSize\"");
        arrayList.add("\"/Kernel/Application Threads Pool/Max Waiting Tasks Queue Size\"");
        altKeysTbl.put("ATP/WaitingTasksQueueSize", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/Application Threads Pool/CurrentThreadPoolSize\"");
        arrayList.add("\"/Kernel/Application Threads Pool/Current Thread Pool Size\"");
        altKeysTbl.put("ATP/CurrentThreadPoolSize", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/Application Threads Pool/WaitingTasksQueueOverflow\"");
        arrayList.add("\"/Kernel/Application Threads Pool/Waiting Tasks Queue Overflow\"");
        altKeysTbl.put("ATP/WaitingTasksQueueOverflow", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/Application Threads Pool/WaitingTasksCount\"");
        arrayList.add("\"/Kernel/Application Threads Pool/Waiting Tasks Count\"");
        altKeysTbl.put("ATP/WaitingTasksCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/Application Threads Pool/ActiveThreadsCount\"");
        arrayList.add("\"/Kernel/Application Threads Pool/Active Threads Count\"");
        altKeysTbl.put("ATP/ActiveThreadsCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/UsedManagedConnectionsCount\"");
        arrayList.add("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/Used managed connections number\"");
        altKeysTbl.put("SDK_JDBC/UsedManagedConnectionsCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/FreeManagedConnectionsCount\"");
        arrayList.add("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/Free managed connections number\"");
        altKeysTbl.put("SDK_JDBC/FreeManagedConnectionsCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/MaxManagedConnectionsNumber\"");
        arrayList.add("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/Maximum connections number\"");
        altKeysTbl.put("SDK_JDBC/MaxManagedConnectionsNumber", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/WaitingForManagedConnectionCount\"");
        arrayList.add("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/Waiting for connections number\"");
        altKeysTbl.put("SDK_JDBC/WaitingForManagedConnectionCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Memory Info/UsedMemory\"");
        arrayList.add("\"/Services/Memory/UsedMemory\"");
        arrayList.add("\"/Services/Memory Info/Used Memory\"");
        altKeysTbl.put("UsedMemory", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Memory Info/AllocatedMemory\"");
        arrayList.add("\"/Services/Memory Info/Allocated Memory\"");
        arrayList.add("\"/Services/Memory/AllocatedMemory\"");
        altKeysTbl.put("AllocatedMemory", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Memory Info/AvailableMemory\"");
        arrayList.add("\"/Services/Memory Info/Available Memory\"");
        arrayList.add("\"/Services/Memory/AvailableMemory\"");
        altKeysTbl.put("AvailableMemory", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Transaction/ActiveTransactionsCount\"");
        arrayList.add("\"/Services/Transaction/OpenTransactionsCount\"");
        altKeysTbl.put("ActiveTransactionsCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/System Threads Pool/WaitingTasksCount\"");
        arrayList.add("\"/Kernel/System Threads Pool/Waiting Tasks Count\"");
        altKeysTbl.put("STP/WaitingTasksCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/System Threads Pool/WaitingTasksQueueSize\"");
        arrayList.add("\"/Kernel/System Threads Pool/Max Waiting Tasks Queue Size\"");
        altKeysTbl.put("STP/WaitingTasksQueueSize", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/System Threads Pool/ThreadPoolPercentageUsage\"");
        arrayList.add("\"/Kernel/System Threads Pool/Thread Pool Usage Rate\"");
        arrayList.add("\"/Kernel/System Threads Pool/ThreadPoolUsageRate\"");
        altKeysTbl.put("STP/ThreadPoolPercentageUsage", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/System Threads Pool/CurrentThreadPoolSize\"");
        arrayList.add("\"/Kernel/System Threads Pool/Current Thread Pool Size\"");
        altKeysTbl.put("STP/CurrentThreadPoolSize", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/System Threads Pool/WaitingTasksQueueOverflow\"");
        arrayList.add("\"/Kernel/System Threads Pool/Waiting Tasks Queue Overflow\"");
        altKeysTbl.put("STP/WaitingTasksQueueOverflow", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/System Threads Pool/ActiveThreadsCount\"");
        arrayList.add("\"/Kernel/System Threads Pool/Active Threads Count\"");
        altKeysTbl.put("STP/ActiveThreadsCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Http Provider/Total requests/Total count\"");
        arrayList.add("\"/Services/Http Provider/AllRequestsCount\"");
        altKeysTbl.put("Http Provider/AllRequestsCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Http Provider/Current open connections/Keep-Alive waiting\"");
        arrayList.add("\"/Services/Http Provider/ConnectionsInKeepAlive\"");
        altKeysTbl.put("Http Provider/ConnectionsInKeepAlive", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/Http Provider/Total connections/Closed by client\"");
        arrayList.add("\"/Services/Http Provider/ConnectionsClosedByClient\"");
        altKeysTbl.put("Http Provider/ConnectionsClosedByClient", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/Connections Manipulator/OtherConnectionsCount\"");
        arrayList.add("\"/Kernel/Connections Manipulator/UnrecognizedConnectionsCount\"");
        altKeysTbl.put("CM/UnrecognizedConnectionsCount", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Kernel/Connections Manipulator/TotalConnectionsCount\"");
        arrayList.add("\"/Kernel/Connections Manipulator/CurrentPoolSize\"");
        altKeysTbl.put("CM/CurrentPoolSize", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/JNDI Registry/BoundObjectsCount\"");
        arrayList.add("\"/Services/JNDI Registry/Bound Objects Count\"");
        altKeysTbl.put("JNDI/BoundObjs", arrayList);
        arrayList = new ArrayList();
        arrayList.add("\"/Services/JNDI Registry/ByteArrayCacheSize\"");
        arrayList.add("\"/Services/JNDI Registry/Byte Array Cache Size\"");
        altKeysTbl.put("JNDI/ByteCacheSize", arrayList);
        keysTbl = new Hashtable();
        altKeyGrpsTbl = new Hashtable();
        assocTest = new Hashtable();
        altKeyGrpsTbl.put("ATP/ActiveThreadsCount", ONLY_SERVERS);
        assocTest.put("ATP/ActiveThreadsCount", "Active threads, Application Threads");
        altKeyGrpsTbl.put("ATP/WaitingTasksCount", ONLY_SERVERS);
        assocTest.put("ATP/WaitingTasksCount", "Waiting tasks, Application Threads");
        altKeyGrpsTbl.put("ATP/WaitingTasksQueueOverflow", ONLY_SERVERS);
        assocTest.put("ATP/WaitingTasksQueueOverflow", "Task queue overflow, Application Threads");
        altKeyGrpsTbl.put("ATP/CurrentThreadPoolSize", ONLY_SERVERS);
        assocTest.put("ATP/CurrentThreadPoolSize", "Current pool size, Application Threads");
        altKeyGrpsTbl.put("ATP/WaitingTasksQueueSize", ONLY_SERVERS);
        assocTest.put("ATP/WaitingTasksQueueSize", "Tasks queue size, Application Threads");
        altKeyGrpsTbl.put("ATP/ThreadPoolPercentageUsage", ONLY_SERVERS);
        assocTest.put("ATP/ThreadPoolPercentageUsage", "Threadpool usage, Application Threads");
        keysTbl.put("\"/Kernel/Connections Manipulator/HTTPConnectionsCount\"", ONLY_DISPATCHER);
        assocTest.put("\"/Kernel/Connections Manipulator/HTTPConnectionsCount\"", "HTTP connections, Cluster Connections");
        keysTbl.put("\"/Kernel/Connections Manipulator/P4ConnectionsCount\"", ONLY_DISPATCHER);
        assocTest.put("\"/Kernel/Connections Manipulator/P4ConnectionsCount\"", "P4 connections, Cluster Connections");
        keysTbl.put("\"/Kernel/Connections Manipulator/IIOPConnectionsCount\"", ONLY_DISPATCHER);
        assocTest.put("\"/Kernel/Connections Manipulator/IIOPConnectionsCount\"", "IIOP connections, Cluster Connections");
        altKeyGrpsTbl.put("CM/UnrecognizedConnectionsCount", ONLY_DISPATCHER);
        assocTest.put("CM/UnrecognizedConnectionsCount", "Unrecognized connections, Cluster Connections");
        altKeyGrpsTbl.put("CM/CurrentPoolSize", ONLY_DISPATCHER);
        assocTest.put("CM/CurrentPoolSize", "Current pool size, Cluster Connections");
        keysTbl.put("\"/Services/Http Provider/Total connections/Closed by server: Connection-close\"", ONLY_DISPATCHER);
        assocTest.put("\"/Services/Http Provider/Total connections/Closed by server: Connection-close\"", "Connections closed by server, HTTP Connections");
        keysTbl.put("\"/Services/Http Provider/Total connections/Closed by server: Timeout\"", ONLY_DISPATCHER);
        assocTest.put("\"/Services/Http Provider/Total connections/Closed by server: Timeout\"", "Connections closed by server, HTTP Connections");
        altKeyGrpsTbl.put("Http Provider/AllRequestsCount", ONLY_DISPATCHER);
        assocTest.put("Http Provider/AllRequestsCount", ", HTTP Connections");
        altKeyGrpsTbl.put("Http Provider/ConnectionsInKeepAlive", ONLY_DISPATCHER);
        assocTest.put("Http Provider/ConnectionsInKeepAlive", "Connections keep alive, HTTP Connections");
        altKeyGrpsTbl.put("Http Provider/ConnectionsClosedByClient", ONLY_DISPATCHER);
        assocTest.put("Http Provider/ConnectionsClosedByClient", "Connections closed by client, HTTP Connections");
        keysTbl.put("\"/Services/Http Provider/General/ResponsesFromCacheCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Http Provider/General/ResponsesFromCacheCount\"", "Responses from cache, HTTP Requests");
        keysTbl.put("\"/Services/Http Provider/General/AllRequestsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Http Provider/General/AllRequestsCount\"", "New HTTP requests, HTTP Requests");
        altKeyGrpsTbl.put("SDK_JDBC/UsedManagedConnectionsCount", ONLY_SERVERS);
        assocTest.put("SDK_JDBC/UsedManagedConnectionsCount", "Used managed connections, JDBC Connection Pools");
        altKeyGrpsTbl.put("SDK_JDBC/FreeManagedConnectionsCount", ONLY_SERVERS);
        assocTest.put("SDK_JDBC/FreeManagedConnectionsCount", "Free managed Connections, JDBC Connection Pools");
        altKeyGrpsTbl.put("SDK_JDBC/MaxManagedConnectionsNumber", ONLY_SERVERS);
        assocTest.put("SDK_JDBC/MaxManagedConnectionsNumber", "Max managed connections, JDBC Connection Pools");
        altKeyGrpsTbl.put("SDK_JDBC/WaitingForManagedConnectionCount", ONLY_SERVERS);
        assocTest.put("SDK_JDBC/WaitingForManagedConnectionCount", "Waiting for managed connections, JDBC Connection Pools");
        keysTbl.put("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/Opened connections count", ONLY_SERVERS);
        assocTest.put("\"/Services/Connector Service/Stand Alone/javax.resource.cci.ConnectionFactory/SDK_JDBC/Opened connections count", "Opened connections, JDBC Connection Pools");
        keysTbl.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/UsedManagedConnectionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/UsedManagedConnectionsCount\"", "User managed connections, JDBC Connection Pools");
        keysTbl.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/ManagedConnectionsUsageRate\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/ManagedConnectionsUsageRate\"", "Managed connections usage, JDBC Connection Pools");
        keysTbl.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/FreeManagedConnectionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/FreeManagedConnectionsCount\"", "Free managed connections, JDBC Connection Pools");
        keysTbl.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/MaxManagedConnectionsNumber\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/MaxManagedConnectionsNumber\"", "Max managed connections, JDBC Connection Pools");
        keysTbl.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/WaitingForManagedConnectionCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/WaitingForManagedConnectionCount\"", "Waiting for managed connections, JDBC Connection Pools");
        keysTbl.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/TimedOutConnectionRequests\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Connector Service/Applications/sap.com/com.sapportals.connectors.database/javax.resource.cci.ConnectionFactory/JDBCFactory/TimedOutConnectionRequests\"", "Timed out connections, JDBC Connection Pools");
        keysTbl.put("\"/Services/JMX Adapter/NotificationQueue/ActiveThreads\"", ALL_TYPES);
        assocTest.put("\"/Services/JMX Adapter/NotificationQueue/ActiveThreads\"", "Active threads, JMX Notify Queue");
        keysTbl.put("\"/Services/JMX Adapter/NotificationQueue/Size\"", ALL_TYPES);
        assocTest.put("\"/Services/JMX Adapter/NotificationQueue/Size\"", "Queue size, JMX Notify Queue");
        keysTbl.put("\"/Kernel/Configuration Manager/Commit Duration\"", ALL_TYPES);
        assocTest.put("\"/Kernel/Configuration Manager/Commit Duration\"", "Commit duration, Kernel Config");
        keysTbl.put("\"/Kernel/Configuration Manager/Locked Exception Rate\"", ALL_TYPES);
        assocTest.put("\"/Kernel/Configuration Manager/Locked Exception Rate\"", "Locked exception rate, Kernel Config");
        keysTbl.put("\"/Kernel/Configuration Manager/Cache Hit Rate\"", ALL_TYPES);
        assocTest.put("\"/Kernel/Configuration Manager/Cache Hit Rate\"", "Cache hit rate, Kernel Config");
        keysTbl.put("\"/Kernel/Configuration Manager/Open For Read Rate\"", ALL_TYPES);
        assocTest.put("\"/Kernel/Configuration Manager/Open For Read Rate\"", "DB read ratio, Kernel Config");
        keysTbl.put("\"/Kernel/Configuration Manager/Open For Write Rate\"", ALL_TYPES);
        assocTest.put("\"/Kernel/Configuration Manager/Open For Write Rate\"", "DB write ratio, Kernel Config");
        keysTbl.put("\"/Services/Log Configurator/General/TotalLogArchivesSize\"", ALL_TYPES);
        assocTest.put("\"/Services/Log Configurator/General/TotalLogArchivesSize\"", "Archives size, Log Config");
        keysTbl.put("\"/Services/Log Configurator/General/TotalLogFilesSize\"", ALL_TYPES);
        assocTest.put("\"/Services/Log Configurator/General/TotalLogFilesSize\"", "Log files size, Log Config");
        keysTbl.put("\"/Services/JMX Adapter/ObjectNameCache/HitRate\"", ALL_TYPES);
        assocTest.put("\"/Services/JMX Adapter/ObjectNameCache/HitRate\"", "Cache hit rate, MBeans Cache");
        keysTbl.put("\"/Services/JMX Adapter/MBeanServer/ClusterWideNotificationListeners\"", ALL_TYPES);
        assocTest.put("\"/Services/JMX Adapter/MBeanServer/ClusterWideNotificationListeners\"", "Notify listeners, MBeans Register");
        keysTbl.put("\"/Services/JMX Adapter/MBeanServer/LocalMBeanRepositorySize\"", ALL_TYPES);
        assocTest.put("\"/Services/JMX Adapter/MBeanServer/LocalMBeanRepositorySize\"", "MBeans registered, MBeans Register");
        keysTbl.put("\"/Services/P4 Provider/ExportedRemoteObjectsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/P4 Provider/ExportedRemoteObjectsCount\"", "Remote objects, P4 Usage");
        keysTbl.put("\"/Services/P4 Provider/RequestsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/P4 Provider/RequestsCount\"", "P4 requests, P4 Usage");
        keysTbl.put("\"/Services/P4 Provider/FailedRequestsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/P4 Provider/FailedRequestsCount\"", "Failed requests, P4 Usage");
        keysTbl.put("\"/Kernel/Pool Manager/Aggregated Data/TotalMemoryAllocated\"", ALL_TYPES);
        assocTest.put("\"/Kernel/Pool Manager/Aggregated Data/TotalMemoryAllocated\"", "Pool memory allocated, Pool Data Aggregate");
        keysTbl.put("\"/Kernel/Pool Manager/Aggregated Data/TotalMemoryUsed\"", ALL_TYPES);
        assocTest.put("\"/Kernel/Pool Manager/Aggregated Data/TotalMemoryUsed\"", "Pool memory used, Pool Data Aggregate");
        altKeyGrpsTbl.put("UsedMemory", ALL_TYPES);
        assocTest.put("UsedMemory", "Memory used, Sap WAS Memory");
        altKeyGrpsTbl.put("AllocatedMemory", ALL_TYPES);
        assocTest.put("AllocatedMemory", "Memory allocated, Sap WAS Memory");
        altKeyGrpsTbl.put("AvailableMemory", ALL_TYPES);
        assocTest.put("AvailableMemory", "Memory available, Sap WAS Memory");
        keysTbl.put("\"/Services/Security/Aggregated Data/UnsuccessfulLogonAttemptsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Security/Aggregated Data/UnsuccessfulLogonAttemptsCount\"", "Failed logon attempts, Sap WAP Sessions");
        keysTbl.put("\"/Services/Security/Aggregated Data/TotalSessionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Security/Aggregated Data/TotalSessionsCount\"", "New sessions, Sap WAP Sessions");
        keysTbl.put("\"/Services/Security/Aggregated Data/ActiveSessionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Security/Aggregated Data/ActiveSessionsCount\"", "Active sessions, Sap WAP Sessions");
        keysTbl.put("\"/Services/Security/Aggregated Data/InvalidSessionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Security/Aggregated Data/InvalidSessionsCount\"", "Invalid sessions, Sap WAP Sessions");
        keysTbl.put("\"/Services/Security/Aggregated Data/LoggedOffSessionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Security/Aggregated Data/LoggedOffSessionsCount\"", "Logged off sessions, Sap WAP Sessions");
        keysTbl.put("\"/Services/Security/Aggregated Data/TimedOutSessionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Security/Aggregated Data/TimedOutSessionsCount\"", "Timed out sessions, Sap WAP Sessions");
        altKeyGrpsTbl.put("ActiveTransactionsCount", ONLY_SERVERS);
        assocTest.put("ActiveTransactionsCount", "Active transactions, Sap WAS Transactions");
        keysTbl.put("\"/Services/Transaction/CommittedTransactionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Transaction/CommittedTransactionsCount\"", "Commit transactions, Sap WAS Transactions");
        keysTbl.put("\"/Services/Transaction/RolledBackTransactionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Transaction/RolledBackTransactionsCount\"", "Rollback transactions, Sap WAS Transactions");
        keysTbl.put("\"/Services/Transaction/SuspendedTransactionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Transaction/SuspendedTransactionsCount\"", "Suspend transactions, Sap WAS Transactions");
        keysTbl.put("\"/Services/Transaction/TimedOutTransactionsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Transaction/TimedOutTransactionsCount\"", "Timedout transactions, Sap WAS Transactions");
        altKeyGrpsTbl.put("STP/ThreadPoolPercentageUsage", ALL_TYPES);
        assocTest.put("STP/ThreadPoolPercentageUsage", "Threadpool usage, System Threads");
        altKeyGrpsTbl.put("STP/WaitingTasksQueueSize", ALL_TYPES);
        assocTest.put("STP/WaitingTasksQueueSize", "Tasks queue size, System Threads");
        altKeyGrpsTbl.put("STP/WaitingTasksCount", ALL_TYPES);
        assocTest.put("STP/WaitingTasksCount", "Tasks waiting, System Threads");
        altKeyGrpsTbl.put("STP/CurrentThreadPoolSize", ALL_TYPES);
        assocTest.put("STP/CurrentThreadPoolSize", "Current pool size, System Threads");
        altKeyGrpsTbl.put("STP/WaitingTasksQueueOverflow", ALL_TYPES);
        assocTest.put("STP/WaitingTasksQueueOverflow", "Tasks queue overflow, System Threads");
        altKeyGrpsTbl.put("STP/ActiveThreadsCount", ALL_TYPES);
        assocTest.put("STP/ActiveThreadsCount", "Active threads, System Threads");
        keysTbl.put("\"/Services/Timeout/EstimatedFrequencyPerMinute\"", ALL_TYPES);
        assocTest.put("\"/Services/Timeout/EstimatedFrequencyPerMinute\"", ", Timeouts");
        altKeyGrpsTbl.put("JNDI/BoundObjs", ONLY_SERVERS);
        assocTest.put("JNDI/BoundObjs", "Bound objects, WasJndiRegistry");
        altKeyGrpsTbl.put("JNDI/ByteCacheSize", ONLY_SERVERS);
        assocTest.put("JNDI/ByteCacheSize", "Byte array cache size, WasJndiRegistry");
        keysTbl.put("\"/Services/Web Container/AllRequestsCount\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Web Container/AllRequestsCount\"", ", WebContainer");
        keysTbl.put("\"/Services/Web Container/CurrentHttpSessions\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Web Container/CurrentHttpSessions\"", "Current HTTP sessions, WebContainer");
        keysTbl.put("\"/Services/Web Container/CurrentSecuritySessions\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Web Container/CurrentSecuritySessions\"", "Current secure sessions, WebContainer");
        keysTbl.put("\"/Services/Web Container/HttpSessionsInvalidatedApplication\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Web Container/HttpSessionsInvalidatedApplication\"", "Invalid HTTP sessions, WebContainer");
        keysTbl.put("\"/Services/Web Container/SecuritySessionsInvalidatedByApplication\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Web Container/SecuritySessionsInvalidatedByApplication\"", "Invalid secure sessions, WebContainer");
        keysTbl.put("\"/Services/Web Container/TimedOutHttpSessions\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Web Container/TimedOutHttpSessions\"", "Timed out HTTP sessions, WebContainer");
        keysTbl.put("\"/Services/Web Container/TimedOutSecuritySessions\"", ONLY_SERVERS);
        assocTest.put("\"/Services/Web Container/TimedOutSecuritySessions\"", "Timeout secure sessions, WebContainer");
        numUniqKeys = keysTbl.size() + altKeyGrpsTbl.size();
        INVALID_MONITOR_VALUE = new Double(-9999.0);
        NADbl = new Double(-5.0);
        syncString = new String("SapWasKeysChecker");
        ht_ht_Dispatcher = new Hashtable();
        ht_ht_ht_Server = new Hashtable();
        ht_ht_SrvDescriptors = new Hashtable();
        ht_Sync = new Hashtable();
        ht_LastTime = new Hashtable();
        ht_lastValidKeyCheck = new Hashtable();
        ht_DispatcherIDs = new Hashtable();
        ht_UnreachableNodes = new Hashtable();
        ht_ValidKeysPerComp = new Hashtable();
        myDatePattern = "dd/MM/yy hh:mm:ss a";
        mySDF = new SimpleDateFormat(myDatePattern);
        numStaleChecks = 1;
    }
}

