/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class TPDCapacityTest
extends SANRAIDBase {
    protected static final double MB_TO_TB = 1048576.0;
    protected static final String HYPHEN = "-";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected double hp3PARSANLogSizeLimitInMB = 5000000.0;
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final String HP3PARSAN_DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/HP3PARSANLog";
    protected static final Double DEFAULT_MINUS_FIVE = new Double(-5.0);
    protected static final String DELIMITER = ":";
    protected static final String DEBUG = "DEBUG";
    protected static final String ERROR = "ERROR";
    protected static final String INFO = "INFO";
    protected static final String WARNING = "WARNING";
    protected static final String STORAGE_UTILIZATION_COMMAND = "showsys -d";
    int sshPortNo = 22;
    String logMessage = "";
    String typ = "ssh";
    protected int cmd_time_out = 60;

    public TPDCapacityTest(String[] stringArray) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        if (this.userName == null || this.userName.trim().length() == 0 || this.userName.equalsIgnoreCase(NULL) || this.userName.equalsIgnoreCase(NONE)) {
            this.logMessage = string + "HP 3PAR  User name is null or empty ";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
        } else {
            this.logMessage = string + "HP 3PAR User name :" + this.userName;
            this.printOut(this.logMessage);
        }
        if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase(NULL) || this.password.equalsIgnoreCase(NONE)) {
            this.logMessage = string + "HP 3PAR  password is null or empty ";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
        } else {
            this.logMessage = string + "HP 3PAR  Password  :*******";
            this.printOut(this.logMessage);
        }
        String string2 = this.getValueForParam("ssh_port");
        if (string2 == null || string2.trim().length() == 0 || string2.equalsIgnoreCase(NULL) || string2.equalsIgnoreCase(NONE)) {
            this.logMessage = string + "SSH port is null or empty ,so assinging 22 default port";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
            string2 = "22";
        } else {
            this.logMessage = string + "HP 3PAR SSH Port   :" + string2;
            this.printOut(this.logMessage);
            this.logMessage = "";
            try {
                this.sshPortNo = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.sshPortNo = 22;
            }
            this.logMessage = string + "HP 3PAR SSH Port (After parse)  :" + string2;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        String string3 = this.getValueForParam("timeout_seconds");
        if (string3 != null && string3.trim().length() > 0) {
            this.logMessage = string + "Timeout string value in constructor : " + string3;
            this.printOut(this.logMessage);
            this.logMessage = "";
            try {
                this.cmd_time_out = Integer.parseInt(string3);
                this.printOut(string + "Timeout value in constructor(After parse) : " + string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.cmd_time_out = 60;
                this.logMessage = string + "Timeout value parsing error ,so assigning default value : " + this.cmd_time_out;
                this.printOut(this.logMessage);
                this.logMessage = "";
            }
        } else {
            this.logMessage = string + "Timeout value not provided by parameter ,so assigning default value : " + this.cmd_time_out;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        String string = "debugComputeMeasures";
        string = this.methodNameTemplate(string);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = -5.0;
        ArrayList arrayList = null;
        try {
            if (this.targetHost == null || this.targetHost.trim().length() == 0) {
                this.logMessage = string + "Target host value null or empty";
                this.printOut(this.logMessage);
                return;
            }
            if (!this.meAgentless) {
                this.logMessage = string + "Test will be executed in agentless mode alone";
                this.printOut(this.logMessage);
                return;
            }
            arrayList = this.cmdExecTo3PAR(this.typ, this.targetHost, this.sshPortNo, this.userName, this.password, STORAGE_UTILIZATION_COMMAND);
            this.printOut(string + "Command output for the command \"" + STORAGE_UTILIZATION_COMMAND + "\"   : " + arrayList);
            if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(DEFAULT_MINUS_FIVE);
                arrayList2.add(DEFAULT_MINUS_FIVE);
                arrayList2.add(DEFAULT_MINUS_FIVE);
                arrayList2.add(DEFAULT_MINUS_FIVE);
                if (!bl) {
                    this.addNewMeasure(arrayList2);
                }
                this.logMessage = string + "Output is null or empty ,so test returning with default measures ,Measure list :" + arrayList2;
                this.printOut(this.logMessage);
                return;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2;
                ArrayList arrayList3 = new ArrayList();
                String string3 = (String)arrayList.get(i);
                if (string3.startsWith("Total Capacity")) {
                    string2 = this.getString(string3, DELIMITER);
                    d = this.convertToDouble(string2);
                    d = this.getMBToTBConverter(d);
                    continue;
                }
                if (string3.startsWith("Allocated Capacity")) {
                    string2 = this.getString(string3, DELIMITER);
                    d2 = this.convertToDouble(string2);
                    d2 = this.getMBToTBConverter(d2);
                    continue;
                }
                if (!string3.startsWith("Free Capacity")) continue;
                string2 = this.getString(string3, DELIMITER);
                d3 = this.convertToDouble(string2);
                d3 = this.getMBToTBConverter(d3);
            }
            if (d > 0.0) {
                d5 = d2 / d * 100.0;
            }
            if (d5 > 0.0) {
                d5 = this.roundDouble(d5);
            }
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            arrayList4.add(new Double(d));
            arrayList4.add(new Double(d2));
            arrayList4.add(new Double(d3));
            arrayList4.add(new Double(d5));
            this.printOut(string + "Total capacity  :" + d);
            this.printOut(string + "Allocated capacity :" + d2);
            this.printOut(string + "Free capacity :" + d3);
            this.printOut(string + "Allocated capacity in percent :" + d5);
            if (!bl) {
                this.addNewMeasure(arrayList4);
            }
            this.printOut(string + "Measure list :" + arrayList4);
        }
        catch (Exception exception) {
            this.logMessage = string + "Error occured ";
            this.printOut(this.logMessage);
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
        }
    }

    private String getString(String string, String string2) {
        String string3 = "getString";
        string3 = this.methodNameTemplate(string3);
        String string4 = null;
        if ((string = this.validateString(string, HYPHEN)).equalsIgnoreCase(HYPHEN)) {
            return string4;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            this.logMessage = string3 + "Error occured ";
            this.printOut(this.logMessage);
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            return null;
        }
        if (string4 != null && string4.trim().length() > 0) {
            string4 = string4.trim();
        }
        return string4;
    }

    protected double getMBToTBConverter(double d) {
        String string = "getMBToTBConverter";
        string = this.methodNameTemplate(string);
        if (d > 0.0) {
            d /= 1048576.0;
            d = this.roundDouble(d, 2);
        }
        this.printOut(string + " Value :" + d);
        return d;
    }

    protected double roundDouble(double d) {
        double d2 = 0.0;
        int n = 2;
        d2 = this.roundDouble(d, n);
        return d2;
    }

    protected double roundDouble(double d, int n) {
        String string = "roundDouble";
        string = this.methodNameTemplate(string);
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string2;
                object = "";
                if (d < 0.0) {
                    object = (String)object + HYPHEN;
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string3 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string3.substring(1);
                }
                object2 = (string2 = EgDbInfo.formatValue((String)object)) == null || string2.trim().length() == 0 ? object : string2;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.printOut(string + "Error in  roundDouble method :" + exception.toString());
            this.putErrorMessageToLogfile("Error in  roundDouble method :" + exception.toString());
        }
        this.printOut(string + "  roundDouble method value :" + d2);
        return d2;
    }

    protected double convertToDouble(String string) {
        String string2 = "convertToDouble";
        string2 = this.methodNameTemplate(string2);
        double d = 0.0;
        if (string != null && string.trim().length() > 0 && !string.equalsIgnoreCase(NULL) && !string.equalsIgnoreCase(NONE)) {
            if ((string = this.validateString(string)).equalsIgnoreCase(HYPHEN)) {
                return d;
            }
        } else {
            return d;
        }
        try {
            d = EgLangInfo.getDoubleValue(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    protected String validateString(String string) {
        return this.validateString(string, HYPHEN);
    }

    protected String validateString(String string, String string2) {
        String string3 = string2;
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE)) {
            string3 = string2;
        } else {
            try {
                string3 = string.trim();
            }
            catch (Exception exception) {
                string3 = string2;
            }
        }
        return string3;
    }

    private ArrayList cmdExecTo3PAR(String string, String string2, int n, String string3, String string4, String string5) {
        long l = System.currentTimeMillis();
        String string6 = "cmdExecTo3PAR";
        string6 = this.methodNameTemplate(string6);
        this.logMessage = string6 + "Command \"" + string5 + "\"  execution starts for the Host :" + string2 + " , Port :" + n + " with User :" + string3;
        this.printOut(this.logMessage);
        this.logMessage = "";
        ArrayList arrayList = null;
        try {
            if (string.equalsIgnoreCase("ssh")) {
                if (EgMainAgent.bUseJavaSshForRemoteAgent) {
                    EgJavaSSH egJavaSSH = new EgJavaSSH(string2, n, string3, string4, (long)this.cmd_time_out);
                    ArrayList arrayList2 = egJavaSSH.executeCommand(string5);
                    ArrayList arrayList3 = new ArrayList();
                    if (arrayList2 != null) {
                        arrayList = (ArrayList)arrayList2.get(0);
                        arrayList3 = (ArrayList)arrayList2.get(1);
                        if (arrayList3 != null && arrayList3.size() > 0) {
                            this.logMessage = string6 + "errorArrayList value greator than zero, so printing Error Message :" + arrayList3 + ",And All output :" + arrayList;
                            this.putErrorMessageToLogfile(this.logMessage);
                            this.printOut(this.logMessage);
                            this.logMessage = "";
                        }
                    }
                } else {
                    arrayList = EgSSHUtil.getExecResults(string2, n, string3, string4, string5);
                }
            } else if (string.equalsIgnoreCase("rexec")) {
                arrayList = EgRexecUtil.getExecResults(string2, n, string3, string4, string5);
            }
            if (arrayList == null) {
                this.logMessage = string6 + "Could not execute the command, Please verify the username/password or network ";
                this.putErrorMessageToLogfile(this.logMessage);
                this.printOut(this.logMessage);
                this.logMessage = "";
                return null;
            }
            if (arrayList.size() == 0) {
                this.logMessage = string6 + " ArrayList size is  less than zero   " + string5 + " for " + this.targetHost;
                this.putErrorMessageToLogfile(this.logMessage);
                this.printOut(this.logMessage);
                this.logMessage = "";
                return null;
            }
        }
        catch (Exception exception) {
            this.logMessage = string6 + "Problem while executing the command " + string5 + " for " + this.targetHost;
            this.putErrorMessageToLogfile(this.logMessage);
            this.printOut(this.logMessage);
            this.logMessage = "";
            this.printOutStackTrace(this.logMessage, exception);
            exception.printStackTrace();
            arrayList = null;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.logMessage = string6 + "Command \"" + string5 + "\"  execution ends for the Host :" + string2 + " , Port :" + n + " with User :" + string3;
        this.printOut(this.logMessage);
        this.logMessage = "";
        this.logMessage = string6 + " Total time(millis) took to execute " + l3 + "  for the command  " + string5;
        return arrayList;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = HP3PARSAN_DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            TPDCapacityTest.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        TPDCapacityTest tPDCapacityTest = new TPDCapacityTest(stringArray);
        tPDCapacityTest.debugComputeMeasures(new Hashtable(), true);
    }
}

