/*
 * Decompiled with CFR 0.152.
 */
import com.tmax.tibero.jdbc.ext.TbDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class TibDBFileStTest
extends GenericTest {
    private String tibSid = "";
    private String username = "";
    private String password = "";
    private ArrayList statusArrayList;
    private ArrayList modeArrayList;

    public TibDBFileStTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.tibSid = this.getValueForParam("tibero_sid");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.tibSid == null || this.tibSid.equalsIgnoreCase("NULL") || this.tibSid.equalsIgnoreCase("none")) {
            this.tibSid = "";
        }
        this.statusArrayList = new ArrayList();
        this.statusArrayList.add("OFFLINE");
        this.statusArrayList.add("SYSTEM");
        this.statusArrayList.add("ONLINE");
        this.statusArrayList.add("RECOVER");
        this.modeArrayList = new ArrayList();
        this.modeArrayList.add("DISABLED");
        this.modeArrayList.add("READ ONLY");
        this.modeArrayList.add("READ WRITE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        block13: {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String string5 = "select file#, name,status, enabled as access_mode from v$datafile";
            try {
                String string6 = "jdbc:tibero:thin:@";
                String string7 = string6 + "" + this.targetHost + ":" + this.portNo + ":" + this.tibSid;
                System.out.println("URL::" + string7);
                TbDataSource tbDataSource = new TbDataSource();
                tbDataSource.setURL(string7);
                tbDataSource.setUser(this.username);
                tbDataSource.setPassword(this.password);
                System.out.println("Bef Connection");
                try {
                    connection = tbDataSource.getConnection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                    exception.printStackTrace();
                    this.closeConn(connection);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                System.out.println("[TibDBFileStTest ] Used Query is : " + string5);
                resultSet = statement.executeQuery(string5);
                while (resultSet.next()) {
                    string = resultSet.getString(1).trim();
                    string2 = resultSet.getString(2).trim();
                    string3 = resultSet.getString(3).trim().toUpperCase();
                    string4 = resultSet.getString(4).trim().toUpperCase();
                    arrayList = new ArrayList();
                    int n = this.statusCheck(string3);
                    int n2 = this.access_modeCheck(string4);
                    arrayList.add(new Double(n));
                    arrayList.add(new Double(n2));
                    System.out.println("[TibDBFileStTest] DBF name  " + string2 + "\t Measures " + arrayList);
                    this.addNewMeasure(string2, arrayList);
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                this.closeRs(resultSet);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", this.entity + "  computeMeasures() targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                exception.printStackTrace();
                break block13;
            }
            finally {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            this.closeStmt(statement);
            this.closeConn(connection);
        }
    }

    private int statusCheck(String string) {
        int n = this.statusArrayList.indexOf(string);
        if (n == -1) {
            n = 4;
        } else if (n <= -1 || n > 3) {
            n = 4;
        }
        System.out.println("[TibDBFileStTest] Oracle DBF Status value is   :" + n);
        return n;
    }

    private int access_modeCheck(String string) {
        int n = this.modeArrayList.indexOf(string);
        if (n == -1) {
            n = 3;
        } else if (n <= -1 || n > 2) {
            n = 3;
        }
        System.out.println("[TibDBFileStTest] oracle DBF Access Mode Value is     :" + n);
        return n;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        TibDBFileStTest tibDBFileStTest = new TibDBFileStTest(stringArray);
        tibDBFileStTest.computeMeasures(new Hashtable());
    }
}

