/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

class TuxedoClientTest
extends GenericTest {
    private String tuxDir = "";
    private String appDir = "";
    private String tuxConfig = "";
    private String cmd = "";
    private String exeCmc = "";
    private String debugFlag = "";
    private String sys_OS = "";
    private String[] envp = null;
    private boolean debug = false;

    public TuxedoClientTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.isDynamicInfoTest = true;
        this.tuxDir = this.getValueForParam("tuxdir");
        this.appDir = this.getValueForParam("appdir");
        this.tuxConfig = this.getValueForParam("tuxconfig");
        this.debugFlag = this.getValueForParam("debug");
        this.envp = new String[2];
        if (this.tuxDir == null || this.tuxDir.equalsIgnoreCase("NULL") || this.tuxDir.equalsIgnoreCase("none")) {
            this.tuxDir = "";
        }
        if (this.appDir == null || this.appDir.equalsIgnoreCase("NULL") || this.appDir.equalsIgnoreCase("none")) {
            this.appDir = "";
        }
        if (this.tuxConfig == null || this.tuxConfig.equalsIgnoreCase("NULL") || this.tuxConfig.equalsIgnoreCase("none")) {
            this.tuxConfig = "";
        }
        this.debug = this.debugFlag == null ? false : this.debugFlag != null && (this.debugFlag.equalsIgnoreCase("true") || this.debugFlag.equalsIgnoreCase("yes"));
        this.cmd = "printclient";
        this.sys_OS = System.getProperty("os.name").toUpperCase();
        if (this.sys_OS.trim().startsWith("WIN")) {
            this.tuxDir.replace('/', '\\');
            this.appDir.replace('/', '\\');
            this.tuxConfig.replace('/', '\\');
            this.exeCmc = EgInstallInfo.getInstallDir() + "\\lib\\tux.bat " + this.tuxDir + " " + this.appDir + " " + this.tuxConfig + " " + this.cmd;
        } else {
            this.tuxDir.replace('\\', '/');
            this.appDir.replace('\\', '/');
            this.tuxConfig.replace('\\', '/');
            this.envp[0] = "PATH=" + EgInstallInfo.getInstallDir() + "/bin";
            this.envp[1] = "LD_LIBRARY_PATH=/usr/lib";
            this.exeCmc = EgInstallInfo.getInstallDir() + "/bin/tux.sh " + this.tuxDir + " " + this.appDir + " " + this.tuxConfig + " " + this.cmd;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        int n = 0;
        ArrayList arrayList = new ArrayList();
        Hashtable hashtable2 = new Hashtable();
        EgUtilities egUtilities = EgUtilities.createInstance();
        arrayList = this.sys_OS.trim().startsWith("WIN") ? egUtilities.getExecOutputLines(this.exeCmc) : egUtilities.getExecOutputLinesForUnix(this.exeCmc, this.envp);
        if (arrayList == null || arrayList.size() == 0) {
            System.out.println("TuxBBDetailsTest Error in executing the command ..." + this.exeCmc);
            return;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return;
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            string = (String)arrayList2.get(i);
            ++n;
            if (string.startsWith("---------")) break;
        }
        String string2 = "";
        string = "";
        String string3 = "";
        String string4 = "";
        for (int i = n; i < arrayList2.size(); ++i) {
            String string5 = (String)arrayList2.get(i);
            if (string5 == null || string5.trim().length() == 0 || string5.trim().equals(">") || string5 == null || string5.trim().length() <= 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string5, " ");
            int n2 = stringTokenizer.countTokens();
            String string6 = "";
            String string7 = "";
            String string8 = "";
            if (n2 != 6) continue;
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            String string9 = stringTokenizer.nextToken();
            String string10 = stringTokenizer.nextToken();
            String string11 = stringTokenizer.nextToken();
            String string12 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            String string13 = stringTokenizer.nextToken();
            string2 = string2 != null && string2.equalsIgnoreCase("idle") ? "0" : (string2 != null && string2.equalsIgnoreCase("idlet") ? "1" : (string2 != null && string2.equalsIgnoreCase("busy") ? "90" : (string2 != null && string2.equalsIgnoreCase("busyt") ? "100" : "4")));
            arrayList3.add(new Double(string2));
            string6 = string10 + ":" + string11;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string12, ":");
            int n3 = stringTokenizer2.countTokens();
            if (n3 == 3) {
                string7 = stringTokenizer2.nextToken();
                string8 = stringTokenizer2.nextToken();
                int n4 = Integer.parseInt(string7) * 60;
                int n5 = Integer.parseInt(string8) + n4;
                arrayList3.add(new Double(n5));
            }
            StringTokenizer stringTokenizer3 = new StringTokenizer(string13, "/");
            string = stringTokenizer3.nextToken();
            string3 = stringTokenizer3.nextToken();
            string4 = stringTokenizer3.nextToken();
            arrayList3.add(new Double(string));
            arrayList3.add(new Double(string3));
            arrayList3.add(new Double(string4));
            if (this.debug) {
                System.out.println("[TuxedoClientTest]info=======>" + string6 + "measureList=======>" + arrayList3);
            }
            this.addNewMeasure(string6, arrayList3);
        }
    }

    public static void main(String[] stringArray) {
        TuxedoClientTest tuxedoClientTest = new TuxedoClientTest(stringArray);
        try {
            while (true) {
                tuxedoClientTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

