/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.IniFile;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UCSTestBase
extends GenericTest {
    private String ucsUrl = "";
    private String ucsUser = "";
    private String ucsPwd = "";
    private long ucsPort = 80L;
    private long xmlQueryTimeout = 60000L;
    private boolean isSsl = false;
    private static boolean isSslDone = false;
    private static String sslSynch = new String("sslSynch");
    private long lastTime = 0L;
    boolean isDataCollected = false;
    private String vm = new String("CiscoUCS");
    private static int ucsCount = 0;
    private static Hashtable lastTimeHash = new Hashtable();
    private static Hashtable syncStringHash = new Hashtable();
    private static Hashtable vmHash = new Hashtable();
    private static String globalSynch = new String("gk");
    protected static Hashtable equipmentChassisHash = new Hashtable();
    protected static Hashtable equipmentChassisStatsHash = new Hashtable();
    protected static Hashtable equipmentChassisFanHash = new Hashtable();
    protected static Hashtable equipmentChassisFanStatsHash = new Hashtable();
    protected static Hashtable equipmentChassisFanModuleHash = new Hashtable();
    protected static Hashtable equipmentChassisFanModuleStatsHash = new Hashtable();
    protected static Hashtable equipmentChassisIOModuleHash = new Hashtable();
    protected static Hashtable equipmentChassisIOModuleStatsHash = new Hashtable();
    protected static Hashtable equipmentChassisIOMBPHash = new Hashtable();
    protected static Hashtable equipmentChassisIOMFPHash = new Hashtable();
    protected static Hashtable equipmentChassisPSUsHash = new Hashtable();
    protected static Hashtable equipmentChassisPSUsStatsHash = new Hashtable();
    protected static Hashtable equipmentFIFanHash = new Hashtable();
    protected static Hashtable equipmentFIFanStatsHash = new Hashtable();
    protected static Hashtable equipmentFIFanModuleHash = new Hashtable();
    protected static Hashtable equipmentFIFanModuleStatsHash = new Hashtable();
    protected static Hashtable equipmentFIPSUsHash = new Hashtable();
    protected static Hashtable equipmentFIPSUsStatsHash = new Hashtable();
    protected static Hashtable equipmentFINetworkElementHash = new Hashtable();
    protected static Hashtable equipmentFIswEnvStatsHash = new Hashtable();
    protected static Hashtable equipmentFIswSystemStatsHash = new Hashtable();
    protected static Hashtable equipmentFIFcPIoHash = new Hashtable();
    protected static Hashtable equipmentFIFcStatsHash = new Hashtable();
    protected static Hashtable equipmentFIFcErrStatsHash = new Hashtable();
    protected static Hashtable equipmentFIEthPIoHash = new Hashtable();
    protected static Hashtable equipmentFIEthTxStatsHash = new Hashtable();
    protected static Hashtable equipmentFIEthRxStatsHash = new Hashtable();
    protected static Hashtable equipmentChassisServersHash = new Hashtable();
    protected static Hashtable equipmentChassisServersMBPwrHash = new Hashtable();
    protected static Hashtable equipmentChassisServersMBTempHash = new Hashtable();
    protected static Hashtable equipmentChassisServersMemArrayHash = new Hashtable();
    protected static Hashtable equipmentChassisServersCPUsHash = new Hashtable();
    protected static Hashtable equipmentChassisServersAdaptorHostEthIfHash = new Hashtable();
    protected static Hashtable equipmentChassisServersAdaptorVnicStatsHash = new Hashtable();
    protected static Hashtable equipmentRackServersAdaptorHostEthIfHash = new Hashtable();
    protected static Hashtable equipmentRackServersAdaptorVnicStatsHash = new Hashtable();
    protected static Hashtable lanFabricEthLanPcHash = new Hashtable();
    protected static Hashtable lanFabricEthLanPcEpHash = new Hashtable();
    protected static Hashtable faultsSummaryHash = new Hashtable();
    protected static Hashtable serversMemArrayErrorsStatsHash = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UCSTestBase(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        String string4 = globalSynch;
        synchronized (string4) {
            string3 = (String)syncStringHash.get(this.reportingName);
            if (string3 == null) {
                string3 = new String(this.reportingName);
                syncStringHash.put(this.reportingName, string3);
                string2 = new String("CiscoUCS_" + ucsCount);
                ++ucsCount;
                vmHash.put(this.reportingName, string2);
                lastTimeHash.put(this.reportingName, new Long(0L));
            }
        }
        string4 = this.getValueForParam("ucs_User");
        if (string4 != null && string4.trim().length() > 0) {
            this.ucsUser = string4;
        }
        if ((string3 = this.getValueForParam("ucs_Password")) != null && string3.trim().length() > 0) {
            this.ucsPwd = string3;
        }
        if ((string2 = this.getValueForParam("ssl")) == null || string2.length() > 0) {
            // empty if block
        }
        if (string2.equalsIgnoreCase("Yes") || string2.equalsIgnoreCase("True")) {
            this.isSsl = true;
            if (!isSslDone) {
                this.installSSL();
            }
        }
        if ((string = this.getValueForParam("webPort")) != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
            if (string.equalsIgnoreCase("default")) {
                this.ucsPort = this.isSsl ? 443L : 80L;
            } else {
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    n = this.isSsl ? 443 : 80;
                    exception.printStackTrace();
                    String string5 = EgInstallInfo.getStackTraceAsString(exception);
                    this.logToErrorFile("ERROR", "UCSTestBase", string5);
                }
                this.ucsPort = n;
            }
        }
        this.ucsUrl = this.isSsl ? "https://" + this.targetHost + ":" + this.ucsPort + "/nuova" : "http://" + this.targetHost + ":" + this.ucsPort + "/nuova";
        this.setLastExecutionTime();
        this.vm = (String)vmHash.get(this.reportingName);
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
        String string6 = iniFile.getValue("AGENT_SETTINGS", "UCSAPITimeout");
        if (string6 != null && string6.trim().length() > 0) {
            try {
                this.xmlQueryTimeout = Long.parseLong(string6) * 1000L;
            }
            catch (Exception exception) {
                String string7 = EgInstallInfo.getStackTraceAsString(exception);
                this.logToErrorFile("ERROR", "UCSTestBase", string7);
            }
        }
        this.needAgentlessDD = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectMetrics() {
        String string = this.vm;
        synchronized (string) {
            this.getLastExectionTime();
            long l = System.currentTimeMillis();
            long l2 = l - this.lastTime;
            if ((double)l2 >= 0.9 * (double)this.measurePeriod) {
                this.isDataCollected = true;
                this.lastTime = l;
                this.setLastExecutionTime();
            } else {
                this.isDataCollected = false;
            }
            if (this.isDataCollected) {
                this.setMetrics();
                this.lastTime = System.currentTimeMillis();
                this.setLastExecutionTime();
            }
        }
    }

    private void setMetrics() {
        try {
            String string = this.getCookie();
            if (string == null || string.length() < 47) {
                this.clearMetrics();
                return;
            }
            this.setEquipmentChassisInfo(string);
            this.setEquipmentChassisStatsInfo(string);
            this.setEquipmentFanInfo(string);
            this.setEquipmentFanStatsInfo(string);
            this.setEquipmentFanModulesInfo(string);
            this.setEquipmentFanModulesStatsInfo(string);
            this.setEquipmentIOModuleInfo(string);
            this.setEquipmentIOModuleStatsInfo(string);
            this.setEquipmentIOModuleBPInfo(string);
            this.setEquipmentIOMoudleFPInfo(string);
            this.setEquipmentPSUsInfo(string);
            this.setEquipmentChassisPSUsStatsInfo(string);
            this.setEquipmentFIPSUsStatsInfo(string);
            this.setEquipmentFINetworkElementInfo(string);
            this.setEquipmentFIswEnvStatsInfo(string);
            this.setEquipmentFIswSystemInfoHash(string);
            this.setEquipmentFIFcPIoInfo(string);
            this.setEquipmentFIFcStatsInfo(string);
            this.setEquipmentFIFcErrStatsInfo(string);
            this.setEquipmentFIEthPIoInfo(string);
            this.setEquipmentFIEthTxStatsInfo(string);
            this.setEquipmentFIEthRxStatsInfo(string);
            this.setEquipmentChassisServerInfo(string);
            this.setEquipmentChassisServerMBPwrInfo(string);
            this.setEquipmentChassisServerMBTempInfo(string);
            this.setEquipmentChassisServersMemArrayInfo(string);
            this.setEquipmentChassisServersCPUsInfo(string);
            this.setEquipmentChassisServersAdaptorHostEthIfInfo(string);
            this.setEquipmentChassisServersAdaptorVnicStatsInfo(string);
            this.setLanFabricEthLanPcInfo(string);
            this.setLanFabricEthLanPcEpInfo(string);
            this.setEquipmentFaultsInfo(string);
            this.setEquipmentChassisServersMemoryArrayEventInfo(string);
            this.logoutCookie(string);
        }
        catch (Exception exception) {
            System.out.println("[UCSTestBase] Exception occured while calling the setMetris method " + exception);
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", "UCSTestBase", string);
            exception.printStackTrace();
        }
    }

    private void clearMetrics() {
        equipmentChassisHash.put(this.reportingName, new ArrayList());
        equipmentChassisStatsHash.put(this.reportingName, new ArrayList());
        equipmentChassisFanHash.put(this.reportingName, new ArrayList());
        equipmentChassisFanStatsHash.put(this.reportingName, new ArrayList());
        equipmentChassisIOModuleHash.put(this.reportingName, new ArrayList());
        equipmentChassisIOModuleStatsHash.put(this.reportingName, new ArrayList());
        equipmentChassisFanModuleHash.put(this.reportingName, new ArrayList());
        equipmentChassisFanModuleStatsHash.put(this.reportingName, new ArrayList());
        equipmentChassisIOMBPHash.put(this.reportingName, new ArrayList());
        equipmentChassisIOMFPHash.put(this.reportingName, new ArrayList());
        equipmentChassisPSUsHash.put(this.reportingName, new ArrayList());
        equipmentChassisPSUsStatsHash.put(this.reportingName, new ArrayList());
        equipmentFIFanHash.put(this.reportingName, new ArrayList());
        equipmentFIFanStatsHash.put(this.reportingName, new ArrayList());
        equipmentFIFanModuleHash.put(this.reportingName, new ArrayList());
        equipmentFIFanModuleStatsHash.put(this.reportingName, new ArrayList());
        equipmentFIPSUsHash.put(this.reportingName, new ArrayList());
        equipmentFIPSUsStatsHash.put(this.reportingName, new ArrayList());
        equipmentFINetworkElementHash.put(this.reportingName, new ArrayList());
        equipmentFIswEnvStatsHash.put(this.reportingName, new ArrayList());
        equipmentFIswSystemStatsHash.put(this.reportingName, new ArrayList());
        equipmentFIFcPIoHash.put(this.reportingName, new ArrayList());
        equipmentFIFcStatsHash.put(this.reportingName, new ArrayList());
        equipmentFIFcErrStatsHash.put(this.reportingName, new ArrayList());
        equipmentFIEthPIoHash.put(this.reportingName, new ArrayList());
        equipmentFIEthTxStatsHash.put(this.reportingName, new ArrayList());
        equipmentFIEthRxStatsHash.put(this.reportingName, new ArrayList());
        equipmentChassisServersHash.put(this.reportingName, new ArrayList());
        equipmentChassisServersMBPwrHash.put(this.reportingName, new ArrayList());
        equipmentChassisServersMBTempHash.put(this.reportingName, new ArrayList());
        equipmentChassisServersMemArrayHash.put(this.reportingName, new ArrayList());
        equipmentChassisServersCPUsHash.put(this.reportingName, new ArrayList());
        equipmentChassisServersAdaptorHostEthIfHash.put(this.reportingName, new ArrayList());
        equipmentChassisServersAdaptorVnicStatsHash.put(this.reportingName, new ArrayList());
        equipmentRackServersAdaptorHostEthIfHash.put(this.reportingName, new ArrayList());
        equipmentRackServersAdaptorVnicStatsHash.put(this.reportingName, new ArrayList());
        lanFabricEthLanPcHash.put(this.reportingName, new ArrayList());
        lanFabricEthLanPcEpHash.put(this.reportingName, new ArrayList());
        faultsSummaryHash.put(this.reportingName, new ArrayList());
        serversMemArrayErrorsStatsHash.put(this.reportingName, new ArrayList());
    }

    private void setLastExecutionTime() {
        lastTimeHash.put(this.reportingName, new Long(this.lastTime));
    }

    private void getLastExectionTime() {
        Long l = (Long)lastTimeHash.get(this.reportingName);
        if (l != null) {
            this.lastTime = l;
        }
    }

    private String getCookie() {
        String string = "<aaaLogin inName=\"" + this.ucsUser + "\" inPassword=\"" + this.ucsPwd + "\" />";
        String string2 = "";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string);
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        ArrayList arrayList = this.getAttributes(string3, "aaaLogin");
        if (arrayList == null || arrayList.size() == 0) {
            return string2;
        }
        Hashtable hashtable = (Hashtable)arrayList.get(0);
        if (hashtable == null || hashtable.size() == 0) {
            return string2;
        }
        if (hashtable.containsKey("outCookie")) {
            string2 = (String)hashtable.get("outCookie");
        }
        return string2;
    }

    private void logoutCookie(String string) {
        String string2 = "<aaaLogout inCookie=\"" + string + "\" />";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
    }

    private void setEquipmentChassisInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentChassis'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "equipmentChassis");
        equipmentChassisHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentChassisStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentChassisStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "equipmentChassisStats");
        equipmentChassisStatsHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFanInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentFan'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentChassisFanHash.put(this.reportingName, new ArrayList());
            equipmentFIFanHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getAttributes(string3, "equipmentFan");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            ArrayList<Hashtable> arrayList3 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0) continue;
                if (string4.startsWith("sys/chassis")) {
                    arrayList2.add(hashtable);
                    continue;
                }
                if (!string4.startsWith("sys/switch")) continue;
                arrayList3.add(hashtable);
            }
            equipmentChassisFanHash.put(this.reportingName, arrayList2);
            equipmentFIFanHash.put(this.reportingName, arrayList3);
        } else {
            equipmentChassisHash.put(this.reportingName, new ArrayList());
            equipmentFIFanHash.put(this.reportingName, new ArrayList());
        }
    }

    private void setEquipmentFanStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentFanStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentChassisFanStatsHash.put(this.reportingName, new ArrayList());
            equipmentFIFanStatsHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getAttributes(string3, "equipmentFanStats");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            ArrayList<Hashtable> arrayList3 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0) continue;
                if (string4.startsWith("sys/chassis")) {
                    arrayList2.add(hashtable);
                    continue;
                }
                if (!string4.startsWith("sys/switch")) continue;
                arrayList3.add(hashtable);
            }
            equipmentChassisFanStatsHash.put(this.reportingName, arrayList2);
            equipmentFIFanStatsHash.put(this.reportingName, arrayList3);
        } else {
            equipmentChassisFanStatsHash.put(this.reportingName, new ArrayList());
            equipmentFIFanStatsHash.put(this.reportingName, new ArrayList());
        }
    }

    private void setEquipmentFanModulesInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentFanModule'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentChassisFanModuleHash.put(this.reportingName, new ArrayList());
            equipmentFIFanModuleHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getValidOuput(string3, "equipmentFanModule");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            ArrayList<Hashtable> arrayList3 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0) continue;
                if (string4.startsWith("sys/chassis")) {
                    arrayList2.add(hashtable);
                    continue;
                }
                if (!string4.startsWith("sys/switch")) continue;
                arrayList3.add(hashtable);
            }
            equipmentChassisFanModuleHash.put(this.reportingName, arrayList2);
            equipmentFIFanModuleHash.put(this.reportingName, arrayList3);
        } else {
            equipmentChassisFanModuleHash.put(this.reportingName, new ArrayList());
            equipmentFIFanModuleHash.put(this.reportingName, new ArrayList());
        }
        System.out.println("equipmentChassisFanModuleHash---->" + equipmentChassisFanModuleHash);
        System.out.println("equipmentFIFanModuleHash--------->" + equipmentFIFanModuleHash);
    }

    private void setEquipmentFanModulesStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentFanModuleStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentChassisFanModuleStatsHash.put(this.reportingName, new ArrayList());
            equipmentFIFanModuleStatsHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getValidOuput(string3, "equipmentFanModuleStats");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            ArrayList<Hashtable> arrayList3 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0) continue;
                if (string4.startsWith("sys/chassis")) {
                    arrayList2.add(hashtable);
                    continue;
                }
                if (!string4.startsWith("sys/switch")) continue;
                arrayList3.add(hashtable);
            }
            equipmentChassisFanModuleStatsHash.put(this.reportingName, arrayList2);
            equipmentFIFanModuleStatsHash.put(this.reportingName, arrayList3);
        } else {
            equipmentChassisFanModuleStatsHash.put(this.reportingName, new ArrayList());
            equipmentFIFanModuleStatsHash.put(this.reportingName, new ArrayList());
        }
    }

    private void setEquipmentPSUsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentPsu'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentChassisPSUsHash.put(this.reportingName, new ArrayList());
            equipmentFIPSUsHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getAttributes(string3, "equipmentPsu");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            ArrayList<Hashtable> arrayList3 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0) continue;
                if (string4.startsWith("sys/chassis")) {
                    arrayList2.add(hashtable);
                    continue;
                }
                if (!string4.startsWith("sys/switch")) continue;
                arrayList3.add(hashtable);
            }
            equipmentChassisPSUsHash.put(this.reportingName, arrayList2);
            equipmentFIPSUsHash.put(this.reportingName, arrayList3);
        } else {
            equipmentChassisPSUsHash.put(this.reportingName, new ArrayList());
            equipmentFIPSUsHash.put(this.reportingName, new ArrayList());
        }
    }

    private void setEquipmentChassisPSUsStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentPsuStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentChassisPSUsStatsHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getAttributes(string3, "equipmentPsuStats");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0 || !string4.startsWith("sys/chassis")) continue;
                arrayList2.add(hashtable);
            }
            equipmentChassisPSUsStatsHash.put(this.reportingName, arrayList2);
        } else {
            equipmentChassisPSUsStatsHash.put(this.reportingName, new ArrayList());
        }
    }

    private void setEquipmentFIPSUsStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentPsuInputStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentFIPSUsStatsHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getAttributes(string3, "equipmentPsuInputStats");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0 || !string4.startsWith("sys/switch")) continue;
                arrayList2.add(hashtable);
            }
            equipmentFIPSUsStatsHash.put(this.reportingName, arrayList2);
        } else {
            equipmentFIPSUsStatsHash.put(this.reportingName, new ArrayList());
        }
    }

    private void setEquipmentIOModuleInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentIOCard'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "equipmentIOCard");
        equipmentChassisIOModuleHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentIOModuleStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='equipmentIOCardStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "equipmentIOCardStats");
        equipmentChassisIOModuleStatsHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentIOModuleBPInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='etherServerIntFIo'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "etherServerIntFIo");
        equipmentChassisIOMBPHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentIOMoudleFPInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='etherSwitchIntFIo'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "etherSwitchIntFIo");
        equipmentChassisIOMFPHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentChassisServerInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='computeBlade'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "computeBlade");
        equipmentChassisServersHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentChassisServerMBPwrInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='computeMbPowerStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "computeMbPowerStats");
        equipmentChassisServersMBPwrHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentChassisServerMBTempInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='computeMbTempStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "computeMbTempStats");
        equipmentChassisServersMBTempHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentChassisServersMemArrayInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='memoryUnitEnvStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "memoryUnitEnvStats");
        equipmentChassisServersMemArrayHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentChassisServersCPUsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='processorEnvStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "processorEnvStats");
        equipmentChassisServersCPUsHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentChassisServersAdaptorHostEthIfInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='adaptorHostEthIf'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentChassisServersAdaptorHostEthIfHash.put(this.reportingName, new ArrayList());
            equipmentRackServersAdaptorHostEthIfHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getAttributes(string3, "adaptorHostEthIf");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            ArrayList<Hashtable> arrayList3 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0) continue;
                if (string4.startsWith("sys/chassis")) {
                    arrayList2.add(hashtable);
                    continue;
                }
                if (!string4.startsWith("sys/rack-unit")) continue;
                arrayList3.add(hashtable);
            }
            equipmentChassisServersAdaptorHostEthIfHash.put(this.reportingName, arrayList2);
            equipmentRackServersAdaptorHostEthIfHash.put(this.reportingName, arrayList3);
        } else {
            equipmentChassisServersAdaptorHostEthIfHash.put(this.reportingName, new ArrayList());
            equipmentRackServersAdaptorHostEthIfHash.put(this.reportingName, new ArrayList());
        }
    }

    private void setEquipmentChassisServersAdaptorVnicStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='adaptorVnicStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        if (string3 == null || string3.length() == 0) {
            equipmentChassisServersAdaptorVnicStatsHash.put(this.reportingName, new ArrayList());
            equipmentRackServersAdaptorVnicStatsHash.put(this.reportingName, new ArrayList());
            return;
        }
        ArrayList arrayList = this.getAttributes(string3, "adaptorVnicStats");
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<Hashtable> arrayList2 = new ArrayList<Hashtable>();
            ArrayList<Hashtable> arrayList3 = new ArrayList<Hashtable>();
            Hashtable hashtable = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                hashtable = (Hashtable)arrayList.get(i);
                if (hashtable == null || hashtable.size() == 0 || !hashtable.containsKey("dn") || (string4 = (String)hashtable.get("dn")) == null || string4.length() <= 0) continue;
                if (string4.startsWith("sys/chassis")) {
                    arrayList2.add(hashtable);
                    continue;
                }
                if (!string4.startsWith("sys/rack-unit")) continue;
                arrayList3.add(hashtable);
            }
            equipmentChassisServersAdaptorVnicStatsHash.put(this.reportingName, arrayList2);
            equipmentRackServersAdaptorVnicStatsHash.put(this.reportingName, arrayList3);
        } else {
            equipmentChassisServersAdaptorVnicStatsHash.put(this.reportingName, new ArrayList());
            equipmentRackServersAdaptorVnicStatsHash.put(this.reportingName, new ArrayList());
        }
    }

    private void setEquipmentFINetworkElementInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='networkElement'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "networkElement");
        equipmentFINetworkElementHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFIswEnvStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='swEnvStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "swEnvStats");
        equipmentFIswEnvStatsHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFIswSystemInfoHash(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='swSystemStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "swSystemStats");
        equipmentFIswSystemStatsHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFIFcPIoInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='fcPIo'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "fcPIo");
        equipmentFIFcPIoHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFIFcStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='fcStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "fcStats");
        equipmentFIFcStatsHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFIFcErrStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='fcErrStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "fcErrStats");
        equipmentFIFcErrStatsHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFIEthPIoInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='etherPIo'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "etherPIo");
        equipmentFIEthPIoHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFIEthTxStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='etherTxStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "etherTxStats");
        equipmentFIEthTxStatsHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFIEthRxStatsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='etherRxStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "etherRxStats");
        equipmentFIEthRxStatsHash.put(this.reportingName, arrayList);
    }

    private void setLanFabricEthLanPcInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='fabricEthLanPc'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "fabricEthLanPc");
        lanFabricEthLanPcHash.put(this.reportingName, arrayList);
    }

    private void setLanFabricEthLanPcEpInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='fabricEthLanPcEp'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "fabricEthLanPcEp");
        lanFabricEthLanPcEpHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentFaultsInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='faultInst'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "faultInst");
        faultsSummaryHash.put(this.reportingName, arrayList);
    }

    private void setEquipmentChassisServersMemoryArrayEventInfo(String string) {
        String string2 = "<configResolveClass cookie='" + string + "' inHierarchical='false' classId='memoryErrorStats'/>";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
        ArrayList arrayList = this.getValidOuput(string3, "memoryErrorStats");
        serversMemArrayErrorsStatsHash.put(this.reportingName, arrayList);
    }

    private ArrayList getValidOuput(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        arrayList = this.getAttributes(string, string2);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        return new ArrayList();
    }

    private ArrayList getAttributes(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            byte[] byArray = string.getBytes("UTF-8");
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Document document = documentBuilder.parse(byteArrayInputStream);
            if (document == null) {
                return arrayList;
            }
            document.getDocumentElement().normalize();
            document.getDocumentElement().getNodeName();
            NodeList nodeList = document.getElementsByTagName(string2);
            if (nodeList == null) {
                return arrayList;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap;
                Node node = nodeList.item(i);
                if (node == null || node.getNodeType() != 1) continue;
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                Element element = (Element)node;
                if (element == null || (namedNodeMap = element.getAttributes()) == null) continue;
                int n = namedNodeMap.getLength();
                for (int j = 0; j < n; ++j) {
                    Node node2 = namedNodeMap.item(j);
                    if (node2 == null) continue;
                    String string3 = node2.getNodeName();
                    String string4 = node2.getNodeValue();
                    hashtable.put(string3, string4);
                }
                arrayList.add(hashtable);
            }
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            String string5 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", "UCSTestBase", string5);
            exception.printStackTrace();
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (Exception exception2) {
                String string6 = EgInstallInfo.getStackTraceAsString(exception2);
                this.logToErrorFile("ERROR", "UCSTestBase", string6);
            }
        }
        return arrayList;
    }

    private String getXmlResponseFromUCS(String string, String string2) {
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        try {
            uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (httpURLConnection == null) {
                return "";
            }
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
            int n = 0;
            httpURLConnection.setRequestProperty("Content-length", "" + n);
            httpURLConnection.setRequestMethod("POST");
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write(string2.getBytes("UTF-8"));
            outputStream.flush();
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList = null;
            int n2 = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n2 = connectionThread.code;
                arrayList = connectionThread.data;
            }
            httpURLConnection.disconnect();
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            String string3 = (String)arrayList.get(0);
            return string3;
        }
        catch (Exception exception) {
            System.out.println("[UCSTestBase] Exception occured while getting the response from UCS " + exception);
            String string4 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", "UCSTestBase", string4);
            exception.printStackTrace();
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = this.xmlQueryTimeout;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
                String string = EgInstallInfo.getStackTraceAsString(exception);
                this.logToErrorFile("ERROR", "UCSTestBase", string);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSSL() {
        String string = sslSynch;
        synchronized (string) {
            try {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var4_6 = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                isSslDone = true;
            }
            catch (Exception exception) {
                String string2 = EgInstallInfo.getStackTraceAsString(exception);
                this.logToErrorFile("ERROR", "UCSTestBase", string2);
                exception.printStackTrace();
            }
        }
    }

    protected double getEquipmentChassisAdminState(String string) {
        double d = 1.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("acknowledged")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("re-acknowledged")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("decommission")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("remove")) {
            d = 4.0;
        }
        return d;
    }

    protected double getEquipmentChassisConfigState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("un-initialized")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("un-acknowledged")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("unsupported-connectivity")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("ok")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("removing")) {
            d = 4.0;
        }
        return d;
    }

    protected double getLicenseState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("license-ok")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("license-insufficient")) {
            d = 2.0;
        }
        return d;
    }

    protected double getEquipmentOperabilityState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("operable")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("inoperable")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("degraded")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("powered-off")) {
            d = 4.0;
        } else if (string.equalsIgnoreCase("power-problem")) {
            d = 5.0;
        } else if (string.equalsIgnoreCase("removed")) {
            d = 6.0;
        } else if (string.equalsIgnoreCase("voltage-problem")) {
            d = 7.0;
        } else if (string.equalsIgnoreCase("thermal-problem")) {
            d = 8.0;
        } else if (string.equalsIgnoreCase("performance-problem")) {
            d = 9.0;
        } else if (string.equalsIgnoreCase("accessibility-problem")) {
            d = 10.0;
        } else if (string.equalsIgnoreCase("identity-unestablishable")) {
            d = 11.0;
        } else if (string.equalsIgnoreCase("bios-post-timeout")) {
            d = 12.0;
        } else if (string.equalsIgnoreCase("disabled")) {
            d = 13.0;
        } else if (string.equalsIgnoreCase("fabric-conn-problem")) {
            d = 51.0;
        } else if (string.equalsIgnoreCase("fabric-unsupported-conn")) {
            d = 52.0;
        } else if (string.equalsIgnoreCase("config")) {
            d = 81.0;
        } else if (string.equalsIgnoreCase("equipment-problem")) {
            d = 82.0;
        } else if (string.equalsIgnoreCase("decommissioning")) {
            d = 83.0;
        } else if (string.equalsIgnoreCase("chassis-limit-exceeded")) {
            d = 84.0;
        } else if (string.equalsIgnoreCase("not-supported")) {
            d = -5.0;
        } else if (string.equalsIgnoreCase("discovery")) {
            d = 101.0;
        } else if (string.equalsIgnoreCase("discovery-failed")) {
            d = 102.0;
        } else if (string.equalsIgnoreCase("identify")) {
            d = 103.0;
        } else if (string.equalsIgnoreCase("post-failure")) {
            d = 104.0;
        } else if (string.equalsIgnoreCase("upgrade-problem")) {
            d = 105.0;
        } else if (string.equalsIgnoreCase("peer-comm-problem")) {
            d = 106.0;
        } else if (string.equalsIgnoreCase("auto-upgrade")) {
            d = 107.0;
        }
        return d;
    }

    protected double getEquipmentChassisPowerOperState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("ok")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("failed")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("input-failed")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("input-degraded")) {
            d = 4.0;
        } else if (string.equalsIgnoreCase("output-failed")) {
            d = 5.0;
        } else if (string.equalsIgnoreCase("output-degraded")) {
            d = 6.0;
        } else if (string.equalsIgnoreCase("redundancy-failed")) {
            d = 7.0;
        } else if (string.equalsIgnoreCase("redundancy-degraded")) {
            d = 8.0;
        }
        return d;
    }

    protected double getEquipmentPresenceState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("empty")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("equipped")) {
            d = 10.0;
        } else if (string.equalsIgnoreCase("missing")) {
            d = 11.0;
        } else if (string.equalsIgnoreCase("mismatch")) {
            d = 12.0;
        } else if (string.equalsIgnoreCase("equipped-not-primary")) {
            d = 13.0;
        } else if (string.equalsIgnoreCase("equipped-identity-unestablishable")) {
            d = 20.0;
        } else if (string.equalsIgnoreCase("mismatch-identity-unestablishable")) {
            d = 21.0;
        } else if (string.equalsIgnoreCase("inaccessible")) {
            d = 30.0;
        } else if (string.equalsIgnoreCase("unauthorized")) {
            d = 40.0;
        } else if (string.equalsIgnoreCase("not-supported")) {
            d = -5.0;
        }
        return d;
    }

    protected double getEquipmentSensorThresholdStatus(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        }
        if (string.equalsIgnoreCase("ok")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("upper-non-recoverable")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("upper-critical")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("upper-non-critical")) {
            d = 4.0;
        } else if (string.equalsIgnoreCase("lower-non-critical")) {
            d = 5.0;
        } else if (string.equalsIgnoreCase("lower-critical")) {
            d = 6.0;
        } else if (string.equalsIgnoreCase("lower non-recoverable")) {
            d = 7.0;
        } else if (string.equalsIgnoreCase("not-supported")) {
            d = -5.0;
        }
        return d;
    }

    protected double getEtherSatelliteConnDiscoveryState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("absent")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("present")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("mis-connect")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("missing")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("new")) {
            d = 4.0;
        }
        return d;
    }

    public double getNetworkPortOperState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("indeterminate")) {
            d = 0.0;
        }
        if (string.equalsIgnoreCase("up")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("admin-down")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("link-down")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("failed")) {
            d = 4.0;
        } else if (string.equalsIgnoreCase("no-license")) {
            d = 5.0;
        } else if (string.equalsIgnoreCase("link-up")) {
            d = 6.0;
        } else if (string.equalsIgnoreCase("hardware-failure")) {
            d = 7.0;
        } else if (string.equalsIgnoreCase("software-failure")) {
            d = 8.0;
        } else if (string.equalsIgnoreCase("error-disabled")) {
            d = 9.0;
        } else if (string.equalsIgnoreCase("sfp-not-present")) {
            d = 10.0;
        }
        return d;
    }

    protected double getComputeAdminState(String string) {
        double d = 1.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("in-service")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("out-of-service")) {
            d = 2.0;
        }
        return d;
    }

    protected double getEquipmentPowerState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("on")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("test")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("off")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("online")) {
            d = 4.0;
        } else if (string.equalsIgnoreCase("offline")) {
            d = 5.0;
        } else if (string.equalsIgnoreCase("offduty")) {
            d = 6.0;
        } else if (string.equalsIgnoreCase("degraded")) {
            d = 7.0;
        } else if (string.equalsIgnoreCase("power-save")) {
            d = 8.0;
        } else if (string.equalsIgnoreCase("error")) {
            d = 9.0;
        } else if (string.equalsIgnoreCase("not-supported")) {
            d = -5.0;
        }
        return d;
    }

    protected double getComputeAssociateState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("none")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("establishing")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("associated")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("removing")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("failed")) {
            d = 4.0;
        }
        return d;
    }

    protected double getComputeDiscoveryState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("undiscovered")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("in-progress")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("malformed-fru-info")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("fru-not-ready")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("insufficiently-equipped")) {
            d = 4.0;
        } else if (string.equalsIgnoreCase("failed")) {
            d = 8.0;
        } else if (string.equalsIgnoreCase("complete")) {
            d = 16.0;
        } else if (string.equalsIgnoreCase("retry")) {
            d = 32.0;
        } else if (string.equalsIgnoreCase("throttled")) {
            d = 64.0;
        } else if (string.equalsIgnoreCase("illegal-fru")) {
            d = 128.0;
        } else if (string.equalsIgnoreCase("fru-identity-indeterminate")) {
            d = 129.0;
        } else if (string.equalsIgnoreCase("fru-state-indeterminate")) {
            d = 130.0;
        } else if (string.equalsIgnoreCase("diagnostics-in-progress")) {
            d = 131.0;
        } else if (string.equalsIgnoreCase("efidiagnostics-in-progress")) {
            d = 132.0;
        } else if (string.equalsIgnoreCase("diagnostics-failed")) {
            d = 133.0;
        } else if (string.equalsIgnoreCase("diagnostics-complete")) {
            d = 134.0;
        }
        return d;
    }

    protected double getComputeOperState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("indeterminate")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("unassociated")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("ok")) {
            d = 10.0;
        } else if (string.equalsIgnoreCase("discovery")) {
            d = 11.0;
        } else if (string.equalsIgnoreCase("config")) {
            d = 12.0;
        } else if (string.equalsIgnoreCase("unconfig")) {
            d = 13.0;
        } else if (string.equalsIgnoreCase("power-off")) {
            d = 14.0;
        } else if (string.equalsIgnoreCase("restart")) {
            d = 15.0;
        } else if (string.equalsIgnoreCase("maintenance")) {
            d = 20.0;
        } else if (string.equalsIgnoreCase("test")) {
            d = 21.0;
        } else if (string.equalsIgnoreCase("compute-mismatch")) {
            d = 29.0;
        } else if (string.equalsIgnoreCase("compute-failed")) {
            d = 30.0;
        } else if (string.equalsIgnoreCase("degraded")) {
            d = 31.0;
        } else if (string.equalsIgnoreCase("discovery-failed")) {
            d = 32.0;
        } else if (string.equalsIgnoreCase("config-failure")) {
            d = 33.0;
        } else if (string.equalsIgnoreCase("unconfig-failed")) {
            d = 34.0;
        } else if (string.equalsIgnoreCase("test-failed")) {
            d = 35.0;
        } else if (string.equalsIgnoreCase("maintenance-failed")) {
            d = 36.0;
        } else if (string.equalsIgnoreCase("removed")) {
            d = 40.0;
        } else if (string.equalsIgnoreCase("disabled")) {
            d = 41.0;
        } else if (string.equalsIgnoreCase("inaccessible")) {
            d = 50.0;
        } else if (string.equalsIgnoreCase("thermal-problem")) {
            d = 60.0;
        } else if (string.equalsIgnoreCase("power-problem")) {
            d = 61.0;
        } else if (string.equalsIgnoreCase("voltage-problem")) {
            d = 62.0;
        } else if (string.equalsIgnoreCase("inoperable")) {
            d = 63.0;
        } else if (string.equalsIgnoreCase("decomissioning")) {
            d = 101.0;
        } else if (string.equalsIgnoreCase("bios-restore")) {
            d = 201.0;
        } else if (string.equalsIgnoreCase("cmos-reset")) {
            d = 202.0;
        } else if (string.equalsIgnoreCase("diagnostics")) {
            d = 203.0;
        } else if (string.equalsIgnoreCase("diagnostics-failed")) {
            d = 204.0;
        }
        return d;
    }

    protected double getComputeSlotState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("empty")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("equipped")) {
            d = 10.0;
        } else if (string.equalsIgnoreCase("missing")) {
            d = 11.0;
        } else if (string.equalsIgnoreCase("mismatch")) {
            d = 12.0;
        } else if (string.equalsIgnoreCase("equipped-not-primary")) {
            d = 13.0;
        } else if (string.equalsIgnoreCase("equipped-identity-unestablishable")) {
            d = 20.0;
        } else if (string.equalsIgnoreCase("mismatch-identity-unestablishable")) {
            d = 21.0;
        } else if (string.equalsIgnoreCase("inaccessible")) {
            d = 30.0;
        } else if (string.equalsIgnoreCase("unauthorized")) {
            d = 40.0;
        }
        return d;
    }

    protected double getComputeAvailState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unavailable")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("available")) {
            d = 1.0;
        }
        return d;
    }

    protected double getComputeCheckPointState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("removing")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("shallow-checkpoint")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("deep-checkpoint")) {
            d = 3.0;
        }
        if (string.equalsIgnoreCase("discovered")) {
            d = 4.0;
        }
        return d;
    }

    protected double getFIOperabilityState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("operable")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("inoperable")) {
            d = 2.0;
        }
        return d;
    }

    protected double getFCAdminState(String string) {
        double d = 2.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("enabled")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("disabled")) {
            d = 2.0;
        }
        return d;
    }

    protected double getFCPortSpeed(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("indeterminate")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("1gbps")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("2gbps")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("4gbps")) {
            d = 3.0;
        } else if (string.equalsIgnoreCase("8gbps")) {
            d = 4.0;
        }
        return d;
    }

    protected double getEthPortSpeed(String string) {
        double d = 2.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("indeterminate")) {
            d = 0.0;
            return d;
        }
        if (string.equalsIgnoreCase("1gbps")) {
            d = 1.0;
            return d;
        }
        if (string.equalsIgnoreCase("10gbps")) {
            d = 2.0;
            return d;
        }
        if (string.equalsIgnoreCase("20gbps")) {
            d = 3.0;
            return d;
        }
        if (string.equalsIgnoreCase("40gbps")) {
            d = 4.0;
            return d;
        }
        try {
            d = Double.parseDouble(string);
            string = this.round(d, 4);
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
            String string2 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", "UCSTestBase", string2);
        }
        return d;
    }

    protected double getAdapterAdminState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("enabled")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("reset-connectivity-active")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("reset-connectivity-passive")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("reset-connectivity")) {
            d = 3.0;
        }
        return d;
    }

    protected double getvLanStatus(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("ok")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("missing-primary")) {
            d = 1.0;
        }
        return d;
    }

    protected double getFabricOperState(String string) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("unknown")) {
            d = 0.0;
        } else if (string.equalsIgnoreCase("up")) {
            d = 1.0;
        } else if (string.equalsIgnoreCase("down")) {
            d = 2.0;
        } else if (string.equalsIgnoreCase("error-misconfigured")) {
            d = 3.0;
        }
        return d;
    }

    protected double getDoubleValue(String string) {
        double d = -5.0;
        if (string == null) {
            return d;
        }
        if ((string = string.trim()).length() == 0) {
            return d;
        }
        if (string.equalsIgnoreCase("not-applicable")) {
            return -3.0;
        }
        try {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = -5.0;
                String string2 = EgInstallInfo.getStackTraceAsString(exception);
                this.logToErrorFile("ERROR", "UCSTestBase", string2);
                return d;
            }
            string = this.round(d, 4);
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
            String string3 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", "UCSTestBase", string3);
        }
        return d;
    }

    protected Hashtable getValueAsHashtable(ArrayList arrayList) {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        if (arrayList == null || arrayList.size() == 0) {
            return hashtable;
        }
        int n = arrayList.size();
        Hashtable hashtable2 = null;
        for (int i = 0; i < n; ++i) {
            String string;
            hashtable2 = (Hashtable)arrayList.get(i);
            if (hashtable2 == null || hashtable2.size() == 0 || !hashtable2.containsKey("dn") || (string = (String)hashtable2.get("dn")) == null || string.length() <= 0) continue;
            hashtable.put(string, hashtable2);
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        UCSTestBase uCSTestBase = new UCSTestBase(stringArray);
    }
}

