/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class WAPRadioStatTest
extends EgSnmpGenericTest {
    boolean isFirst = true;

    public WAPRadioStatTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.setMeasureCount(4);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getMeasures(".1.3.6.1.4.1.9.6.1.104.1.6.1.1.3");
        Hashtable hashtable3 = this.getMeasures(".1.3.6.1.4.1.9.6.1.104.1.6.1.1.2");
        Hashtable hashtable4 = this.getMeasures(".1.3.6.1.4.1.9.6.1.104.1.6.1.1.11");
        Hashtable hashtable5 = this.getMeasures(".1.3.6.1.4.1.9.6.1.104.1.6.1.1.24");
        Hashtable hashtable6 = this.getMeasures(".1.3.6.1.4.1.9.6.1.104.1.6.1.1.36");
        if (hashtable2 == null || hashtable2.size() == 0) {
            if (this.isFirst) {
                this.logToErrorFile("Info", "WAPRadioStatTest No Radio found for this Accesspoint :", this.targetHost);
                this.isFirst = false;
            }
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            double d = -5.0;
            double d2 = -5.0;
            double d3 = -5.0;
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            String string3 = (String)hashtable3.get(string);
            String string4 = (String)hashtable6.get(string);
            String string5 = (String)hashtable4.get(string);
            String string6 = (String)hashtable5.get(string);
            d2 = this.getDoubleValue(string3);
            d = this.getDoubleValue(string4);
            d3 = this.getDoubleValue(string6);
            double d4 = this.getDoubleValue(string5);
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d3));
            System.out.println(this.entity + " MeasureList == >" + arrayList);
            this.addNewMeasure(string2, arrayList);
        }
    }

    private Hashtable getMeasures(String string) {
        String string2 = "";
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = this.runSnmpCmdForOid(string);
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string2 = this.lhs[i];
                    string3 = this.rhs[i] != null && this.rhs[i].trim().length() > 0 ? this.rhs[i].trim() : "-5";
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "WAPRadioStatTest error occured in getMeasures for targetHost :", this.targetHost);
            exception.printStackTrace();
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = string != null && string.trim().length() > 0 ? Double.parseDouble(string) : -5.0;
        }
        catch (Exception exception) {
            d = -5.0;
            this.logToErrorFile("Exception", "WAPRadioStatTest Exception occured in Double value conversion for targetHost :", this.targetHost);
            exception.printStackTrace();
        }
        return d;
    }

    public static void main(String[] stringArray) {
        WAPRadioStatTest wAPRadioStatTest = new WAPRadioStatTest(stringArray);
        wAPRadioStatTest.computeMeasures(new Hashtable());
    }
}

