/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgAgentTopoInfo;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class WebSiteTransactionTest
extends WebAdapterTest {
    public boolean reread = false;
    public ArrayList reportingNames = new ArrayList();
    private int requestRateIndex = 0;
    private int pctErrorsIndex = 1;
    private int pctAbortsIndex = 2;
    private int kbytesSentRateIndex = 3;
    private int avgResponseTimeIndex = 4;
    private int numCurrentRequestsIndex = 5;
    private int monitorPeriod = 300;
    private String index;
    private String[][] categoryName;
    private String[][] categoryInfo;
    private String[] webSites;
    private String[][] aliasSites;
    private int[] aliasSiteCount;
    private int[] categoryCount;
    private double[][][] categoryResult;
    private int numWebSites;
    private String webAdapterFile = egConfigDir + "webadapter.ini.";
    private int MAX_NUM_CATEGORIES;
    private int MAX_NUM_WEBSITES;
    private int MAX_NUM_ALIASES;
    private boolean debug;
    private EgAgentTopoInfo topo;
    private boolean isConfigFileModified;
    private String shmString;
    private String hashCodeString;
    ArrayList objectList;
    private String temp;
    private long sharedMemPtr;

    public native boolean detachSharedId(long var1);

    public native long checkShmid(int var1, boolean var2);

    public native boolean getResult(int var1, double[][] var2, int var3, int var4, int var5, int var6, long var7);

    public native boolean sendConfigInfo(int var1, String[] var2, String[] var3, int var4, int var5, int var6, String var7, int var8, String[] var9, int var10, long var11);

    public static void main(String[] stringArray) {
        WebSiteTransactionTest webSiteTransactionTest = new WebSiteTransactionTest(stringArray);
        webSiteTransactionTest.executeTest();
        for (int i = 0; i < 5; ++i) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            webSiteTransactionTest.executeTest();
        }
    }

    public WebSiteTransactionTest(String[] stringArray) {
        super(stringArray);
        this.MAX_NUM_CATEGORIES = WebSiteTransactionTest.configInfo.maxCategories;
        this.MAX_NUM_WEBSITES = WebSiteTransactionTest.configInfo.maxNumWebSites;
        this.MAX_NUM_ALIASES = WebSiteTransactionTest.configInfo.maxAliasSites;
        this.debug = false;
        this.topo = null;
        this.isConfigFileModified = false;
        this.shmString = null;
        this.hashCodeString = null;
        this.objectList = null;
        this.temp = null;
        this.sharedMemPtr = -1L;
        if (stringArray.length < 6 || !stringArray[0].equalsIgnoreCase("-host") || !stringArray[2].equalsIgnoreCase("-port")) {
            System.err.println("Usage: WebServerTest -host <serverName> -port <portNo> -period <period>\n");
            System.exit(-1);
        }
        this.numOutputFields = 6;
        this.targetHost = new String(stringArray[1]);
        this.portNo = new String(stringArray[3]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-period")) continue;
            try {
                this.monitorPeriod = Integer.parseInt(stringArray[i + 1]);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.hashCodeString = String.valueOf(this.hashCode());
        this.hashCodeString = this.hashCodeString.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTest() {
        if (this.debug) {
            System.out.println("STOPPING TEST with shmid " + this.shmId);
        }
        boolean bl = false;
        Hashtable hashtable = shmIdTestObjects;
        synchronized (hashtable) {
            this.objectList = (ArrayList)shmIdTestObjects.get(this.shmString);
            if (this.objectList != null && this.objectList.size() > 0 && this.objectList.contains(this.hashCodeString)) {
                int n = this.objectList.indexOf(this.hashCodeString);
                if (n != -1) {
                    this.objectList.remove(n);
                }
                if (this.objectList.size() == 0) {
                    bl = true;
                }
            }
        }
        this.shmId = -1;
        if (bl) {
            if (this.sharedMemPtr != -1L) {
                this.detachSharedId(this.sharedMemPtr);
            }
            hashtable = serverSharedId;
            synchronized (hashtable) {
                serverSharedId.remove(this.shmString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTest() {
        if (this.sharedMemPtr != -1L) {
            this.detachSharedId(this.sharedMemPtr);
        }
        this.shmString = String.valueOf(this.shmId);
        this.shmId = -1;
        Hashtable hashtable = serverSharedId;
        synchronized (hashtable) {
            serverSharedId.remove(this.shmString);
        }
        hashtable = shmIdTestObjects;
        synchronized (hashtable) {
            shmIdTestObjects.remove(this.shmString);
        }
        this.shmString = String.valueOf(this.shmId);
    }

    public boolean getSharedId() {
        this.shmId = -1;
        super.searchFiles();
        this.shmString = String.valueOf(this.shmId);
        this.shmString = this.shmString.trim();
        return this.shmId != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTest() {
        int n;
        this.initTest();
        this.categoryResult = new double[WebSiteTransactionTest.configInfo.maxNumWebSites][WebSiteTransactionTest.configInfo.maxCategories][this.numOutputFields];
        if (!this.isFileExist()) {
            this.resetTest();
        }
        if (this.shmId == -1) {
            if (!this.getSharedId()) {
                this.errorMsg = new String("WebAdapterData file could not be opened");
                this.updateAllResultSets();
                this.categoryResult = null;
                return false;
            }
            if (this.shmId == -1) {
                this.updateAllResultSets();
                this.categoryResult = null;
                return true;
            }
            try {
                Properties properties = serverSharedId;
                synchronized (properties) {
                    if (this.getExclusiveAccess()) {
                        if (!this.getAccess()) {
                            this.sharedMemPtr = this.checkShmid(this.shmId, false);
                            if (this.sharedMemPtr != -1L) {
                                String string = String.valueOf(this.sharedMemPtr);
                                serverSharedId.setProperty(this.shmString, string);
                            }
                        }
                    } else {
                        this.shmId = -1;
                        this.errorMsg = "getExclusiveAccess() failed ..";
                        return false;
                    }
                    this.deleteLockFile();
                    if (this.sharedMemPtr == -1L) {
                        this.errorMsg = new String("Shared memory not available for " + this.reportingName + ":" + this.portNo);
                        this.shmId = -1;
                        this.updateAllResultSets();
                        this.categoryResult = null;
                        return false;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                this.shmId = -1;
                this.errorMsg = new String("JNI exception incheckShmid() for " + this.reportingName + ":" + this.portNo);
                this.updateAllResultSets();
                this.categoryResult = null;
                return false;
            }
            if (!this.openConfigFile()) {
                this.resetTest();
                this.categoryResult = null;
                this.updateAllResultSets();
                return true;
            }
            if (this.getExclusiveAccess()) {
                int n2;
                try {
                    if (!this.getAccess()) {
                        this.deleteLockFile();
                        this.shmId = -1;
                        return false;
                    }
                    for (n2 = 0; n2 < this.numWebSites; ++n2) {
                        if (this.sendConfigInfo(n2, this.categoryName[n2], this.categoryInfo[n2], this.categoryCount[n2], this.shmId, this.monitorPeriod, this.webSites[n2], this.numWebSites, this.aliasSites[n2], this.aliasSiteCount[n2], this.sharedMemPtr)) continue;
                        this.resetTest();
                        this.errorMsg = "could not send config info for " + this.reportingName + ":" + this.portNo;
                        this.updateAllResultSets();
                        this.categoryResult = null;
                        this.deleteLockFile();
                        return false;
                    }
                    this.isConfigFileModified = false;
                }
                catch (RuntimeException runtimeException) {
                    this.resetTest();
                    this.errorMsg = " Jni returns false in sendConfigInfo() for " + this.reportingName + ":" + this.portNo;
                    this.updateAllResultSets();
                    this.categoryResult = null;
                    this.deleteLockFile();
                    return false;
                }
                try {
                    if (!this.getAccess()) {
                        this.deleteLockFile();
                        this.shmId = -1;
                        return false;
                    }
                    for (n2 = 0; n2 < this.numWebSites; ++n2) {
                        if (this.getResult(n2, this.categoryResult[n2], this.categoryCount[n2], this.numStructures, this.shmId, this.numWebSites - 1, this.sharedMemPtr)) continue;
                        this.resetTest();
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.resetTest();
                    this.errorMsg = new String("JNI Exception ingetResult() for " + this.reportingName + ":" + this.portNo);
                    this.updateAllResultSets();
                    this.categoryResult = null;
                    this.deleteLockFile();
                    return false;
                }
                this.deleteLockFile();
            }
            this.categoryResult = null;
            this.updateAllResultSets();
            return true;
        }
        if (!this.openConfigFile()) {
            this.categoryResult = null;
            this.resetTest();
            this.updateAllResultSets();
            return true;
        }
        if (this.isConfigFileModified) {
            try {
                if (this.getExclusiveAccess()) {
                    if (!this.getAccess()) {
                        this.deleteLockFile();
                        this.shmId = -1;
                        return false;
                    }
                    for (n = 0; n < this.numWebSites; ++n) {
                        if (this.sendConfigInfo(n, this.categoryName[n], this.categoryInfo[n], this.categoryCount[n], this.shmId, this.monitorPeriod, this.webSites[n], this.numWebSites, this.aliasSites[n], this.aliasSiteCount[n], this.sharedMemPtr)) continue;
                        this.categoryResult = null;
                        this.resetTest();
                        this.errorMsg = "could not send config info for " + this.reportingName + ":" + this.portNo;
                        this.updateAllResultSets();
                        this.deleteLockFile();
                        return false;
                    }
                    this.deleteLockFile();
                }
            }
            catch (RuntimeException runtimeException) {
                this.resetTest();
                this.categoryResult = null;
                this.errorMsg = "Jni Returns False in sendConfigInfo() for " + this.reportingName + ":" + this.portNo;
                this.updateAllResultSets();
                return false;
            }
        }
        try {
            if (this.getExclusiveAccess()) {
                if (!this.getAccess()) {
                    this.deleteLockFile();
                    this.shmId = -1;
                    return false;
                }
                for (n = 0; n < this.numWebSites; ++n) {
                    if (this.getResult(n, this.categoryResult[n], this.categoryCount[n], this.numStructures, this.shmId, this.numWebSites - 1, this.sharedMemPtr)) {
                        if (this.isConfigFileModified) continue;
                        this.printResult(n, this.categoryCount[n]);
                        continue;
                    }
                    this.categoryResult = null;
                    this.resetTest();
                    this.updateAllResultSets();
                    this.deleteLockFile();
                    return true;
                }
                this.deleteLockFile();
            }
            if (!this.isConfigFileModified) {
                this.updateAllResultSets();
            }
            this.categoryResult = null;
            return true;
        }
        catch (RuntimeException runtimeException) {
            this.categoryResult = null;
            this.updateAllResultSets();
            this.errorMsg = new String("JNI Exception in  getResult() for " + this.reportingName + ":" + this.portNo);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAccess() {
        if (serverSharedId.containsKey(this.shmString)) {
            this.temp = serverSharedId.getProperty(this.shmString);
            this.sharedMemPtr = Long.parseLong(this.temp);
            Hashtable hashtable = shmIdTestObjects;
            synchronized (hashtable) {
                if (shmIdTestObjects.containsKey(this.shmString)) {
                    this.objectList = (ArrayList)shmIdTestObjects.get(this.shmString);
                    if (this.objectList != null && !this.objectList.contains(this.hashCodeString)) {
                        this.objectList.add(this.hashCodeString);
                    }
                } else {
                    this.objectList = new ArrayList();
                    this.objectList.add(this.hashCodeString);
                    shmIdTestObjects.put(this.shmString, this.objectList);
                }
            }
            return true;
        }
        return false;
    }

    private void printAndCopy(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
    }

    public boolean openConfigFile() {
        int n;
        if (!this.reread && this.topo != null && !this.topo.checkForUpdate()) {
            this.isConfigFileModified = false;
            return true;
        }
        this.reread = false;
        if (this.topo == null) {
            this.topo = new EgAgentTopoInfo("agent");
        }
        this.isConfigFileModified = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.srvrAddress.length; ++i) {
            if (!this.srvrAddress[i].equals("*") && !this.srvrAddress[i].equals(this.hostIpAddress) && !this.srvrAddress[i].equals("_default_")) continue;
            for (n = 0; n < arrayList.size() && !((String)arrayList.get(n)).equals(this.srvrPorts[i]); ++n) {
            }
            if (n != arrayList.size()) continue;
            arrayList.add(this.srvrPorts[i]);
        }
        if (arrayList.size() == 0) {
            arrayList.add(this.portNo);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = 0; i < this.reportingNames.size(); ++i) {
                String string = (String)this.reportingNames.get(i);
                String[] stringArray = this.topo.getWebSitesForServer(string + ":" + (String)arrayList.get(n));
                if (stringArray == null || stringArray.length == 0) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    int n2;
                    for (n2 = 0; n2 < arrayList2.size() && !stringArray[j].equals((String)arrayList2.get(n2)); ++n2) {
                    }
                    if (n2 != arrayList2.size()) continue;
                    arrayList2.add(stringArray[j]);
                }
            }
        }
        if (arrayList2.size() == 0) {
            if (this.debug) {
                System.out.println("WebSiteTest:  No WebSites to Monitor for " + this.reportingName + ":" + this.portNo);
            }
            return true;
        }
        this.webSites = new String[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            this.webSites[n] = (String)arrayList2.get(n);
        }
        this.numWebSites = this.webSites.length;
        if (this.numWebSites > this.MAX_NUM_WEBSITES) {
            this.errorMsg = new String("Number of websites exceed thelimit webadapter limit " + this.MAX_NUM_WEBSITES + " for " + this.reportingName + ":" + this.portNo);
            this.numWebSites = this.MAX_NUM_WEBSITES;
        }
        this.aliasSites = new String[this.numWebSites][this.MAX_NUM_ALIASES];
        this.aliasSiteCount = new int[this.numWebSites];
        this.categoryCount = new int[this.numWebSites];
        for (n = 0; n < this.numWebSites; ++n) {
            String[] stringArray = this.topo.getSiteAlias(this.webSites[n]);
            if (stringArray == null || stringArray.length == 0) {
                this.aliasSites[n] = null;
                this.aliasSiteCount[n] = 0;
                continue;
            }
            int n3 = stringArray.length;
            if (n3 > this.MAX_NUM_ALIASES) {
                n3 = this.MAX_NUM_ALIASES;
            }
            for (int i = 0; i < n3; ++i) {
                this.aliasSites[n][i] = stringArray[i];
            }
            this.aliasSiteCount[n] = n3;
        }
        this.categoryName = new String[this.MAX_NUM_WEBSITES][this.MAX_NUM_CATEGORIES];
        this.categoryInfo = new String[this.MAX_NUM_WEBSITES][this.MAX_NUM_CATEGORIES];
        for (n = 0; n < this.numWebSites; ++n) {
            String[] stringArray = this.topo.getTransactionsForWebSite(this.webSites[n]);
            if (stringArray == null) {
                this.categoryCount[n] = 0;
                continue;
            }
            this.categoryCount[n] = stringArray.length;
            this.printAndCopy(stringArray, this.categoryName[n]);
        }
        for (n = 0; n < this.numWebSites; ++n) {
            for (int i = 0; i < this.categoryCount[n]; ++i) {
                this.categoryInfo[n][i] = this.topo.getPatternForTransaction(this.webSites[n], this.categoryName[n][i]);
            }
        }
        return true;
    }

    private void printResult(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            String string = this.webSites[n] + siteAndInfoSeparator + infoFieldSeparator + this.categoryName[n][i];
            if (this.categoryResult[n][i][this.requestRateIndex] <= 0.0) {
                d4 = 0.0;
                d3 = 0.0;
            } else {
                d4 = this.categoryResult[n][i][this.pctErrorsIndex] * 100.0 / this.categoryResult[n][i][this.requestRateIndex];
                d3 = this.categoryResult[n][i][this.pctAbortsIndex] * 100.0 / this.categoryResult[n][i][this.requestRateIndex];
                d4 = d4 > 100.0 ? 100.0 : d4;
                double d5 = d3 = d3 > 100.0 ? 100.0 : d3;
            }
            if (this.timeSinceLastTest <= 0.0) {
                d2 = -1.0;
                d = -1.0;
            } else {
                d2 = this.categoryResult[n][i][this.requestRateIndex] / this.timeSinceLastTest;
                d = this.categoryResult[n][i][this.kbytesSentRateIndex] / (this.timeSinceLastTest * 1024.0);
            }
            this.addValueToResultSet(string, this.requestRateIndex, d2);
            this.addValueToResultSet(string, this.pctErrorsIndex, d4);
            this.addValueToResultSet(string, this.pctAbortsIndex, d3);
            this.addValueToResultSet(string, this.kbytesSentRateIndex, d);
            this.addValueToResultSet(string, this.avgResponseTimeIndex, this.categoryResult[n][i][this.avgResponseTimeIndex]);
            this.addValueToResultSet(string, this.numCurrentRequestsIndex, -5.0);
        }
    }

    static {
        System.loadLibrary("eg_reptr_cat");
    }
}

