/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.net.URLEncoder;
import java.util.ArrayList;

public class WsGlobalTxTest
extends EgWebSphere {
    private String uri = "egurkha/egurkha/EgWebSphere.jsp";
    private String webServerPort = "80";
    public boolean isSsl = false;
    private String url = "";
    private String ndmanager = "none";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String encryptPass = "false";
    private String userPassword = "none";
    private String server = "";
    private String serverName = null;
    private static int globalTransBegunIndex = 0;
    private static int activeGlobalTransIndex = 1;
    private static int globalTranDurationIndex = 2;
    private static int globalCommitDurationIndex = 3;
    private static int numOptimizationIndex = 4;
    private static int globalTransCommittedIndex = 5;
    private static int globalTransRolledBackIndex = 6;
    private static int globalTransTimeoutIndex = 7;
    private static int globalTransInvolvedIndex = 8;
    private static int globalPrepareDurationIndex = 9;
    private double globalTransBegun = 0.0;
    private double activeGlobalTrans = 0.0;
    private double globalTranDuration = 0.0;
    private double globalCommitDuration = 0.0;
    private double numOptimization = 0.0;
    private double globalTransCommitted = 0.0;
    private double globalTransRolledBack = 0.0;
    private double globalTransTimeout = 0.0;
    private double globalTransInvolved = 0.0;
    private double globalPrepareDuration = 0.0;
    private String tempHost = "";

    public WsGlobalTxTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 10;
        this.ndmanager = this.getValueForParam("ndmanager");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.serverName = this.getValueForParam("serverHostName");
        this.url = this.getValueForParam("url");
        this.webServerPort = this.getValueForParam("webServerPort");
        this.encryptPass = this.getValueForParam("encryptPass");
        this.server = this.getValueForParam("serverName");
        String string = this.getValueForParam("ssl");
        if (string != null) {
            this.isSsl = new Boolean(string);
        }
        if (this.serverName == null || this.serverName.equalsIgnoreCase("localhost")) {
            this.serverName = this.getHostName();
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.user != null && !this.user.equalsIgnoreCase("none")) {
            this.userPassword = this.user + ":" + EgCrypt.decrypt(this.password);
        }
        this.ndmanager = URLEncoder.encode(this.ndmanager);
        this.serverName = URLEncoder.encode(this.serverName);
        this.server = URLEncoder.encode(this.server);
        this.user = URLEncoder.encode(this.user);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: WsGlobalTxTest -host <targetHost> -port <Port> -webServerPort <webServerPort>");
            return;
        }
        WsGlobalTxTest wsGlobalTxTest = new WsGlobalTxTest(stringArray);
        wsGlobalTxTest.executeTest();
    }

    public boolean executeTest() {
        try {
            this.initTest();
            String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
            this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
            this.url = this.isSsl ? "https://" + this.tempHost + ":" + this.webServerPort : "http://" + this.tempHost + ":" + this.webServerPort;
            String string2 = this.url + "/" + this.uri + "?module=transactionModule&summary=true&transaction=global&hostname=" + this.serverName + "&ndmanager=" + this.ndmanager + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + this.password + "&server=" + this.server;
            ArrayList arrayList = this.returnMeasures(string2, "transaction", this.isSsl, this.userPassword);
            if (arrayList == null) {
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            this.tokenizeMeasureString(arrayList);
            String[] stringArray = this.getInfo();
            if (stringArray == null || stringArray.length == 0) {
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].substring(0, stringArray[i].lastIndexOf("transactionModule") - 1);
                this.globalTransBegun = this.getValue(stringArray[i], "globalTransBegun", true);
                this.activeGlobalTrans = this.getValue(stringArray[i], "activeGlobalTrans", false);
                this.globalTranDuration = this.getValue(stringArray[i], "globalTranDuration", true);
                if (this.globalTranDuration > 0.0) {
                    this.globalTranDuration /= 1000.0;
                }
                this.globalCommitDuration = this.getValue(stringArray[i], "globalCommitDuration", true);
                if (this.globalCommitDuration > 0.0) {
                    this.globalCommitDuration /= 1000.0;
                }
                this.numOptimization = this.getValue(stringArray[i], "numOptimization", true);
                this.globalTransCommitted = this.getValue(stringArray[i], "globalTransCommitted", true);
                this.globalTransRolledBack = this.getValue(stringArray[i], "globalTransRolledBack", true);
                this.globalTransTimeout = this.getValue(stringArray[i], "globalTransTimeout", true);
                this.globalTransInvolved = this.getValue(stringArray[i], "globalTransInvolved", true);
                this.globalPrepareDuration = this.getValue(stringArray[i], "globalPrepareDuration", true);
                if (this.globalPrepareDuration > 0.0) {
                    this.globalPrepareDuration /= 1000.0;
                }
                if (this.timeSinceLastTest <= 0.0) {
                    this.globalTransBegun = -1.0;
                    this.globalTranDuration = -1.0;
                    this.globalCommitDuration = -1.0;
                    this.numOptimization = -1.0;
                    this.globalTransCommitted = -1.0;
                    this.globalTransRolledBack = -1.0;
                    this.globalTransTimeout = -1.0;
                    this.globalTransInvolved = -1.0;
                    this.globalPrepareDuration = -1.0;
                } else {
                    this.globalTransBegun /= this.timeSinceLastTest;
                    this.numOptimization /= this.timeSinceLastTest;
                    this.globalTransCommitted /= this.timeSinceLastTest;
                    this.globalTransRolledBack /= this.timeSinceLastTest;
                    this.globalTransTimeout /= this.timeSinceLastTest;
                }
                if (this.globalTransBegun < 0.0 || this.globalTranDuration < 0.0 || this.globalCommitDuration < 0.0 || this.numOptimization < 0.0 || this.globalTransCommitted < 0.0 || this.globalTransRolledBack < 0.0 || this.globalTransTimeout < 0.0 || this.globalTransInvolved < 0.0 || this.globalPrepareDuration < 0.0) {
                    this.globalTransBegun = -1.0;
                    this.globalTranDuration = -1.0;
                    this.globalCommitDuration = -1.0;
                    this.numOptimization = -1.0;
                    this.globalTransCommitted = -1.0;
                    this.globalTransRolledBack = -1.0;
                    this.globalTransTimeout = -1.0;
                    this.globalTransInvolved = -1.0;
                    this.globalPrepareDuration = -1.0;
                }
                this.addValueToResultSet(string + string3, globalTransBegunIndex, this.globalTransBegun);
                this.addValueToResultSet(string + string3, activeGlobalTransIndex, this.activeGlobalTrans);
                this.addValueToResultSet(string + string3, globalTranDurationIndex, this.globalTranDuration);
                this.addValueToResultSet(string + string3, globalCommitDurationIndex, this.globalCommitDuration);
                this.addValueToResultSet(string + string3, numOptimizationIndex, this.numOptimization);
                this.addValueToResultSet(string + string3, globalTransCommittedIndex, this.globalTransCommitted);
                this.addValueToResultSet(string + string3, globalTransRolledBackIndex, this.globalTransRolledBack);
                this.addValueToResultSet(string + string3, globalTransTimeoutIndex, this.globalTransTimeout);
                this.addValueToResultSet(string + string3, globalTransInvolvedIndex, this.globalTransInvolved);
                this.addValueToResultSet(string + string3, globalPrepareDurationIndex, this.globalPrepareDuration);
            }
            this.updateAllResultSets(true);
            return true;
        }
        catch (Exception exception) {
            this.updateAllResultSets();
            return true;
        }
    }
}

