/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;

public class WsJdbcTest
extends EgWebSphere {
    private String uri = "egurkha/egurkha/EgWebSphere.jsp";
    private String webServerPort = "80";
    public boolean isSsl = false;
    private String url = "";
    private String ndmanager = "none";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String encryptPass = "false";
    private String userPassword = "none";
    private String serverName = null;
    private String server = "";
    private static int creationRateIndex = 0;
    private static int destroyRateIndex = 1;
    private static int returnRateIndex = 2;
    private static int allocationRateIndex = 3;
    private static int poolSizeIndex = 4;
    private static int concurrentWaitersIndex = 5;
    private static int avgWaitTimeIndex = 6;
    private static int faultsIndex = 7;
    private static int pctUsedIndex = 8;
    private static int pctMaxedIndex = 9;
    private static int prepStmtCacheDiscardsIndex = 10;
    private double creationRate = 0.0;
    private double destroyRate = 0.0;
    private double returnRate = 0.0;
    private double allocationRate = 0.0;
    private double poolSize = 0.0;
    private double concurrentWaiters = 0.0;
    private double avgWaitTime = 0.0;
    private double faults = 0.0;
    private double pctUsed = 0.0;
    private double pctMaxed = 0.0;
    private double prepStmtCacheDiscards = 0.0;
    private String tempHost = "";

    public WsJdbcTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 11;
        this.ndmanager = this.getValueForParam("ndmanager");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.serverName = this.getValueForParam("serverHostName");
        this.url = this.getValueForParam("url");
        this.webServerPort = this.getValueForParam("webServerPort");
        this.encryptPass = this.getValueForParam("encryptPass");
        this.server = this.getValueForParam("serverName");
        String string = this.getValueForParam("ssl");
        if (string != null) {
            this.isSsl = new Boolean(string);
        }
        if (this.serverName == null || this.serverName.equalsIgnoreCase("localhost")) {
            this.serverName = this.getHostName();
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.user != null && !this.user.equalsIgnoreCase("none")) {
            this.userPassword = this.user + ":" + EgCrypt.decrypt(this.password);
        }
        this.ndmanager = URLEncoder.encode(this.ndmanager);
        this.serverName = URLEncoder.encode(this.serverName);
        this.server = URLEncoder.encode(this.server);
        this.user = URLEncoder.encode(this.user);
    }

    public static void main(String[] stringArray) {
        WsJdbcTest wsJdbcTest = new WsJdbcTest(stringArray);
        wsJdbcTest.executeTest();
    }

    public boolean executeTest() {
        try {
            this.initTest();
            String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
            this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
            this.url = this.isSsl ? "https://" + this.tempHost + ":" + this.webServerPort : "http://" + this.tempHost + ":" + this.webServerPort;
            String string2 = this.url + "/" + this.uri + "?module=connectionPoolModule&summary=true&hostname=" + this.serverName + "&ndmanager=" + this.ndmanager + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + this.password + "&server=" + this.server;
            ArrayList arrayList = this.returnMeasures(string2, "connectionPool", this.isSsl, this.userPassword);
            if (arrayList == null) {
                this.prevValues = new Hashtable();
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            this.tokenizeMeasureString(arrayList);
            String[] stringArray = this.getInfo();
            if (stringArray == null || stringArray.length == 0) {
                this.prevValues = new Hashtable();
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].endsWith("connectionPoolModule")) continue;
                String string3 = string + stringArray[i];
                this.creationRate = this.getValue(stringArray[i], "numCreates", true);
                this.destroyRate = this.getValue(stringArray[i], "numDestroys", true);
                this.returnRate = this.getValue(stringArray[i], "numReturns", true);
                this.allocationRate = this.getValue(stringArray[i], "numAllocates", true);
                this.poolSize = this.getValue(stringArray[i], "poolSize", false);
                this.concurrentWaiters = this.getValue(stringArray[i], "concurrentWaiters", false);
                this.avgWaitTime = this.getValue(stringArray[i], "avgWaitTime", true);
                if (this.avgWaitTime > 0.0) {
                    this.avgWaitTime /= 1000.0;
                }
                this.faults = this.getValue(stringArray[i], "faults", true);
                this.pctUsed = this.getValue(stringArray[i], "percentUsed", false);
                this.pctMaxed = this.getValue(stringArray[i], "percentMaxed", false);
                this.prepStmtCacheDiscards = this.getValue(stringArray[i], "prepStmtCacheDiscards", true);
                if (this.timeSinceLastTest <= 0.0) {
                    this.creationRate = -1.0;
                    this.destroyRate = -1.0;
                    this.returnRate = -1.0;
                    this.allocationRate = -1.0;
                    this.faults = -1.0;
                    this.prepStmtCacheDiscards = -1.0;
                } else {
                    this.creationRate /= this.timeSinceLastTest;
                    this.destroyRate /= this.timeSinceLastTest;
                    this.returnRate /= this.timeSinceLastTest;
                    this.allocationRate /= this.timeSinceLastTest;
                    this.faults /= this.timeSinceLastTest;
                    this.prepStmtCacheDiscards /= this.timeSinceLastTest;
                }
                if (this.creationRate < 0.0 || this.destroyRate < 0.0 || this.returnRate < 0.0 || this.allocationRate < 0.0 || this.avgWaitTime < 0.0 || this.faults < 0.0 || this.prepStmtCacheDiscards < 0.0) {
                    this.creationRate = -1.0;
                    this.destroyRate = -1.0;
                    this.returnRate = -1.0;
                    this.allocationRate = -1.0;
                    this.avgWaitTime = -1.0;
                    this.faults = -1.0;
                    this.prepStmtCacheDiscards = -1.0;
                }
                this.addValueToResultSet(string3, creationRateIndex, this.creationRate);
                this.addValueToResultSet(string3, destroyRateIndex, this.destroyRate);
                this.addValueToResultSet(string3, returnRateIndex, this.returnRate);
                this.addValueToResultSet(string3, allocationRateIndex, this.allocationRate);
                this.addValueToResultSet(string3, poolSizeIndex, this.poolSize);
                this.addValueToResultSet(string3, concurrentWaitersIndex, this.concurrentWaiters);
                this.addValueToResultSet(string3, avgWaitTimeIndex, this.avgWaitTime);
                this.addValueToResultSet(string3, faultsIndex, this.faults);
                this.addValueToResultSet(string3, pctUsedIndex, this.pctUsed);
                this.addValueToResultSet(string3, pctMaxedIndex, this.pctMaxed);
                this.addValueToResultSet(string3, prepStmtCacheDiscardsIndex, this.prepStmtCacheDiscards);
            }
            this.updateAllResultSets(true);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.updateAllResultSets();
            return true;
        }
    }
}

