/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.eg.EgSSL;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class XtremIOBase
extends GenericTest {
    protected String xioUser = null;
    protected String xioPass = null;
    protected String xmsIP = "";
    protected String urlString = "";
    protected final String DEFAULT_PORT = "80";
    private final String DEFAULT_URI_SUFFIX = "";
    boolean isSsl = false;
    private boolean ssl_enabled = false;
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    protected static final double KB_TO_GB = 1048576.0;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    protected String monitoredCluster = null;
    protected double xioAPIVersion = 1.0;
    protected static final String HYPHEN = "-";

    public XtremIOBase(String[] stringArray) {
        super(stringArray);
        try {
            String string;
            this.xioUser = this.getValueForParam("XtremIO_user");
            this.xioPass = this.getValueForParam("XtremIO_password");
            this.xmsIP = this.getValueForParam("xms_ip");
            String string2 = this.getValueForParam("ssl");
            if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"))) {
                this.isSsl = true;
            }
            if ((string = this.getValueForParam("XtremIO_API_Version")) == null || string.trim().length() == 0 || string.equalsIgnoreCase("NONE") || string.equalsIgnoreCase("null")) {
                this.xioAPIVersion = 1.0;
            } else {
                try {
                    this.xioAPIVersion = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    this.xioAPIVersion = 1.0;
                }
            }
            this.monitoredCluster = this.getValueForParam("XtremIO_Cluster");
            if (this.monitoredCluster == null || this.monitoredCluster.trim().length() == 0 || this.monitoredCluster.equalsIgnoreCase("NONE") || this.monitoredCluster.equalsIgnoreCase("null")) {
                this.xioAPIVersion = 1.0;
            }
            if (this.xmsIP == null || this.xmsIP.trim().length() == 0 || this.xmsIP.equalsIgnoreCase("NONE") || this.xmsIP.equalsIgnoreCase("null")) {
                this.xmsIP = this.targetHost;
                this.printOut("XMS IP is empty, Assign host IP to XMS IP");
            } else if (this.xmsIP != null && this.xmsIP.trim().length() > 0 && !this.xmsIP.equalsIgnoreCase("NONE") && !this.xmsIP.equalsIgnoreCase("null")) {
                this.xioAPIVersion = 2.0;
                this.monitoredCluster = this.targetHost;
                this.printOut("XMS IP provided by user, Assign hostname to Cluster name and version  is 2");
            }
            this.urlString = this.isSsl ? "https://" + this.xmsIP + "/" : "http://" + this.xmsIP + "/";
            this.printOut("XMSIP " + this.xmsIP);
            this.printOut("Version " + this.xioAPIVersion);
            this.printOut("Clutser " + this.monitoredCluster);
            String string3 = "80";
            if (this.portNo != null && !this.portNo.equalsIgnoreCase("null")) {
                string3 = this.portNo;
            }
            this.printOut("urlString : " + this.urlString);
            this.needAgentlessDD = true;
            this.isNewDynamicInfoTest = true;
            this.fixedTestPeriod = true;
        }
        catch (Exception exception) {
            this.printOut("Error in base constructor " + exception.toString());
            this.putErrorMessageToLogfile("Error in base constructor " + exception.toString());
            exception.printStackTrace();
        }
    }

    public String getJSONDataFromURL(String string, boolean bl) {
        String string2 = this.urlString + string;
        return this.getJSONDataFromURL(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJSONDataFromURL(String string) {
        string = string + "";
        this.printOut("URL String in getJSONDataFromURL  :" + string);
        HttpURLConnection httpURLConnection = null;
        String string2 = null;
        try {
            Object object;
            ConnectionThread connectionThread;
            Object object2;
            byte[] byArray;
            Object object3;
            Object object4;
            if (this.isSsl && !this.ssl_enabled) {
                object4 = EgSSL.getInstance();
                EgSSL.enableSSL();
                object3 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                byArray = null;
                object2 = new MyX509TrustManager();
                connectionThread = null;
                TrustManager[] trustManagerArray = new TrustManager[]{object2};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init((KeyManager[])connectionThread, trustManagerArray, new SecureRandom());
                object = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)object);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                this.ssl_enabled = true;
            }
            object4 = new URL(string);
            object3 = this.xioUser + ":" + this.xioPass;
            byArray = Base64.encodeBase64((byte[])((String)object3).getBytes());
            object2 = new String(byArray);
            httpURLConnection = (HttpURLConnection)((URL)object4).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(500);
            httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object2);
            httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.connect();
            connectionThread = new ConnectionThread(httpURLConnection, false);
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            object = new StringBuilder();
            if (bl) {
                ArrayList arrayList;
                n = connectionThread.code;
                if (n != 200) {
                    this.putErrorMessageToLogfile("Error in getJSONDataFromURL method REST url connection ..." + n);
                }
                if ((arrayList = connectionThread.data) == null || arrayList.isEmpty() || arrayList.size() == 0) {
                    this.putWarningMessageToLogfile(" Data null or empty data");
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((StringBuilder)object).append((String)arrayList.get(i));
                }
            }
            if (!bl || n != 200) {
                this.putWarningMessageToLogfile(" Timing out or invalid response code:" + n);
            }
            string2 = ((StringBuilder)object).toString();
            this.printOut("Result value in getJSONDataFromURL :" + string2);
        }
        catch (Exception exception) {
            this.putErrorMessageToLogfile("Error in getJSONDataFromURL " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            httpURLConnection = null;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        String string = "api/json/types/clusters";
        XtremIOBase xtremIOBase = new XtremIOBase(stringArray);
        xtremIOBase.getJSONDataFromURL(string, true);
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                this.putWarningMessageToLogfile(" Timed out and hence going to kill the thread :" + System.currentTimeMillis());
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                this.putWarningMessageToLogfile(" Timed out and killed the thread :" + System.currentTimeMillis());
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        this.putWarningMessageToLogfile(" sleepTime less than zero in checkForTimeout :" + System.currentTimeMillis());
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                this.printOut("" + exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    protected double getValueFromJSONObject(JSONObject jSONObject, String string) {
        return this.getValueFromJSONObject(jSONObject, string, false);
    }

    protected double getValueFromJSONObject(JSONObject jSONObject, String string, boolean bl) {
        double d;
        block12: {
            d = -5.0;
            try {
                if (jSONObject == null || jSONObject.isEmpty()) {
                    this.printOut("jsonObject is  null or empty for the parameter :" + string);
                    return d;
                }
                if (bl) {
                    try {
                        long l = (Long)jSONObject.get((Object)string);
                        d = l;
                    }
                    catch (Exception exception) {
                        d = -5.0;
                    }
                    break block12;
                }
                String string2 = null;
                try {
                    string2 = "" + jSONObject.get((Object)string);
                }
                catch (Exception exception) {
                    this.printOut("Exception raised while parsing json object for the parmeter :" + string + " , Exception message :" + exception.toString());
                }
                if (string2 == null || string2.trim().length() == 0 || string2.equalsIgnoreCase("none") || string2.equalsIgnoreCase("null")) {
                    d = -5.0;
                } else {
                    try {
                        d = Double.parseDouble(string2);
                    }
                    catch (Exception exception) {
                        d = -5.0;
                    }
                }
                this.printOut("Parameter : " + string + " value: " + d);
            }
            catch (Exception exception) {
                this.printOut("getValueFromJSONObject got exception " + exception.toString());
            }
        }
        return d;
    }

    protected Hashtable getTypeDataHashtable(String string) {
        Hashtable<String, String> hashtable;
        block9: {
            hashtable = new Hashtable<String, String>();
            try {
                String string2 = string;
                if (string.lastIndexOf("/") > -1) {
                    string = string.substring(string.lastIndexOf("/") + 1);
                    this.printOut("Param for before  calling method  :" + string);
                    if (string.equalsIgnoreCase("xms")) {
                        string = string + "s";
                    } else if (this.xioAPIVersion > 1.0 && string.indexOf("?cluster-name=") > -1) {
                        string = string.substring(0, string.lastIndexOf("?cluster-name="));
                        this.printOut("Param for inside  calling method  :" + string);
                    }
                }
                this.printOut("Param for the calling method  :" + string);
                String string3 = this.getJSONDataFromURL(string2, true);
                if (string3 == null || string3.length() <= 0) break block9;
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject = null;
                try {
                    jSONObject = (JSONObject)jSONParser.parse(string3);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                JSONArray jSONArray = (JSONArray)jSONObject.get((Object)string);
                for (int i = 0; i < jSONArray.size(); ++i) {
                    JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
                    String string4 = (String)jSONObject2.get((Object)"href");
                    String string5 = (String)jSONObject2.get((Object)"name");
                    this.printOut(string4);
                    this.printOut(string5);
                    if (string4 == null || string4.trim().length() <= 0 || string5 == null || string5.trim().length() <= 0) continue;
                    hashtable.put(string5, string4);
                }
            }
            catch (Exception exception) {
                this.printOut("Error in getTypeDataHashtable  method : " + exception.toString());
                this.putErrorMessageToLogfile("Error in getTypeDataHashtable  method : " + exception.toString());
            }
        }
        this.printOut("getTypeDataHashtable result  " + hashtable);
        return hashtable;
    }

    protected Hashtable getClusters() {
        Hashtable hashtable = new Hashtable();
        String string = "api/json/types/clusters";
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getXEnvs() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/xenvs?cluster-name=" + this.monitoredCluster : "api/json/types/xenvs";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getXBricks() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/bricks?cluster-name=" + this.monitoredCluster : "api/json/types/bricks";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getXDPGs() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/data-protection-groups?cluster-name=" + this.monitoredCluster : "api/json/types/data-protection-groups";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getVolumes() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/volumes?cluster-name=" + this.monitoredCluster : "api/json/types/volumes";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getVolumeFolders() {
        Hashtable hashtable = new Hashtable();
        String string = "api/json/types/volume-folders";
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getSnapShots() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/snapshots?cluster-name=" + this.monitoredCluster : "api/json/types/snapshots";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getInitiators() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/initiators?cluster-name=" + this.monitoredCluster : "api/json/types/initiators";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getInitiatorGroups() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/initiator-groups?cluster-name=" + this.monitoredCluster : "api/json/types/initiator-groups";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getSSDs() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/ssds?cluster-name=" + this.monitoredCluster : "api/json/types/ssds";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getIGFolders() {
        Hashtable hashtable = new Hashtable();
        String string = "api/json/types/ig-folders";
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getTargets() {
        String string = null;
        string = this.xioAPIVersion > 1.0 ? "api/json/v2/types/targets?cluster-name=" + this.monitoredCluster : "api/json/types/targets";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getDAEs() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "api/json/v2/types/daes?cluster-name=" + this.monitoredCluster;
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getDAEPSUS() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "api/json/v2/types/dae-psus?cluster-name=" + this.monitoredCluster;
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getInfinibandSwitches() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "api/json/v2/types/infiniband-switches?cluster-name=" + this.monitoredCluster;
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getBBUs() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "/api/json/v2/types/bbus?cluster-name=" + this.monitoredCluster;
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getDAEController() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "/api/json/v2/types/dae-controllers?cluster-name=" + this.monitoredCluster;
        this.printOut("URI for getDAEController :" + string);
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        this.printOut("getDAEController  Hashtable value :" + hashtable);
        return hashtable;
    }

    protected Hashtable getLocalDisks() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "/api/json/v2/types/local-disks?cluster-name=" + this.monitoredCluster;
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getXMS() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "/api/json/v2/types/xms";
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getSlots() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "/api/json/v2/types/slots?cluster-name=" + this.monitoredCluster;
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected Hashtable getStorageControllers() {
        String string = null;
        if (!(this.xioAPIVersion > 1.0)) {
            return null;
        }
        string = "api/json/v2/types/storage-controllers?cluster-name=" + this.monitoredCluster;
        Hashtable hashtable = new Hashtable();
        hashtable = this.getTypeDataHashtable(string);
        return hashtable;
    }

    protected double kbToGB(double d) {
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = d / 1048576.0;
        }
        return d2;
    }

    protected double roundDouble(double d) {
        double d2 = 0.0;
        int n = 2;
        d2 = this.roundDouble(d, n);
        return d2;
    }

    protected double roundDouble(double d, int n) {
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string;
                object = "";
                if (d < 0.0) {
                    object = (String)object + HYPHEN;
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string2.substring(1);
                }
                object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.printOut("Error in  roundDouble method :" + exception.toString());
            this.putErrorMessageToLogfile("Error in  roundDouble method :" + exception.toString());
        }
        return d2;
    }

    protected double fruLifeCycleState(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("healthy") ? 0.0 : (string.equalsIgnoreCase("initializing") ? 1.0 : (string.equalsIgnoreCase("uninitialized") ? 2.0 : (string.equalsIgnoreCase("failed") ? 3.0 : (string.equalsIgnoreCase("disconnected") ? 4.0 : -1.0)))));
        return d;
    }

    protected double enabledStatus(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("enabled") ? 0.0 : (string.equalsIgnoreCase("disabled") ? 1.0 : -1.0));
        return d;
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }
}

