/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ZingJvmMemoryUsage
extends GenericTest {
    private int measurecount = 5;
    private static String[] descriptor = new String[]{"Physical", "Linux", "Zing:Total", "Zing:Reservable", "Zing:Contingency", "Zing:PausePrevention"};
    private static String[] zingPSPath = new String[]{"/usr/bin/zing-ps", "/usr/local/bin/zing-ps", "/usr/sbin/zing-ps"};
    private String targetJVMOsName = "";
    private ArrayList ddTotalList = null;
    private ArrayList ddContingencyList = null;
    private ArrayList ddPauseList = null;

    public ZingJvmMemoryUsage(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measurecount);
        this.isNewDynamicInfoTest = true;
        this.targetJVMOsName = this.alos != null ? this.alos.toLowerCase() : System.getProperty("os.name").toLowerCase();
    }

    private String getZingPSPath() {
        String string = "";
        for (int i = 0; i < zingPSPath.length; ++i) {
            String string2 = zingPSPath[i];
            File file = new File(string2);
            if (!file.exists()) continue;
            string = zingPSPath[i];
            break;
        }
        return string;
    }

    public void computeMeasures(Hashtable hashtable) {
        if (this.targetJVMOsName.indexOf("linux") <= -1) {
            return;
        }
        boolean bl = false;
        String string = this.getZingPSPath();
        if (string != null && string.length() > 0) {
            bl = true;
        }
        if (bl) {
            try {
                String string2 = string + " -s";
                EgUtilities egUtilities = EgUtilities.createInstance();
                ArrayList arrayList = egUtilities.getCommandOutputLines(string2);
                if (arrayList != null && arrayList.size() > 0) {
                    this.processResult(arrayList);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception occured ZingJvmMemoryUsage " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private static double[] getDetails(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = stringTokenizer.countTokens();
        double[] dArray = null;
        if (n2 == 7) {
            dArray = new double[6];
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < 6; ++i) {
                dArray[i] = ZingJvmMemoryUsage.doubleConversion(stringTokenizer.nextToken());
            }
        }
        return dArray;
    }

    private static double doubleConversion(String string) {
        if (string != null && string.length() > 0) {
            if (string.equals("-")) {
                return -1.0;
            }
            try {
                double d = Double.parseDouble(string);
                return d;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0.0;
    }

    private void processResult(ArrayList arrayList) {
        Object object;
        int n;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        int n2 = 0;
        this.ddTotalList = new ArrayList();
        this.ddContingencyList = null;
        this.ddPauseList = null;
        if (arrayList != null && arrayList.size() > 0) {
            n = arrayList.size();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                int n3;
                Object object2;
                int n4;
                StringTokenizer stringTokenizer;
                String string = (String)arrayList.get(i);
                int n5 = string.length();
                if (n5 == 0) continue;
                string = string.trim();
                if (!bl) {
                    if (string.startsWith("Used:")) {
                        dArray = ZingJvmMemoryUsage.getDetails(string, 0);
                    } else if (string.startsWith("Free:")) {
                        dArray2 = ZingJvmMemoryUsage.getDetails(string, 1);
                    } else if (string.startsWith("Total:")) {
                        dArray3 = ZingJvmMemoryUsage.getDetails(string, 2);
                    }
                    if (string.indexOf("Found") <= -1 || string.indexOf("process") <= -1) continue;
                    bl = true;
                    stringTokenizer = new StringTokenizer(string, " ");
                    n4 = stringTokenizer.countTokens();
                    if (n4 < 2) continue;
                    stringTokenizer.nextToken();
                    object2 = stringTokenizer.nextToken();
                    if (object2 == null || ((String)object2).length() <= 0) continue;
                    try {
                        n2 = Integer.parseInt((String)object2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (string == null || string.startsWith("USER") || (n4 = (stringTokenizer = new StringTokenizer(string, " ")).countTokens()) < 10) continue;
                object2 = new ArrayList();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                object = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = stringTokenizer.nextToken();
                String string9 = stringTokenizer.nextToken();
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken()).append(" ");
                }
                String string10 = stringBuffer.toString();
                ((ArrayList)object2).add(string3);
                ((ArrayList)object2).add(string2);
                ((ArrayList)object2).add(string4);
                ((ArrayList)object2).add(string5);
                ((ArrayList)object2).add(string6);
                ((ArrayList)object2).add(string7);
                ((ArrayList)object2).add(string8);
                ((ArrayList)object2).add(string9);
                ((ArrayList)object2).add(string10);
                this.ddTotalList.add(object2);
                try {
                    n3 = Integer.parseInt(string7);
                    if (n3 > 0) {
                        if (this.ddContingencyList == null) {
                            this.ddContingencyList = new ArrayList();
                        }
                        this.ddContingencyList.add(object2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    n3 = Integer.parseInt(string8);
                    if (n3 <= 0) continue;
                    if (this.ddPauseList == null) {
                        this.ddPauseList = new ArrayList();
                    }
                    this.ddPauseList.add(object2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (dArray != null && dArray.length > 0 && dArray2 != null && dArray2.length > 0 && dArray3 != null && dArray3.length > 0) {
            for (n = 0; n < descriptor.length; ++n) {
                String string = descriptor[n];
                void var8_10 = dArray[n];
                void var10_13 = dArray2[n];
                void var12_17 = dArray3[n];
                double d = -5.0;
                if (var8_10 > -1.0 && var12_17 > 0.0) {
                    d = var8_10 / var12_17 * 100.0;
                }
                object = new ArrayList<Double>();
                ((ArrayList)object).add(new Double((double)var8_10));
                ((ArrayList)object).add(new Double((double)var10_13));
                ((ArrayList)object).add(new Double((double)var12_17));
                ((ArrayList)object).add(new Double(d));
                if (string.equals(descriptor[2])) {
                    ((ArrayList)object).add(new Double(n2));
                } else {
                    ((ArrayList)object).add(new Double(-5.0));
                }
                this.addNewMeasure(string, (ArrayList)object);
            }
        }
    }

    private ArrayList getTotalDDList() {
        return this.ddTotalList;
    }

    private ArrayList getContingencyDDList() {
        return this.ddContingencyList;
    }

    private ArrayList getPauseDDList() {
        return this.ddPauseList;
    }

    public ArrayList getDDList(String string) {
        if (string != null) {
            if (string.indexOf(descriptor[2]) > -1) {
                return this.getTotalDDList();
            }
            if (string.indexOf(descriptor[4]) > 0) {
                return this.getContingencyDDList();
            }
            if (string.indexOf(descriptor[5]) > 0) {
                return this.getPauseDDList();
            }
        }
        return null;
    }
}

