/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class WebLogicDependencyServers {
    static MBeanServerConnection connection;
    static JMXConnector connector;
    static ObjectName service;
    private String hostIp;
    private ArrayList portNos;
    private String who;

    public WebLogicDependencyServers(String string, ArrayList arrayList, String string2) {
        this.hostIp = string;
        this.portNos = arrayList;
        this.who = string2;
    }

    private boolean connectToWebLogic(String string, int n, String string2, String string3) {
        boolean bl = false;
        String string4 = "t3";
        String string5 = "/jndi/";
        String string6 = "weblogic.management.mbeanservers.domainruntime";
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL(string4, string, n, string5 + string6);
            service = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.security.principal", string2);
            hashtable.put("java.naming.security.credentials", string3);
            hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            connector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
            connection = connector.getMBeanServerConnection();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private Object getObjectName(ObjectName objectName, String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return connection.getAttribute(objectName, string);
    }

    private ArrayList getJdbcRuntime() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ObjectName[] objectNameArray = (ObjectName[])connection.getAttribute(service, "ServerRuntimes");
            int n = objectNameArray.length;
            for (int i = 0; i < n; ++i) {
                String string = (String)connection.getAttribute(objectNameArray[i], "Name");
                ObjectName[] objectNameArray2 = (ObjectName[])connection.getAttribute(new ObjectName("com.bea:Name=" + string + ",ServerRuntime=" + string + ",Location=" + string + ",Type=JDBCServiceRuntime"), "JDBCDataSourceRuntimeMBeans");
                int n2 = objectNameArray2.length;
                for (int j = 0; j < n2; ++j) {
                    String string2 = (String)connection.getAttribute(objectNameArray2[j], "Name");
                    ObjectName objectName = new ObjectName("com.bea:Name=" + string2 + ",Type=JDBCSystemResource");
                    ObjectName objectName2 = (ObjectName)this.getObjectName(objectName, "JDBCResource");
                    ObjectName objectName3 = (ObjectName)this.getObjectName(objectName2, "JDBCDriverParams");
                    String string3 = (String)this.getObjectName(objectName3, "Url");
                    if (string3 == null || string3.length() <= 0) continue;
                    arrayList.add(string3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public ArrayList discoverDependencyServers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IniFile iniFile = null;
        if (this.who.equals("Manager")) {
            iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
        } else if (this.who.equals("Agent")) {
            iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
        }
        String string = iniFile.getValue("DISCOVERY_CREDENTIAL", "WebLogic_server");
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.indexOf(":") <= 0) continue;
                String string3 = string2.substring(0, string2.indexOf(":"));
                String string4 = string2.substring(string2.indexOf(":") + 1);
                for (int i = 0; i < this.portNos.size(); ++i) {
                    ArrayList arrayList2;
                    Integer n = (Integer)this.portNos.get(i);
                    int n2 = n;
                    if (!this.connectToWebLogic(this.hostIp, n2, string3, string4) || (arrayList2 = this.getJdbcRuntime()) == null || arrayList2.size() <= 0) continue;
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        String string5;
                        String string6 = ((String)arrayList2.get(j)).toLowerCase();
                        if (string6.indexOf("oracle") > 0) {
                            string5 = this.parseOracleUrl(string6, n2);
                            arrayList.add(string5);
                            continue;
                        }
                        if (string6.indexOf("sql") <= 0) continue;
                        string5 = this.parseSqlUrl(string6, n2);
                        arrayList.add(string5);
                    }
                }
            }
        }
        return arrayList;
    }

    private String parseSqlUrl(String string, int n) {
        String string2 = null;
        IniFile iniFile = null;
        if (this.who.equals("Agent")) {
            iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_discover.ini", true);
        } else if (this.who.equals("Manager")) {
            iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini", true);
        }
        if (string.indexOf("sqlserver") > 0 || string.indexOf("microsoft") > 0) {
            string = string.substring(string.indexOf("://") + 3);
            String string3 = string.substring(0, string.indexOf(":"));
            String string4 = string.substring(string.indexOf(":") + 1);
            if (string4.indexOf("/") > 0) {
                string4 = string4.substring(0, string4.indexOf("/"));
            } else if (string4.indexOf(";") > 0) {
                string4 = string4.substring(0, string4.indexOf(";"));
            }
            string2 = "MS_sql_server:" + string3 + ":" + string4 + "=" + "MS_sql_server" + "," + string3 + "," + string3 + "," + string4 + ",no";
            iniFile.setValue(this.hostIp + "_DEPENDENCY_COMPONENTS", "MS_sql_server:" + string3 + ":" + string4, "WebLogic_server:" + this.hostIp + ":" + n);
        }
        iniFile.saveFile();
        return string2;
    }

    private String parseOracleUrl(String string, int n) {
        String string2 = null;
        IniFile iniFile = null;
        if (this.who.equals("Agent")) {
            iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_discover.ini", true);
        } else if (this.who.equals("Manager")) {
            iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini", true);
        }
        if (string.indexOf("@") > 0) {
            Object object;
            string = string.substring(string.indexOf("@") + 1);
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (string.indexOf("address") > 0 || string.indexOf("protocol") > 0) {
                string3 = string.substring(string.indexOf("host=") + 5, string.indexOf(")"));
                object = string.substring(string.indexOf("port=") + 5);
                string4 = ((String)object).substring(0, ((String)object).indexOf(")"));
                object = ((String)object).substring(((String)object).indexOf("sid=") + 4);
                string5 = ((String)object).substring(0, ((String)object).indexOf(")"));
            } else if (string.indexOf("/") > 0) {
                string3 = string.substring(0, string.indexOf(":"));
                string4 = string.substring(string.indexOf(":") + 1, string.indexOf("/"));
                string5 = string.substring(string.indexOf("/") + 1);
            } else if (string.indexOf(":") > 0 && ((StringTokenizer)(object = new StringTokenizer(string, ":"))).countTokens() == 3) {
                string3 = ((StringTokenizer)object).nextToken();
                string4 = ((StringTokenizer)object).nextToken();
                string5 = ((StringTokenizer)object).nextToken();
            }
            object = new StringTokenizer(string3, ".");
            if (((StringTokenizer)object).countTokens() != 4) {
                try {
                    string3 = InetAddress.getByName(string3).getHostAddress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string2 = "Oracle_server:" + string3 + ":" + string4 + "=" + "Oracle_server" + "," + string3 + "," + string3 + "," + string4 + ",no," + string5;
            iniFile.setValue(this.hostIp + "_DEPENDENCY_COMPONENTS", "Oracle_server:" + string3 + ":" + string4, "WebLogic_server:" + this.hostIp + ":" + n);
        }
        iniFile.saveFile();
        return string2;
    }
}

