/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMUtils;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.Status;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BTMDiscovery;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APMComponentIDRepository {
    protected static String logPrefix = "APMComponentIDRepository";
    protected static String loggerDispStr = "[" + logPrefix + "]";
    private static final Hashtable<String, JavaAPMComponent> componentRepository = new Hashtable();
    private static final Hashtable<String, String> tempComponentRepository = new Hashtable();
    private static final Hashtable<String, String> tempDisocoveredPingTimeRepository = new Hashtable();
    private static HashMap guidNickMap = new HashMap();
    private static HashMap nickGuidMap = new HashMap();

    private APMComponentIDRepository() {
    }

    public static void registerJavaComponent(String componentID, String entity) {
        JavaAPMComponent component = componentRepository.get(componentID);
        if (component == null) {
            component = new JavaAPMComponent(componentID);
        }
        component.addEntity(entity);
        componentRepository.put(componentID, component);
    }

    public static void registerJavaComponent(String componentID, String entity, boolean isNewlydiscoverd) {
        APMComponentIDRepository.registerJavaComponent(componentID, entity);
        JavaAPMComponent component = componentRepository.get(componentID);
        component.setNewlyDiscoverd(isNewlydiscoverd);
    }

    public static void registerJavaComponent(String componentID, String entity, String nickName, String hostIP, String hostPort, String componentType) {
        if (componentID == null || componentID.length() <= 0) {
            return;
        }
        JavaAPMComponent component = componentRepository.get(componentID);
        if (component == null) {
            component = new JavaAPMComponent(componentID, nickName, hostIP, hostPort, componentType);
        }
        component.addEntity(entity);
        componentRepository.put(componentID, component);
        component.initiateSnapShotTaker();
    }

    public static void unRegisterJavaComponent(String componentID, boolean saveIntoDeletedCompDetails, boolean deleteFully) {
        JavaAPMComponent component = componentRepository.remove(componentID);
        if (component != null) {
            component.removeAllEntities();
            component.setHandlerObject(null);
            String hostIp = component.getHostIP();
            String hostPort = component.getHostPort();
            String componentType = component.getComponentType();
            String serverDetails = String.valueOf(hostIp) + ":" + hostPort + ":" + componentType;
            APMDiscoveryHelper.removeEntriesFromApmDiscoveryIni(componentID, serverDetails, saveIntoDeletedCompDetails, deleteFully);
            if (saveIntoDeletedCompDetails && deleteFully) {
                String variable = String.valueOf(componentType) + ":" + hostIp + ":" + hostPort;
                String value = String.valueOf(componentType) + "," + hostIp + "," + hostIp + "," + hostPort;
                APMComponentIDRepository.addEntryIntoAutoDeleteIni("Removed_Servers", variable, value);
            }
            String nickName = component.getNickWithPort();
            APMUtils.removeComponentZipFile(nickName);
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Component ID : {} is completely removed from Component Repository.", (Object)loggerDispStr, (Object)componentID);
        }
    }

    private static void addEntryIntoAutoDeleteIni(String subject, String variable, String value) {
        IniFile inifile = EgApmFilesSync.getInstance(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AUTO_DELETE_FILEPATH, true);
        try {
            try {
                inifile.setValue(subject, variable, value);
                inifile.saveFile();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Add entry to eg_agentAutoDelete.ini :-  {} = {} ", new Object[]{loggerDispStr, variable, value});
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to add entry to eg_agentAutoDelete.ini :-  {} = {}", new Object[]{loggerDispStr, variable, value});
                EgApmFilesSync.releaseInstance(inifile);
            }
        }
        finally {
            EgApmFilesSync.releaseInstance(inifile);
        }
    }

    public static void unRegisterJavaComponent(String componentID, String entity) {
        JavaAPMComponent component = componentRepository.get(componentID);
        if (component != null) {
            component.removeEntity(entity);
        }
    }

    public static Hashtable getComponentRepository() {
        return componentRepository;
    }

    public static boolean isSiteIdAvailable(String componentID) {
        return componentRepository.containsKey(componentID);
    }

    public static JavaAPMComponent getJavaAPMComponent(String componentID) {
        return componentRepository.get(componentID);
    }

    public static void registerStatusAsManagedOffload(String componentID) {
        JavaAPMComponent component = componentRepository.get(componentID);
        if (component != null) {
            component.setStatus(Status.MANAGED_OFFLOAD);
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} ComponentID:{} is registered as {} ", new Object[]{loggerDispStr, componentID, Status.MANAGED_OFFLOAD});
        }
    }

    public static boolean isOffloadComponentID(String componentID) {
        JavaAPMComponent component = componentRepository.get(componentID);
        return component != null && component.getStatus() == Status.MANAGED_OFFLOAD;
    }

    public static boolean isNonOffloadComponentID(String componentID) {
        JavaAPMComponent component = componentRepository.get(componentID);
        return component != null && component.getStatus() == Status.MANAGED_NON_OFFLOAD;
    }

    static void snapShotTaker() {
        Set<String> keys = componentRepository.keySet();
        for (String nodeID : keys) {
            JavaAPMComponent component = componentRepository.get(nodeID);
            component.updateSnapShot();
            try {
                BTMDiscovery btmDiscoveryWithNodeId = JavaTransactionFlowUtility.getBTMDiscoveryObject(nodeID);
                if (btmDiscoveryWithNodeId == null) continue;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace(" updating transaction flow test data for {}", (Object)nodeID);
                btmDiscoveryWithNodeId.updateTransmitCopy();
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} exception while updating transaction flow test data {}", (Object)loggerDispStr, (Object)e);
            }
        }
    }

    public static String getGUID(String nodeID) {
        return (String)nickGuidMap.get(nodeID);
    }

    public static String getNick(String jvmID) {
        return (String)guidNickMap.get(jvmID);
    }

    public HashMap getGuidNickMap() {
        return guidNickMap;
    }

    public static void setGuidNickMap(HashMap guidNickMapNew) {
        if (guidNickMapNew != null && guidNickMapNew.size() > 0) {
            guidNickMap = guidNickMapNew;
        }
    }

    public HashMap getNickguidMap() {
        return nickGuidMap;
    }

    public static void setNickguidMap(HashMap nickguidMapNew) {
        if (nickguidMapNew != null && nickguidMapNew.size() > 0) {
            nickGuidMap = nickguidMapNew;
        }
    }

    public static Hashtable<String, String> getTempComponentIDTable() {
        return tempComponentRepository;
    }

    public static void addToTempComponentRepository(String key, String value) {
        if (key != null && value != null) {
            tempComponentRepository.put(key, value);
        }
    }

    public static String getJvmGuidFromTemp(String key) {
        return tempComponentRepository.get(key);
    }

    public static boolean removeFromTempComponentRepository(String key, boolean removeDependecy) {
        tempComponentRepository.remove(key);
        return true;
    }

    public static boolean isThisManaged(String componentID) {
        return tempComponentRepository.containsKey(componentID);
    }

    public static Hashtable<String, String> getDiscoveryPingTimeTable() {
        return tempDisocoveredPingTimeRepository;
    }

    public static void addToTempComponentDiscoveryRepository(String key, String value) {
        if (key != null && value != null) {
            tempDisocoveredPingTimeRepository.put(key, value);
        }
    }

    public static String getLastPingTimeFromDiscoveryTemp(String key) {
        return tempDisocoveredPingTimeRepository.get(key);
    }

    public static boolean removeFromTempComponentDiscoveryRepository(String key, boolean removeDependecy) {
        tempDisocoveredPingTimeRepository.remove(key);
        return true;
    }

    public static boolean isThisAvailableInDiscoveryPingTime(String componentID) {
        return tempDisocoveredPingTimeRepository.containsKey(componentID);
    }

    public static void setStatusForBtmDiscovery(String jvmGuid, boolean finalized) {
        JavaAPMComponent component = APMComponentIDRepository.getJavaAPMComponent(jvmGuid);
        if (component != null && component.isNewlyDiscoverd()) {
            if (finalized) {
                component.setDiscoveredDetailsFinalized(true);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Discovery details stored for {} and discovery finalized ACK added to JavaAPMComponent ", (Object)loggerDispStr, (Object)jvmGuid);
            } else {
                component.setDiscoveredDetailsStored(true);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Discovery details stored for {} and discovery stored ACK added to JavaAPMComponent ", (Object)loggerDispStr, (Object)jvmGuid);
            }
        }
    }
}

