/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMNodeWorker;
import com.eg.apm.APMUtils;
import com.eg.apm.NodeBTMLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class APMNodeComponentIDRepository {
    protected static String logPrefix = "APMNodeComponentIDRepository";
    protected static String loggerDispStr = "[" + logPrefix + "]";
    private static Hashtable nonOffloadComponentIDTable = new Hashtable();
    private static Hashtable offloadThresholdTable = new Hashtable();
    private static Hashtable offloadPropsTable = new Hashtable();
    private static Hashtable offloadComponentIDTable = new Hashtable();
    private static Hashtable componentIDTable = new Hashtable();
    private static Hashtable tempComponentIDTable = new Hashtable();
    private static Hashtable componentWithTestOffloadConfig = new Hashtable();
    private static HashMap componentWithFullTestConfig = new HashMap();
    private static Hashtable previousComponentNameListTable = new Hashtable();
    private static HashMap newComponetIDs = new HashMap();

    public static void registerComponentID(String componentID, String entity) {
        if (componentIDTable.containsKey(componentID)) {
            ArrayList entities = (ArrayList)componentIDTable.get(componentID);
            if (!entities.contains(entity)) {
                entities.add(entity);
                componentIDTable.put(componentID, entities);
                NodeBTMLogger.nodeLogger.debug("{} new test[{}] added with ComponentID - {}. Current component id table is {}", new Object[]{loggerDispStr, entity, componentID, componentIDTable});
            }
        } else {
            ArrayList<String> entities = new ArrayList<String>();
            entities.add(entity);
            componentIDTable.put(componentID, entities);
            NodeBTMLogger.nodeLogger.debug("{} New ComponentID - {} is registered in componentIDTable.", (Object)loggerDispStr, (Object)componentID);
            NodeBTMLogger.nodeLogger.debug("{} New test[{}] added with ComponentID - {}. Current component id table is {}", new Object[]{loggerDispStr, entity, componentID, componentIDTable});
        }
    }

    public static void unRegisterComponentID(String componentID, String testName, boolean removeComponentID) {
        ArrayList entities;
        if (removeComponentID) {
            componentIDTable.remove(componentID);
            APMNodeWorker.clearOffloadBTMDataRepository(componentID, " Component unmanaged. ");
            APMNodeWorker.addNewEntryTosRepositoryRemoved(componentID, componentID);
            NodeBTMLogger.nodeLogger.debug("{} ComponentID:{}  is removed from Component ID table. Current Component ID Table is {}  ", new Object[]{loggerDispStr, componentID, componentIDTable});
            APMNodeComponentIDRepository.removeTestOffloadConfig(componentID);
            APMNodeComponentIDRepository.removeComponentWithFullTestConfig(componentID);
            APMNodeComponentIDRepository.unRegisterFromOffloadComponentIDTable(componentID);
            APMNodeComponentIDRepository.unRegisterFromNonOffloadComponentIDTable(componentID);
            String tempCompID = APMNodeWorker.getValueFromTempComponentIDTable(componentID);
            if (tempCompID != null && tempCompID.length() > 0) {
                APMNodeWorker.clearOffloadBTMDataRepository(componentID, " No need of temporary component id data. ");
            }
            String serverDetails = String.valueOf(APMNodeWorker.getValueFromTempComponentIDTable("*" + componentID));
            APMNodeWorker.removeEntriesFromApmDiscoveryIni(componentID, serverDetails, false, false);
            APMUtils.removeComponentZipFile(componentID);
        } else if (componentIDTable.containsKey(componentID) && (entities = (ArrayList)componentIDTable.get(componentID)).contains(testName)) {
            entities.remove(testName);
            NodeBTMLogger.nodeLogger.debug("{} Test[{}] is removed from ComponentID -{} . Current component id table is {} : ", new Object[]{loggerDispStr, testName, componentID, componentIDTable});
            componentIDTable.put(componentID, entities);
            if (testName.equalsIgnoreCase("NodeTransTest")) {
                APMNodeWorker.IsThisAvailableInUPDmanagerTable(componentID);
            } else if (testName.equalsIgnoreCase("KNodeTransTest")) {
                APMNodeWorker.IsThisAvailableInUPDmanagerTable(componentID);
            }
        }
    }

    public static Hashtable getComponentIDTable() {
        return componentIDTable;
    }

    public static boolean isThisTestEnabled(String componentID, String testName) {
        ArrayList entities;
        if (componentIDTable.containsKey(componentID) && (entities = (ArrayList)componentIDTable.get(componentID)).contains(testName)) {
            NodeBTMLogger.nodeLogger.debug(" {} {} is enabled for {}.", new Object[]{loggerDispStr, testName, componentID});
            return true;
        }
        return false;
    }

    public static boolean isSiteIdAvailable(String componentID) {
        return componentIDTable.containsKey(componentID);
    }

    public static void registerIntoOffloadComponentIDTable(String componentID) {
        if (!offloadComponentIDTable.containsKey(componentID)) {
            offloadComponentIDTable.put(componentID, componentID);
            NodeBTMLogger.nodeLogger.debug("{}  ComponentID:{} registered in Offload Table", (Object)loggerDispStr, (Object)componentID);
        }
    }

    public static void unRegisterFromOffloadComponentIDTable(String componentID) {
        if (offloadComponentIDTable.containsKey(componentID)) {
            offloadComponentIDTable.remove(componentID);
            NodeBTMLogger.nodeLogger.debug("{}  ComponentID:{} unregistered in Offload Table", (Object)loggerDispStr, (Object)componentID);
        }
    }

    public static boolean isOffloadComponentID(String componentID) {
        return offloadComponentIDTable.containsKey(componentID);
    }

    public static Hashtable getOffloadComponentIDTable() {
        return offloadComponentIDTable;
    }

    public static void registerIntoNonOffloadComponentIDTable(String componentID) {
        if (!nonOffloadComponentIDTable.containsKey(componentID)) {
            nonOffloadComponentIDTable.put(componentID, componentID);
            NodeBTMLogger.nodeLogger.debug("{} ComponentID:{} registered in Non-Offload Table", (Object)loggerDispStr, (Object)componentID);
        }
    }

    public static boolean isNonOffloadComponentID(String componentID) {
        return nonOffloadComponentIDTable.containsKey(componentID);
    }

    public static Hashtable getNonOffloadComponentIDTable() {
        return nonOffloadComponentIDTable;
    }

    public static void unRegisterFromNonOffloadComponentIDTable(String componentID) {
        if (nonOffloadComponentIDTable.containsKey(componentID)) {
            nonOffloadComponentIDTable.remove(componentID);
            NodeBTMLogger.nodeLogger.debug("{}  ComponentID:{} unregistered in Agent Non-Offload Table", (Object)loggerDispStr, (Object)componentID);
        }
    }

    public static void registerNewThreshold(String componentID, HashMap tresholdValue) {
        NodeBTMLogger.nodeLogger.debug("{}  {}={} registered in Agent Threshold Table ", new Object[]{loggerDispStr, componentID, tresholdValue});
        offloadThresholdTable.put(componentID, tresholdValue);
    }

    public static void unregisterThreshold(String componentID) {
        NodeBTMLogger.nodeLogger.debug("{}  {} Threshold Unregistered in Agent Threshold Table ", (Object)loggerDispStr, (Object)componentID);
        offloadThresholdTable.remove(componentID);
    }

    public static boolean isNewThresholdAvailable(String componentID) {
        return offloadThresholdTable.containsKey(componentID);
    }

    public static HashMap getNewThreshold(String componentID) {
        return (HashMap)offloadThresholdTable.get(componentID);
    }

    public static Hashtable getOffloadThresholdTable() {
        return offloadThresholdTable;
    }

    public static Hashtable getOffloadPropsTable() {
        return offloadPropsTable;
    }

    public static void registerNewProps(String componentID, HashMap propsData) {
        NodeBTMLogger.nodeLogger.debug(" {} {}={} registered in Agent Props Table ", new Object[]{loggerDispStr, componentID, propsData});
        offloadPropsTable.put(componentID, propsData);
    }

    public static void unregisterProps(String componentID) {
        NodeBTMLogger.nodeLogger.debug("{}  {} Props Unregistered in Agent Props Table ", (Object)loggerDispStr, (Object)componentID);
        offloadPropsTable.remove(componentID);
    }

    public static HashMap getNewProps(String componentID) {
        return (HashMap)offloadPropsTable.get(componentID);
    }

    public static boolean isNewPropsAvailable(String componentID) {
        return offloadPropsTable.containsKey(componentID);
    }

    public static Object getComponentWithTestOffloadConfigTable() {
        return componentWithTestOffloadConfig;
    }

    public static HashMap getComponentWithTestOffloadConfig(String componentID) {
        return (HashMap)componentWithTestOffloadConfig.get(componentID);
    }

    public static void setComponentWithTestOffloadConfig(String componentID, HashMap configs) {
        NodeBTMLogger.nodeLogger.debug("{}  {} Offload config registered in componentWithTestOffloadConfig Table ", (Object)loggerDispStr, (Object)componentID);
        componentWithTestOffloadConfig.put(componentID, configs);
    }

    public static boolean isTestOffloadConfigAvailable(String componentID) {
        return componentWithTestOffloadConfig.containsKey(componentID);
    }

    public static void removeTestOffloadConfig(String componentID) {
        NodeBTMLogger.nodeLogger.debug("{}  {} Offload config Unregistered in componentWithTestOffloadConfig Table ", (Object)loggerDispStr, (Object)componentID);
        componentWithTestOffloadConfig.remove(componentID);
    }

    public static Hashtable getComponentWithTestOffloadConfig() {
        return componentWithTestOffloadConfig;
    }

    public static HashMap getComponentWithFullTestConfigTable() {
        return componentWithFullTestConfig;
    }

    public static HashMap getComponentWithFullTestConfig(String componentID) {
        return (HashMap)componentWithFullTestConfig.get(componentID);
    }

    public static void setComponentWithFullTestConfig(String componentID, HashMap testsWithFullConfigs) {
        componentWithFullTestConfig.put(componentID, testsWithFullConfigs);
    }

    public static void removeComponentWithFullTestConfig(String componentID) {
        NodeBTMLogger.nodeLogger.debug("{}  {} Offload Full test config Unregistered in componentWithFullTestConfig Table ", (Object)loggerDispStr, (Object)componentID);
        componentWithFullTestConfig.remove(componentID);
    }

    public static Hashtable getPreviousComponentNameList(String componentID) {
        return (Hashtable)previousComponentNameListTable.get(componentID);
    }

    public static void setPreviousComponentNameList(String componentID, List names) {
        NodeBTMLogger.nodeLogger.trace(" {} Old component Name list registered in previousComponentNameListTable-  {} : {}", new Object[]{loggerDispStr, componentID, names});
        previousComponentNameListTable.put(componentID, names);
    }

    public static String getNewComponentName(String componentID) {
        for (Map.Entry entry : previousComponentNameListTable.entrySet()) {
            String newComponentID = (String)entry.getKey();
            List nameList = (List)entry.getValue();
            if (!nameList.contains(componentID) || newComponentID.equalsIgnoreCase(componentID)) continue;
            NodeBTMLogger.nodeLogger.trace("{}  New component name found for {} : {}", new Object[]{componentID, loggerDispStr, newComponentID});
            return newComponentID;
        }
        return null;
    }

    public static boolean isThisComponentNameAvailableInPreviousList(String componentID) {
        return previousComponentNameListTable.containsKey(componentID);
    }

    public static void removePreviousComponentNameList(String componentID) {
        NodeBTMLogger.nodeLogger.debug("{}  {} Previous Component Name List Unregistered in PreviousComponentNameList Table ", (Object)loggerDispStr, (Object)componentID);
        previousComponentNameListTable.remove(componentID);
    }

    public static Hashtable getPreviousComponentNameListTable() {
        return previousComponentNameListTable;
    }

    public static HashMap getnewComponetIDs() {
        return newComponetIDs;
    }

    public static void setNewComponetIDs(HashMap ComponetIDs) {
        newComponetIDs = ComponetIDs;
    }

    public static boolean IsThisAvailableInNewComponetIDs(String key) {
        return newComponetIDs.containsKey(key);
    }

    public static String getValueFromNewComponetIDs(String key) {
        return (String)newComponetIDs.get(key);
    }

    public static void removeThisFromNewComponetIDs(String key) {
        newComponetIDs.remove(key);
    }

    public static void addNewEntryToNewComponetIDs(String key, String value) {
        newComponetIDs.put(key, value);
    }
}

