/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgConfigFilesSync;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.jtm.BTMConstants;
import java.util.HashMap;
import java.util.Vector;

public class ApmDemoInfo {
    private static IniFile demoFileObj;
    private static long lastModifiedTime;
    private static long lastSize;
    private static String demoFile;
    private static String apmIniFile;
    private static String APM_DEMO;
    private static final String loggerPrefix = "[ApmDemoInfo] ";
    private static HashMap kubernetesDemoData;
    private static boolean isDemoMode;
    private static boolean isKubernetesDemoMode;
    private static long discoveryContributorSleepTime;
    private static long appflowDataContributorSleepTime;
    private static long ONE_MIN;
    private static long FIFTEEN_SECONDS;

    public ApmDemoInfo(boolean bl) {
        ApmDemoInfo.init(bl);
    }

    private static void init(boolean bl) {
        isDemoMode = ApmDemoInfo.readApmDemoFlag();
        lastModifiedTime = ApmDemoInfo.lastModified();
        lastSize = ApmDemoInfo.lastSize();
        demoFileObj = new IniFile(demoFile, bl);
        if (isDemoMode) {
            ApmDemoInfo.readAllEntriesForDemo();
        }
        ApmDemoInfo.printConfigs();
    }

    private static void printConfigs() {
        APMDiscoveryLogger.discoveryLogger.debug(" {} isDemoMode : {}, isKubernetesDemoMode : {}, discoveryContributorSleepTime : {}, appflowDataContributorSleepTime : {}", new Object[]{loggerPrefix, isDemoMode, isKubernetesDemoMode, discoveryContributorSleepTime, appflowDataContributorSleepTime});
    }

    public static boolean initDemoMode() {
        ApmDemoInfo.init(false);
        return true;
    }

    private static void readAllEntriesForDemo() {
        isKubernetesDemoMode = Boolean.parseBoolean(ApmDemoInfo.readDemoValue("Custom_Kubernetes_Demo"));
        kubernetesDemoData = APMUtils.getLinesAsMap(demoFileObj, "CUSTOM_KUBERNETES_DEMO", APMDiscoveryLogger.discoveryLogger);
        discoveryContributorSleepTime = APMUtils.getAndValidateLongValue(demoFileObj, "APM", "APMDiscoveryContributorSleepTime", ONE_MIN, FIFTEEN_SECONDS, APMDiscoveryLogger.discoveryLogger);
        appflowDataContributorSleepTime = APMUtils.getAndValidateLongValue(demoFileObj, "APM", "APMAppflowDataContributorSleepTime", ONE_MIN, FIFTEEN_SECONDS, APMDiscoveryLogger.discoveryLogger);
    }

    public static HashMap getKubernetesDemo() {
        return kubernetesDemoData;
    }

    public static boolean isDemoMode() {
        return isDemoMode;
    }

    public static boolean isDemoMode(boolean bl) {
        isDemoMode = ApmDemoInfo.readApmDemoFlag();
        return isDemoMode;
    }

    public static boolean isKubernetesDemoMode() {
        return isKubernetesDemoMode;
    }

    public static long lastModified() {
        return IniFile.getLastModified(demoFile);
    }

    public static long lastSize() {
        return IniFile.getLastSize(demoFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForUpdate() {
        long l = ApmDemoInfo.lastModified();
        long l2 = ApmDemoInfo.lastSize();
        if (l == lastModifiedTime && l2 == lastSize) {
            return false;
        }
        String string = APM_DEMO;
        synchronized (string) {
            l = ApmDemoInfo.lastModified();
            l2 = ApmDemoInfo.lastSize();
            if (l == lastModifiedTime && l2 == lastSize) {
                return false;
            }
            ApmDemoInfo.init(false);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile() {
        try {
            String string = APM_DEMO;
            synchronized (string) {
                demoFileObj.saveFile();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to save eg_apmGuid.ini file", (Object)loggerPrefix, (Object)exception);
        }
    }

    public static String readDemoValue(String string) {
        String string2 = ApmDemoInfo.getValue(APM_DEMO, string);
        return string2;
    }

    public void setValue(String string, String string2, String string3) {
        demoFileObj.setValue(string, string2, string3);
    }

    public static String getValue(String string, String string2) {
        return demoFileObj.getValue(string, string2);
    }

    public String[] getVariables(String string) {
        return demoFileObj.getVariables(string);
    }

    public Vector getValues(String string) {
        return demoFileObj.getAllValues(string);
    }

    public String[] getLinesUnderSubject(String string) {
        return demoFileObj.getLinesUnderSubject(string);
    }

    private static boolean readApmDemoFlag() {
        IniFile iniFile = new IniFile(apmIniFile);
        String string = iniFile.getValue("APM_DEMO", "APM_Demo");
        return Boolean.parseBoolean(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeApmDemoFlag(String string) {
        boolean bl = true;
        IniFile iniFile = EgConfigFilesSync.getInstance(apmIniFile);
        try {
            iniFile.setValue("APM_DEMO", "APM_DEMO", string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to  write ApmBtmMonitorFlag() : {}", (Object)loggerPrefix, (Object)exception);
            bl = false;
        }
        finally {
            iniFile.saveFile();
            EgConfigFilesSync.releaseInstance(iniFile);
        }
        return bl;
    }

    public static long getDiscoveryContributorSleepTime() {
        return discoveryContributorSleepTime;
    }

    public static long getAppflowDataContributorSleepTime() {
        return appflowDataContributorSleepTime;
    }

    static {
        demoFile = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_DEMO_FILEPATH;
        apmIniFile = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
        APM_DEMO = new String("APM_DEMO");
        isDemoMode = false;
        isKubernetesDemoMode = false;
        discoveryContributorSleepTime = 15000L;
        appflowDataContributorSleepTime = 15000L;
        ONE_MIN = 60000L;
        FIFTEEN_SECONDS = 15000L;
    }
}

