/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmDemoInfo;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashMap;

public class ContainersService {
    private static boolean isWindows = false;
    private static boolean isKubernetes = false;
    private static boolean isKubernetesDaemonSetAgent = false;
    public static boolean ssl = false;
    public static String serviceToken = "";
    private static CONTAINER container = CONTAINER.NONE;
    public static String ip = "127.0.0.1";
    public static int port = 443;
    private static final String logPrefix = "[KubernetesAPI] ";

    public static boolean isKubernetesDaemonSet() {
        return isKubernetesDaemonSetAgent;
    }

    public static void setKubernetesDaemonSet(boolean bl) {
        isKubernetesDaemonSetAgent = bl;
    }

    public static boolean isKubernetes() {
        return isKubernetes;
    }

    public static String getServiceToken() {
        return serviceToken;
    }

    public static void setServiceToken(String string) {
        serviceToken = string;
    }

    public static void initContainerClusterEnvDiscovery() {
        try {
            ContainersService.findOS();
            if (isWindows) {
                return;
            }
            ContainersService.findContainerClusterEnv();
            if (ApmDemoInfo.isKubernetesDemoMode()) {
                try {
                    HashMap hashMap = ApmDemoInfo.getKubernetesDemo();
                    ip = (String)hashMap.get("IP");
                    port = Integer.parseInt((String)hashMap.get("Port"));
                    serviceToken = (String)hashMap.get("Token");
                    ssl = Boolean.parseBoolean((String)hashMap.get("Ssl"));
                    APMDiscoveryLogger.discoveryLogger.info("{} Activating Kubernetes service discovery in DEMO mode : {}", (Object)logPrefix);
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing isThisAgentRunningAsADaemonSet() : {}", (Object)logPrefix, (Object)exception);
                }
            } else {
                String string = System.getProperty("EG_MANAGER");
                ContainersService.setKubernetesDaemonSet(true);
                if (isKubernetesDaemonSetAgent) {
                    ContainersService.findIpAndPort();
                    if (ContainersService.isKubernetesDaemonSet()) {
                        ContainersService.findKubeServiceToken();
                        APMDiscoveryLogger.discoveryLogger.warn("{} Activating Kubernetes service discovery in DAEMONSET mode : {}", (Object)logPrefix);
                    }
                }
            }
            ContainersService.printKubeEnvDetails();
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing isThisAgentRunningAsADaemonSet() : {}", (Object)logPrefix, (Object)exception);
        }
    }

    private static void findContainerClusterEnv() {
        container = CONTAINER.KUBERNETES;
    }

    public static boolean isKube() {
        return container == CONTAINER.KUBERNETES;
    }

    private static void findOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string != null && string.indexOf("win") > -1) {
            isWindows = true;
        }
    }

    private static void printKubeEnvDetails() {
        if (APMDiscoveryLogger.discoveryLogger.isInfoEnabled()) {
            APMDiscoveryLogger.discoveryLogger.info("{} Container Cluster Master IP : {}", (Object)logPrefix, (Object)ip);
            APMDiscoveryLogger.discoveryLogger.info("{} Container Cluster Master Port : {}", (Object)logPrefix, (Object)port);
            APMDiscoveryLogger.discoveryLogger.info("{} Container Cluster Master Token [masked] : {}", (Object)logPrefix, (Object)serviceToken);
            APMDiscoveryLogger.discoveryLogger.info("{} Container Cluster Master SSL : {}", (Object)logPrefix, (Object)ssl);
            APMDiscoveryLogger.discoveryLogger.info("{} is Kubernetes Demo Mode : {}", (Object)logPrefix, (Object)ApmDemoInfo.isKubernetesDemoMode());
        }
    }

    private static void findIpAndPort() {
        try {
            String string = System.getenv("KUBERNETES_SERVICE_HOST");
            if (string != null && string.length() > 0) {
                ip = string.trim();
            } else {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get data for KUBERNETES_SERVICE_HOST: ", (Object)logPrefix, (Object)string);
            }
            String string2 = System.getenv("KUBERNETES_PORT_443_TCP_PORT");
            if (string2 != null && string.length() > 0) {
                port = Integer.parseInt(string2.trim());
            } else {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get data for KUBERNETES_PORT_443_TCP_PORT: ", (Object)logPrefix, (Object)string2);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing findIpAndPort() : {}", (Object)logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String readFileContentAsString(String string) {
        StringBuilder stringBuilder;
        block16: {
            String string2;
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            Object var5_6 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block16;
            }
            catch (Exception exception) {}
            break block16;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    if (!isWindows) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} {} - File Not found exception : ", (Object)logPrefix, (Object)string);
                    }
                    Object var5_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block16;
                    }
                    catch (Exception exception) {}
                    break block16;
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing readFileContentAsString() : {}", (Object)logPrefix, (Object)exception);
                    Object var5_8 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block16;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return stringBuilder.toString();
    }

    private static void findKubeServiceToken() {
        String string;
        if (!isWindows && (string = ContainersService.readFileContentAsString("/var/run/secrets/kubernetes.io/serviceaccount/token")) != null && string.length() > 0) {
            ContainersService.setServiceToken(string.trim());
            ssl = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CONTAINER {
        NONE,
        DOCKER,
        KUBERNETES,
        OPEN_SHIFT,
        SWARM,
        MESOS;

    }
}

