/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.JavaBTMLogger;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

public final class JVMDataRepository {
    public static final Hashtable dataTable = new Hashtable();
    private static final Hashtable jvmPropsTable = new Hashtable();
    public static Logger logger = JavaBTMLogger.btmLogger;
    protected static String loggerDispStr = "[JVMDataRepository]";

    private JVMDataRepository() {
    }

    public static void setData(String nodeId, Hashtable htable) {
        Set keys = htable.keySet();
        for (String key : keys) {
            ArrayList al = (ArrayList)htable.get(key);
            if (dataTable.containsKey(nodeId)) {
                Hashtable innerTable = (Hashtable)dataTable.get(nodeId);
                innerTable.put(key, al);
                continue;
            }
            Hashtable<String, ArrayList> h = new Hashtable<String, ArrayList>();
            h.put(key, al);
            dataTable.put(nodeId, h);
        }
        logger.trace("{} {} JVM data added into repository : {}", new Object[]{loggerDispStr, nodeId, htable});
    }

    public static void clearData(String jvmGuid) {
        try {
            if (jvmGuid != null) {
                dataTable.remove(jvmGuid);
            }
        }
        catch (Exception e) {
            logger.warn("{} {} Unable to clear data for JVM data repository : {}", (Object)loggerDispStr, (Object)jvmGuid);
        }
    }

    public static ArrayList getData(String nodeId, String entity) {
        Hashtable innerTable;
        ArrayList al = null;
        boolean res = APMComponentIDRepository.isOffloadComponentID(nodeId);
        if (!res) {
            logger.info("{}  This Component {} data not available in JAR mode repository . Ensure JAR mode running or Please enable JMX mode for this component. Entity : {} ", new Object[]{loggerDispStr, nodeId, entity});
            return al;
        }
        if (dataTable.containsKey(nodeId) && (innerTable = (Hashtable)dataTable.get(nodeId)).containsKey(entity)) {
            al = (ArrayList)innerTable.get(entity);
            innerTable.remove(entity);
        }
        logger.trace("{} {} JVM data retrived from repository : {}", new Object[]{loggerDispStr, nodeId, al});
        return al;
    }

    public static void registerJvmNewProps(String componentID, Hashtable modifiedPropsTable) {
        logger.debug("{}  {}={} registered in Agent jvmPropsTable   ", new Object[]{loggerDispStr, componentID, modifiedPropsTable});
        jvmPropsTable.put(componentID, modifiedPropsTable);
    }

    public static void unregisterJvmProps(String componentID) {
        logger.debug("{} {} Props Unregistered in Agent jvmPropsTable   ", (Object)loggerDispStr, (Object)componentID);
        jvmPropsTable.remove(componentID);
    }

    public static Hashtable getNewJvmProps(String componentID) {
        return (Hashtable)jvmPropsTable.get(componentID);
    }

    public static boolean isNewJvmPropsAvailable(String componentID) {
        boolean result = false;
        if (jvmPropsTable.containsKey(componentID)) {
            result = true;
        }
        return result;
    }
}

