/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.Status;
import com.eg.jtm.BTMDiscovery;
import java.util.TimerTask;

final class SnapShotTaker
extends TimerTask {
    protected static String loggerDispStr = "[SnapShotTaker]";
    private String jvmGUID;

    public SnapShotTaker(String guid) {
        this.jvmGUID = guid;
    }

    public void run() {
        try {
            this.doSnapShot();
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do SnapShotTaker for - {}: {}", new Object[]{loggerDispStr, this.jvmGUID, e});
        }
    }

    private void doSnapShot() {
        if (this.jvmGUID != null) {
            JavaAPMComponent component = APMComponentIDRepository.getJavaAPMComponent(this.jvmGUID);
            if (component.getStatus() != Status.MANAGED_OFFLOAD) {
                return;
            }
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Doing snapshot for - {} , JavaAPMComponent Obj - {} ", new Object[]{loggerDispStr, this.jvmGUID, component});
            if (component != null) {
                component.updateSnapShot();
            }
            try {
                BTMDiscovery btmDiscoveryWithNodeId = JavaTransactionFlowUtility.getBTMDiscoveryObject(this.jvmGUID);
                if (btmDiscoveryWithNodeId != null) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace(" updating transaction flow test data for {}", (Object)this.jvmGUID);
                    btmDiscoveryWithNodeId.updateTransmitCopy();
                }
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} exception while updating transaction flow test data {}", (Object)loggerDispStr, (Object)e);
            }
        }
    }
}

