/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type = "Unknown";
    private List<Long> children = null;
    private MethodInfo parent = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private long executionTime = -1L;
    private Map properties = null;
    private transient int status = 0;
    private transient boolean error = false;
    private transient boolean isStartComponent = false;
    private transient boolean slowURL = false;
    private transient boolean errorURL = false;
    private transient boolean isStalled = false;
    private transient boolean isSQLPresent = false;
    private static final transient String DDCellColSep = "#=#";
    private static final transient String DDCellRowSep = "%*%";
    private static final transient String ExtCallSep = "[*#*]";
    private transient String urlPatternsMatched = null;
    private String className = null;
    private String methodName = null;
    private String desc = null;
    private long id;

    public MethodInfo() {
        this.isStartComponent = false;
        this.children = new ArrayList<Long>();
        this.id = 0L;
    }

    public MethodInfo(String className, String methodName, String desc, MethodInfo parent, long id, HashMap<Long, MethodInfo> childMapReference) {
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
        this.parent = parent;
        this.children = new ArrayList<Long>();
        this.isStartComponent = false;
        this.id = id;
        childMapReference.put(this.id, this);
    }

    public MethodInfo(String className, String methodName, String desc, MethodInfo parent, String urlPatternsMatched, long id, HashMap<Long, MethodInfo> childMapReference) {
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
        this.parent = parent;
        this.urlPatternsMatched = urlPatternsMatched;
        this.children = new ArrayList<Long>();
        this.isStartComponent = true;
        this.id = id;
        childMapReference.put(this.id, this);
    }

    public StringBuffer getMethodDisplayName() {
        StringBuffer methodDisplayName = new StringBuffer();
        methodDisplayName.append(this.className);
        methodDisplayName.append(".");
        methodDisplayName.append(this.methodName);
        methodDisplayName.append(".");
        methodDisplayName.append(this.desc);
        methodDisplayName.append(".");
        return methodDisplayName;
    }

    public String getUrlPatternsMatched() {
        this.urlPatternsMatched = (String)this.properties.get("PS");
        return this.urlPatternsMatched;
    }

    public String getGuidString() {
        return (String)this.properties.get("GUID");
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getRawURL() {
        return (String)this.properties.get("requestID");
    }

    public List<Long> getChildMinfos() {
        return this.children;
    }

    public MethodInfo getParent() {
        return this.parent;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getType() {
        return this.type;
    }

    public long getExecutionTime() {
        if (this.executionTime == -1L) {
            this.executionTime = this.endTime - this.startTime;
            return this.executionTime;
        }
        return this.executionTime;
    }

    public Map getProperties() {
        return this.properties;
    }

    public long getId() {
        return this.id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    private void printNodes(StringBuffer MISB, MethodInfo rootMinfo, MethodInfo Minfo, String idx, boolean traceAll) {
        HashMap levelMap = this.prepareOrderMap();
        if (levelMap == null || levelMap.isEmpty()) {
            return;
        }
        TreeSet levelKeys = new TreeSet(levelMap.keySet());
        int levelSize = levelKeys.size();
        Iterator itr = levelKeys.iterator();
        int level = 1;
        while (itr.hasNext()) {
            String keyString = (String)itr.next();
            MethodInfo tempInfo = (MethodInfo)levelMap.get(keyString);
            String methodType = tempInfo.getType();
            if (traceAll) {
                MISB.append(keyString);
                MISB.append(DDCellColSep).append(this.getNodeLabelAndURLParam(tempInfo, keyString));
                if (level < levelSize) {
                    MISB.append(DDCellRowSep);
                }
            } else if (methodType.equals("SQL") || methodType.equals("HTTP") || methodType.equals("THREAD_INIT") || methodType.equals("THREAD_JOIN") || methodType.equals("WEBSERVICE") || methodType.equals("JMS") || methodType.equals("SAP JCO") || methodType.startsWith("Custom_")) {
                MISB.append(keyString);
                MISB.append(DDCellColSep).append(this.getNodeLabelAndURLParam(tempInfo, keyString));
                if (level < levelSize) {
                    MISB.append(DDCellRowSep);
                }
            }
            ++level;
        }
    }

    private StringBuffer getNodeLabelAndURLParam(MethodInfo nodeMinfo, String nodeIndex) {
        String subCompType = nodeMinfo.getType();
        long nodeExecTime = nodeMinfo.getExecutionTime();
        StringBuffer detailsSB = new StringBuffer();
        detailsSB.append(nodeExecTime);
        detailsSB.append(DDCellColSep).append(nodeMinfo.getMethodDisplayName());
        detailsSB.append(DDCellColSep).append(subCompType);
        return detailsSB;
    }

    String getTree(boolean traceAll) {
        StringBuffer MISB = new StringBuffer();
        this.printNodes(MISB, this, this, "0", traceAll);
        return MISB.toString();
    }

    public boolean isStalled() {
        return (Boolean)this.properties.get("isStalled");
    }

    public boolean isSlowURL() {
        return (Boolean)this.properties.get("isSlowURL");
    }

    public boolean isErrorURL() {
        return (Boolean)this.properties.get("isErrorURL");
    }

    public boolean isSQLPresent() {
        return (Boolean)this.properties.get("isSQLPresent");
    }

    public void clearURLTree() {
        try {
            HashMap hashMap = (HashMap)this.properties.remove("CHILD_MAP");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HashMap prepareOrderMap() {
        HashMap<String, MethodInfo> levelMap = new HashMap<String, MethodInfo>();
        try {
            Stack<MethodInfo> blocks = new Stack<MethodInfo>();
            MethodInfo thisInfo = this;
            blocks.push(thisInfo);
            HashMap<MethodInfo, String> orderMap = new HashMap<MethodInfo, String>();
            orderMap.put(thisInfo, "0");
            levelMap.put("0", thisInfo);
            HashMap childMap = (HashMap)this.properties.get("CHILD_MAP");
            while (!blocks.isEmpty()) {
                thisInfo = (MethodInfo)blocks.pop();
                String orderString = (String)orderMap.get(thisInfo);
                ArrayList MIList = (ArrayList)thisInfo.getChildMinfos();
                if (MIList == null || MIList.size() <= 0) continue;
                int k = 0;
                while (k < MIList.size()) {
                    MethodInfo tempInfo;
                    Long tempId = (Long)MIList.get(k);
                    if (childMap != null && childMap.size() > 0 && !(tempInfo = (MethodInfo)childMap.get(tempId)).equals(thisInfo)) {
                        blocks.push(tempInfo);
                        orderMap.put(tempInfo, String.valueOf(orderString) + "." + k);
                        levelMap.put(String.valueOf(orderString) + "." + k, tempInfo);
                    }
                    ++k;
                }
            }
            Object var2_2 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return levelMap;
    }
}

