/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMethodInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type = "Unknown";
    private List<Long> children = null;
    private NodeMethodInfo parent = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private long executionTime = -1L;
    private Map properties = null;
    private transient int status = 0;
    private transient boolean error = false;
    private transient boolean isStartComponent = false;
    private transient boolean slowURL = false;
    private transient boolean errorURL = false;
    private transient boolean isStalled = false;
    private transient boolean isSQLPresent = false;
    private static final transient String DDCellColSep = "#=#";
    private static final transient String DDCellRowSep = "%*%";
    private static final transient String ExtCallSep = "[*#*]";
    private transient String urlPatternsMatched = null;
    private String className = null;
    private String methodName = null;
    private String desc = null;
    private long id;

    public NodeMethodInfo() {
        this.isStartComponent = false;
        this.children = new ArrayList<Long>();
        this.id = 0L;
    }

    public NodeMethodInfo(String string, String string2, String string3, NodeMethodInfo nodeMethodInfo, long l, HashMap<Long, NodeMethodInfo> hashMap) {
        this.className = string;
        this.methodName = string2;
        this.desc = string3;
        this.parent = nodeMethodInfo;
        this.children = new ArrayList<Long>();
        this.isStartComponent = false;
        this.id = l;
        hashMap.put(this.id, this);
    }

    public NodeMethodInfo(String string, String string2, String string3, NodeMethodInfo nodeMethodInfo, String string4, long l, HashMap<Long, NodeMethodInfo> hashMap) {
        this.className = string;
        this.methodName = string2;
        this.desc = string3;
        this.parent = nodeMethodInfo;
        this.urlPatternsMatched = string4;
        this.children = new ArrayList<Long>();
        this.isStartComponent = true;
        this.id = l;
        hashMap.put(this.id, this);
    }

    public String getLearningKey() {
        return this.className + "#" + this.methodName + "#" + this.desc;
    }

    public StringBuffer getMethodDisplayName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.className);
        stringBuffer.append(".");
        stringBuffer.append(this.methodName);
        stringBuffer.append(".");
        stringBuffer.append(this.desc);
        stringBuffer.append(".");
        return stringBuffer;
    }

    public String getUrlPatternsMatched() {
        this.urlPatternsMatched = (String)this.properties.get("urlPatternsMatched");
        return this.urlPatternsMatched;
    }

    public String getGuidString() {
        return (String)this.properties.get("GUID");
    }

    public void setErrorURL(boolean bl) {
        this.errorURL = bl;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getRawURL() {
        return (String)this.properties.get("requestID");
    }

    public List<Long> getChildMinfos() {
        return this.children;
    }

    public void addToChildInfo(HashMap<Long, NodeMethodInfo> hashMap, NodeMethodInfo nodeMethodInfo) {
        long l = nodeMethodInfo.getId();
        this.children.add(l);
        hashMap.put(l, nodeMethodInfo);
    }

    public void clearAllChildInfos(HashMap<Long, NodeMethodInfo> hashMap) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Long l = this.children.get(i);
            hashMap.remove(l);
        }
        this.children.clear();
    }

    void addChildMinfo(NodeMethodInfo nodeMethodInfo, HashMap<Long, NodeMethodInfo> hashMap) {
        long l = nodeMethodInfo.getId();
        hashMap.put(l, nodeMethodInfo);
        if (!this.children.add(l)) {
            hashMap.remove(l);
        }
    }

    void removeChildMinfo(NodeMethodInfo nodeMethodInfo, HashMap<Long, NodeMethodInfo> hashMap) {
        long l = nodeMethodInfo.getId();
        hashMap.remove(l);
        if (!this.children.remove(l)) {
            hashMap.put(l, nodeMethodInfo);
        }
    }

    public NodeMethodInfo getParent() {
        return this.parent;
    }

    public void setParent(NodeMethodInfo nodeMethodInfo) {
        this.parent = nodeMethodInfo;
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long l) {
        this.startTime = l;
        this.status = 0;
    }

    public long getEndTime() {
        return this.endTime;
    }

    void setEndTime(long l, boolean bl) {
        this.endTime = l;
        if (bl) {
            this.error = true;
            this.status = 2;
        } else {
            this.error = false;
            this.status = 1;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime() {
        this.executionTime = 0L;
    }

    public void setExecutionTime(long l) {
        this.executionTime = l;
    }

    public int getStatus() {
        return this.status;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public boolean isCompleted() {
        return this.status != 0;
    }

    private String toSimpleString() {
        if (this.isStartComponent) {
            return this.getMethodDisplayName() + " - " + this.getExecutionTime();
        }
        return this.getMethodDisplayName() + " - " + this.getExecutionTime();
    }

    private void printNodes(StringBuffer stringBuffer, NodeMethodInfo nodeMethodInfo, NodeMethodInfo nodeMethodInfo2, String string, boolean bl) {
        HashMap hashMap = this.prepareOrderMap();
        if (hashMap == null || hashMap.isEmpty()) {
            return;
        }
        TreeSet treeSet = new TreeSet(hashMap.keySet());
        int n = treeSet.size();
        Iterator iterator = treeSet.iterator();
        int n2 = 1;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            NodeMethodInfo nodeMethodInfo3 = (NodeMethodInfo)hashMap.get(string2);
            String string3 = nodeMethodInfo3.getType();
            if (bl) {
                stringBuffer.append(string2);
                stringBuffer.append(DDCellColSep).append(this.getNodeLabelAndURLParam(nodeMethodInfo3, string2));
                if (n2 < n) {
                    stringBuffer.append(DDCellRowSep);
                }
            } else if (string3.equals("SQL") || string3.equals("HTTP") || string3.equals("THREAD_INIT") || string3.equals("THREAD_JOIN") || string3.equals("WEBSERVICE") || string3.equals("JMS") || string3.equals("SAP JCO") || string3.startsWith("Custom_")) {
                stringBuffer.append(string2);
                stringBuffer.append(DDCellColSep).append(this.getNodeLabelAndURLParam(nodeMethodInfo3, string2));
                if (n2 < n) {
                    stringBuffer.append(DDCellRowSep);
                }
            }
            ++n2;
        }
    }

    private StringBuffer getNodeLabelAndURLParam(NodeMethodInfo nodeMethodInfo, String string) {
        String string2 = nodeMethodInfo.getType();
        long l = nodeMethodInfo.getExecutionTime();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l);
        stringBuffer.append(DDCellColSep).append(nodeMethodInfo.getMethodDisplayName());
        stringBuffer.append(DDCellColSep).append(string2);
        return stringBuffer;
    }

    String getTree(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.printNodes(stringBuffer, this, this, "0", bl);
        return stringBuffer.toString();
    }

    public boolean isStalled() {
        return (Boolean)this.properties.get("isStalled");
    }

    public boolean isSlowURL() {
        return (Boolean)this.properties.get("isSlowURL");
    }

    public boolean isErrorURL() {
        return (Boolean)this.properties.get("isErrorURL");
    }

    public boolean isSQLPresent() {
        return (Boolean)this.properties.get("isSQLPresent");
    }

    public void clearURLTree() {
        try {
            HashMap hashMap = (HashMap)this.properties.remove("CHILD_MAP");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HashMap prepareOrderMap() {
        HashMap<String, NodeMethodInfo> hashMap = new HashMap<String, NodeMethodInfo>();
        try {
            Stack<NodeMethodInfo> stack = new Stack<NodeMethodInfo>();
            NodeMethodInfo nodeMethodInfo = this;
            stack.push(nodeMethodInfo);
            HashMap<NodeMethodInfo, String> hashMap2 = new HashMap<NodeMethodInfo, String>();
            hashMap2.put(nodeMethodInfo, "0");
            hashMap.put("0", nodeMethodInfo);
            HashMap hashMap3 = (HashMap)this.properties.get("CHILD_MAP");
            while (!stack.isEmpty()) {
                nodeMethodInfo = (NodeMethodInfo)stack.pop();
                String string = (String)hashMap2.get(nodeMethodInfo);
                ArrayList arrayList = (ArrayList)nodeMethodInfo.getChildMinfos();
                if (arrayList == null || arrayList.size() <= 0) continue;
                for (int i = 0; i < arrayList.size(); ++i) {
                    NodeMethodInfo nodeMethodInfo2;
                    Long l = (Long)arrayList.get(i);
                    if (hashMap3 == null || hashMap3.size() <= 0 || (nodeMethodInfo2 = (NodeMethodInfo)hashMap3.get(l)).equals(nodeMethodInfo)) continue;
                    stack.push(nodeMethodInfo2);
                    hashMap2.put(nodeMethodInfo2, string + "." + i);
                    hashMap.put(string + "." + i, nodeMethodInfo2);
                }
            }
            stack = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }
}

