/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.URLPatternData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public final class URLPatternMeasure {
    boolean modified = false;
    private String pName;
    private Hashtable pMeasureHT;
    private static final Double defaultMeasure = new Double(0.0);
    private final List<Double> defaultPatternData = new ArrayList<Double>();
    private double averageResponseTime = 0.0;
    private static final String ERROR_URL_EXISTS = "ERROR_URL_EXISTS";
    private int old_measure_count = 18;
    private static final String PATTERN_DATA = "patternData";
    private static final String SLOW_URL_LISTS = "SlowURLLists";
    private static final String ERROR_URL_LISTS = "ErrorURLLists";
    private static final String ALL_URL_LISTS = "AllURLLists";
    private static final String STALLED_URL_LISTS = "StalledURLLists";
    private static final String SLOWURL_THREAD_LISTS = "SlowURLThreadLists";
    private static final String ERRORURL_THREAD_LISTS = "ErrorURLThreadLists";
    private static final String STALLEDURL_THREAD_LISTS = "StalledURLThreadLists";
    private static final String HEALTHYURL_THREAD_LISTS = "HealthyURLThreadLists";
    private static final String HYPEN_STRING = "-";
    protected static String logPrefix = "URLPatternMeasure";
    protected static String loggerDispStr = "[" + logPrefix + "]";
    PropsManager propsManager;

    public URLPatternMeasure(PropsManager propsManager) {
        this.propsManager = propsManager;
        this.pName = "SUMMARY_PATTERN";
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(this.pName, this.defaultPatternData);
        int j = 0;
        while (j < PropsManager.getSubCompNameLength()) {
            this.defaultPatternData.add(defaultMeasure);
            this.defaultPatternData.add(defaultMeasure);
            ++j;
        }
    }

    public URLPatternMeasure(String patternName, PropsManager propsManager) {
        this.propsManager = propsManager;
        this.pName = patternName;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(PATTERN_DATA, this.defaultPatternData);
        this.pMeasureHT.put(SLOW_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERROR_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ALL_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLED_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(SLOWURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERRORURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, HYPEN_STRING);
    }

    public Hashtable getMeasureTbl() {
        Hashtable cloneTable = (Hashtable)this.pMeasureHT.clone();
        this.modified = false;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(PATTERN_DATA, this.defaultPatternData);
        this.pMeasureHT.put(SLOW_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERROR_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ALL_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLED_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(SLOWURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERRORURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, HYPEN_STRING);
        return cloneTable;
    }

    private void getBackWardCompatibalityResult(ArrayList measureList) {
        int measureListSize = measureList.size();
        if (measureListSize > this.old_measure_count) {
            int i = measureListSize - 1;
            while (i >= this.old_measure_count) {
                measureList.remove(i);
                --i;
            }
        }
    }

    public Hashtable getSummaryMeasures() {
        Hashtable cloneTable = (Hashtable)this.pMeasureHT.clone();
        this.modified = false;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put("SUMMARY_PATTERN", this.defaultPatternData);
        return cloneTable;
    }

    public boolean isErrorURLExists() {
        boolean flag = false;
        if (this.pMeasureHT != null) {
            flag = this.pMeasureHT.containsKey(ERROR_URL_EXISTS);
        }
        return flag;
    }

    public void update(URLPatternData UPD, URLPatternMeasure summaryUPM, boolean calculateAverage) {
        this.modified = true;
        ArrayList summaryArrayList = (ArrayList)summaryUPM.pMeasureHT.get("SUMMARY_PATTERN");
        if (this.pMeasureHT.containsKey(PATTERN_DATA)) {
            ArrayList existingData = (ArrayList)this.pMeasureHT.get(PATTERN_DATA);
            ArrayList<Double> syncDataList = new ArrayList<Double>();
            ArrayList<Double> summaryList = new ArrayList<Double>();
            int j = 0;
            while (j < UPD.numOf.length) {
                double currentNumOf = UPD.numOf[j];
                double currentSumOf = UPD.sumOf[j];
                double existingNumOf = 0.0;
                double existingSumOf = 0.0;
                try {
                    existingNumOf = (Double)existingData.get(j * 2);
                    existingSumOf = (Double)existingData.get(j * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                syncDataList.add(new Double(existingNumOf + currentNumOf));
                syncDataList.add(new Double(existingSumOf + currentSumOf));
                double existingSummaryNumOf = 0.0;
                double existingSummarySumOf = 0.0;
                try {
                    existingSummaryNumOf = (Double)summaryArrayList.get(j * 2);
                    existingSummarySumOf = (Double)summaryArrayList.get(j * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                summaryList.add(new Double(existingSummaryNumOf + currentNumOf));
                summaryList.add(new Double(existingSummarySumOf + currentSumOf));
                ++j;
            }
            this.pMeasureHT.put(PATTERN_DATA, syncDataList);
            summaryUPM.pMeasureHT.put("SUMMARY_PATTERN", summaryList);
            if (calculateAverage) {
                this.calculateAverage(syncDataList);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Counter: {} {}  Avg.Response : {} ", new Object[]{loggerDispStr, this.pName, syncDataList, this.averageResponseTime});
            }
        } else {
            ArrayList<Double> syncDataList = new ArrayList<Double>();
            ArrayList<Double> summaryList = new ArrayList<Double>();
            int j = 0;
            while (j < UPD.numOf.length) {
                double currentNumOf = UPD.numOf[j];
                double currentSumOf = UPD.sumOf[j];
                syncDataList.add(currentNumOf);
                syncDataList.add(currentSumOf);
                double existingSummaryNumOf = 0.0;
                double existingSummarySumOf = 0.0;
                try {
                    existingSummaryNumOf = (Double)summaryArrayList.get(j * 2);
                    existingSummarySumOf = (Double)summaryArrayList.get(j * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                summaryList.add(new Double(existingSummaryNumOf + currentNumOf));
                summaryList.add(new Double(existingSummarySumOf + currentSumOf));
                ++j;
            }
            this.pMeasureHT.put(PATTERN_DATA, syncDataList);
            summaryUPM.pMeasureHT.put("SUMMARY_PATTERN", summaryList);
            if (calculateAverage) {
                this.calculateAverage(syncDataList);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Counter: {} {}  Avg.Response : {} ", new Object[]{loggerDispStr, this.pName, syncDataList, this.averageResponseTime});
            }
        }
        this.calculateSlowURLDetails(UPD);
        this.calculateErrorURLDetails(UPD);
        if (this.propsManager.isTraceHealthyURL()) {
            this.calculateAllURLDetails(UPD);
        }
        this.calculateStalledURLDetails(UPD);
    }

    private void calculateAverage(ArrayList sourceList) {
        double totalNum = (Double)sourceList.get(0);
        if (totalNum > 0.0) {
            double totalSum = (Double)sourceList.get(1);
            this.averageResponseTime = totalSum / totalNum;
        }
    }

    private void calculateStalledURLDetails(URLPatternData UPD) {
        ArrayList<MethodInfo> stalledDataList = null;
        boolean existingData = false;
        Object dataObject = this.pMeasureHT.get(STALLED_URL_LISTS);
        if (dataObject != null && dataObject instanceof ArrayList && (stalledDataList = (ArrayList<MethodInfo>)dataObject) != null && stalledDataList.size() > 0) {
            existingData = true;
        }
        ArrayList stalledUrlList = null;
        int initialSize = 0;
        if (UPD.getStalledURLsList() != null) {
            if (stalledDataList == null) {
                stalledDataList = new ArrayList<MethodInfo>();
            }
            stalledUrlList = (ArrayList)UPD.getStalledURLsList().clone();
            initialSize = stalledUrlList.size();
            int k = 0;
            while (k < initialSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)stalledUrlList.get(k);
                    stalledDataList.add(rootMI);
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating stalledUrlList {} ", (Object)loggerDispStr, (Object)e);
                    break;
                }
                ++k;
            }
            if (existingData) {
                Collections.sort(stalledDataList, new BTMUrlComparator());
                int nowSize = stalledDataList.size();
                int maxStalled = this.propsManager.getMaxStalledURLs();
                if (nowSize > maxStalled) {
                    int i = nowSize - 1;
                    while (i >= maxStalled) {
                        stalledDataList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put(STALLED_URL_LISTS, stalledDataList);
        }
        stalledUrlList = null;
        UPD.cleanStalledURLsList();
        ArrayList<MethodInfo> stalledThreadDataList = null;
        boolean existingThreadData = false;
        Object dataThreadObject = this.pMeasureHT.get(STALLEDURL_THREAD_LISTS);
        if (dataThreadObject != null && dataThreadObject instanceof ArrayList && (stalledThreadDataList = (ArrayList<MethodInfo>)dataThreadObject) != null && stalledThreadDataList.size() > 0) {
            existingThreadData = true;
        }
        ArrayList stalledThreadList = null;
        int initialThreadSize = 0;
        if (UPD.getStalledTHREADsList() != null) {
            if (stalledThreadDataList == null) {
                stalledThreadDataList = new ArrayList<MethodInfo>();
            }
            stalledThreadList = (ArrayList)UPD.getStalledTHREADsList().clone();
            initialThreadSize = stalledThreadList.size();
            int k = 0;
            while (k < initialThreadSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)stalledThreadList.get(k);
                    stalledThreadDataList.add(rootMI);
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating stalledThreadList {}", (Object)loggerDispStr, (Object)e);
                    break;
                }
                ++k;
            }
            if (existingThreadData) {
                Collections.sort(stalledThreadDataList, new BTMUrlComparator());
                int nowSize = stalledThreadDataList.size();
                int maxStalled = this.propsManager.getMaxSlowURLs();
                if (nowSize > maxStalled) {
                    int i = nowSize - 1;
                    while (i >= maxStalled) {
                        stalledThreadDataList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, stalledThreadDataList);
        }
        stalledThreadList = null;
        UPD.cleanStalledTHREADsList();
    }

    private void calculateSlowURLDetails(URLPatternData UPD) {
        ArrayList<MethodInfo> slowDataList = null;
        boolean existingData = false;
        Object dataObject = this.pMeasureHT.get(SLOW_URL_LISTS);
        if (dataObject != null && dataObject instanceof ArrayList && (slowDataList = (ArrayList<MethodInfo>)dataObject) != null && slowDataList.size() > 0) {
            existingData = true;
        }
        ArrayList slowUrlList = null;
        int initialSize = 0;
        if (UPD.getSlowURLsList() != null) {
            if (slowDataList == null) {
                slowDataList = new ArrayList<MethodInfo>();
            }
            slowUrlList = (ArrayList)UPD.getSlowURLsList().clone();
            initialSize = slowUrlList.size();
            int k = 0;
            while (k < initialSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)slowUrlList.get(k);
                    slowDataList.add(rootMI);
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating slowUrlList{} ", (Object)loggerDispStr, (Object)e);
                    break;
                }
                ++k;
            }
            slowUrlList = null;
            UPD.cleanSlowURLsList();
            if (existingData) {
                Collections.sort(slowDataList, new BTMUrlComparator());
                int nowSize = slowDataList.size();
                int maxSlow = this.propsManager.getMaxSlowURLs();
                if (nowSize > maxSlow) {
                    int i = nowSize - 1;
                    while (i >= maxSlow) {
                        slowDataList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put(SLOW_URL_LISTS, slowDataList);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} calculateSlowURLDetails- SLOW_URL_LISTS : ", (Object)loggerDispStr);
        }
        ArrayList<MethodInfo> slowThreadDataList = null;
        boolean existingThreadData = false;
        Object dataThreadObject = this.pMeasureHT.get(SLOWURL_THREAD_LISTS);
        if (dataThreadObject != null && dataThreadObject instanceof ArrayList && (slowThreadDataList = (ArrayList<MethodInfo>)dataThreadObject) != null && slowThreadDataList.size() > 0) {
            existingThreadData = true;
        }
        ArrayList slowThreadList = null;
        int initialThreadSize = 0;
        if (UPD.getSlowTHREADsList() != null) {
            if (slowThreadDataList == null) {
                slowThreadDataList = new ArrayList<MethodInfo>();
            }
            slowThreadList = (ArrayList)UPD.getSlowTHREADsList().clone();
            initialThreadSize = slowThreadList.size();
            int k = 0;
            while (k < initialThreadSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)slowThreadList.get(k);
                    slowThreadDataList.add(rootMI);
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating slowUrlList {} ", (Object)loggerDispStr, (Object)e);
                    break;
                }
                ++k;
            }
            if (existingThreadData) {
                Collections.sort(slowThreadDataList, new BTMUrlComparator());
                int nowSize = slowThreadDataList.size();
                int maxSlow = this.propsManager.getMaxSlowURLs();
                if (nowSize > maxSlow) {
                    int i = nowSize - 1;
                    while (i >= maxSlow) {
                        slowThreadDataList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put(SLOWURL_THREAD_LISTS, slowThreadDataList);
        }
        slowThreadList = null;
        UPD.cleanSlowTHREADsList();
    }

    private void calculateErrorURLDetails(URLPatternData UPD) {
        ArrayList<MethodInfo> errorDataList = null;
        boolean existingData = false;
        Object dataObject = this.pMeasureHT.get(ERROR_URL_LISTS);
        if (dataObject != null && dataObject instanceof ArrayList && (errorDataList = (ArrayList<MethodInfo>)dataObject) != null && errorDataList.size() > 0) {
            existingData = true;
        }
        ArrayList errorUrlList = null;
        int initialSize = 0;
        if (UPD.getErrorURLsList() != null) {
            if (errorDataList == null) {
                errorDataList = new ArrayList<MethodInfo>();
            }
            errorUrlList = (ArrayList)UPD.getErrorURLsList().clone();
            initialSize = errorUrlList.size();
            int k = 0;
            while (k < initialSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)errorUrlList.get(k);
                    errorDataList.add(rootMI);
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating errorUrlList {}", (Object)loggerDispStr, (Object)e);
                    break;
                }
                ++k;
            }
            if (existingData) {
                Collections.sort(errorDataList, new BTMUrlComparator());
                int nowSize = errorDataList.size();
                int maxError = this.propsManager.getMaxErrorURLs();
                if (nowSize > maxError) {
                    int i = nowSize - 1;
                    while (i >= maxError) {
                        errorDataList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put(ERROR_URL_LISTS, errorDataList);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} calculateErrorURLDetails - ERROR_URL_LISTS : ", (Object)loggerDispStr);
            if (errorDataList.size() > 0) {
                this.pMeasureHT.put(ERROR_URL_EXISTS, ERROR_URL_EXISTS);
            }
        }
        errorUrlList = null;
        UPD.cleanErrorURLsList();
        ArrayList<MethodInfo> errorDataThreadList = null;
        boolean existingThreadData = false;
        Object dataThreadObject = this.pMeasureHT.get(ERRORURL_THREAD_LISTS);
        if (dataThreadObject != null && dataThreadObject instanceof ArrayList && (errorDataThreadList = (ArrayList<MethodInfo>)dataThreadObject) != null && errorDataThreadList.size() > 0) {
            existingThreadData = true;
        }
        ArrayList errorThreadList = null;
        int initialThreadSize = 0;
        if (UPD.getErrorTHREADsList() != null) {
            if (errorDataThreadList == null) {
                errorDataThreadList = new ArrayList<MethodInfo>();
            }
            errorThreadList = (ArrayList)UPD.getErrorTHREADsList().clone();
            initialThreadSize = errorThreadList.size();
            int k = 0;
            while (k < initialThreadSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)errorThreadList.get(k);
                    errorDataThreadList.add(rootMI);
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating errorThreadList {}", (Object)loggerDispStr, (Object)e);
                    break;
                }
                ++k;
            }
            if (existingThreadData) {
                Collections.sort(errorDataThreadList, new BTMUrlComparator());
                int nowSize = errorDataThreadList.size();
                int maxError = this.propsManager.getMaxErrorURLs();
                if (nowSize > maxError) {
                    int i = nowSize - 1;
                    while (i >= maxError) {
                        errorDataThreadList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put(ERRORURL_THREAD_LISTS, errorDataThreadList);
        }
        errorThreadList = null;
        UPD.cleanErrorTHREADsList();
    }

    private void calculateAllURLDetails(URLPatternData UPD) {
        ArrayList<MethodInfo> allDataList = null;
        boolean existingData = false;
        Object dataObject = this.pMeasureHT.get(ALL_URL_LISTS);
        if (dataObject != null && dataObject instanceof ArrayList && (allDataList = (ArrayList<MethodInfo>)dataObject) != null && allDataList.size() > 0) {
            existingData = true;
        }
        ArrayList allUrlList = null;
        int initialSize = 0;
        if (UPD.getAllURLsList() != null) {
            if (allDataList == null) {
                allDataList = new ArrayList<MethodInfo>();
            }
            allUrlList = (ArrayList)UPD.getAllURLsList().clone();
            initialSize = allUrlList.size();
            int k = 0;
            while (k < initialSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)allUrlList.get(k);
                    allDataList.add(rootMI);
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating AllUrlList {}", (Object)loggerDispStr, (Object)e);
                    break;
                }
                ++k;
            }
            if (existingData) {
                Collections.sort(allDataList, new BTMUrlComparator());
                int nowSize = allDataList.size();
                int maxHealthy = this.propsManager.getHelathyURLs();
                if (nowSize > maxHealthy) {
                    int i = 0;
                    while (allDataList.size() > maxHealthy) {
                        allDataList.remove(0);
                        ++i;
                    }
                }
            }
            this.pMeasureHT.put(ALL_URL_LISTS, allDataList);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} calculateAllURLDetails - ALL_URL_LISTS : ", (Object)loggerDispStr);
        }
        allUrlList = null;
        UPD.cleanAllURLsList();
        ArrayList<MethodInfo> healthyDataThreadList = null;
        boolean existingThreadData = false;
        Object healthyThreadObject = this.pMeasureHT.get(HEALTHYURL_THREAD_LISTS);
        if (healthyThreadObject != null && healthyThreadObject instanceof ArrayList && (healthyDataThreadList = (ArrayList<MethodInfo>)healthyThreadObject) != null && healthyDataThreadList.size() > 0) {
            existingThreadData = true;
        }
        ArrayList healthyThreadList = null;
        int initialThreadSize = 0;
        if (UPD.getHealthyThreadList() != null) {
            if (healthyDataThreadList == null) {
                healthyDataThreadList = new ArrayList<MethodInfo>();
            }
            healthyThreadList = (ArrayList)UPD.getHealthyThreadList().clone();
            initialThreadSize = healthyThreadList.size();
            int k = 0;
            while (k < initialThreadSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)healthyThreadList.get(k);
                    healthyDataThreadList.add(rootMI);
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating helathyThreadList {}", (Object)loggerDispStr, (Object)e);
                    break;
                }
                ++k;
            }
            if (existingThreadData) {
                Collections.sort(healthyDataThreadList, new BTMUrlComparator());
                int nowSize = healthyDataThreadList.size();
                int maxHealthy = this.propsManager.getHelathyURLs();
                if (nowSize > maxHealthy) {
                    int i = nowSize - 1;
                    while (i >= maxHealthy) {
                        healthyDataThreadList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, healthyDataThreadList);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} calculateAllURLDetails - HEALTHYURL_THREAD_LISTS : ", (Object)loggerDispStr);
        }
        healthyThreadList = null;
        UPD.cleanHealthyThreadList();
    }

    public String toString() {
        ArrayList ErrorURLLists;
        StringBuilder outSB = new StringBuilder();
        outSB.append("URLPatternMeasure for pattern ").append(this.pName).append("\n");
        outSB.append("'modified' flag is  ").append(this.modified).append("\n");
        ArrayList pMeasuresList = (ArrayList)this.pMeasureHT.get(PATTERN_DATA);
        if (pMeasuresList != null) {
            outSB.append(pMeasuresList.toString()).append("\n");
        } else {
            outSB.append("No measures\n");
        }
        ArrayList allURLLists = (ArrayList)this.pMeasureHT.get(ALL_URL_LISTS);
        int allUrlSize = 0;
        if (allURLLists != null) {
            allUrlSize = allURLLists.size();
            outSB.append("All URL List Size: ").append(allUrlSize).append(" \n");
        } else {
            outSB.append("No All URLs for this pattern.\n");
        }
        ArrayList SlowURLLists = (ArrayList)this.pMeasureHT.get(SLOW_URL_LISTS);
        if (SlowURLLists != null) {
            if (SlowURLLists.size() > 0) {
                outSB.append("Slow URL List: \n");
                int i = 0;
                while (i < SlowURLLists.size()) {
                    ArrayList SlowURLList = (ArrayList)SlowURLLists.get(i);
                    outSB.append("Slow URL ").append(i).append(" : ").append(SlowURLList.toString());
                    ++i;
                }
            } else {
                outSB.append("No Slow URLs for this pattern.\n");
            }
        }
        if ((ErrorURLLists = (ArrayList)this.pMeasureHT.get(ERROR_URL_LISTS)) != null) {
            if (ErrorURLLists.size() > 0) {
                outSB.append("Error URL List: \n");
                int i = 0;
                while (i < ErrorURLLists.size()) {
                    ArrayList ErrorURLList = (ArrayList)ErrorURLLists.get(i);
                    outSB.append("Error URL ").append(i).append(" : ").append(ErrorURLList.toString());
                    ++i;
                }
            } else {
                outSB.append("No Error URLs for this pattern.\n");
            }
        }
        outSB.append("*******************************************************************************************");
        return outSB.toString();
    }

    public double getAverageResponseTime() {
        return this.averageResponseTime;
    }

    void modifyDefaultPatternData() {
        int now_size = this.defaultPatternData.size();
        if (now_size > this.old_measure_count) {
            int i = now_size - 1;
            while (i >= this.old_measure_count) {
                this.defaultPatternData.remove(i);
                --i;
            }
        }
    }

    void updateDefaultPatternData() {
        int currentSize = this.defaultPatternData.size();
        int diff = PropsManager.getSubCompNameLength() * 2 - currentSize;
        if (diff > 0) {
            int j = 0;
            while (j < diff) {
                this.defaultPatternData.add(defaultMeasure);
                ++j;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BTMUrlComparator
    implements Comparator<MethodInfo> {
        BTMUrlComparator() {
        }

        @Override
        public int compare(MethodInfo methodInfo1, MethodInfo methodInfo2) {
            Long objectA = new Long(0L);
            if (methodInfo1 != null) {
                objectA = methodInfo1.getExecutionTime();
            }
            Long objectB = new Long(0L);
            if (methodInfo2 != null) {
                objectB = methodInfo2.getExecutionTime();
            }
            return objectB.compareTo(objectA);
        }
    }
}

