/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.LDAPUrl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.GetOpt;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.MimeBase64Encoder;

public class LDAPSearch
extends LDAPTool {
    private static boolean m_attrsonly = false;
    private static int m_deref = 0;
    private static int m_scope = 2;
    private static int m_sizelimit = 0;
    private static int m_timelimit = 0;
    private static int verbose = 0;
    private static String[] m_attrs = null;
    private static String m_base = "o=ace industry,c=us";
    private static String m_filter = null;
    private static String m_sep = ":";
    private static Vector m_sort = new Vector();
    private static boolean m_sortOnServer = false;
    private static boolean m_tempFiles = false;
    private static int m_beforeCount = 0;
    private static int m_afterCount = 0;
    private static int m_index = 0;
    private static int m_count = 0;
    private static int m_vlvTokens = 0;
    private static String m_searchVal = null;
    private static boolean m_foldLine = true;
    private static final int MAX_LINE = 77;
    private static PrintWriter m_pw = new PrintWriter(System.out);

    private static void doUsage() {
        System.err.println("usage: LDAPSearch -b basedn [options] filter [attributes...]");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -v            run in verbose mode");
        System.err.println("  -n            show what would be done but don't actually do it");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -t            write values to files");
        System.err.println("  -A            retrieve attribute names only");
        System.err.println("  -F sep        print 'sep' instead of '=' between attribute names and values");
        System.err.println("  -S attr       sort the results by attribute 'attr'");
        System.err.println("  -s scope      one of base, one, or sub (search scope)");
        System.err.println("  -a deref      one of never, always, search, or find (alias dereferencing)");
        System.err.println("  -l timelimit  time limit (in seconds) for search");
        System.err.println("  -T            do not fold (wrap) long lines (default is to fold)");
        System.err.println("  -x            perform sorting on server");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -z sizelimit  size limit (in entries) for search");
        System.err.println("  -G before:after:index:count | before:after:value where 'before' and 'after' are the number of entries surrounding 'index'. 'count' is the content count, 'value' is the search value.");
        System.err.println("  -y proxy-DN   DN to use for access control");
    }

    private static void dosearch() {
        String[] stringArray;
        Object object;
        Object[] objectArray = null;
        try {
            Object object2;
            object = new Vector<Object>();
            stringArray = null;
            if (m_sortOnServer && m_sort.size() > 0) {
                object2 = new LDAPSortKey[m_sort.size()];
                int n = 0;
                while (n < ((LDAPSortKey[])object2).length) {
                    object2[n] = new LDAPSortKey((String)m_sort.elementAt(n));
                    ++n;
                }
                stringArray = new LDAPSortControl((LDAPSortKey[])object2, true);
                ((Vector)object).addElement(stringArray);
            }
            if (stringArray == null && m_vlvTokens >= 3) {
                System.err.println("Server-side sorting is required for virtual list option");
                LDAPSearch.doUsage();
                System.exit(0);
            }
            object2 = null;
            if (m_vlvTokens == 3) {
                object2 = new LDAPVirtualListControl(m_searchVal, m_beforeCount, m_afterCount);
            } else if (m_vlvTokens > 3) {
                object2 = new LDAPVirtualListControl(m_index, m_beforeCount, m_afterCount, m_count);
            }
            if (object2 != null) {
                ((Vector)object).addElement(object2);
            }
            if (LDAPTool.m_proxyControl != null) {
                ((Vector)object).addElement(LDAPTool.m_proxyControl);
            }
            if (LDAPTool.m_ordinary) {
                LDAPControl lDAPControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
                ((Vector)object).addElement(lDAPControl);
            }
            if (((Vector)object).size() > 0) {
                objectArray = new LDAPControl[((Vector)object).size()];
                ((Vector)object).copyInto(objectArray);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(0);
        }
        object = null;
        try {
            stringArray = LDAPTool.m_client.getSearchConstraints();
            stringArray.setServerControls((LDAPControl[])objectArray);
            stringArray.setDereference(m_deref);
            stringArray.setMaxResults(m_sizelimit);
            stringArray.setTimeLimit(m_timelimit);
            stringArray.setReferrals(LDAPTool.m_referrals);
            if (LDAPTool.m_referrals) {
                LDAPTool.setDefaultReferralCredentials((LDAPConstraints)stringArray);
            }
            stringArray.setHopLimit(LDAPTool.m_hopLimit);
            object = LDAPTool.m_client.search(m_base, m_scope, m_filter, m_attrs, m_attrsonly, (LDAPSearchConstraints)stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        if (m_sort.size() > 0 && !m_sortOnServer) {
            stringArray = new String[m_sort.size()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = (String)m_sort.elementAt(n);
                ++n;
            }
            ((LDAPSearchResults)object).sort(new LDAPCompareAttrNames(stringArray));
        }
        LDAPSearch.printResults(object);
        LDAPSearch.showControls(LDAPTool.m_client.getResponseControls());
    }

    protected static void extractParameters(String[] stringArray) {
        Object object;
        String string = "HATtxvna:b:F:l:s:S:z:G:";
        GetOpt getOpt = LDAPTool.extractParameters(string, stringArray);
        if (getOpt.hasOption('H')) {
            LDAPSearch.doUsage();
            System.exit(0);
        }
        if (getOpt.hasOption('A')) {
            m_attrsonly = true;
        }
        if (getOpt.hasOption('x')) {
            m_sortOnServer = true;
        }
        if (getOpt.hasOption('t')) {
            m_tempFiles = true;
        }
        if (getOpt.hasOption('F')) {
            m_sep = getOpt.getOptionParam('F');
        }
        if (getOpt.hasOption('a')) {
            object = getOpt.getOptionParam('a');
            if (((String)object).equalsIgnoreCase("never")) {
                m_deref = 0;
            } else if (((String)object).equalsIgnoreCase("search")) {
                m_deref = 1;
            } else if (((String)object).equalsIgnoreCase("find")) {
                m_deref = 2;
            } else if (((String)object).equalsIgnoreCase("always")) {
                m_deref = 3;
            } else {
                System.err.println("Error: alias deref option should be never, search, find, or always.");
            }
        }
        if (getOpt.hasOption('b')) {
            m_base = getOpt.getOptionParam('b');
        }
        if (getOpt.hasOption('S')) {
            m_sort.addElement(getOpt.getOptionParam('S'));
        }
        if (getOpt.hasOption('l')) {
            try {
                m_timelimit = Integer.parseInt(getOpt.getOptionParam('l'));
            }
            catch (NumberFormatException numberFormatException) {
                m_timelimit = 0;
            }
        }
        if (getOpt.hasOption('s')) {
            object = getOpt.getOptionParam('s');
            if (((String)object).equalsIgnoreCase("base")) {
                m_scope = 0;
            } else if (((String)object).equalsIgnoreCase("one")) {
                m_scope = 1;
            } else if (((String)object).equalsIgnoreCase("sub")) {
                m_scope = 2;
            } else {
                System.err.println("Error: scope should be base, one or sub.");
            }
        }
        if (getOpt.hasOption('z')) {
            try {
                m_sizelimit = Integer.parseInt(getOpt.getOptionParam('z'));
            }
            catch (NumberFormatException numberFormatException) {
                m_sizelimit = 0;
            }
        }
        if (getOpt.hasOption('T')) {
            m_foldLine = false;
        }
        LDAPSearch.parseVlv(getOpt);
        object = getOpt.getParameters().elements();
        Vector vector = new Vector();
        while (object.hasMoreElements()) {
            vector.addElement(object.nextElement());
        }
        int n = vector.size();
        if (n <= 0) {
            System.err.println("Error: must supply filter string!");
            LDAPSearch.doUsage();
            System.exit(0);
        }
        if (n == 1) {
            m_filter = (String)vector.elementAt(0);
            if (LDAPTool.m_verbose) {
                System.err.println("filter pattern: " + m_filter);
            }
            m_attrs = null;
            if (LDAPTool.m_verbose) {
                System.err.println("returning: ALL");
                System.err.println("filter is: (" + m_filter + ")");
            }
        }
        if (n > 1) {
            m_filter = (String)vector.elementAt(0);
            if (LDAPTool.m_verbose) {
                System.err.println("filter pattern: " + m_filter);
                System.err.print("returning:");
            }
            m_attrs = new String[n];
            int n2 = 1;
            while (n2 < n) {
                LDAPSearch.m_attrs[n2 - 1] = (String)vector.elementAt(n2);
                if (LDAPTool.m_verbose) {
                    System.err.print(" " + m_attrs[n2 - 1]);
                }
                ++n2;
            }
            if (LDAPTool.m_verbose) {
                System.err.println();
                System.err.println("filter is: (" + m_filter + ")");
            }
        }
    }

    private static FileOutputStream getTempFile(String string) throws IOException {
        String string2;
        File file;
        int n = 0;
        do {
            string2 = String.valueOf(string) + '.' + n;
            file = new File(string2);
            ++n;
        } while (file.exists());
        LDAPSearch.printString(String.valueOf(string) + m_sep + " " + string2);
        return new FileOutputStream(file);
    }

    public static void main(String[] stringArray) {
        LDAPSearch.extractParameters(stringArray);
        if (!LDAPTool.m_justShow) {
            try {
                LDAPTool.m_client = new LDAPConnection();
                LDAPTool.m_client.connect(LDAPTool.m_ldaphost, LDAPTool.m_ldapport);
            }
            catch (Exception exception) {
                System.err.println("Error: client connection failed!");
                System.exit(0);
            }
            try {
                LDAPTool.m_client.authenticate(LDAPTool.m_version, LDAPTool.m_binddn, LDAPTool.m_passwd);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                System.exit(0);
            }
            LDAPSearch.dosearch();
            m_pw.flush();
            m_pw.close();
            try {
                LDAPTool.m_client.disconnect();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
        System.exit(0);
    }

    private static void parseVlv(GetOpt getOpt) {
        block9: {
            StringTokenizer stringTokenizer;
            block10: {
                if (!getOpt.hasOption('G')) break block9;
                String string = getOpt.getOptionParam('G');
                stringTokenizer = new StringTokenizer(string, ":");
                m_vlvTokens = stringTokenizer.countTokens();
                if (m_vlvTokens < 3) {
                    LDAPSearch.doUsage();
                    System.exit(0);
                }
                try {
                    m_beforeCount = Integer.parseInt((String)stringTokenizer.nextElement());
                }
                catch (NumberFormatException numberFormatException) {
                    m_beforeCount = 0;
                }
                try {
                    m_afterCount = Integer.parseInt((String)stringTokenizer.nextElement());
                }
                catch (NumberFormatException numberFormatException) {
                    m_afterCount = 0;
                }
                if (m_vlvTokens != 3) break block10;
                m_searchVal = (String)stringTokenizer.nextElement();
                break block9;
            }
            if (m_vlvTokens <= 3) break block9;
            try {
                m_index = Integer.parseInt((String)stringTokenizer.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                m_index = 0;
            }
            try {
                m_count = Integer.parseInt((String)stringTokenizer.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                m_count = 0;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void printResults(LDAPSearchResults var0) {
        try lbl-1000:
        // 2 sources

        {
            block7: while (true) {
                if (!var0.hasMoreElements()) {
                    return;
                }
                var1_1 = null;
                try {
                    var1_1 = var0.next();
                }
                catch (LDAPReferralException var2_4) {
                    var3_6 = var2_4.getURLs();
                    System.err.println("Referral entries: ");
                    var4_7 = 0;
                    if (true) ** GOTO lbl45
                }
                catch (Exception var2_5) {
                    System.err.println(var2_5.toString());
                    continue;
                }
                var2_3 = var1_1.getDN();
                if (var2_3 != null) {
                    LDAPSearch.printString("dn" + LDAPSearch.m_sep + " " + var2_3);
                } else {
                    LDAPSearch.printString("dn" + LDAPSearch.m_sep);
                }
                var3_6 = var1_1.getAttributeSet();
                var4_8 = var3_6.getAttributes();
lbl24:
                // 2 sources

                while (true) {
                    if (!var4_8.hasMoreElements()) {
                        LDAPSearch.m_pw.println();
                        continue block7;
                    }
                    var5_9 = (LDAPAttribute)var4_8.nextElement();
                    var6_10 = var5_9.getName();
                    if (LDAPSearch.m_attrsonly) {
                        LDAPSearch.printString(String.valueOf(var6_10) + ":");
                        continue;
                    }
                    var7_11 = var5_9.getByteValues();
                    if (var7_11 == null) {
                        System.err.println("Failed to do string conversion for " + var6_10);
                        continue;
                    }
                    ** GOTO lbl72
                    break;
                }
                break;
            }
        }
        catch (Exception var1_2) {
            System.err.println(var1_2.toString());
            System.exit(0);
        }
        return;
        do {
            System.err.println("\t" + var3_6[var4_7].getUrl().toString());
            ++var4_7;
lbl45:
            // 2 sources

        } while (var4_7 < ((LDAPUrl[])var3_6).length);
        ** while (true)
lbl-1000:
        // 1 sources

        {
            if (LDAPSearch.m_tempFiles) {
                try {
                    var8_12 = LDAPSearch.getTempFile(var6_10);
                    var8_12.write((byte[])var7_11.nextElement());
                }
                catch (Exception var8_13) {
                    System.err.println("Error writing values of " + var6_10 + ", " + var8_13.toString());
                    System.exit(1);
                }
                continue;
            }
            var8_12 = (byte[])var7_11.nextElement();
            var9_14 = null;
            if (LDIF.isPrintable((byte[])var8_12)) {
                var9_14 = new String((byte[])var8_12, "UTF8");
                LDAPSearch.printString(String.valueOf(var6_10) + LDAPSearch.m_sep + " " + var9_14);
                continue;
            }
            var10_15 = new ByteBuf((byte[])var8_12, 0, ((Object)var8_12).length);
            var11_16 = new ByteBuf();
            var12_17 = new MimeBase64Encoder();
            var12_17.translate(var10_15, var11_16);
            var13_18 = var11_16.length();
            if (var13_18 > 0) {
                var9_14 = new String(var11_16.toBytes(), 0, var13_18);
                LDAPSearch.printString(String.valueOf(var6_10) + ":: " + var9_14);
                continue;
            }
            LDAPSearch.m_pw.print(String.valueOf(var6_10) + ": \n");
lbl72:
            // 6 sources

            ** while (var7_11.hasMoreElements())
        }
lbl73:
        // 1 sources

        ** while (true)
    }

    private static void printString(String string) {
        if (m_foldLine) {
            LDIF.breakString(m_pw, string, 77);
        } else {
            m_pw.print(string);
            m_pw.print('\n');
        }
    }

    private static void showControls(LDAPControl[] lDAPControlArray) {
        if (lDAPControlArray == null) {
            return;
        }
        LDAPSortControl lDAPSortControl = null;
        LDAPVirtualListResponse lDAPVirtualListResponse = null;
        int n = 0;
        while (n < lDAPControlArray.length) {
            if (lDAPControlArray[n] instanceof LDAPSortControl) {
                lDAPSortControl = (LDAPSortControl)lDAPControlArray[n];
            } else if (lDAPControlArray[n] instanceof LDAPVirtualListResponse) {
                lDAPVirtualListResponse = (LDAPVirtualListResponse)lDAPControlArray[n];
            }
            ++n;
        }
        if (lDAPSortControl != null) {
            String string = lDAPSortControl.getFailedAttribute();
            int n2 = lDAPSortControl.getResultCode();
            if (n2 != 0) {
                System.err.println("Error code: " + n2);
                if (string != null) {
                    System.err.println("Offending attribute: " + string);
                } else {
                    System.err.println("No offending attribute returned");
                }
            } else {
                m_pw.println("Server indicated results sorted OK");
            }
        }
        if (lDAPVirtualListResponse != null) {
            int n3 = lDAPVirtualListResponse.getResultCode();
            if (n3 == 0) {
                m_pw.println("Server indicated virtual list positioning OK");
                m_pw.println("index " + lDAPVirtualListResponse.getFirstPosition() + " content count " + lDAPVirtualListResponse.getContentCount());
            } else {
                System.err.println("Virtual List Error: " + LDAPException.errorCodeToString(n3));
            }
        }
    }
}

