/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public abstract class RemoteHttpServlet
extends HttpServlet
implements Remote {
    protected Registry registry;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            UnicastRemoteObject.exportObject(this);
            this.bind();
        }
        catch (RemoteException remoteException) {
            this.log("Problem binding to RMI registry: " + remoteException.getMessage());
        }
    }

    public void destroy() {
        this.unbind();
    }

    protected String getRegistryName() {
        String string = this.getInitParameter("registryName");
        if (string != null) {
            return string;
        }
        return this.getClass().getName();
    }

    protected int getRegistryPort() {
        try {
            return Integer.parseInt(this.getInitParameter("registryPort"));
        }
        catch (NumberFormatException numberFormatException) {
            return 1099;
        }
    }

    protected void bind() {
        try {
            this.registry = LocateRegistry.getRegistry(this.getRegistryPort());
            this.registry.list();
        }
        catch (Exception exception) {
            this.registry = null;
        }
        if (this.registry == null) {
            try {
                this.registry = LocateRegistry.createRegistry(this.getRegistryPort());
            }
            catch (Exception exception) {
                this.log("Could not get or create RMI registry on port " + this.getRegistryPort() + ": " + exception.getMessage());
                return;
            }
        }
        try {
            this.registry.rebind(this.getRegistryName(), this);
        }
        catch (Exception exception) {
            this.log("Could not bind to RMI registry: " + exception.getMessage());
            return;
        }
    }

    protected void unbind() {
        try {
            if (this.registry != null) {
                this.registry.unbind(this.getRegistryName());
            }
        }
        catch (Exception exception) {
            this.log("Problem unbinding from RMI registry: " + exception.getMessage());
        }
    }
}

