/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.charset.Charset;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public class TbDatabaseMetaData
implements DatabaseMetaData {
    protected TbConnection conn;

    public TbDatabaseMetaData(TbConnection tbConnection) {
        this.conn = tbConnection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        if (this.conn.getExtFeatureInfo().supports(1)) {
            PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_ATTRIBUTES);
            preparedStatement.setInt(1, this.conn.getMapDateToTimestamp() ? 93 : 91);
            preparedStatement.setString(2, string2 == null ? "%" : string2);
            preparedStatement.setString(3, string3 == null ? "%" : string3);
            preparedStatement.setString(4, string4 == null ? "%" : string4);
            TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
            tbResultSetBase.closeStatementOnClose();
            return tbResultSetBase;
        }
        int n = 21;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TbStatement tbStatement = new TbStatement(this.conn);
        TbResultSet tbResultSet = TbResultSetFactory.buildEmptyResultSet(tbStatement, -2, n, 0);
        DataTypeConverter dataTypeConverter = this.conn.getTypeConverter();
        TbColumnDesc[] tbColumnDescArray = new TbColumnDesc[n];
        for (int i = 0; i < n; ++i) {
            tbColumnDescArray[i] = new TbColumnDesc();
        }
        tbColumnDescArray[0].set("TYPE_CAT", 3, n2, n3, n4, n5);
        tbColumnDescArray[1].set("TYPE_SCHEM", 3, n2, n3, n4, n5);
        tbColumnDescArray[2].set("TYPE_NAME", 3, n2, n3, n4, n5);
        tbColumnDescArray[3].set("ATTR_NAME", 3, n2, n3, n4, n5);
        tbColumnDescArray[4].set("DATA_TYPE", 1, n2, n3, n4, n5);
        tbColumnDescArray[5].set("ATTR_TYPE_NAME", 3, n2, n3, n4, n5);
        tbColumnDescArray[6].set("ATTR_SIZE", 1, n2, n3, n4, n5);
        tbColumnDescArray[7].set("DECIMAL_DIGITS", 1, n2, n3, n4, n5);
        tbColumnDescArray[8].set("NUM_PREC_RADIX", 1, n2, n3, n4, n5);
        tbColumnDescArray[9].set("NULLABLE", 1, n2, n3, n4, n5);
        tbColumnDescArray[10].set("REMARKS", 3, n2, n3, n4, n5);
        tbColumnDescArray[11].set("ATTR_DEF", 3, n2, n3, n4, n5);
        tbColumnDescArray[12].set("SQL_DATA_TYPE", 1, n2, n3, n4, n5);
        tbColumnDescArray[13].set("SQL_DATETIME_SUB", 1, n2, n3, n4, n5);
        tbColumnDescArray[14].set("CHAR_OCTET_LENGTH", 1, n2, n3, n4, n5);
        tbColumnDescArray[15].set("ORDINAL_POSITION", 1, n2, n3, n4, n5);
        tbColumnDescArray[16].set("IS_NULLABLE", 3, n2, n3, n4, n5);
        tbColumnDescArray[17].set("SCOPE_CATALOG", 3, n2, n3, n4, n5);
        tbColumnDescArray[18].set("SCOPE_SCHEMA", 3, n2, n3, n4, n5);
        tbColumnDescArray[19].set("SCOPE_TABLE", 3, n2, n3, n4, n5);
        tbColumnDescArray[20].set("SOURCE_DATA_TYPE", 1, n2, n3, n4, n5);
        dataTypeConverter.buildColumnMetadata(tbColumnDescArray, tbResultSet, tbColumnDescArray.length);
        ((TbResultSetBase)tbResultSet).closeStatementOnClose();
        return tbResultSet;
    }

    public synchronized ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.getBestRowIdentifierQuery(this.conn.getExtFeatureInfo().supports(2)));
        preparedStatement.setInt(1, this.conn.getMapDateToTimestamp() ? 93 : 91);
        switch (n) {
            case 0: {
                preparedStatement.setInt(2, 0);
                preparedStatement.setInt(3, 0);
                break;
            }
            case 1: {
                preparedStatement.setInt(2, 1);
                preparedStatement.setInt(3, 1);
                break;
            }
            case 2: {
                preparedStatement.setInt(2, 0);
                preparedStatement.setInt(3, 1);
            }
        }
        preparedStatement.setString(4, string3);
        preparedStatement.setString(5, string2 != null ? string2 : "%");
        preparedStatement.setString(6, bl ? "X" : "Y");
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public synchronized ResultSet getCatalogs() throws SQLException {
        Statement statement = this.conn.createStatement();
        TbResultSetBase tbResultSetBase = (TbResultSetBase)statement.executeQuery(TbDatabaseMetaQuery.QUERY_CATALOGS);
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        return "";
    }

    public synchronized ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_COLUMNPRIVILEGES);
        preparedStatement.setString(1, string2 != null ? string2 : "%");
        preparedStatement.setString(2, string3 != null ? string3 : "%");
        preparedStatement.setString(3, string4 != null ? string4 : "%");
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public synchronized ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = this.conn.getIncludeSynonyms();
        boolean bl2 = this.conn.getMapDateToTimestamp();
        PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.getTableColumnsQuery(bl, this.conn.getExtFeatureInfo().supports(2)));
        preparedStatement.setInt(1, bl2 ? 93 : 91);
        preparedStatement.setString(2, string2 != null ? string2 : "%");
        if (bl) {
            preparedStatement.setString(3, string2 != null ? string2 : "%");
            preparedStatement.setString(4, string3 != null ? string3 : "%");
            preparedStatement.setString(5, string3 != null ? string3 : "%");
            preparedStatement.setString(6, string4 != null ? string4 : "%");
            preparedStatement.setString(7, string2 != null ? string2 : "%");
            preparedStatement.setString(8, string2 != null ? string2 : "%");
        } else {
            preparedStatement.setString(3, string3 != null ? string3 : "%");
            preparedStatement.setString(4, string4 != null ? string4 : "%");
        }
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return this.getRelatedKeys(string2, string3, string5, string6, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.conn.serverInfo.getTbMajor();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.conn.serverInfo.getTbMinor();
    }

    public String getDatabaseProductName() throws SQLException {
        String string = this.conn.info.getDatabaseProductName();
        if (string == null || string.equals("")) {
            return this.conn.serverInfo.getTbProductName();
        }
        return string;
    }

    public String getDatabaseProductVersion() throws SQLException {
        String string = this.conn.info.getDatabaseProductVersion();
        if (string == null || string.equals("")) {
            return this.conn.serverInfo.getTbProductVersion();
        }
        return string;
    }

    public synchronized ResultSet getDBParam(String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(TbDatabaseMetaQuery.QUERY_IPARAM);
        if (string != null) {
            stringBuffer.append(" name like '%").append(string.toUpperCase()).append("%' and");
        }
        stringBuffer.append(" name not like '").append(this.getSearchStringEscape()).append("_%' escape '").append(this.getSearchStringEscape()).append("'");
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public int getDriverMajorVersion() {
        return Integer.parseInt(DriverConstants.JDBC_MAJOR);
    }

    public int getDriverMinorVersion() {
        return Integer.parseInt(DriverConstants.JDBC_MINOR);
    }

    public String getDriverName() throws SQLException {
        String string = this.conn.info.getDriverName();
        if (string == null || string.equals("")) {
            return DriverConstants.BRAND_NAME + " " + DriverConstants.JDBC_PRODUCT_NAME;
        }
        return string;
    }

    public String getDriverVersion() throws SQLException {
        String string = this.conn.info.getDriverVersion();
        if (string == null || string.equals("")) {
            return DriverConstants.JDBC_MAJOR + "." + DriverConstants.JDBC_MINOR + "." + " ";
        }
        return string;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getRelatedKeys(string2, string3, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    public String getExtraNameCharacters() throws SQLException {
        return "$#";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getRelatedKeys(null, null, string2, string3, "ORDER BY pktable_schem, pktable_name, key_seq");
    }

    public synchronized ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (!bl2) {
            this.gatherTableStats(string2, string3);
        }
        StringBuffer stringBuffer = new StringBuffer(TbDatabaseMetaQuery.QUERY_INDEXINFO01);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" and owner = ? ");
        }
        stringBuffer.append(" union ");
        stringBuffer.append(TbDatabaseMetaQuery.QUERY_INDEXINFO02);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" and i.owner = ? ");
        }
        if (bl) {
            stringBuffer.append(" and i.uniqueness = 'UNIQUE' ");
        }
        stringBuffer.append(TbDatabaseMetaQuery.QUERY_INDEXINFO03);
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n = 1;
        preparedStatement.setString(n++, string3);
        if (string2 != null && string2.length() > 0) {
            preparedStatement.setString(n++, string2);
        }
        preparedStatement.setString(n++, string3);
        if (string2 != null && string2.length() > 0) {
            preparedStatement.setString(n++, string2);
        }
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherTableStats(String string, String string2) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.conn.prepareCall(TbDatabaseMetaQuery.QUERY_GATHER_TABLE_STATS);
            callableStatement.setString(1, string != null && string.length() > 0 ? string : this.conn.info.getUser());
            callableStatement.setString(2, string2);
            callableStatement.execute();
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int getJDBCMajorVersion() throws SQLException {
        int n = 3;
        return n;
    }

    public int getJDBCMinorVersion() throws SQLException {
        int n = 0;
        return n;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 65535;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 65535;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 30;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1000;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 30;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 30;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 30;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 30;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public synchronized ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_PRIMARYKEY);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2 != null ? string2 : "%");
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public synchronized ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(TbDatabaseMetaQuery.getProcedureColumnsQuery(this.conn.getMapDateToTimestamp()));
        String string5 = this.getQualifiedSchemaName(string2);
        String string6 = this.getQualifiedObjName(string3);
        String string7 = this.getQualifiedObjName(string4);
        if (string != null && string.length() == 0) {
            stringBuffer.append("   AND PACKAGE_NAME IS NULL");
        } else if (string != null) {
            stringBuffer.append("   AND PACKAGE_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
        }
        stringBuffer.append("   AND OBJECT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
        if (string7.equals("%")) {
            stringBuffer.append("   AND (ARGUMENT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("' ");
            stringBuffer.append("        OR (ARGUMENT_NAME IS NULL AND DATA_TYPE IS NOT NULL))");
        } else {
            stringBuffer.append("   AND ARGUMENT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("' ");
        }
        stringBuffer.append("   ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME");
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        int n = 1;
        preparedStatement.setString(n++, string5);
        if (string != null && string.length() > 0) {
            preparedStatement.setString(n++, string);
        }
        preparedStatement.setString(n++, string6);
        preparedStatement.setString(n++, string7);
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public synchronized ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String string4 = this.getQualifiedSchemaName(string2);
        String string5 = this.getQualifiedObjName(string3);
        StringBuffer stringBuffer = new StringBuffer(TbDatabaseMetaQuery.QUERY_PROCEDURES);
        if (string == null) {
            stringBuffer.append("   AND (OBJECT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("' OR");
            stringBuffer.append("        PROCEDURE_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("')");
            stringBuffer.append(" ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME");
        } else if (string.length() == 0) {
            stringBuffer.append("   AND OBJECT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
            stringBuffer.append("   AND PROCEDURE_NAME IS NULL");
        } else {
            stringBuffer.append("   AND OBJECT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
            stringBuffer.append("   AND PROCEDURE_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
            stringBuffer.append(" ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME");
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string4);
        if (string == null) {
            preparedStatement.setString(2, string5);
            preparedStatement.setString(3, string5);
        } else if (string.equals("")) {
            preparedStatement.setString(2, string5);
        } else {
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string5);
        }
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    private String getQualifiedObjName(String string) throws SQLException {
        if (string == null) {
            return "%";
        }
        if (string.length() == 0) {
            throw TbError.newSQLException(-90649);
        }
        return string;
    }

    private String getQualifiedSchemaName(String string) {
        if (string == null) {
            return "%";
        }
        if (string.equals("")) {
            return this.conn.info.getUser();
        }
        return string;
    }

    private synchronized ResultSet getRelatedKeys(String string, String string2, String string3, String string4, String string5) throws SQLException {
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer(TbDatabaseMetaQuery.QUERY_RELATEDKEYS);
        if (string2 != null) {
            stringBuffer.append(" AND p.table_name \t= ? ");
        }
        if (string4 != null) {
            stringBuffer.append(" AND f.table_name \t= ? ");
        }
        if (string != null && string.length() > 0) {
            stringBuffer.append(" AND p.owner \t= ? ");
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(" AND f.owner \t= ? ");
        }
        stringBuffer.append(string5);
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        if (string2 != null) {
            preparedStatement.setString(n++, string2);
        }
        if (string4 != null) {
            preparedStatement.setString(n++, string4);
        }
        if (string != null && string.length() > 0) {
            preparedStatement.setString(n++, string);
        }
        if (string3 != null && string3.length() > 0) {
            preparedStatement.setString(n++, string3);
        }
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.conn.createStatement();
        TbResultSetBase tbResultSetBase = (TbResultSetBase)statement.executeQuery(TbDatabaseMetaQuery.QUERY_SCHEMAS_01 + TbDatabaseMetaQuery.QUERY_SCHEMAS_02);
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    public String getSearchStringEscape() throws SQLException {
        return TbDatabaseMetaQuery.escapeChar;
    }

    public String getServerCharSet() throws SQLException {
        return Charset.getName(this.conn.getServerCharSet());
    }

    public String getSQLKeywords() throws SQLException {
        return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_words";
    }

    public int getSQLStateType() throws SQLException {
        return 0;
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SPACE,SUBSTRING,UCASE";
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        int n = 4;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TbStatement tbStatement = new TbStatement(this.conn);
        TbResultSet tbResultSet = TbResultSetFactory.buildEmptyResultSet(tbStatement, -2, n, 0);
        DataTypeConverter dataTypeConverter = this.conn.getTypeConverter();
        TbColumnDesc[] tbColumnDescArray = new TbColumnDesc[n];
        for (int i = 0; i < n; ++i) {
            tbColumnDescArray[i] = new TbColumnDesc();
        }
        tbColumnDescArray[0].set("TABLE_CAT", 3, n2, n3, n4, n5);
        tbColumnDescArray[1].set("TABLE_SCHEM", 3, n2, n3, n4, n5);
        tbColumnDescArray[2].set("TABLE_NAME", 3, n2, n3, n4, n5);
        tbColumnDescArray[3].set("SUPERTABLE_NAME", 3, n2, n3, n4, n5);
        dataTypeConverter.buildColumnMetadata(tbColumnDescArray, tbResultSet, tbColumnDescArray.length);
        ((TbResultSetBase)tbResultSet).closeStatementOnClose();
        return tbResultSet;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        int n = 6;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TbStatement tbStatement = new TbStatement(this.conn);
        TbResultSet tbResultSet = TbResultSetFactory.buildEmptyResultSet(tbStatement, -2, n, 0);
        DataTypeConverter dataTypeConverter = this.conn.getTypeConverter();
        TbColumnDesc[] tbColumnDescArray = new TbColumnDesc[n];
        for (int i = 0; i < n; ++i) {
            tbColumnDescArray[i] = new TbColumnDesc();
        }
        tbColumnDescArray[0].set("TYPE_CAT", 3, n2, n3, n4, n5);
        tbColumnDescArray[1].set("TYPE_SCHEM", 3, n2, n3, n4, n5);
        tbColumnDescArray[2].set("TYPE_NAME", 3, n2, n3, n4, n5);
        tbColumnDescArray[3].set("SUPERTYPE_CAT", 3, n2, n3, n4, n5);
        tbColumnDescArray[4].set("SUPERTYPE_SCHEM", 3, n2, n3, n4, n5);
        tbColumnDescArray[5].set("SUPERTYPE_NAME", 3, n2, n3, n4, n5);
        dataTypeConverter.buildColumnMetadata(tbColumnDescArray, tbResultSet, tbColumnDescArray.length);
        ((TbResultSetBase)tbResultSet).closeStatementOnClose();
        return tbResultSet;
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USER";
    }

    public synchronized ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_TABLEPRIVILEGES);
        preparedStatement.setString(1, string2 != null ? string2 : "%");
        preparedStatement.setString(2, string3 != null ? string3 : "%");
        preparedStatement.setString(3, string2 != null ? string2 : "%");
        preparedStatement.setString(4, string3 != null ? string3 : "%");
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public synchronized ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(TbDatabaseMetaQuery.QUERY_TABLES);
        if (stringArray != null) {
            stringBuffer.append(" AND o.object_type IN ( ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("'").append(stringArray[i]).append("'");
                    continue;
                }
                stringBuffer.append(", '").append(stringArray[i]).append("'");
            }
            stringBuffer.append(") ");
        } else {
            stringBuffer.append(" AND o.object_type IN ('TABLE', 'SYNONYM', 'VIEW') ");
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        preparedStatement.setString(1, string2 != null ? string2 : "%");
        preparedStatement.setString(2, string3 != null ? string3 : "%");
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public synchronized ResultSet getTableTypes() throws SQLException {
        Statement statement = this.conn.createStatement();
        TbResultSetBase tbResultSetBase = (TbResultSetBase)statement.executeQuery(TbDatabaseMetaQuery.QUERY_TABLETYPES);
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURTIME,DAYOFMONTH,EXTRACT,HOUR,MINUTE,MONTH,NOW,SECOND,YEAR";
    }

    public ResultSet getTypeInfo() throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_TYPEINFO);
        boolean bl = this.conn.getExtFeatureInfo().supports(2);
        preparedStatement.setInt(1, bl ? 1 : 0);
        preparedStatement.setInt(2, bl ? 1 : 0);
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        if (this.conn.getExtFeatureInfo().supports(1) && (nArray == null || Arrays.binarySearch(nArray, 2002) > -1)) {
            PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTS);
            preparedStatement.setString(1, string2 != null ? string2 : "%");
            preparedStatement.setString(2, string3 != null ? string3 : "%");
            TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
            tbResultSetBase.closeStatementOnClose();
            return tbResultSetBase;
        }
        int n = 7;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TbStatement tbStatement = new TbStatement(this.conn);
        TbResultSet tbResultSet = TbResultSetFactory.buildEmptyResultSet(tbStatement, -2, n, 0);
        DataTypeConverter dataTypeConverter = this.conn.getTypeConverter();
        TbColumnDesc[] tbColumnDescArray = new TbColumnDesc[n];
        for (int i = 0; i < n; ++i) {
            tbColumnDescArray[i] = new TbColumnDesc();
        }
        tbColumnDescArray[0].set("TYPE_CAT", 3, n2, n3, n4, n5);
        tbColumnDescArray[1].set("TYPE_SCHEM", 3, n2, n3, n4, n5);
        tbColumnDescArray[2].set("TYPE_NAME", 3, n2, n3, n4, n5);
        tbColumnDescArray[3].set("CLASS_NAME", 3, n2, n3, n4, n5);
        tbColumnDescArray[4].set("DATA_TYPE", 1, n2, n3, n4, n5);
        tbColumnDescArray[5].set("REMARKS", 3, n2, n3, n4, n5);
        tbColumnDescArray[6].set("BASE_TYPE", 1, n2, n3, n4, n5);
        dataTypeConverter.buildColumnMetadata(tbColumnDescArray, tbResultSet, tbColumnDescArray.length);
        ((TbResultSetBase)tbResultSet).closeStatementOnClose();
        return tbResultSet;
    }

    public String getURL() throws SQLException {
        return this.conn.info.getURL();
    }

    public String getUserName() throws SQLException {
        return this.conn.info.getUser();
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.getVersionColumnsQuery(this.conn.getMapDateToTimestamp(), this.conn.getExtFeatureInfo().supports(2)));
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2 != null ? string2 : "%");
        TbResultSetBase tbResultSetBase = (TbResultSetBase)preparedStatement.executeQuery();
        tbResultSetBase.closeStatementOnClose();
        return tbResultSetBase;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return n != 1007;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return n != 1007;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        switch (n) {
            case 1: 
            case 12: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 12: {
                        return true;
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                switch (n2) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        switch (n2) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: {
                return true;
            }
            case 1005: {
                return false;
            }
        }
        return false;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        switch (n) {
            case 2: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }
}

