/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class TbRSFwOnly
extends TbResultSetBase {
    private Row row;
    private int chunkOffset;
    protected int lastFetchedCnt;

    protected TbRSFwOnly(TbStatement tbStatement, int n, int n2, int n3) throws SQLException {
        super(tbStatement, n, n2, n3);
        this.currentRowIndex = -1;
    }

    public void buildRowTable(int n, byte[] byArray) throws SQLException {
        this.chunkOffset = 1;
        if (this.rowsFetchedCnt + n < 0) {
            throw TbError.newSQLException(-90613);
        }
        this.lastFetchedCnt = this.rowsFetchedCnt;
        this.rowsFetchedCnt += n;
        this.currentFetchCount = n;
        if (this.row == null) {
            this.row = new Row(this.columnCount);
        }
        this.rowChunk = byArray;
    }

    private void checkRowIndex(int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-90635);
        }
        if (this.stmt.getMaxRows() != 0 && n >= this.stmt.getMaxRows() || n >= this.rowsFetchedCnt && this.fetchComplete) {
            throw TbError.newSQLException(-90647);
        }
        if (n < this.lastFetchedCnt || this.stmt.getMaxRows() != 0 && n >= this.stmt.getMaxRows() || n >= this.rowsFetchedCnt) {
            throw TbError.newSQLException(-90624);
        }
    }

    protected Row getCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        return this.row;
    }

    public synchronized boolean next() throws SQLException {
        if (!super.next()) {
            this.closeCursor();
            return false;
        }
        this.chunkOffset += this.row.buildRowData(this.rowChunk, this.chunkOffset, this.cols);
        return true;
    }

    protected void removeCurrentRow() throws SQLException {
    }

    protected void reset() {
        super.reset();
        if (this.row != null) {
            this.row.close();
            this.row = null;
        }
    }

    public boolean absolute(int n) throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public void afterLast() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public void beforeFirst() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean first() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean isLast() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean last() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean previous() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean relative(int n) throws SQLException {
        throw TbError.newSQLException(-90620);
    }
}

