/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbRSFwOnly;
import com.tmax.tibero.jdbc.driver.TbRSScrollable;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TbRSSensitive
extends TbRSScrollable {
    protected TbPreparedStatement refetchStmt = null;
    private int[] rowIndices = null;
    private List refetchRowids = null;
    private int lastRowIdParamCnt = 0;
    private int startRowIndex = -1;
    private int stopRowIndex = -1;
    private static final int REFRESH_FETCH_SIZE = 1;

    protected TbRSSensitive(TbStatement tbStatement, int n, int n2, int n3) throws SQLException {
        super(tbStatement, n, n2, n3);
        this.rowIndices = new int[tbStatement.getFetchSize()];
        this.refetchRowids = new ArrayList(tbStatement.getFetchSize());
    }

    public synchronized boolean absolute(int n) throws SQLException {
        if (super.absolute(n)) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRefetchStatement(int n) throws SQLException {
        if (this.lastRowIdParamCnt != n) {
            if (this.refetchStmt != null) {
                try {
                    this.refetchStmt.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    this.refetchStmt = null;
                }
            }
            String string = TbSQLParser.getRowIdAddedRefetchSql(this.stmt.getSqlWithRowId(), n);
            this.refetchStmt = new TbPreparedStatement(this.stmt.conn, string);
            this.lastRowIdParamCnt = n;
            if (this.stmt instanceof ParamContainer) {
                this.refetchStmt.impl().copyBindParamInfo((ParamContainer)((Object)this.stmt));
            }
        }
        int n2 = this.refetchStmt.getParamContainer().getParameterCnt();
        int n3 = n2 - this.lastRowIdParamCnt;
        for (int i = 0; i < this.lastRowIdParamCnt; ++i) {
            this.refetchStmt.setBytes(n3 + i + 1, 3, (byte[])this.refetchRowids.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            if (this.refetchStmt != null) {
                try {
                    this.refetchStmt.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.refetchStmt = null;
                }
            }
        }
    }

    protected void fetchRowsChunk() throws SQLException {
        super.fetchRowsChunk();
        if (this.currentFetchCount > 0) {
            this.stopRowIndex = this.rowsFetchedCnt - 1;
            this.startRowIndex = this.rowsFetchedCnt - this.currentFetchCount;
        }
    }

    private int fillRowIndexForRefetch(int n) throws SQLException {
        int n2 = 0;
        if (this.fetchDirection == 1001) {
            int n3 = Math.max(this.currentRowIndex - n, 0);
            int n4 = this.currentRowIndex;
            while (n4 > n3) {
                this.rowIndices[n2] = n4;
                this.refetchRowids.add(n2, this.getRowAt(n4).getRawBytes(1));
                --n4;
                ++n2;
            }
        } else {
            int n5 = Math.min(this.currentRowIndex + n, this.rowsFetchedCnt);
            int n6 = this.currentRowIndex;
            while (n6 < n5) {
                this.rowIndices[n2] = n6;
                this.refetchRowids.add(n2, this.getRowAt(n6).getRawBytes(1));
                ++n6;
                ++n2;
            }
        }
        return n2;
    }

    public synchronized boolean first() throws SQLException {
        if (super.first()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    private boolean isByteArrayEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean last() throws SQLException {
        if (super.last()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    public synchronized boolean next() throws SQLException {
        if (super.next()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (super.previous()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    private void refreshCachedRows(int n) throws SQLException {
        this.refetchStmt.setFetchSize(n);
        TbRSFwOnly tbRSFwOnly = (TbRSFwOnly)this.refetchStmt.executeQuery();
        block2: while (tbRSFwOnly.next()) {
            byte[] byArray = tbRSFwOnly.getBytes(1);
            for (int i = 0; i < n; ++i) {
                if (!this.isByteArrayEqual(byArray, (byte[])this.refetchRowids.get(i))) continue;
                Row row = tbRSFwOnly.getCurrentRow();
                Row row2 = new Row();
                row2.duplicate(row);
                this.setRowAt(this.rowIndices[i], row2);
                continue block2;
            }
        }
        try {
            tbRSFwOnly.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isCurrentWindow(int n) {
        return n >= this.startRowIndex && n <= this.stopRowIndex;
    }

    public synchronized void refreshRow() throws SQLException {
        int n = this.refreshRowForced(1);
        if (this.fetchDirection == 1000) {
            this.startRowIndex = this.currentRowIndex;
            this.stopRowIndex = this.currentRowIndex + n - 1;
        } else {
            this.startRowIndex = this.currentRowIndex - n + 1;
            this.stopRowIndex = this.currentRowIndex;
        }
    }

    protected int refreshRowForced(int n) throws SQLException {
        if (!this.rsetType.useRowId()) {
            throw TbError.newSQLException(-590724);
        }
        try {
            int n2 = this.fillRowIndexForRefetch(n);
            this.buildRefetchStatement(n2);
            this.refreshCachedRows(n2);
            return n2;
        }
        catch (SQLException sQLException) {
            throw TbError.newSQLException(-90626, sQLException);
        }
    }

    public synchronized boolean relative(int n) throws SQLException {
        if (super.relative(n)) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    protected void removeCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        this.rows.remove(this.currentRowIndex);
        if (this.currentRowIndex < this.startRowIndex) {
            --this.startRowIndex;
        }
        if (this.currentRowIndex < this.stopRowIndex) {
            --this.stopRowIndex;
        }
        --this.currentRowIndex;
        --this.rowsFetchedCnt;
    }

    public void reset() {
        super.reset();
        this.refetchStmt = null;
    }
}

