/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

public class TbSQLTypeScanner {
    private static final char NULL = '\u0000';
    private static final int STATE_START = 0;
    private static final int STATE_1 = 1;
    private static final int STATE_2 = 2;
    private static final int STATE_3 = 3;
    private static final int STATE_4 = 4;
    private static final int STATE_5 = 5;
    private static final int STATE_6 = 6;
    private static final int STATE_DONE = 10;
    public static final int STMT_UNKNOWN = 0;
    public static final int STMT_QUERY = 16;
    public static final int STMT_DML = 32;
    public static final int STMT_DML_DELETE = 33;
    public static final int STMT_DML_UPDATE = 34;
    public static final int STMT_DML_INSERT = 36;
    public static final int STMT_DML_MERGE = 40;
    public static final int STMT_PSM = 64;
    public static final int STMT_PSM_BEGIN = 65;
    public static final int STMT_PSM_CALL = 66;
    public static final int STMT_PSM_DECLARE = 68;
    public static final int STMT_DDL = 128;
    public static final int STMT_DDL_JAVA_SRC = 136;
    private int state;
    private int index;
    private int textLen;
    private String text;

    public int getCurrentIndex() {
        return this.index;
    }

    private char getNextChar() {
        if (this.index < this.textLen) {
            return this.text.charAt(this.index++);
        }
        return '\u0000';
    }

    public synchronized int getSQLType(String string) {
        this.index = 0;
        this.textLen = string.length();
        this.text = string;
        String string2 = this.getToken();
        if (string2.equals("(")) {
            string2 = this.getToken();
        }
        if (string2.equals("SELECT") || string2.equals("WITH")) {
            return 16;
        }
        if (string2.equals("DELETE")) {
            return 33;
        }
        if (string2.equals("INSERT")) {
            return 36;
        }
        if (string2.equals("UPDATE")) {
            return 34;
        }
        if (string2.equals("MERGE")) {
            return 40;
        }
        if (string2.equals("BEGIN")) {
            return 65;
        }
        if (string2.equals("DECLARE")) {
            return 68;
        }
        if (string2.equals("CALL")) {
            return 66;
        }
        String[] stringArray = new String[]{"CREATE", "OR", "REPLACE", "AND", "RESOLVE", "JAVA", "SOURCE"};
        if (string2.equals(stringArray[0])) {
            int n = 1;
            int n2 = 1;
            while (n2 > 0) {
                int n3;
                String string3 = this.getToken();
                for (n3 = n; n3 < stringArray.length; ++n3) {
                    if (!stringArray[n3].equals(string3)) continue;
                    n = n3 + 1;
                    n2 |= 1 << n3;
                    break;
                }
                if ((n2 & 1) > 0 && (n2 & 0x20) > 0 && (n2 & 0x40) > 0) {
                    return 136;
                }
                if (n3 != stringArray.length) continue;
                n2 = 0;
            }
            return 128;
        }
        String[] stringArray2 = new String[]{"{", "?", "=", "CALL"};
        if (string2.startsWith(stringArray2[0])) {
            int n = 1;
            int n4 = 1;
            String string4 = string2;
            int n5 = stringArray2[0].length();
            while (n4 > 0) {
                int n6;
                string4 = string4.length() == n5 ? this.getToken() : string4.substring(n5);
                for (n6 = n; n6 < stringArray2.length; ++n6) {
                    if (string4.startsWith(stringArray2[n6])) {
                        n = n6 + 1;
                        n5 = stringArray2[n6].length();
                        n4 |= 1 << n6;
                        break;
                    }
                    if (n6 != 1 || string4.length() <= 1 || string4.charAt(0) != ':') continue;
                    n = n6 + 1;
                    int n7 = string4.indexOf(61);
                    n5 = n7 > 0 ? n7 : string4.length();
                    n4 |= 1 << n6;
                    break;
                }
                if ((n4 & 1) > 0 && (n4 & 8) > 0) {
                    return 66;
                }
                if (n6 != stringArray2.length) continue;
                n4 = 0;
            }
        }
        return 0;
    }

    private String getToken() {
        this.state = 0;
        StringBuffer stringBuffer = new StringBuffer(32);
        while (this.state != 10) {
            char c = this.getNextChar();
            boolean bl = true;
            block0 : switch (this.state) {
                case 0: {
                    switch (c) {
                        case '/': {
                            this.state = 1;
                            break block0;
                        }
                        case '-': {
                            this.state = 4;
                            break block0;
                        }
                        case '\'': {
                            this.state = 6;
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            if (stringBuffer.length() > 0) {
                                this.state = 10;
                                bl = false;
                                this.ungetNextChar();
                                break block0;
                            }
                            this.state = 10;
                            bl = true;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (stringBuffer.length() > 0) {
                                this.state = 10;
                            }
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '*': {
                            this.state = 2;
                            bl = false;
                            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            bl = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '*': {
                            this.state = 3;
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    switch (c) {
                        case '*': {
                            bl = false;
                            break block0;
                        }
                        case '/': {
                            this.state = 0;
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 2;
                    bl = false;
                    break;
                }
                case 4: {
                    switch (c) {
                        case '-': {
                            this.state = 5;
                            bl = false;
                            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            bl = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            this.state = 0;
                            this.ungetNextChar();
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    bl = false;
                    break;
                }
                case 6: {
                    switch (c) {
                        case '\'': {
                            this.state = 0;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                }
            }
            if (!bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.substring(0, stringBuffer.length()).toUpperCase();
    }

    private void ungetNextChar() {
        --this.index;
    }

    public static boolean isDMLStmt(int n) {
        return (n & 0x20) > 0;
    }

    public static boolean isPSMStmt(int n) {
        return (n & 0x40) > 0;
    }

    public static boolean isQueryStmt(int n) {
        return (n & 0x10) > 0;
    }

    public static boolean isDDLStmt(int n) {
        return (n & 0x80) > 0;
    }
}

