/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ReaderInputStream
extends InputStream {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private Reader reader_;
    private ConvTable table_;
    private int ccsid_ = -1;
    private String encoding_ = null;
    private BidiConversionProperties properties_ = new BidiConversionProperties();
    private char[] cache_ = new char[1024];
    private byte[] b_cache_ = new byte[2562];
    private int nextRead_ = 0;
    private int nextWrite_ = 0;
    private int mode_ = 2;

    public ReaderInputStream(Reader reader, String string) throws UnsupportedEncodingException {
        if (reader == null) {
            Trace.log(2, "Parameter 'reader' is null.");
            throw new NullPointerException("reader");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'reader' is null.");
            throw new NullPointerException("encoding");
        }
        this.reader_ = reader;
        this.encoding_ = string;
        this.initializeTable();
    }

    public ReaderInputStream(Reader reader, int n) throws UnsupportedEncodingException {
        if (reader == null) {
            Trace.log(2, "Parameter 'reader' is null.");
            throw new NullPointerException("reader");
        }
        if (n < 0 || n > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.reader_ = reader;
        this.ccsid_ = n;
        this.initializeTable();
    }

    public ReaderInputStream(Reader reader, int n, int n2) throws UnsupportedEncodingException {
        this(reader, n, new BidiConversionProperties(n2));
    }

    public ReaderInputStream(Reader reader, int n, BidiConversionProperties bidiConversionProperties) throws UnsupportedEncodingException {
        if (reader == null) {
            Trace.log(2, "Parameter 'reader' is null.");
            throw new NullPointerException("reader");
        }
        if (n < 0 || n > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.reader_ = reader;
        this.ccsid_ = n;
        this.properties_ = bidiConversionProperties;
        this.initializeTable();
    }

    public ReaderInputStream(Reader reader, int n, int n2, int n3) throws UnsupportedEncodingException {
        this(reader, n, new BidiConversionProperties(n2), n3);
    }

    public ReaderInputStream(Reader reader, int n, BidiConversionProperties bidiConversionProperties, int n2) throws UnsupportedEncodingException {
        this(reader, n, bidiConversionProperties);
        if (n2 < 1) {
            Trace.log(2, "Value of parameter 'cacheSize' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("cacheSize", 4);
        }
        this.cache_ = new char[n2];
        this.b_cache_ = new byte[(n2 * 5 + 3) / 2];
    }

    public synchronized int available() throws IOException {
        return this.nextWrite_ - this.nextRead_;
    }

    public synchronized void close() throws IOException {
        if (this.table_ == null) {
            return;
        }
        this.reader_.close();
        this.table_ = null;
    }

    private synchronized boolean fillCache() throws IOException {
        if (this.nextRead_ >= this.nextWrite_) {
            int n = this.reader_.read(this.cache_, 0, this.cache_.length);
            if (n == -1) {
                return false;
            }
            String string = new String(this.cache_, 0, n);
            byte[] byArray = this.table_.stringToByteArray(string, this.properties_);
            int n2 = byArray[0] & 0xFF;
            int n3 = byArray[byArray.length - 1] & 0xFF;
            if (this.mode_ == 2) {
                if (n2 == 14) {
                    if (n3 == 15) {
                        this.mode_ = 1;
                        System.arraycopy(byArray, 0, this.b_cache_, 0, byArray.length - 1);
                        this.nextRead_ = 0;
                        this.nextWrite_ = byArray.length - 1;
                    } else {
                        System.arraycopy(byArray, 0, this.b_cache_, 0, byArray.length);
                        this.nextRead_ = 0;
                        this.nextWrite_ = byArray.length;
                    }
                } else if (n3 == 15) {
                    this.mode_ = 1;
                    System.arraycopy(byArray, 0, this.b_cache_, 0, byArray.length - 1);
                    this.nextRead_ = 0;
                    this.nextWrite_ = byArray.length - 1;
                } else {
                    System.arraycopy(byArray, 0, this.b_cache_, 0, byArray.length);
                    this.nextRead_ = 0;
                    this.nextWrite_ = byArray.length;
                }
            } else if (n2 == 14) {
                if (n3 == 15) {
                    System.arraycopy(byArray, 1, this.b_cache_, 0, byArray.length - 2);
                    this.nextRead_ = 0;
                    this.nextWrite_ = byArray.length - 2;
                } else {
                    this.mode_ = 2;
                    System.arraycopy(byArray, 1, this.b_cache_, 0, byArray.length - 1);
                    this.nextRead_ = 0;
                    this.nextWrite_ = byArray.length - 1;
                }
            } else if (n3 == 15) {
                this.b_cache_[0] = 15;
                System.arraycopy(byArray, 0, this.b_cache_, 1, byArray.length - 1);
                this.nextRead_ = 0;
                this.nextWrite_ = byArray.length;
            } else {
                this.mode_ = 2;
                this.b_cache_[0] = 15;
                System.arraycopy(byArray, 0, this.b_cache_, 1, byArray.length);
                this.nextRead_ = 0;
                this.nextWrite_ = byArray.length + 1;
            }
        }
        if (this.nextRead_ >= this.nextWrite_) {
            return this.fillCache();
        }
        return true;
    }

    public int getBidiStringType() {
        return this.properties_.getBidiStringType();
    }

    public int getCacheSize() {
        return this.cache_.length;
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    public String getEncoding() {
        if (this.ccsid_ == -1 || this.encoding_ != null) {
            return this.encoding_;
        }
        return ConversionMaps.ccsidToEncoding(this.ccsid_);
    }

    private void initializeTable() throws UnsupportedEncodingException {
        String string;
        if (this.encoding_ != null && (string = ConversionMaps.encodingToCcsidString(this.encoding_)) != null) {
            this.ccsid_ = Integer.parseInt(string);
        }
        this.table_ = this.ccsid_ == -1 ? ConvTable.getTable(this.encoding_) : ConvTable.getTable(this.ccsid_, null);
    }

    public synchronized int read() throws IOException {
        if (this.fillCache()) {
            return this.b_cache_[this.nextRead_++];
        }
        return -1;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (byArray.length == 0) {
            return 0;
        }
        if (this.fillCache()) {
            int n = byArray.length > this.nextWrite_ - this.nextRead_ ? this.nextWrite_ - this.nextRead_ : byArray.length;
            System.arraycopy(this.b_cache_, this.nextRead_, byArray, 0, n);
            this.nextRead_ += n;
            return n;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (n < 0 || n > byArray.length) {
            Trace.log(2, "Value of parameter 'offset' is not valid:", n);
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (n2 < 0 || n2 > byArray.length - n) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.fillCache()) {
            int n3 = n2 > this.nextWrite_ - this.nextRead_ ? this.nextWrite_ - this.nextRead_ : n2;
            System.arraycopy(this.b_cache_, this.nextRead_, byArray, n, n3);
            this.nextRead_ += n3;
            return n3;
        }
        return -1;
    }

    public synchronized long skip(long l) throws IOException {
        if (l < 0L) {
            Trace.log(2, "Value of parameter 'length' is not valid: " + l);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = 0L;
        byte[] byArray = new byte[l < (long)this.b_cache_.length ? (int)l : this.b_cache_.length];
        int n = this.read(byArray);
        if (n < 0) {
            return 0L;
        }
        l2 += (long)n;
        while (n > 0 && l2 < l) {
            n = this.read(byArray);
            if (n <= 0) continue;
            l2 += (long)n;
        }
        return l2;
    }
}

