/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLVarcharForBitData
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final byte[] default_ = new byte[0];
    private SQLConversionSettings settings_;
    private int length_;
    private int maxLength_;
    private int truncated_;
    private byte[] value_;

    SQLVarcharForBitData(int n, SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
        this.length_ = 0;
        this.maxLength_ = n;
        this.truncated_ = 0;
        this.value_ = default_;
    }

    public Object clone() {
        return new SQLVarcharForBitData(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
        AS400ByteArray aS400ByteArray = new AS400ByteArray(this.length_);
        this.value_ = (byte[])aS400ByteArray.toObject(byArray, n + 2);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        AS400ByteArray aS400ByteArray = new AS400ByteArray(this.length_);
        BinaryConverter.unsignedShortToByteArray(this.length_, byArray, n);
        aS400ByteArray.toBytes(this.value_, byArray, n + 2);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            try {
                this.value_ = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else if (object instanceof byte[]) {
            this.value_ = (byte[])object;
        } else if (object instanceof InputStream) {
            int n2 = n;
            if (n2 >= 0) {
                InputStream inputStream = (InputStream)object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n3 = n2 < 262144 ? n2 : 262144;
                byte[] byArray = new byte[n3];
                try {
                    int n4 = 0;
                    int n5 = inputStream.read(byArray, 0, n3);
                    while (n5 > -1 && n4 < n2) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                        int n6 = n2 - (n4 += n5);
                        if (n6 < n3) {
                            n3 = n6;
                        }
                        n5 = inputStream.read(byArray, 0, n3);
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
                this.value_ = byteArrayOutputStream.toByteArray();
                if (this.value_.length < n2) {
                    JDError.throwSQLException(this, "07006");
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (object instanceof Reader) {
            int n7 = n;
            if (n7 >= 0) {
                try {
                    int n8 = n7 < 262144 ? n7 : 262144;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    HexReaderInputStream hexReaderInputStream = new HexReaderInputStream((Reader)object);
                    byte[] byArray = new byte[n8];
                    int n9 = 0;
                    int n10 = hexReaderInputStream.read(byArray, 0, n8);
                    while (n10 > -1 && n9 < n7) {
                        byteArrayOutputStream.write(byArray, 0, n10);
                        int n11 = n7 - (n9 += n10);
                        if (n11 < n8) {
                            n8 = n11;
                        }
                        n10 = hexReaderInputStream.read(byArray, 0, n8);
                    }
                    this.value_ = byteArrayOutputStream.toByteArray();
                    if (this.value_.length < n7) {
                        JDError.throwSQLException(this, "07006");
                    }
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Blob) {
            this.value_ = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Clob) {
            try {
                this.value_ = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else {
            JDError.throwSQLException(this, "07006");
        }
        int n12 = this.value_.length;
        if (n12 > this.maxLength_) {
            byte[] byArray = new byte[this.maxLength_];
            System.arraycopy(this.value_, 0, byArray, 0, this.maxLength_);
            this.value_ = byArray;
            this.truncated_ = n12 - this.maxLength_;
        } else {
            this.truncated_ = 0;
        }
        this.length_ = this.value_.length;
    }

    public int getSQLType() {
        return 31;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "[B";
    }

    public String getLiteralPrefix() {
        return "X'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "VARCHAR() FOR BIT DATA";
    }

    public int getMaximumPrecision() {
        return 32739;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 448;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -3;
    }

    public String getTypeName() {
        return "VARCHAR() FOR BIT DATA";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        return new ByteArrayInputStream(this.getBytes());
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        byte[] byArray = this.getBytes();
        return new AS400JDBCBlob(byArray, byArray.length);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public byte[] getBytes() {
        this.truncated_ = 0;
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length > n && n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value_, 0, byArray, 0, n);
            return byArray;
        }
        return this.value_;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        return new StringReader(BinaryConverter.bytesToString(this.getBytes()));
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        String string = BinaryConverter.bytesToString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return this.getBytes();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        return BinaryConverter.bytesToString(this.getBytes());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }
}

