/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.security.Principal;
import java.util.Arrays;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.Debug;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;

public abstract class ClientSecurity
implements ClientSecurityContext {
    private final String mechanism;
    protected CIMNameSpace nameSpace;
    protected Principal principal;
    protected String userName;
    protected byte[] userPswd;
    protected String nsHost;
    protected String nsPath;
    protected boolean bEstablished;
    private byte[] encryptKey = null;
    private static final int MAX_DATA_SIZE = 15;

    public ClientSecurity(String mechanism) {
        this.mechanism = mechanism;
        this.userPswd = new byte[0];
        this.nsPath = "";
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public String getServerName() {
        return this.nsHost;
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public String getUserName() {
        return this.userName;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isEstablished() {
        return this.bEstablished;
    }

    public void setNameSpace(CIMNameSpace namespace) throws CIMException {
        if (namespace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.nameSpace = namespace;
        this.nsHost = namespace.getHost();
        this.nsPath = namespace.getNameSpace();
    }

    public void setPrincipal(Principal prin) throws CIMException {
        if (prin == null || !(prin instanceof UserPrincipal)) {
            Debug.trace1("Invalid client user principal");
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.principal = prin;
        this.userName = prin.getName();
        if (this.userName == null || this.userName.trim().length() == 0) {
            Debug.trace1("Invalid client user principal");
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
    }

    public void setCredential(Object cred) throws CIMException {
        String tPswd = null;
        if (cred != null) {
            if (cred instanceof PasswordCredential) {
                tPswd = ((PasswordCredential)cred).getUserPassword();
            } else if (cred instanceof String) {
                tPswd = (String)cred;
            }
        }
        if (tPswd == null) {
            Debug.trace1("Invalid credential for user " + this.userName);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        int len = tPswd.length();
        this.userPswd = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = tPswd.charAt(i);
            this.userPswd[i] = (byte)c;
        }
    }

    public void dispose() {
        this.bEstablished = false;
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        Arrays.fill(this.userPswd, (byte)0);
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
    }

    public String getUserPassword() {
        String tPswd = null;
        if (this.userPswd.length > 0) {
            char[] ca = new char[this.userPswd.length];
            for (int i = 0; i < this.userPswd.length; ++i) {
                ca[i] = (char)(0 | this.userPswd[i] & 0xFF);
            }
            tPswd = new String(ca);
        }
        return tPswd;
    }

    public SecurityToken getSecurityToken(String[] sarray) throws CIMException {
        return null;
    }

    public String trans51Format(String inData) throws CIMException {
        int i;
        if (inData.length() > 15 || this.encryptKey == null) {
            Debug.trace1("Cannot encrypt data; invalid data or session key");
            throw new CIMException("CIM_ERR_FAILED", "Bad data length or null encrypt key");
        }
        byte[] pwb = inData.getBytes();
        int len = this.encryptKey.length;
        byte[] rb = new byte[len];
        System.arraycopy(this.encryptKey, 0, rb, 0, len);
        byte[] pad = new byte[len];
        SecurityUtil.secrand.nextBytes(pad);
        for (i = 0; i < pwb.length; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ pwb[i]);
        }
        int n = i++;
        rb[n] = (byte)(rb[n] ^ 0);
        while (i < rb.length) {
            int n2 = i;
            rb[n2] = (byte)(rb[n2] ^ pad[i]);
            ++i;
        }
        String val = SecurityUtil.toHex(rb);
        return val;
    }
}

