/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMObject;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CloneUtil;
import javax.wbem.cim.MOFFormatter;

public class CIMInstance
extends CIMObject
implements Serializable {
    static final long serialVersionUID = 200L;
    private String className = "";
    private String alias = "";

    public CIMInstance() {
        super("");
    }

    public CIMObjectPath getObjectPath() {
        CIMObjectPath cop = super.getObjectPath();
        Vector keys = this.getKeys();
        if (keys != null && keys.size() > 0) {
            cop.setKeys(keys);
        }
        return cop;
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = new String(className);
    }

    public CIMProperty getProperty(String propertyName) {
        if (this.allproperties == null || propertyName == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(propertyName, ".");
        String property = st.nextToken();
        try {
            String subProperty = st.nextToken();
            CIMProperty cp = super.getProperty(property);
            if (cp != null) {
                while (true) {
                    try {
                        CIMInstance ci = (CIMInstance)cp.getValue().getValue();
                        cp = ci.getProperty(subProperty);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                    if (!st.hasMoreTokens()) break;
                    subProperty = st.nextToken();
                }
                return cp;
            }
            return this.getProperty(subProperty, property);
        }
        catch (Exception e) {
            return super.getProperty(property);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getName() {
        return this.className;
    }

    public Vector getKeyValuePairs() {
        return this.getKeys();
    }

    public CIMInstance localElements() {
        CIMInstance ci = new CIMInstance();
        ci.className = this.className;
        ci.setObjectPath(this.getObjectPath());
        if (this.allproperties != null) {
            Vector<CIMProperty> ov = new Vector<CIMProperty>();
            Enumeration props = this.allproperties.elements();
            while (props.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)props.nextElement();
                if (pe.isPropagated()) continue;
                ov.add(pe);
            }
            ci.setProperties(ov);
        }
        return ci;
    }

    public CIMInstance localElements(List classNames) {
        if (classNames == null) {
            return this;
        }
        HashSet<String> classSet = new HashSet<String>();
        Iterator iter = classNames.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            classSet.add(s.toLowerCase());
        }
        CIMInstance ci = new CIMInstance();
        ci.className = this.className;
        ci.setObjectPath(this.getObjectPath());
        if (this.allproperties != null) {
            Vector<CIMProperty> ov = new Vector<CIMProperty>();
            Enumeration eProps = this.allproperties.elements();
            while (eProps.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)eProps.nextElement();
                if (!classSet.contains(pe.getOriginClass().toLowerCase())) continue;
                ov.add(pe);
            }
            ci.setProperties(ov);
        }
        return ci;
    }

    public CIMInstance filterProperties(String[] propertyList, boolean includeQualifier, boolean includeClassOrigin) {
        CIMInstance ci = new CIMInstance();
        ci.className = this.className;
        ci.alias = this.alias;
        ci.setObjectPath(this.getObjectPath());
        Vector propList = this.getFilteredProperties(propertyList, includeQualifier, includeClassOrigin);
        ci.setProperties(propList);
        return ci;
    }

    public Object clone() {
        CIMInstance ci = new CIMInstance();
        ci.className = this.className;
        ci.alias = this.alias;
        ci.setObjectPath(this.getObjectPath());
        if (this.allproperties != null) {
            ci.setProperties(CloneUtil.cloneProperties(this.allproperties));
        }
        return ci;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMInstance)) {
            return false;
        }
        return this.getObjectPath().equals(((CIMInstance)o).getObjectPath());
    }

    public int hashCode() {
        return this.getObjectPath().hashCode();
    }
}

