/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cimxml;

import org.w3c.dom.Node;

public class NodeTreeWalker {
    Node curNode = null;
    Node topNode = null;

    public NodeTreeWalker(Node initialNode) {
        this.topNode = this.curNode = initialNode;
    }

    public Node getCurrentNode() {
        return this.curNode;
    }

    public Node nextNode() {
        Node theNode = this.curNode;
        if (theNode != null) {
            this.curNode = theNode.getFirstChild();
            while (this.curNode == null && theNode != null && this.topNode != theNode) {
                this.curNode = theNode.getNextSibling();
                if (this.curNode != null) continue;
                theNode = theNode.getParentNode();
            }
        }
        return this.curNode;
    }

    public Node nextSibling() {
        this.curNode = this.curNode != this.topNode && this.curNode != null ? this.curNode.getNextSibling() : null;
        return this.curNode;
    }

    public Node getNextElement(String name) {
        Node nextNode = this.nextNode();
        if (name == null) {
            return nextNode;
        }
        while (this.curNode != null && !nextNode.getNodeName().equals(name)) {
            nextNode = this.nextNode();
        }
        return this.curNode;
    }

    public Node removeCurrent() {
        if (this.curNode != null) {
            Node parent = this.curNode.getParentNode();
            Node nextNode = this.curNode.getNextSibling();
            parent.removeChild(this.curNode);
            this.curNode = nextNode;
        }
        return this.curNode;
    }
}

