/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.ClientProperties;
import javax.wbem.client.Debug;
import javax.wbem.security.ClientSecurityContext;

public class ClientSecurityFactory {
    private static final String PROP_SECURITY = "security";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_MECHANISM = "mechanism";
    private static final String PROP_NAME = "name";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_CLASS = "client.class";
    private static final String DFLT_XML_SECURITY = "basic";
    private static final String DFLT_BASIC_CLASS = "javax.wbem.security.BasicClientSecurity";
    static /* synthetic */ Class class$javax$wbem$cim$CIMNameSpace;
    static /* synthetic */ Class class$java$security$Principal;
    static /* synthetic */ Class class$java$lang$Object;

    public static ClientSecurityContext createClientSecurity(CIMNameSpace ns, Principal principal, Object credential, String mechanism, String protocol) throws CIMException {
        String name = null;
        String mech = null;
        String proto = protocol;
        if ((protocol == null || protocol.trim().length() == 0) && (proto = ClientProperties.getProperty(name = "transport.protocol.default")) == null) {
            proto = "cim-xml";
        }
        proto = proto.toLowerCase();
        if ((mech == null || mech.trim().length() == 0) && (mech = ClientProperties.getProperty(name = "transport." + proto + "." + PROP_SECURITY + "." + PROP_DEFAULT)) == null) {
            if (proto.equals("cim-xml")) {
                mech = DFLT_XML_SECURITY;
            } else {
                Debug.trace1("Security mechanism not valid");
                throw new CIMSecurityException("CIM_ERR_NOT_FOUND", (Object)PROP_DEFAULT);
            }
        }
        mech = mech.toLowerCase();
        name = "security.mechanism.name." + mech;
        String temp = ClientProperties.getProperty(name);
        if (temp == null || !mech.equalsIgnoreCase(temp)) {
            Debug.trace1("Security mechanism not in configuration properties");
            throw new CIMException("CIM_ERR_NOT_FOUND", "mechanism-0");
        }
        Debug.trace1("Security mechanism name is " + mech);
        name = "security." + mech + "." + PROP_TRANSPORT;
        String list = ClientProperties.getProperty(name);
        if (list == null && mech.equals(DFLT_XML_SECURITY)) {
            list = "cim-xml";
        }
        if (list == null) {
            Debug.trace1("Security mechanism not supported on protocol");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", (Object)"mechanism-1");
        }
        List al = ClientSecurityFactory.parseList(list);
        if (!al.contains(proto)) {
            Debug.trace1("Security mechanism not supported on protocol");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", (Object)"mechanism-2");
        }
        name = "security." + mech + "." + PROP_CLASS;
        String classname = ClientProperties.getProperty(name);
        if (classname == null && mech.equals(DFLT_XML_SECURITY)) {
            classname = DFLT_BASIC_CLASS;
        }
        if (classname == null) {
            Debug.trace1("No security module class for mechanism");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", (Object)"mechanism-3");
        }
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            Debug.trace1("Mechanism " + mech + ": class not found: " + classname, ex);
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", (Object)"mechanism-5");
        }
        ClientSecurityContext cs = null;
        try {
            Class[] paramTypes = new Class[]{class$javax$wbem$cim$CIMNameSpace == null ? (class$javax$wbem$cim$CIMNameSpace = ClientSecurityFactory.class$("javax.wbem.cim.CIMNameSpace")) : class$javax$wbem$cim$CIMNameSpace, class$java$security$Principal == null ? (class$java$security$Principal = ClientSecurityFactory.class$("java.security.Principal")) : class$java$security$Principal, class$java$lang$Object == null ? (class$java$lang$Object = ClientSecurityFactory.class$("java.lang.Object")) : class$java$lang$Object};
            Object[] paramList = new Object[]{ns, principal, credential};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            cs = (ClientSecurityContext)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            Throwable ax = ex.getTargetException();
            Debug.trace1("Error in security module class constructor", ax);
            if (ax instanceof CIMException) {
                CIMException cex = (CIMException)ax;
                throw cex;
            }
            throw new CIMSecurityException("CIM_ERR_FAILED", (Object)ax);
        }
        catch (Exception ex) {
            Debug.trace1("Error creating security module instance", ex);
            throw new CIMSecurityException("CIM_ERR_FAILED", (Object)ex);
        }
        return cs;
    }

    public static String[] getSecurityMechanisms() throws CIMException {
        String[] astr = null;
        String name = "security.mechanism";
        List list = ClientProperties.getPropertyList(name);
        if (list != null && list.size() > 0) {
            astr = new String[list.size()];
            list.toArray(astr);
        }
        return astr;
    }

    private static List parseList(String list) {
        ArrayList<String> al = new ArrayList<String>(10);
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreElements()) {
            String elem = (String)st.nextElement();
            al.add(elem);
        }
        return al;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

