/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.AbstractCacheObject;
import com.intersys.cache.CacheObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheNullValueException;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.SList;
import com.intersys.objects.StatusCode;
import com.intersys.objects.SystemError;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class Dataholder
extends SysListProxy {
    public static final byte ITEM_UNDEF = -1;
    public static final byte ITEM_PLACEHOLDER = 0;
    public static final byte ITEM_ASCII = 1;
    public static final byte ITEM_UNICODE = 2;
    public static final byte ITEM_XUNICODE = 3;
    public static final byte ITEM_POSINT = 4;
    public static final byte ITEM_NEGINT = 5;
    public static final byte ITEM_POSNUM = 6;
    public static final byte ITEM_NEGNUM = 7;
    public static final byte ITEM_DOUBLE = 8;
    protected static boolean debug = false;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int LONG = 4;
    public static final int BYTE = 5;
    public static final int SHORT = 6;
    public static final int FLOAT = 7;
    public static final int DOUBLE = 8;
    public static final int BIG_INTEGER = 15;
    public static final int BIG_DECIMAL = 16;
    public static final int BINARY = 23;
    public static final int STRING = 24;
    public static final int TIME = 32;
    public static final int DATE = 64;
    public static final int TIMESTAMP = 128;
    public static final int STATUS_CODE = 256;
    public static final int SYS_LIST = 384;
    public static final int S_LIST = 385;
    public static final int OREF = 512;
    public static final int REG_OBJECT = 1024;
    public static final int CACHE_OBJECT = 1026;
    public static final int CACHE_ID = 1028;
    public static final int CACHE_OID = 1030;
    public static final int COLLECTION = 2048;
    public static final int WRAPPED_ITEM = 4096;
    private static final int BASE_YEAR = 1840;
    private static final int BASE_MONTH = 12;
    private static final int BASE_DATE = 31;
    private static final BigInteger MAX_LONG;
    private static final BigInteger MIN_LONG;
    private static final long BASE_TIME;
    private static final long MS_IN_A_DAY = 86400000L;
    private static final TimeZone GMT;
    private static final GregorianCalendar BASE_CALENDAR;
    private static SimpleDateFormat m_sdfTimeDefault;
    protected int mType;
    protected Object mValue;

    public Dataholder() {
        this.mType = 0;
        this.mValue = null;
    }

    public static Dataholder create(Object object) throws CacheException {
        if (object == null) {
            return new Dataholder(24, null);
        }
        if (object instanceof Dataholder) {
            return (Dataholder)object;
        }
        if (object instanceof Byte) {
            return new Dataholder(5, object);
        }
        if (object instanceof Short) {
            return new Dataholder(6, object);
        }
        if (object instanceof Integer) {
            return new Dataholder(2, object);
        }
        if (object instanceof Long) {
            return new Dataholder(4, object);
        }
        if (object instanceof Double) {
            return new Dataholder(8, object);
        }
        if (object instanceof Float) {
            return new Dataholder(7, object);
        }
        if (object instanceof BigDecimal) {
            return new Dataholder(16, object);
        }
        if (object instanceof Boolean) {
            return new Dataholder(1, object);
        }
        if (object instanceof String) {
            return new Dataholder(24, object);
        }
        if (object instanceof Date) {
            return new Dataholder(64, object);
        }
        if (object instanceof Time) {
            return new Dataholder(32, object);
        }
        if (object instanceof Timestamp) {
            return new Dataholder(128, object);
        }
        if (object instanceof java.util.Date) {
            object = new Date(((java.util.Date)object).getTime());
            return new Dataholder(64, object);
        }
        if (object instanceof byte[]) {
            return new Dataholder(23, object);
        }
        if (object instanceof StatusCode) {
            return new Dataholder((StatusCode)object);
        }
        if (object instanceof CacheObject) {
            return new Dataholder(1026, object);
        }
        if (object instanceof SList) {
            return new Dataholder(385, object);
        }
        if (object instanceof ObjectHandle) {
            return new Dataholder(1026, ((ObjectHandle)object).getProxy());
        }
        if (object instanceof List) {
            return new Dataholder(2048, object);
        }
        if (object instanceof Map) {
            return new Dataholder(2048, object);
        }
        if (object instanceof Id) {
            return new Dataholder(1028, object);
        }
        if (object instanceof Oid) {
            return new Dataholder(23, ((Oid)object).getData());
        }
        throw new ClassCastException("Can not convert class " + object.getClass().getName() + " to Dataholder");
    }

    public static Dataholder createFilemanDate(Date date) throws CacheException {
        int n = Dataholder.date2fmint(date);
        return new Dataholder(n);
    }

    public static Dataholder createFilemanTimestamp(Timestamp timestamp) throws CacheException {
        double d = Dataholder.timestamp2fmdouble(timestamp);
        return new Dataholder(d);
    }

    public Dataholder(int n, Object object) {
        if (debug) {
            System.out.println("Dataholder constructor obj = " + object);
        }
        this.set(n, object);
    }

    public Dataholder(int n) throws CacheException {
        this(2, n);
    }

    public Dataholder(Integer n) throws CacheException {
        this(2, n);
    }

    public Dataholder(int n, int n2) throws CacheException {
        this(n, new Integer(n2));
        if (debug) {
            System.out.println("Dataholder constructor int = " + n2);
        }
    }

    public Dataholder(long l) throws CacheException {
        this(4, l);
    }

    public Dataholder(Long l) throws CacheException {
        this(4, l);
    }

    public Dataholder(int n, long l) throws CacheException {
        this(n, new Long(l));
        if (debug) {
            System.out.println("Dataholder constructor long = " + l);
        }
    }

    public Dataholder(boolean bl) throws CacheException {
        this(1, bl);
    }

    public Dataholder(Boolean bl) throws CacheException {
        this(1, bl);
    }

    public Dataholder(int n, boolean bl) throws CacheException {
        this(n, new Boolean(bl));
        if (debug) {
            System.out.println("Dataholder constructor boolean = " + bl);
        }
    }

    public Dataholder(byte by) throws CacheException {
        this(5, by);
    }

    public Dataholder(Byte by) throws CacheException {
        this(5, by);
    }

    public Dataholder(int n, byte by) throws CacheException {
        this(n, new Byte(by));
        if (debug) {
            System.out.println("Dataholder constructor byte = " + by);
        }
    }

    public Dataholder(short s) throws CacheException {
        this(6, s);
    }

    public Dataholder(Short s) throws CacheException {
        this(6, s);
    }

    public Dataholder(int n, short s) throws CacheException {
        this(n, new Short(s));
        if (debug) {
            System.out.println("Dataholder constructor short = " + s);
        }
    }

    public Dataholder(float f) throws CacheException {
        this(7, f);
    }

    public Dataholder(Float f) throws CacheException {
        this(7, f);
    }

    public Dataholder(int n, float f) throws CacheException {
        this(n, new Float(f));
        if (debug) {
            System.out.println("Dataholder constructor float = " + f);
        }
    }

    public Dataholder(double d) throws CacheException {
        this(8, d);
    }

    public Dataholder(Double d) throws CacheException {
        this(8, d);
    }

    public Dataholder(int n, double d) throws CacheException {
        this(n, new Double(d));
        if (debug) {
            System.out.println("Dataholder constructor double = " + d);
        }
    }

    public Dataholder(byte[] byArray) throws CacheException {
        this(23, byArray);
    }

    public Dataholder(String string) throws CacheException {
        this(24, string);
    }

    public Dataholder(Date date) throws CacheException {
        this(64, date);
    }

    public Dataholder(Time time) throws CacheException {
        this(32, time);
    }

    public Dataholder(Timestamp timestamp) throws CacheException {
        this(128, timestamp);
    }

    public Dataholder(BigInteger bigInteger) throws CacheException {
        this(15, bigInteger);
    }

    public Dataholder(BigDecimal bigDecimal) throws CacheException {
        this(16, bigDecimal);
    }

    public Dataholder(SList sList) throws CacheException {
        this(385, sList);
    }

    public Dataholder(Oid oid) throws CacheException {
        this(oid.getData());
    }

    public Dataholder(CacheObject cacheObject) throws CacheException {
        this(1026, cacheObject);
    }

    public Dataholder(ObjectHandle objectHandle) throws CacheException {
        this(1026, objectHandle == null ? null : objectHandle.getProxy());
    }

    public Dataholder(Object object) throws CacheException {
        if (object == null) {
            this.set(0, null);
        } else if (object instanceof ObjectHandle) {
            this.set(1026, ((ObjectHandle)object).getProxy());
        } else if (object instanceof List) {
            this.set(2048, object);
        } else if (object instanceof Map) {
            this.set(2048, object);
        } else {
            throw new CacheException("Unrecognized type: " + object.getClass().getName());
        }
    }

    public Dataholder(StatusCode statusCode) throws CacheException {
        this(23, statusCode == null ? null : statusCode.getBytes());
    }

    public int getType() {
        return this.mType;
    }

    public static boolean isSwizzled(Object object) throws SQLException {
        int n = Dataholder.getItemType(object);
        if (n == 1) {
            byte[] byArray = Dataholder.getByte(object);
            return byArray != null && byArray.length > 0;
        }
        if (n == 4) {
            int n2 = Dataholder.getInteger(object);
            return n2 > 0;
        }
        return false;
    }

    public Object getObject() throws CacheException {
        if (this.mType == 4096) {
            try {
                Object object = SysListProxy.getObject(this.mValue);
                Dataholder.rewind(this.mValue);
                return object;
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Failed to extract wrapped object");
            }
        }
        return this.mValue;
    }

    public Object getObject(int n) throws CacheException {
        switch (n) {
            case 1: {
                return this.getBoolean();
            }
            case 2: {
                return this.getInteger();
            }
            case 4: {
                return this.getLong();
            }
            case 5: {
                return this.getByte();
            }
            case 6: {
                return this.getShort();
            }
            case 7: {
                return this.getFloat();
            }
            case 8: {
                return this.getDouble();
            }
            case 15: {
                return this.getBigInteger();
            }
            case 16: {
                return this.getBigDecimal();
            }
            case 23: {
                return this.getBinary();
            }
            case 24: {
                return this.getString();
            }
            case 32: {
                return this.getTime();
            }
            case 64: {
                return this.getDate();
            }
            case 128: {
                return this.getTimestamp();
            }
            case 256: {
                return this.getStatusCode();
            }
            case 384: {
                return this.getSysList();
            }
            case 385: {
                return this.getSList();
            }
            case 512: {
                return this.getInteger();
            }
            case 1026: {
                return this.getCacheObject();
            }
            case 1024: {
                return this.getInteger();
            }
        }
        throw new CacheException("Unknown type: " + n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Dataholder)) {
            return false;
        }
        Dataholder dataholder = (Dataholder)object;
        if (this.mValue == null) {
            return dataholder.mValue == null;
        }
        return this.mValue.equals(dataholder.mValue);
    }

    public Object getObject(String string) throws CacheException {
        int n = Dataholder.toIntType(string);
        return this.getObject(n);
    }

    public static int toIntType(String string) throws CacheException {
        String string2 = "com.intersys.objects.";
        String string3 = "java.lang.";
        String string4 = "java.math.";
        String string5 = "java.sql.";
        String string6 = "java.util.";
        int n = -1;
        if (string.equals("Integer") || string.equals(string3 + "Integer") || string.equals("int") || string.equals(Dataholder.getTypeString(2))) {
            n = 2;
        } else if (string.equals("String") || string.equals(string3 + "String") || string.equals(Dataholder.getTypeString(24))) {
            n = 24;
        } else if (string.equals("Boolean") || string.equals(string3 + "Boolean") || string.equals("boolean") || string.equals(Dataholder.getTypeString(1))) {
            n = 1;
        } else if (string.equals("Double") || string.equals(string3 + "Double") || string.equals("double") || string.equals(Dataholder.getTypeString(8))) {
            n = 8;
        } else if (string.equals("Date") || string.equals(string5 + "Date") || string.equals(string6 + "Date") || string.equals(Dataholder.getTypeString(64))) {
            n = 64;
        } else if (string.equals("Timestamp") || string.equals(string5 + "Timestamp") || string.equals(Dataholder.getTypeString(128))) {
            n = 128;
        } else if (string.equals("Time") || string.equals(string5 + "Time") || string.equals(Dataholder.getTypeString(32))) {
            n = 32;
        } else if (string.equals("Float") || string.equals(string3 + "Float") || string.equals("float") || string.equals(Dataholder.getTypeString(7))) {
            n = 7;
        } else if (string.equals("Short") || string.equals(string3 + "Short") || string.equals("short") || string.equals(Dataholder.getTypeString(6))) {
            n = 6;
        } else if (string.equals("Byte") || string.equals(string3 + "Byte") || string.equals("byte") || string.equals(Dataholder.getTypeString(5))) {
            n = 5;
        } else if (string.equals("BigInteger") || string.equals(string4 + "BigInteger") || string.equals(Dataholder.getTypeString(15))) {
            n = 15;
        } else if (string.equals("BigDecimal") || string.equals(string4 + "BigDecimal") || string.equals(Dataholder.getTypeString(16))) {
            n = 16;
        } else if (string.equals("Long") || string.equals(string3 + "Long") || string.equals("long") || string.equals(Dataholder.getTypeString(4))) {
            n = 4;
        } else if (string.equals("SList") || string.equals(string2 + "SList")) {
            n = 385;
        } else if (string.equals("RegisteredObject") || string.equals(string2 + "RegisteredObject") || string.equals(Dataholder.getTypeString(1024))) {
            n = 1024;
        } else if (string.equals(Dataholder.getTypeString(512))) {
            n = 512;
        } else if (string.equals(Dataholder.getTypeString(1026))) {
            n = 1026;
        } else if (string.equals(Dataholder.getTypeString(256)) || string.equals(string2 + "StatusCode")) {
            n = 256;
        } else if (string.equals(Dataholder.getTypeString(384))) {
            n = 384;
        } else if (string.equals("byte[]") || string.equals(Dataholder.getTypeString(23))) {
            n = 23;
        } else {
            throw new CacheException("Unknown type: " + string);
        }
        return n;
    }

    private final synchronized void unwrap() throws CacheException {
        if (this.mType != 4096) {
            return;
        }
        if (Dataholder.atEnd(this.mValue)) {
            this.set(24, null);
            return;
        }
        try {
            int n = Dataholder.getItemType(this.mValue);
            switch (n) {
                case -1: {
                    this.set(24, null);
                    break;
                }
                case 1: {
                    this.set(23, Dataholder.getByte(this.mValue));
                    break;
                }
                case 2: {
                    this.set(24, Dataholder.getString(this.mValue));
                    break;
                }
                case 4: 
                case 5: {
                    long l = Dataholder.getLong(this.mValue);
                    if (Integer.MIN_VALUE < l && l < Integer.MAX_VALUE) {
                        this.set(2, new Integer((int)l));
                        break;
                    }
                    this.set(4, new Long(l));
                    break;
                }
                case 6: 
                case 7: {
                    this.set(16, Dataholder.getBigDecimal(this.mValue));
                    break;
                }
                case 8: {
                    this.set(8, Dataholder.getDoubleWrapper(this.mValue));
                    break;
                }
                default: {
                    throw new SystemError("Unknown item type in list");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to get data from SysList");
        }
    }

    public Object getAppropriateInteger() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 2) {
            return (Integer)this.mValue;
        }
        if (this.mType == 4) {
            Long l = (Long)this.mValue;
            long l2 = l;
            if (Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE) {
                return new Integer((int)l2);
            }
            return l;
        }
        if (this.mType == 15) {
            BigInteger bigInteger = (BigInteger)this.mValue;
            if (bigInteger.compareTo(MAX_LONG) > 0 || bigInteger.compareTo(MIN_LONG) < 0) {
                return bigInteger;
            }
            long l = bigInteger.longValue();
            if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as an integer");
    }

    public CacheObject getCacheObject() throws CacheException {
        this.unwrap();
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 1026) {
            return (CacheObject)this.mValue;
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as an CacheObject");
    }

    public Object getCollection() throws CacheException {
        if (this.mValue == null) {
            return null;
        }
        switch (this.mType) {
            case 2048: {
                return this.mValue;
            }
            case 1026: {
                CacheObject cacheObject = (CacheObject)this.mValue;
                return cacheObject.newJavaInstance();
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a Collection");
    }

    public Integer getInteger() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 2 || this.mType == 512) {
            return (Integer)this.mValue;
        }
        return new Integer(this.getIntValue());
    }

    public int getIntValue() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            throw new CacheNullValueException();
        }
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue != false ? 1 : 0;
            }
            case 5: {
                return ((Byte)this.mValue).intValue();
            }
            case 6: {
                return ((Short)this.mValue).intValue();
            }
            case 2: 
            case 512: {
                return (Integer)this.mValue;
            }
            case 1026: {
                if (this.mValue instanceof AbstractCacheObject) {
                    return ((AbstractCacheObject)this.mValue).getOrefForced();
                }
                return ((CacheObject)this.mValue).getOref();
            }
            case 4: {
                return ((Long)this.mValue).intValue();
            }
            case 15: {
                return ((BigInteger)this.mValue).intValue();
            }
            case 7: {
                return ((Float)this.mValue).intValue();
            }
            case 8: {
                return ((Double)this.mValue).intValue();
            }
            case 16: {
                return ((BigDecimal)this.mValue).intValue();
            }
            case 23: {
                return Integer.parseInt(new String((byte[])this.mValue).trim());
            }
            case 24: {
                return Integer.parseInt(((String)this.mValue).trim());
            }
            case 1028: {
                return Integer.parseInt(this.mValue.toString());
            }
            case 64: {
                return Dataholder.date2int((Date)this.mValue);
            }
            case 32: {
                return Dataholder.time2int((Time)this.mValue);
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as an integer");
    }

    public char getCharValue() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            throw new CacheNullValueException();
        }
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue != false ? (char)'\u0001' : '\u0000';
            }
            case 5: {
                return (char)((Byte)this.mValue).byteValue();
            }
            case 6: {
                return (char)((Short)this.mValue).intValue();
            }
            case 2: {
                return (char)((Integer)this.mValue).intValue();
            }
            case 4: {
                return (char)((Long)this.mValue).intValue();
            }
            case 15: {
                return (char)((BigInteger)this.mValue).intValue();
            }
            case 7: {
                return (char)((Float)this.mValue).intValue();
            }
            case 8: {
                return (char)((Double)this.mValue).intValue();
            }
            case 16: {
                return (char)((BigDecimal)this.mValue).intValue();
            }
            case 23: {
                return (char)Integer.parseInt(new String((byte[])this.mValue).trim());
            }
            case 24: {
                return (char)Integer.parseInt(((String)this.mValue).trim());
            }
            case 64: {
                return (char)Dataholder.date2int((Date)this.mValue);
            }
            case 32: {
                return (char)Dataholder.time2int((Time)this.mValue);
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a char value");
    }

    public Long getLong() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 4) {
            return (Long)this.mValue;
        }
        return new Long(this.getLongValue());
    }

    public long getLongValue() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            throw new CacheNullValueException();
        }
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue != false ? 1L : 0L;
            }
            case 5: {
                return ((Byte)this.mValue).longValue();
            }
            case 6: {
                return ((Short)this.mValue).longValue();
            }
            case 2: {
                return ((Integer)this.mValue).longValue();
            }
            case 4: {
                return (Long)this.mValue;
            }
            case 15: {
                return ((BigInteger)this.mValue).longValue();
            }
            case 7: {
                return ((Float)this.mValue).longValue();
            }
            case 8: {
                return ((Double)this.mValue).longValue();
            }
            case 16: {
                return ((BigDecimal)this.mValue).longValue();
            }
            case 23: {
                return Long.parseLong(new String((byte[])this.mValue));
            }
            case 24: {
                return Long.parseLong((String)this.mValue);
            }
            case 1028: {
                return Long.parseLong(this.mValue.toString());
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a long");
    }

    public BigInteger getBigInteger() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            case 5: {
                return BigInteger.valueOf(((Byte)this.mValue).longValue());
            }
            case 6: {
                return BigInteger.valueOf(((Short)this.mValue).longValue());
            }
            case 2: {
                return BigInteger.valueOf(((Integer)this.mValue).longValue());
            }
            case 4: {
                return BigInteger.valueOf((Long)this.mValue);
            }
            case 15: {
                return (BigInteger)this.mValue;
            }
            case 7: {
                return new BigDecimal(((Float)this.mValue).doubleValue()).toBigInteger();
            }
            case 8: {
                return new BigDecimal((Double)this.mValue).toBigInteger();
            }
            case 16: {
                return ((BigDecimal)this.mValue).toBigInteger();
            }
            case 23: {
                return new BigInteger(new String((byte[])this.mValue));
            }
            case 24: {
                return new BigInteger((String)this.mValue);
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a BigInteger");
    }

    public BigDecimal getBigDecimal() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        switch (this.mType) {
            case 1: {
                return BigDecimal.valueOf((Boolean)this.mValue != false ? 1L : 0L);
            }
            case 5: {
                return BigDecimal.valueOf(((Byte)this.mValue).longValue());
            }
            case 6: {
                return BigDecimal.valueOf(((Short)this.mValue).longValue());
            }
            case 2: {
                return BigDecimal.valueOf(((Integer)this.mValue).longValue());
            }
            case 4: {
                return BigDecimal.valueOf((Long)this.mValue);
            }
            case 15: {
                return new BigDecimal((BigInteger)this.mValue);
            }
            case 7: {
                return new BigDecimal(((Float)this.mValue).doubleValue());
            }
            case 8: {
                return new BigDecimal((Double)this.mValue);
            }
            case 16: {
                return (BigDecimal)this.mValue;
            }
            case 23: {
                return new BigDecimal(new String((byte[])this.mValue));
            }
            case 24: {
                return new BigDecimal((String)this.mValue);
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a BigDecimal");
    }

    public Boolean getBoolean() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 1) {
            return (Boolean)this.mValue;
        }
        return new Boolean(this.getBooleanValue());
    }

    public boolean getBooleanValue() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            throw new CacheNullValueException();
        }
        int n = -1;
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue;
            }
            case 5: {
                return (Byte)this.mValue != 0;
            }
            case 6: {
                return (Short)this.mValue != 0;
            }
            case 2: {
                return (Integer)this.mValue != 0;
            }
            case 4: {
                return (Long)this.mValue != 0L;
            }
            case 15: {
                return !((BigInteger)this.mValue).equals(BigInteger.ZERO);
            }
            case 7: {
                return ((Float)this.mValue).floatValue() != 0.0f;
            }
            case 8: {
                return (Double)this.mValue != 0.0;
            }
            case 16: {
                return !((BigDecimal)this.mValue).equals(BigDecimal.valueOf(0L));
            }
            case 23: {
                n = Integer.parseInt(new String((byte[])this.mValue));
                break;
            }
            case 24: {
                n = Integer.parseInt((String)this.mValue);
            }
        }
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a Boolean");
    }

    public Byte getByte() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 5) {
            return (Byte)this.mValue;
        }
        return new Byte(this.getByteValue());
    }

    public byte getByteValue() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            throw new CacheNullValueException();
        }
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue != false ? (byte)1 : 0;
            }
            case 5: {
                return (Byte)this.mValue;
            }
            case 6: {
                return ((Short)this.mValue).byteValue();
            }
            case 2: {
                return ((Integer)this.mValue).byteValue();
            }
            case 4: {
                return ((Long)this.mValue).byteValue();
            }
            case 15: {
                return ((BigInteger)this.mValue).byteValue();
            }
            case 7: {
                return ((Float)this.mValue).byteValue();
            }
            case 8: {
                return ((Double)this.mValue).byteValue();
            }
            case 16: {
                return ((BigDecimal)this.mValue).byteValue();
            }
            case 23: {
                return Byte.parseByte(new String((byte[])this.mValue));
            }
            case 24: {
                return Byte.parseByte((String)this.mValue);
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a byte");
    }

    public Short getShort() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 6) {
            return (Short)this.mValue;
        }
        return new Short(this.getShortValue());
    }

    public short getShortValue() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            throw new CacheNullValueException();
        }
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue != false ? (short)1 : 0;
            }
            case 5: {
                return ((Byte)this.mValue).shortValue();
            }
            case 6: {
                return (Short)this.mValue;
            }
            case 2: {
                return ((Integer)this.mValue).shortValue();
            }
            case 4: {
                return ((Long)this.mValue).shortValue();
            }
            case 15: {
                return ((BigInteger)this.mValue).shortValue();
            }
            case 7: {
                return ((Float)this.mValue).shortValue();
            }
            case 8: {
                return ((Double)this.mValue).shortValue();
            }
            case 16: {
                return ((BigDecimal)this.mValue).shortValue();
            }
            case 23: {
                return Short.parseShort(new String((byte[])this.mValue));
            }
            case 24: {
                return Short.parseShort((String)this.mValue);
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a short");
    }

    public Float getFloat() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 7) {
            return (Float)this.mValue;
        }
        return new Float(this.getFloatValue());
    }

    public float getFloatValue() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            throw new CacheNullValueException();
        }
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue != false ? 1.0f : 0.0f;
            }
            case 5: {
                return ((Byte)this.mValue).floatValue();
            }
            case 6: {
                return ((Short)this.mValue).floatValue();
            }
            case 2: {
                return ((Integer)this.mValue).floatValue();
            }
            case 4: {
                return ((Long)this.mValue).floatValue();
            }
            case 15: {
                return ((BigInteger)this.mValue).floatValue();
            }
            case 7: {
                return ((Float)this.mValue).floatValue();
            }
            case 8: {
                return ((Double)this.mValue).floatValue();
            }
            case 16: {
                return ((BigDecimal)this.mValue).floatValue();
            }
            case 23: {
                return Float.parseFloat(new String((byte[])this.mValue));
            }
            case 24: {
                return Float.parseFloat((String)this.mValue);
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a float");
    }

    public Double getDouble() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 8) {
            return (Double)this.mValue;
        }
        return new Double(this.getDoubleValue());
    }

    public double getDoubleValue() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            throw new CacheNullValueException();
        }
        switch (this.mType) {
            case 1: {
                return (Boolean)this.mValue != false ? 1.0 : 0.0;
            }
            case 5: {
                return ((Byte)this.mValue).doubleValue();
            }
            case 6: {
                return ((Short)this.mValue).doubleValue();
            }
            case 2: {
                return ((Integer)this.mValue).doubleValue();
            }
            case 4: {
                return ((Long)this.mValue).doubleValue();
            }
            case 15: {
                return ((BigInteger)this.mValue).doubleValue();
            }
            case 7: {
                return ((Float)this.mValue).doubleValue();
            }
            case 8: {
                return (Double)this.mValue;
            }
            case 16: {
                return ((BigDecimal)this.mValue).doubleValue();
            }
            case 23: {
                return Double.parseDouble(new String((byte[])this.mValue));
            }
            case 24: {
                return Double.parseDouble((String)this.mValue);
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a double");
    }

    public Date getFilemanDate() throws CacheException {
        return this.getDateInternal(true);
    }

    public Date getDate() throws CacheException {
        return this.getDateInternal(false);
    }

    private Date getDateInternal(boolean bl) throws CacheException {
        int n;
        if (this.mType == 4096) {
            try {
                int n2 = Dataholder.getItemType(this.mValue);
                Date date = null;
                if (n2 == 1 && (date = SysListProxy.getSQLDate(this.mValue)) != null) {
                    this.set(64, date);
                }
                if (date != null) {
                    return date;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                Dataholder.rewind(this.mValue);
            }
            catch (SQLException sQLException) {
                throw new CacheException("Failed to get Date value");
            }
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 64) {
            return (Date)this.mValue;
        }
        try {
            if (this.mType == 24 || this.mType == 23) {
                return Date.valueOf(this.getString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            n = this.getIntValue();
        }
        catch (CacheException cacheException) {
            throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a date");
        }
        if (bl) {
            return Dataholder.fmint2date(n);
        }
        return Dataholder.int2date(n);
    }

    public Time getTime() throws CacheException {
        int n;
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 32) {
            return (Time)this.mValue;
        }
        if (this.mType == 24 || this.mType == 23) {
            String string = this.getString();
            try {
                return Time.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return new Time(m_sdfTimeDefault.parse(string).getTime());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        try {
            n = this.getIntValue();
        }
        catch (CacheException cacheException) {
            throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a time");
        }
        return Dataholder.int2time(n);
    }

    public Timestamp getFilemanTimestamp() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 128) {
            return (Timestamp)this.mValue;
        }
        try {
            double d = this.getDoubleValue();
            return Dataholder.fmfloat2timestamp(d);
        }
        catch (NumberFormatException numberFormatException) {
            return this.getTimestamp();
        }
    }

    public Timestamp getTimestamp() throws CacheException {
        String string;
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.mType == 128) {
            return (Timestamp)this.mValue;
        }
        try {
            string = this.getString();
        }
        catch (CacheException cacheException) {
            throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a timestamp");
        }
        return Dataholder.string2timestamp(string);
    }

    public byte[] getBytes() throws CacheException {
        return this.getBinary();
    }

    public byte[] getBinary() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.mValue == null) {
            return null;
        }
        if (this.mType == 23) {
            return (byte[])this.mValue;
        }
        if (this.mType == 24) {
            return ((String)this.mValue).getBytes();
        }
        if (this.mType == 385) {
            return ((SList)this.mValue).getData();
        }
        if (this.mType == 384) {
            return SysListProxy.getBinaryData(this.mValue);
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a binary");
    }

    public void stuff(Object object) throws CacheException {
        try {
            if (this.mValue == null) {
                SysListProxy.setObject(object, null);
                return;
            }
            switch (this.mType) {
                case 1: {
                    SysListProxy.setBoolean(object, this.getBooleanValue());
                    return;
                }
                case 2: 
                case 5: 
                case 6: 
                case 512: 
                case 1026: {
                    SysListProxy.setInteger(object, this.getIntValue());
                    return;
                }
                case 4: {
                    SysListProxy.setLong(object, this.getLongValue());
                    return;
                }
                case 15: {
                    SysListProxy.setBigDecimal(object, this.getBigDecimal());
                    return;
                }
                case 16: {
                    SysListProxy.setBigDecimal(object, (BigDecimal)this.mValue);
                    return;
                }
                case 7: {
                    SysListProxy.setFloat(object, this.getFloatValue());
                    return;
                }
                case 8: {
                    SysListProxy.setDouble(object, this.getDoubleValue());
                    return;
                }
                case 23: {
                    SysListProxy.setByte(object, this.getBinary());
                    return;
                }
                case 24: {
                    SysListProxy.setString(object, this.getString());
                    return;
                }
                case 64: {
                    SysListProxy.setInteger(object, Dataholder.date2int(this.getDate()));
                    return;
                }
                case 32: {
                    SysListProxy.setInteger(object, Dataholder.time2int(this.getTime()));
                    return;
                }
                case 128: {
                    SysListProxy.setString(object, Dataholder.timestamp2string(this.getTimestamp()));
                    return;
                }
                case 384: 
                case 385: {
                    SysListProxy.setSysList(object, this.getSysList());
                    return;
                }
                case 4096: {
                    Dataholder.concatenate(object, this.mValue);
                    Dataholder.skipAll(object);
                    return;
                }
            }
            throw new CacheException("Do not know how to stuff type " + Dataholder.getTypeString(this.getType()) + " to SysList.");
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Can not stuff value to SysList");
        }
    }

    public String getString() throws CacheException {
        if (this.mType == 4096) {
            try {
                String string = SysListProxy.atEnd(this.mValue) ? null : SysListProxy.getString(this.mValue);
                this.set(24, string);
                return string;
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Failed to get String from " + this.mValue);
            }
        }
        if (this.mValue == null) {
            return null;
        }
        if (this.mType == 24) {
            return (String)this.mValue;
        }
        switch (this.mType) {
            case 23: {
                return new String((byte[])this.mValue);
            }
            case 128: {
                return Dataholder.timestamp2string((Timestamp)this.mValue);
            }
        }
        return this.mValue.toString();
    }

    public Id getId() throws CacheException {
        switch (this.mType) {
            case 1028: {
                return (Id)this.mValue;
            }
            case 1026: {
                return this.getCacheObject().getId();
            }
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a Object Id");
    }

    public SList getSList() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.mValue == null) {
            return null;
        }
        if (this.mType == 384 || this.mType == 23 || this.mType == 24) {
            return new SList(this.getSysList());
        }
        if (this.mType == 385) {
            return (SList)this.mValue;
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a SList");
    }

    public Object getSysList() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        if (this.mValue == null) {
            return null;
        }
        if (this.mType == 384) {
            return this.mValue;
        }
        if (this.mType == 385) {
            return SysListProxy.createSysList(((SList)this.mValue).getData());
        }
        if (this.mType == 23 || this.mType == 24) {
            return SysListProxy.createSysList(this.getBinary());
        }
        throw new CacheException("Attempt to treat type " + Dataholder.getTypeString(this.mType) + " as a SysList");
    }

    public Oid getOid() throws CacheException {
        return new Oid(this.getBinary());
    }

    public StatusCode getStatusCode() throws CacheException {
        if (this.mType == 4096) {
            this.unwrap();
        }
        switch (this.mType) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 15: {
                int n = this.getIntValue();
                if (n == 1) {
                    return StatusCode.OK;
                }
                throw new CacheException("Bad status code: " + n);
            }
        }
        return new StatusCode(this.getBinary());
    }

    public static boolean isBinaryType(int n) throws CacheException {
        switch (n) {
            case 5: 
            case 23: 
            case 256: 
            case 384: 
            case 385: 
            case 4096: {
                return true;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 24: 
            case 32: 
            case 64: 
            case 128: 
            case 512: 
            case 1024: 
            case 1026: {
                return false;
            }
        }
        throw new CacheException("Unknown type: " + n);
    }

    public static boolean isTypeValid(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 384: 
            case 385: 
            case 512: 
            case 1024: 
            case 1026: 
            case 4096: {
                return true;
            }
        }
        return false;
    }

    private static int getSysListTypeForNull(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 512: 
            case 1024: 
            case 1026: {
                return 4;
            }
            case 7: 
            case 8: 
            case 16: {
                return 6;
            }
            case 23: 
            case 24: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 384: 
            case 385: {
                return 1;
            }
        }
        return -1;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static String getTypeString(int n) {
        switch (n) {
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "INTEGER";
            }
            case 4: {
                return "LONG";
            }
            case 5: {
                return "BYTE";
            }
            case 6: {
                return "SHORT";
            }
            case 7: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 15: {
                return "BIG_INTEGER";
            }
            case 16: {
                return "BIG_DECIMAL";
            }
            case 23: {
                return "BINARY";
            }
            case 24: {
                return "STRING";
            }
            case 32: {
                return "TIME";
            }
            case 64: {
                return "DATE";
            }
            case 128: {
                return "TIMESTAMP";
            }
            case 256: {
                return "STATUS_CODE";
            }
            case 384: {
                return "SYS_LIST";
            }
            case 385: {
                return "$LIST";
            }
            case 512: {
                return "OREF";
            }
            case 1026: {
                return "CACHE_OBJECT";
            }
            case 1024: {
                return "REGISTERED_OBJECT";
            }
            case 2048: {
                return "COLLECTION";
            }
            case 4096: {
                return "WRAPPED_ITEM";
            }
        }
        return "UNKNOWN(" + n + ")";
    }

    private boolean isNull() throws CacheException {
        if (this.mValue == null) {
            return true;
        }
        if (this.mType == 4096) {
            throw new SystemError("isNull could not be called for wrapped item!");
        }
        if (this.mValue instanceof String) {
            return ((String)this.mValue).length() <= 0;
        }
        if (this.mValue instanceof byte[]) {
            return ((byte[])this.mValue).length <= 0;
        }
        return false;
    }

    public Object makeSysList(boolean bl, String string) throws CacheException {
        if (this.isNull()) {
            Object object = SysListProxy.createSysList();
            try {
                SysListProxy.setString(object, "");
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "Can not create SysList");
            }
            return object;
        }
        Object object = SysListProxy.createSysList();
        this.stuff(object);
        return object;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (CacheException cacheException) {
            return cacheException.getMessage();
        }
    }

    public String toOrefString() {
        if (this.mValue == null) {
            return "<NULL>";
        }
        try {
            return this.getCacheObject().toOrefString();
        }
        catch (CacheException cacheException) {
            return "<INVALID OREF>";
        }
    }

    public static int date2int(Date date) {
        int n = date.getTimezoneOffset() * 60000;
        long l = date.getTime() - (long)n - BASE_TIME;
        int n2 = (int)(l / 86400000L);
        return n2;
    }

    public static Date int2date(int n) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)BASE_CALENDAR.clone();
        gregorianCalendar.add(5, n);
        return new Date(gregorianCalendar.get(1) - 1900, gregorianCalendar.get(2), gregorianCalendar.get(5));
    }

    public static Date fmint2date(int n) {
        int n2 = n % 100;
        int n3 = n / 100 % 100;
        int n4 = n / 10000 + 1700;
        return new Date(n4 - 1900, n3 - 1, n2);
    }

    public static int date2fmint(Date date) {
        return (int)Dataholder.date2fmint(date, false);
    }

    public static double timestamp2fmdouble(Timestamp timestamp) {
        return Dataholder.date2fmint(timestamp, true);
    }

    private static double date2fmint(java.util.Date date, boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(5);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(1);
        int n4 = n + n2 * 100 + (n3 - 1700) * 10000;
        if (!bl) {
            return n4;
        }
        double d = gregorianCalendar.get(11);
        double d2 = gregorianCalendar.get(12);
        double d3 = gregorianCalendar.get(13);
        double d4 = d / 100.0 + d2 / 10000.0 + d3 / 1000000.0;
        return (double)n4 + d4;
    }

    public static Timestamp fmfloat2timestamp(double d) {
        int n = (int)d;
        int n2 = n % 100;
        int n3 = n / 100 % 100;
        int n4 = n / 10000 + 1700;
        int n5 = (int)((d - (double)n) * 1000000.0);
        int n6 = n5 % 100;
        int n7 = n5 / 100 % 100;
        int n8 = n5 / 10000;
        return new Timestamp(n4 - 1900, n3 - 1, n2, n8, n7, n6, 0);
    }

    public static int time2int(Time time) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(time);
        return gregorianCalendar.get(11) * 3600 + gregorianCalendar.get(12) * 60 + gregorianCalendar.get(13);
    }

    public static Time int2time(int n) {
        int n2 = (n %= 86400) / 3600;
        int n3 = (n %= 3600) / 60;
        return new Time(new GregorianCalendar(1970, 0, 1, n2, n3, n % 60).getTime().getTime());
    }

    public static String timestamp2string(Timestamp timestamp) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(timestamp);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        double d = (double)timestamp.getNanos() / 1.0E9;
        String string = Integer.toString(n);
        String string2 = n2 < 10 ? "0" + n2 : Integer.toString(n2);
        String string3 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        String string4 = n4 < 10 ? "0" + n4 : Integer.toString(n4);
        String string5 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
        String string6 = n6 < 10 ? "0" + n6 : Integer.toString(n6);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumIntegerDigits(0);
        numberFormat.setMaximumFractionDigits(9);
        String string7 = numberFormat.format(d);
        return string + "-" + string2 + "-" + string3 + " " + string4 + ":" + string5 + ":" + string6 + string7;
    }

    public static Timestamp string2timestamp(String string) {
        int n = string.indexOf(string);
        if (n < 0) {
            string = string + ".0";
        }
        return Timestamp.valueOf(string);
    }

    protected void set(int n, Object object) {
        this.mType = n;
        this.mValue = object;
    }

    public static String makeQueryStatement(String string, int n) {
        String string2 = "{ call " + string + " (";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + (i == 0 ? " ?" : ", ?");
        }
        string2 = string2 + " ) }";
        return string2;
    }

    static {
        GMT = TimeZone.getTimeZone("GMT");
        m_sdfTimeDefault = new SimpleDateFormat("HH:mm:ss.SSS");
        BASE_CALENDAR = new GregorianCalendar(1840, 11, 31, 0, 0, 0);
        BASE_CALENDAR.setTimeZone(GMT);
        BASE_TIME = BASE_CALENDAR.getTime().getTime();
        MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    }
}

