/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.CacheIface;
import com.intersys.cache.jbind.ModObjPair;
import com.intersys.cache.jbind.TmpObjPropertyKey;
import com.intersys.cache.jbind.ZObjectValueKey;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import com.intersys.objects.SystemError;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;

class UnsetProperties {
    private Map mPrimProperties = new TreeMap();
    private Map mObjProperties = new TreeMap();
    private Map mTmpObjProperties = new TreeMap();
    private boolean mIsUnicode;
    private String mServerLocale;

    public UnsetProperties(boolean bl, String string) {
        this.mIsUnicode = bl;
        this.mServerLocale = string;
    }

    public void setProperty(int n, int n2, int n3, int n4, boolean bl, String string, Dataholder dataholder) throws CacheException {
        if (bl) {
            this.mObjProperties.put(new ZObjectValueKey(n, n2, n3), new ModObjPair(n4, dataholder));
            this.mTmpObjProperties.put(new TmpObjPropertyKey(n, string), dataholder);
        } else {
            this.mPrimProperties.put(new ZObjectValueKey(n, n2, n3), new ModObjPair(n4, dataholder));
        }
    }

    public boolean find(int n, int n2, int n3, boolean bl) {
        if (bl) {
            return this.mObjProperties.containsKey(new ZObjectValueKey(n, n2, n3));
        }
        return this.mPrimProperties.containsKey(new ZObjectValueKey(n, n2, n3));
    }

    public Dataholder getProperty(int n, int n2, int n3, boolean bl) throws CacheException {
        Map map = bl ? this.mObjProperties : this.mPrimProperties;
        ModObjPair modObjPair = (ModObjPair)map.get(new ZObjectValueKey(n, n2, n3));
        if (modObjPair.val == null) {
            throw new CacheException("Property not found: oref=" + n + ", ii=" + n2 + ", jj=" + n3);
        }
        return modObjPair.val;
    }

    public void makeSetZList(Object object, CacheIface cacheIface) throws CacheException {
        try {
            Object object2;
            Comparable comparable;
            SysListProxy.setInteger(object, this.mPrimProperties.size());
            for (Map.Entry entry : this.mPrimProperties.entrySet()) {
                comparable = (ZObjectValueKey)entry.getKey();
                ((ZObjectValueKey)comparable).appendToSysList(object);
                object2 = (ModObjPair)entry.getValue();
                SysListProxy.setInteger(object, ((ModObjPair)object2).mod);
                ((ModObjPair)object2).val.stuff(object);
                if (Logger.getDebugCache()) {
                    Logger.out.println("Setting prim: " + comparable + " <- " + object2);
                }
                if (cacheIface == null) continue;
                cacheIface.notifyModified(((ZObjectValueKey)comparable).getObjectReference());
            }
            SysListProxy.setInteger(object, this.mObjProperties.size());
            for (Map.Entry entry : this.mTmpObjProperties.entrySet()) {
                comparable = (TmpObjPropertyKey)entry.getKey();
                ((TmpObjPropertyKey)comparable).appendToSysList(object);
                object2 = (Dataholder)entry.getValue();
                ((Dataholder)object2).stuff(object);
                if (Logger.getDebugCache()) {
                    Logger.out.println("Setting obj: " + ((TmpObjPropertyKey)comparable).toString((Dataholder)object2));
                }
                if (cacheIface == null) continue;
                cacheIface.notifyModified(((TmpObjPropertyKey)comparable).getObjectReference());
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to get property from local cache");
        }
        this.clear();
    }

    protected void clear() {
        this.mPrimProperties.clear();
        this.mObjProperties.clear();
        this.mTmpObjProperties.clear();
    }
}

