/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.Dataholder;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheInputStream;
import com.intersys.objects.CacheOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class QuickStreamObject
extends QuickCacheObject {
    private InputStream mIS;
    private ByteArrayOutputStream mOS;
    private QuickCacheOutputStream mOut = null;
    private QuickCacheInputStream mIn = null;

    public QuickStreamObject(TableBasedClass tableBasedClass, InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream) {
        super(tableBasedClass);
        this.mIS = inputStream;
        this.mOS = byteArrayOutputStream;
    }

    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        return null;
    }

    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
    }

    public Object newJavaInstance() throws CacheException {
        return this.getIn();
    }

    public Object newJavaInstance(boolean bl) throws CacheException {
        return this.newJavaInstance();
    }

    public int save(boolean bl) throws CacheException {
        return 0;
    }

    public CacheInputStream getIn() throws CacheException {
        if (this.mIn == null) {
            this.mIn = new QuickCacheInputStream();
        }
        return this.mIn;
    }

    public CacheOutputStream getOut() throws CacheException {
        if (this.mOut == null) {
            this.mOut = new QuickCacheOutputStream();
        }
        return this.mOut;
    }

    protected InputStream getInForSetting() throws CacheException {
        if (this.mOut == null) {
            return null;
        }
        return this.getIn();
    }

    class QuickCacheInputStream
    extends CacheInputStream {
        public QuickCacheInputStream() throws CacheException {
            super(null);
        }

        public synchronized byte[] read(int n) throws IOException {
            byte[] byArray = new byte[n];
            this.check();
            int n2 = QuickStreamObject.this.mIS.read(byArray);
            if (n2 <= 0) {
                return new byte[0];
            }
            if (n2 == n) {
                return byArray;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.check();
            return QuickStreamObject.this.mIS.read(byArray, n, n2);
        }

        public int available() throws IOException {
            this.check();
            return QuickStreamObject.this.mIS.available();
        }

        public boolean markSupported() {
            if (QuickStreamObject.this.mIS == null) {
                return true;
            }
            return QuickStreamObject.this.mIS.markSupported();
        }

        public synchronized void reset() throws IOException {
            if (QuickStreamObject.this.mIS == null) {
                throw new IOException("Either nothing was marked or write occured afterwards");
            }
            QuickStreamObject.this.mIS.reset();
        }

        public synchronized void mark(int n) {
            this.check();
            QuickStreamObject.this.mIS.mark(n);
        }

        public void close() throws IOException {
            QuickStreamObject.this.mIS = null;
        }

        public void rewind() throws CacheException {
            throw new CacheException("Operation is not supported with Light connection");
        }

        public void seek(long l) throws IOException {
            throw new IOException("Operation is not supported with Light connection");
        }

        public synchronized long tell() {
            throw new RuntimeException("Operation is not supported with Light connection");
        }

        private void check() {
            if (QuickStreamObject.this.mIS == null) {
                QuickStreamObject.this.mIS = new ByteArrayInputStream(QuickStreamObject.this.mOS.toByteArray());
            }
        }
    }

    class QuickCacheOutputStream
    extends CacheOutputStream {
        public QuickCacheOutputStream() throws CacheException {
            super(null);
        }

        public void rewind() throws CacheException {
            throw new CacheException("Operation is not supported by Light connection");
        }

        public void write(byte[] byArray) throws IOException {
            QuickStreamObject.this.mOS.write(byArray);
            QuickStreamObject.this.mIS = null;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            QuickStreamObject.this.mOS.flush();
        }
    }
}

