/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.serial;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.serial.SerialCollectionObject;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Oid;
import com.intersys.objects.reflect.TypeModifierHelper;
import com.intersys.objects.reflect.TypeModifiers;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SerialStorageReader
implements TypeModifiers {
    private static boolean trace = false;
    private Object mFieldValues;
    private Dataholder[] mCachedValues;
    private SysDatabase mDB;

    public SerialStorageReader(SysDatabase sysDatabase, Object object, int n) throws CacheException {
        this.mDB = sysDatabase;
        if (object instanceof byte[]) {
            object = SysListProxy.createSysList((byte[])object);
        }
        try {
            this.mFieldValues = SysListProxy.getSysList(object);
            if (SysListProxy.atEnd(this.mFieldValues)) {
                this.mFieldValues = null;
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to get serial state: " + object);
        }
        this.mCachedValues = new Dataholder[n];
    }

    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        Dataholder dataholder;
        if (this.mCachedValues[n] != null) {
            return this.mCachedValues[n];
        }
        if (trace) {
            Monitor.addRecord(this, n);
        }
        if (this.mFieldValues == null) {
            dataholder = new Dataholder();
        } else {
            try {
                Object object = SysListProxy.getWrappedItem(this.mFieldValues, n);
                dataholder = n2 != 0 ? this.getCollection(object, n2, n3, string) : (TypeModifierHelper.isSerial(n3) ? this.getSerialObject(string, object) : new Dataholder(4096, object));
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Failed to get property with idx " + n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new CacheException(arrayIndexOutOfBoundsException, "Failed to get property with idx " + n);
            }
        }
        this.mCachedValues[n] = dataholder;
        return dataholder;
    }

    public Oid getOid() {
        return new Oid(this.mFieldValues);
    }

    public byte[] getOriginalSerialState() {
        return SysListProxy.getBinaryData(this.mFieldValues);
    }

    private Dataholder getCollection(Object object, int n, int n2, String string) throws SQLException, CacheException {
        Object object2;
        if (TypeModifierHelper.isList(n)) {
            object2 = this.getSerialList(object, n2, string);
        } else if (n == 1) {
            object2 = this.getSerialArray(object, n2, string);
        } else {
            throw new CacheException("Unsupported collection type in serial object: " + n);
        }
        return new Dataholder(new SerialCollectionObject(object2));
    }

    private List getSerialList(Object object, int n, String string) throws SQLException, CacheException {
        Object object2 = SysListProxy.getSysList(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block5: while (object2 != null && !SysListProxy.atEnd(object2)) {
            switch (n) {
                case 4608: {
                    throw new CacheException("persistent objects are not supported inside serials");
                }
                case 256: {
                    String string2 = SysListProxy.getString(object2);
                    arrayList.add(string2);
                    continue block5;
                }
                case 8704: {
                    Object object3 = SysListProxy.getSysList(object2);
                    arrayList.add(this.getSerialInstance(string, object3));
                    continue block5;
                }
            }
            throw new CacheException("Unsupported collection element type: " + n);
        }
        return arrayList;
    }

    private Map getSerialArray(Object object, int n, String string) throws SQLException, CacheException {
        Object object2 = SysListProxy.getSysList(object);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block5: while (object2 != null && !SysListProxy.atEnd(object2)) {
            Object object3 = SysListProxy.getSysList(object2);
            String string2 = SysListProxy.getString(object3);
            switch (n) {
                case 4608: {
                    throw new CacheException("persistent objects are not supported inside serials");
                }
                case 256: {
                    String string3 = SysListProxy.getString(object3);
                    hashMap.put(string2, string3);
                    continue block5;
                }
                case 8704: {
                    Object object4 = SysListProxy.getSysList(object3);
                    hashMap.put(string2, this.getSerialInstance(string, object4));
                    continue block5;
                }
            }
            throw new CacheException("Unsupported collection element type");
        }
        return hashMap;
    }

    private Object getSerialInstance(String string, Object object) throws CacheException {
        CacheObject cacheObject = this.mDB.deserializeObject(string, object);
        return cacheObject.newJavaInstance();
    }

    private Dataholder getSerialObject(String string, Object object) throws CacheException {
        SysDatabase sysDatabase = this.mDB;
        CacheObject cacheObject = sysDatabase.deserializeObject(string, object);
        return new Dataholder(cacheObject);
    }

    public static void dumpMonitor(PrintStream printStream) {
        Monitor.dump(printStream);
    }

    private static class Monitor {
        private static Map records;
        private static int counter;

        private Monitor() {
        }

        public static void addRecord(Object object, int n) {
            ArrayList<Integer> arrayList;
            if (records == null) {
                records = new HashMap();
            }
            if ((arrayList = (ArrayList<Integer>)records.get(object)) == null) {
                arrayList = new ArrayList<Integer>();
                records.put(object, arrayList);
            } else {
                Integer n2 = (Integer)arrayList.get(arrayList.size() - 1);
                if (n2 > n) {
                    ++counter;
                }
            }
            arrayList.add(new Integer(n));
        }

        public static void dump(PrintStream printStream) {
            printStream.println(counter);
            Iterator iterator = records.values().iterator();
            while (iterator.hasNext()) {
                printStream.println(iterator.next());
            }
        }

        static {
            counter = 0;
        }
    }
}

