/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.metadata.MetaMetaClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.InvalidMethodException;
import com.intersys.objects.InvalidPropertyException;
import com.intersys.objects.Logger;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheArgument;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.CacheModifier;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Vector;

public class CacheGeneric {
    private static boolean updateSystemClasses;
    private static boolean updateUserClasses;
    private static boolean checkUserClasses;
    private static boolean updateDetermined;

    protected static void checkZobjValid(Database database, String string, String string2, int n, int n2, int n3) throws CacheException {
        CacheClass cacheClass = database.getCacheClass(string);
        CacheField cacheField = cacheClass.getField(string2);
        int n4 = cacheField.getII();
        int n5 = cacheField.getJJ();
        int n6 = cacheField.getKK();
        if (n4 == n && n5 == n2 && n6 == n3) {
            return;
        }
        throw new InvalidPropertyException(database, string, string2, n, n4, n2, n5);
    }

    public static void checkAllFieldsValid(Database database, String string, Class clazz) throws CacheException {
        CacheClass cacheClass = database.getCacheClass(string);
        Method[] methodArray = clazz.getMethods();
        Vector<Throwable> vector = new Vector<Throwable>();
        Object[] objectArray = new Object[]{database};
        Iterator iterator = cacheClass.getFieldNames();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.startsWith("%")) {
                string2 = "_" + string2.substring(1);
            }
            String string3 = "check" + string2 + "Valid";
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(string3)) continue;
                method = methodArray[i];
                break;
            }
            if (method == null) {
                vector.add(new InvalidPropertyException(database, string, string2, 0, 0, 0, 0, "Property " + string2 + " in Cache class " + string + " not found in Java class " + clazz.getName()));
                continue;
            }
            method.setAccessible(true);
            try {
                method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof InvalidPropertyException) {
                    vector.add(throwable);
                    continue;
                }
                throw new CacheException(throwable, "Exception while checking validity of property " + string2 + " in Cache class " + string);
            }
            catch (Exception exception) {
                throw new CacheException(exception, "Exception while checking validity of property " + string2 + " in Cache class " + string);
            }
        }
        if (!vector.isEmpty()) {
            throw new InvalidClassException(database, string, vector);
        }
    }

    public static void checkMetadataFields(CacheClass cacheClass) throws CacheException, IllegalAccessException {
        Class clazz = null;
        try {
            clazz = cacheClass.getJavaClass();
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace();
        }
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField = cacheFieldArray[i];
            String string = "ii_" + cacheField.getName();
            Field field = CacheGeneric.findField(clazz, string);
            int n = cacheField.getII();
            CacheGeneric.checkUpdateIdx(field, n, true);
        }
    }

    public static void checkFieldsLimited(Database database, String string, Class clazz) throws CacheException, IllegalAccessException {
        boolean bl = false;
        if (CacheGeneric.isMetadataClass(string, clazz)) {
            bl = true;
        }
        CacheGeneric.determineUpdateClasses();
        boolean bl2 = CacheGeneric.isSystemClass(string, clazz);
        if (!bl2 && !checkUserClasses) {
            return;
        }
        boolean bl3 = bl2 ? updateSystemClasses : updateUserClasses;
        if (bl) {
            ReadOnlyDatabase readOnlyDatabase = ((SysDatabase)database).getReadOnlyDatabase();
            MetaMetaClass metaMetaClass = new MetaMetaClass(readOnlyDatabase, string);
            metaMetaClass.verifyClass();
            return;
        }
        CacheClass cacheClass = database.getCacheClass(string);
        Vector<InvalidPropertyException> vector = new Vector<InvalidPropertyException>();
        Iterator iterator = cacheClass.getFieldNames();
        while (iterator.hasNext()) {
            int n;
            boolean bl4 = true;
            String string2 = (String)iterator.next();
            String string3 = string2.startsWith("%") ? '_' + string2.substring(1) : string2;
            CacheField cacheField = cacheClass.getField(string2);
            String string4 = "ii_" + string3;
            Field field = CacheGeneric.findField(clazz, string4);
            if (field == null) {
                if (bl2) {
                    string3 = "_" + Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
                    string4 = "ii_" + string3;
                    field = CacheGeneric.findField(clazz, string4);
                } else if (cacheClass.getField("_" + string2) == null) {
                    string4 = "ii__" + string3;
                    field = CacheGeneric.findField(clazz, string4);
                }
            }
            int n2 = cacheField.getII();
            bl4 &= CacheGeneric.checkUpdateIdx(field, n2, bl3);
            String string5 = "jj_" + string3;
            Field field2 = CacheGeneric.findField(clazz, string5);
            int n3 = cacheField.getJJ();
            bl4 &= CacheGeneric.checkUpdateIdx(field2, n3, bl3);
            String string6 = "kk_" + string3;
            Field field3 = CacheGeneric.findField(clazz, string6);
            if (bl4 &= CacheGeneric.checkUpdateIdx(field3, n = cacheField.getKK(), bl3)) continue;
            vector.add(new InvalidPropertyException(database, string, string2, field.getInt(null), n2, field2.getInt(null), n3));
        }
        if (!vector.isEmpty()) {
            throw new InvalidClassException(database, string, vector);
        }
    }

    private static boolean checkUpdateIdx(Field field, int n, boolean bl) throws IllegalAccessException {
        if (field == null) {
            return true;
        }
        field.setAccessible(true);
        int n2 = field.getInt(null);
        if (n2 == n) {
            return true;
        }
        if (bl) {
            field.setInt(null, n);
            if (Logger.debugOn()) {
                Logger.out.println("WARNING: Field " + field.getDeclaringClass().getName() + '.' + field.getName() + " updated.");
            }
            return true;
        }
        return false;
    }

    protected static void checkAllMethods(Database database, String string, Class clazz) throws CacheException {
        CacheClass cacheClass = database.getCacheClass(string);
        Method[] methodArray = clazz.getMethods();
        Vector<InvalidMethodException> vector = new Vector<InvalidMethodException>();
        CacheMethod[] cacheMethodArray = cacheClass.getMethods();
        for (int i = 0; i < cacheMethodArray.length; ++i) {
            Object object;
            CacheField cacheField;
            CacheMethod cacheMethod = cacheMethodArray[i];
            String string2 = cacheMethod.getName();
            if (CacheModifier.isServerOnly(cacheMethod.getModifiers()) || string2.startsWith("%")) continue;
            if ((string2.startsWith("get") || string2.startsWith("set")) && (cacheField = cacheClass.getField((String)(object = string2.substring(3)))) != null) {
                string2 = "_" + string2;
            }
            object = null;
            int n = 0;
            for (int j = 0; j < methodArray.length; ++j) {
                if (!methodArray[j].getName().equals(string2)) continue;
                object = methodArray[j];
                int n2 = CacheGeneric.tryMethod(cacheMethod, (Method)object);
                if (n2 == 0) {
                    n = 0;
                    break;
                }
                n |= n2;
            }
            if (object == null) {
                vector.add(new InvalidMethodException(database, string, string2, "Method " + string2 + " in Cache class " + string + " not found in Java class " + clazz.getName()));
                continue;
            }
            if (n & true) {
                vector.add(new InvalidMethodException(database, string, string2, "Methods " + string2 + " in Cache class " + string + " and in Java class " + clazz.getName() + " have different " + "static modifiers"));
                continue;
            }
            if ((n & 2) == 0) continue;
            vector.add(new InvalidMethodException(database, string, string2, "Methods " + string2 + " in Cache class " + string + " and in Java class " + clazz.getName() + " have different " + "number of arguments"));
        }
        if (!vector.isEmpty()) {
            throw new InvalidClassException(database, string, vector);
        }
    }

    private static int tryMethod(CacheMethod cacheMethod, Method method) throws CacheException {
        boolean bl;
        boolean bl2 = CacheModifier.isStatic(cacheMethod.getModifiers());
        if (bl2 ^ (bl = Modifier.isStatic(method.getModifiers()))) {
            return 1;
        }
        int n = method.getParameterTypes().length;
        if (bl2) {
            --n;
        }
        CacheArgument[] cacheArgumentArray = cacheMethod.getArgumentTypes();
        int n2 = cacheArgumentArray.length;
        int n3 = 0;
        for (int i = 0; i < cacheArgumentArray.length && !CacheModifier.hasDefaultValue(cacheArgumentArray[i].getModifiers()); ++i) {
            ++n3;
        }
        if (n3 > n || n > n2) {
            return 2;
        }
        return 0;
    }

    private static final boolean isSystemClass(String string, Class clazz) {
        boolean bl = clazz.getPackage() != null && (clazz.getPackage().equals(CacheGeneric.class.getPackage()) || clazz.getPackage().getName().startsWith(CacheGeneric.class.getPackage().getName())) && string.startsWith("%");
        return bl;
    }

    private static final boolean isMetadataClass(String string, Class clazz) {
        boolean bl = string.startsWith("%Compiler.LG.");
        return bl;
    }

    public static void reset() {
        updateSystemClasses = true;
        updateUserClasses = true;
        checkUserClasses = true;
        updateDetermined = false;
    }

    private static final void determineUpdateClasses() throws CacheException {
        if (updateDetermined) {
            return;
        }
        String string = System.getProperty("com.intersys.classes.update.system");
        if (string != null) {
            if (string.equalsIgnoreCase("true") || string.equals("1")) {
                updateSystemClasses = true;
            } else if (string.equalsIgnoreCase("false") || string.equals("0")) {
                updateSystemClasses = false;
            } else {
                throw new CacheException("Invalid value for property com.intersys.classes.update.system: " + string);
            }
        }
        int n = ConnectionUtils.determineUpdateUserClasses();
        switch (n) {
            case 1: {
                updateUserClasses = true;
                break;
            }
            case 2: {
                updateUserClasses = false;
                break;
            }
            case -1: {
                checkUserClasses = false;
                break;
            }
            default: {
                throw new SystemError("Invalid value for property update.user: " + n);
            }
        }
        updateDetermined = true;
    }

    private static final Field findField(Class clazz, String string) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(string);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return null;
            }
            return CacheGeneric.findField(clazz2, string);
        }
    }

    static {
        CacheGeneric.reset();
    }
}

