/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class CachePooledConnection
implements PooledConnection {
    protected ConnectionEventListener listener = null;
    protected CacheConnectionPoolDataSource myDataSource;
    protected CacheConnection physicalConnection;
    protected String url;
    protected String user;
    protected String password;

    CachePooledConnection(CacheConnectionPoolDataSource cacheConnectionPoolDataSource, String string, String string2) throws SQLException {
        this.myDataSource = cacheConnectionPoolDataSource;
        this.url = this.myDataSource.url;
        this.user = string;
        this.password = string2;
        this.physicalConnection = new CacheConnection(cacheConnectionPoolDataSource.url, cacheConnectionPoolDataSource.server, cacheConnectionPoolDataSource.port, cacheConnectionPoolDataSource.database, this.user, this.password, cacheConnectionPoolDataSource.eventClass, cacheConnectionPoolDataSource.logStream, cacheConnectionPoolDataSource.loginTimeout, cacheConnectionPoolDataSource.nodelay, this, cacheConnectionPoolDataSource.securityLevel, cacheConnectionPoolDataSource.principalName);
    }

    public Connection getConnection() throws SQLException {
        return this.physicalConnection;
    }

    public synchronized void close() throws SQLException {
        this.physicalConnection.pooled = null;
        this.physicalConnection.close();
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listener = connectionEventListener;
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listener = null;
    }

    protected synchronized void release() {
        this.listener.connectionClosed(new ConnectionEvent(this));
    }

    protected synchronized void returnToPool() {
        if (this.myDataSource.pool.size() >= this.myDataSource.maxPoolSize) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.physicalConnection = null;
            return;
        }
        if (!this.myDataSource.pool.contains(this)) {
            this.myDataSource.pool.add(this);
        }
        --this.myDataSource.activeConnections;
    }
}

