/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.ListUtil;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.TimestampFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class SysList {
    public static final byte ITEM_UNDEF = -1;
    public static final byte ITEM_PLACEHOLDER = 0;
    public static final byte ITEM_ASCII = 1;
    public static final byte ITEM_UNICODE = 2;
    public static final byte ITEM_XUNICODE = 3;
    public static final byte ITEM_POSINT = 4;
    public static final byte ITEM_NEGINT = 5;
    public static final byte ITEM_POSNUM = 6;
    public static final byte ITEM_NEGNUM = 7;
    public static final byte ITEM_DOUBLE = 8;
    private static final int STREAM_BUF_SIZE = 32768;
    private static final int CHUNKSIZE = 256;
    private int BUCKET_SIZE = 1024;
    private static final int[] needarr = new int[]{0, 32, 64, 128, 128, 256, 256, 256, 256, 512, 512, 512, 512, 512, 512, 512, 512};
    private static Calendar m_defaultCalendar;
    private static SimpleDateFormat m_sdfDate;
    private static SimpleDateFormat m_sdfTime;
    private static SimpleDateFormat m_sdfTimestamp;
    private static SimpleDateFormat m_sdfDateDefault;
    private static SimpleDateFormat m_sdfTimeDefault;
    private static SimpleDateFormat m_sdfTimestampDefault;
    private static boolean useIEEEDouble;
    private static String defaultEncoding;
    private String serverLocale = "ISO8859_1";
    private byte[] m_aData;
    private int m_iLength;
    private int m_iLastIndex;
    private int m_iLastOffset;
    private int m_len;
    private int m_pos;
    private boolean m_isUnicode = false;
    private int currentRowIndex;
    private int currentRowOffset;
    private int maxFieldSize = 0;
    private int maxItemSize = 0;
    protected boolean isNull;

    protected SysList() {
        this.m_aData = new byte[256];
        this.m_iLength = 0;
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    protected SysList(byte[] byArray) {
        if (byArray == null) {
            this.m_aData = new byte[256];
            this.m_iLength = 0;
            this.m_iLastIndex = 0;
            this.m_iLastOffset = 0;
        } else {
            this.setList(byArray);
        }
    }

    SysList(byte[] byArray, int n) {
        this.setList(byArray, n, 0);
    }

    SysList(byte[] byArray, int n, int n2) {
        this.setList(byArray, n, n2);
    }

    protected SysList(boolean bl, SysList sysList) {
        if (bl) {
            this.setList(sysList.getData());
        } else {
            this.m_aData = sysList.m_aData;
            this.m_iLength = sysList.m_iLength;
            this.m_iLastIndex = sysList.m_iLastIndex;
            this.m_iLastOffset = sysList.m_iLastOffset;
        }
        this.setServerType(sysList.m_isUnicode, sysList.serverLocale);
    }

    protected SysList(boolean bl, byte[] byArray) {
        if (bl) {
            this.setList(byArray, byArray.length, 0);
        } else {
            this.setList(byArray);
        }
    }

    protected void disableIEEEDouble() {
        useIEEEDouble = false;
    }

    protected String getDefaultEncoding() {
        return this.serverLocale;
    }

    protected String readServerEncoding() throws SQLException {
        String string = this.getString();
        if (string.equalsIgnoreCase("LATIN1")) {
            return "ISO8859_1";
        }
        if (string.equalsIgnoreCase("LATIN2")) {
            return "ISO8859_2";
        }
        if (string.equalsIgnoreCase("LATINC")) {
            return "ISO8859_5";
        }
        if (string.equalsIgnoreCase("LATING")) {
            return "ISO8859_7";
        }
        if (string.equalsIgnoreCase("LATINH")) {
            return "ISO8859_8";
        }
        if (string.equalsIgnoreCase("CP1251")) {
            return "Cp1251";
        }
        if (string.equalsIgnoreCase("UNICODE")) {
            return "ISO8859_1";
        }
        return string;
    }

    private synchronized boolean eltLength() throws SQLException {
        this.isNull = false;
        this.m_pos = this.m_iLastOffset++;
        if (this.m_aData[this.m_pos] == 0) {
            if (this.m_pos + 3 > this.m_iLength) {
                throw new SQLException("Incorrect list format: " + (this.m_pos + 3) + " > " + this.m_iLength, "S1000");
            }
            this.m_len = this.m_aData[this.m_pos + 1] & 0xFF | (this.m_aData[this.m_pos + 2] & 0xFF) << 8;
            this.m_pos += 3;
            if (this.m_len == 0) {
                this.m_len = (this.m_aData[this.m_pos] & 0xFF | (this.m_aData[this.m_pos + 1] & 0xFF) << 8 | (this.m_aData[this.m_pos + 2] & 0xFF) << 16 | (this.m_aData[this.m_pos + 3] & 0xFF) << 24) - 1;
                this.m_pos += 4;
            } else {
                --this.m_len;
            }
        } else {
            if (this.m_aData[this.m_pos] == 1) {
                ++this.m_iLastIndex;
                this.m_len = 0;
                this.isNull = true;
                return this.isNull;
            }
            if (this.m_pos >= this.m_iLength) {
                throw new SQLException("Incorrect list format: " + this.m_pos + " >= " + this.m_iLength, "S1000");
            }
            this.m_len = (this.m_aData[this.m_pos++] & 0xFF) - 2;
        }
        if (this.m_pos + this.m_len >= this.m_iLength) {
            throw new SQLException("Incorrect list format: " + (this.m_pos + this.m_len + 1) + " > " + this.m_iLength, "S1000");
        }
        this.m_iLastOffset = this.m_pos + this.m_len + 1;
        ++this.m_iLastIndex;
        if (this.m_len == 0 && this.m_aData[this.m_pos] == 1) {
            this.isNull = true;
        }
        return this.isNull;
    }

    private synchronized void ensureBuffer(int n) {
        n = n + this.BUCKET_SIZE - 1 & ~(this.BUCKET_SIZE - 1);
        this.BUCKET_SIZE *= 2;
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_aData, 0, byArray, 0, this.m_iLength);
        this.m_aData = byArray;
    }

    private synchronized int makeItem(int n, int n2) {
        if (n2 < 255) {
            if (this.m_iLength + ++n2 > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + n2);
            }
            if (this.m_iLength != n) {
                System.arraycopy(this.m_aData, n, this.m_aData, n + n2, this.m_iLength - n);
            }
            this.m_iLength += n2;
            this.m_aData[n] = (byte)n2;
            ++this.m_iLastIndex;
            this.m_iLastOffset += n2;
            return n + 1;
        }
        if (n2 < 32768) {
            if (this.m_iLength + n2 + 3 > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + n2 + 3);
            }
            if (this.m_iLength != n) {
                System.arraycopy(this.m_aData, n, this.m_aData, n + n2 + 3, this.m_iLength - n);
            }
            this.m_iLength += n2 + 3;
            this.m_aData[n] = 0;
            this.m_aData[n + 1] = (byte)n2;
            this.m_aData[n + 2] = (byte)(n2 >> 8);
            ++this.m_iLastIndex;
            this.m_iLastOffset += n2 + 3;
            return n + 3;
        }
        if (this.m_iLength + n2 + 7 > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + n2 + 7);
        }
        if (this.m_iLength != n) {
            System.arraycopy(this.m_aData, n, this.m_aData, n + n2 + 3, this.m_iLength - n);
        }
        this.m_iLength += n2 + 7;
        this.m_aData[n] = 0;
        this.m_aData[n + 1] = 0;
        this.m_aData[n + 2] = 0;
        this.m_aData[n + 3] = (byte)n2;
        this.m_aData[n + 4] = (byte)(n2 >> 8);
        this.m_aData[n + 5] = (byte)(n2 >> 16);
        this.m_aData[n + 6] = (byte)(n2 >> 24);
        ++this.m_iLastIndex;
        this.m_iLastOffset += n2 + 7;
        return n + 7;
    }

    private boolean isWide(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    protected int getItemType() throws SQLException {
        int n = this.m_iLastOffset;
        if (n == this.m_iLength) {
            throw new NoMoreDataException();
        }
        if (this.m_aData[n] == 1) {
            return -1;
        }
        if ((n += this.m_aData[n] == 0 ? 3 : 1) >= this.m_iLength) {
            throw new SQLException("Incorrect list format: " + (n + 1) + " > " + this.m_iLength, "S1000");
        }
        return this.m_aData[n] & 0xFF;
    }

    private String grabUnicode() {
        int n = this.m_pos;
        char[] cArray = new char[this.m_len >>>= 1];
        int n2 = 0;
        while (n2 < this.m_len) {
            cArray[n2] = (char)(this.m_aData[n] & 0xFF | this.m_aData[n + 1] << 8);
            ++n2;
            n += 2;
        }
        return new String(cArray);
    }

    private void stuffAscii(String string) {
        byte[] byArray;
        int n = this.m_iLastOffset;
        try {
            byArray = string.getBytes(this.serverLocale);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        int n2 = byArray.length;
        n = this.makeItem(n, n2 + 1);
        this.m_aData[n] = 1;
        System.arraycopy(byArray, 0, this.m_aData, n + 1, n2);
    }

    private void stuffList(SysList sysList) {
        int n = this.m_iLastOffset;
        int n2 = sysList.m_iLength;
        n = this.makeItem(n, n2 + 1);
        this.m_aData[n] = 1;
        System.arraycopy(sysList.m_aData, 0, this.m_aData, n + 1, n2);
    }

    protected synchronized SysList set(byte[] byArray) throws SQLException {
        if (byArray.length == 0) {
            char[] cArray = new char[]{'\u0000'};
            this.stuffAscii(new String(cArray));
            return this;
        }
        if (this.maxItemSize != 0 && byArray.length > this.maxItemSize) {
            throw new SQLException("Max item size (" + this.maxItemSize + ") exceeded");
        }
        int n = this.m_iLastOffset;
        int n2 = byArray.length;
        n = this.makeItem(n, n2 + 1);
        this.m_aData[n] = 1;
        System.arraycopy(byArray, 0, this.m_aData, n + 1, n2);
        return this;
    }

    private void stuffUnicode(String string) {
        int n = this.m_iLastOffset;
        int n2 = string.length();
        n = this.makeItem(n, n2 * 2 + 1);
        this.m_aData[n++] = 2;
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            this.m_aData[n] = (byte)c;
            this.m_aData[n + 1] = (byte)(c >> 8);
            ++n3;
            n += 2;
        }
    }

    private void stuffNegInt(int n) {
        int n2 = this.m_iLastOffset;
        if (n < -65536) {
            if (n < -16777216) {
                n2 = this.makeItem(n2, 5);
                this.m_aData[n2 + 4] = (byte)(n >> 24);
            } else {
                n2 = this.makeItem(n2, 4);
            }
            this.m_aData[n2 + 3] = (byte)(n >> 16);
            this.m_aData[n2 + 2] = (byte)(n >> 8);
            this.m_aData[n2 + 1] = (byte)n;
        } else if (n < -256) {
            n2 = this.makeItem(n2, 3);
            this.m_aData[n2 + 2] = (byte)(n >> 8);
            this.m_aData[n2 + 1] = (byte)n;
        } else if (n != -1) {
            n2 = this.makeItem(n2, 2);
            this.m_aData[n2 + 1] = (byte)n;
        } else {
            n2 = this.makeItem(n2, 1);
        }
        this.m_aData[n2] = 5;
    }

    private void stuffPosInt(int n) {
        int n2 = this.m_iLastOffset;
        if (n > 65535) {
            if (n > 0xFFFFFF) {
                n2 = this.makeItem(n2, 5);
                this.m_aData[n2 + 4] = (byte)(n >> 24);
            } else {
                n2 = this.makeItem(n2, 4);
            }
            this.m_aData[n2 + 3] = (byte)(n >> 16);
            this.m_aData[n2 + 2] = (byte)(n >> 8);
            this.m_aData[n2 + 1] = (byte)n;
        } else if (n > 255) {
            n2 = this.makeItem(n2, 3);
            this.m_aData[n2 + 2] = (byte)(n >> 8);
            this.m_aData[n2 + 1] = (byte)n;
        } else if (n != 0) {
            n2 = this.makeItem(n2, 2);
            this.m_aData[n2 + 1] = (byte)n;
        } else {
            n2 = this.makeItem(n2, 1);
        }
        this.m_aData[n2] = 4;
    }

    private void stuffPosLong(long l) {
        int n = l > 0xFFFFFFFFL ? (l > 0xFFFFFFFFFFFFL ? (l > 0xFFFFFFFFFFFFFFL ? 8 : 7) : (l > 0xFFFFFFFFFFL ? 6 : 5)) : (l > 65535L ? (l > 0xFFFFFFL ? 4 : 3) : (l > 255L ? 2 : (l > 0L ? 1 : 0)));
        int n2 = this.stuffRawLong(l, n);
        this.m_aData[n2] = 4;
    }

    private void stuffNegLong(long l) {
        int n = l < -4294967296L ? (l < -281474976710656L ? (l < -72057594037927936L ? 8 : 7) : (l < -1099511627776L ? 6 : 5)) : (l < -65536L ? (l < -1048576L ? 4 : 3) : (l < -256L ? 2 : (l < -1L ? 1 : 0)));
        int n2 = this.stuffRawLong(l, n);
        this.m_aData[n2] = 5;
    }

    private final int stuffRawLong(long l, int n) {
        int n2 = this.m_iLastOffset;
        n2 = this.makeItem(n2, n + 1);
        switch (n) {
            case 8: {
                this.m_aData[n2 + 8] = (byte)(l >> 56);
            }
            case 7: {
                this.m_aData[n2 + 7] = (byte)(l >> 48);
            }
            case 6: {
                this.m_aData[n2 + 6] = (byte)(l >> 40);
            }
            case 5: {
                this.m_aData[n2 + 5] = (byte)(l >> 32);
            }
            case 4: {
                this.m_aData[n2 + 4] = (byte)(l >> 24);
            }
            case 3: {
                this.m_aData[n2 + 3] = (byte)(l >> 16);
            }
            case 2: {
                this.m_aData[n2 + 2] = (byte)(l >> 8);
            }
            case 1: {
                this.m_aData[n2 + 1] = (byte)l;
            }
        }
        return n2;
    }

    public synchronized void setIEEEDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        int n = this.stuffRawLong(l, 8);
        this.m_aData[n] = 8;
    }

    protected synchronized SysList set(BigInteger bigInteger) throws SQLException {
        int n;
        int n2;
        if (bigInteger == null) {
            this.setNull();
            return this;
        }
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray.length;
        boolean bl = byArray[0] < 0;
        if (bl) {
            for (n2 = 0; n2 < n3 && byArray[n2] == 255; ++n2) {
            }
            if (n2 == n3) {
                --n2;
                n = 1;
            } else {
                n = n3 - n2;
            }
        } else {
            while (n2 < n3 && byArray[n2] == 0) {
                ++n2;
            }
            if (n2 == n3) {
                return this.set(0);
            }
            n = n3 - n2;
        }
        int n4 = this.m_iLastOffset;
        n4 = this.makeItem(n4, n + 1);
        for (int i = 1; i <= n; ++i) {
            this.m_aData[n4 + i] = byArray[n3 - i];
        }
        this.m_aData[n4] = bl ? 5 : 4;
        return this;
    }

    private synchronized void stuffPosNum(int n, long l) {
        int n2 = this.m_iLastOffset;
        int n3 = l > 0xFFFFFFFFL ? (l > 0xFFFFFFFFFFFFL ? (l > 0xFFFFFFFFFFFFFFL ? 8 : 7) : (l > 0xFFFFFFFFFFL ? 6 : 5)) : (l > 65535L ? (l > 0xFFFFFFL ? 4 : 3) : (l > 255L ? 2 : (l > 0L ? 1 : 0)));
        n2 = this.makeItem(n2, n3 + 2);
        this.m_aData[n2++] = 6;
        this.m_aData[n2] = (byte)n;
        switch (n3) {
            case 8: {
                this.m_aData[n2 + 8] = (byte)(l >> 56);
            }
            case 7: {
                this.m_aData[n2 + 7] = (byte)(l >> 48);
            }
            case 6: {
                this.m_aData[n2 + 6] = (byte)(l >> 40);
            }
            case 5: {
                this.m_aData[n2 + 5] = (byte)(l >> 32);
            }
            case 4: {
                this.m_aData[n2 + 4] = (byte)(l >> 24);
            }
            case 3: {
                this.m_aData[n2 + 3] = (byte)(l >> 16);
            }
            case 2: {
                this.m_aData[n2 + 2] = (byte)(l >> 8);
            }
            case 1: {
                this.m_aData[n2 + 1] = (byte)l;
            }
        }
    }

    private synchronized void stuffNegNum(int n, long l) {
        int n2 = this.m_iLastOffset;
        int n3 = l < -4294967296L ? (l < -281474976710656L ? (l < -72057594037927936L ? 8 : 7) : (l < -1099511627776L ? 6 : 5)) : (l < -65536L ? (l < -1048576L ? 4 : 3) : (l < -256L ? 2 : (l < -1L ? 1 : 0)));
        n2 = this.makeItem(n2, n3 + 2);
        this.m_aData[n2++] = 7;
        this.m_aData[n2] = (byte)n;
        switch (n3) {
            case 8: {
                this.m_aData[n2 + 8] = (byte)(l >> 56);
            }
            case 7: {
                this.m_aData[n2 + 7] = (byte)(l >> 48);
            }
            case 6: {
                this.m_aData[n2 + 6] = (byte)(l >> 40);
            }
            case 5: {
                this.m_aData[n2 + 5] = (byte)(l >> 32);
            }
            case 4: {
                this.m_aData[n2 + 4] = (byte)(l >> 24);
            }
            case 3: {
                this.m_aData[n2 + 3] = (byte)(l >> 16);
            }
            case 2: {
                this.m_aData[n2 + 2] = (byte)(l >> 8);
            }
            case 1: {
                this.m_aData[n2 + 1] = (byte)l;
            }
        }
    }

    protected synchronized SysList set(BigDecimal bigDecimal) throws SQLException {
        int n = this.m_iLastOffset;
        int n2 = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.unscaledValue();
        int n3 = bigInteger.bitLength();
        if (n3 < 64 && n2 <= 128) {
            int n4;
            byte[] byArray = bigInteger.toByteArray();
            n3 = byArray.length;
            int n5 = n4 = byArray[0] == 0 || byArray[0] == 255 ? 1 : 0;
            if (n2 == 0) {
                n = this.makeItem(n, n3 - n4 + 1);
                this.m_aData[n++] = byArray[0] >= 0 ? 4 : 5;
            } else {
                n = this.makeItem(n, n3 - n4 + 2);
                this.m_aData[n++] = byArray[0] >= 0 ? 6 : 7;
                this.m_aData[n++] = (byte)(-n2);
            }
            while (n3 > n4) {
                this.m_aData[n++] = byArray[--n3];
            }
        } else {
            this.stuffAscii(ListUtil.scaledDecimaltoString(-n2, bigInteger));
        }
        return this;
    }

    protected synchronized void setSQLText(String string, int n) throws SQLException {
        if (n <= 10) {
            this.set(string);
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            char[] cArray = new char[]{'\u0000'};
            this.stuffPosInt(1);
            this.stuffAscii(new String(cArray));
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = this.isWide(string) ? 15952 : 31904;
        int n6 = n2 / n5;
        n6 = n2 % n5 != 0 ? n2 / n5 + 1 : n2 / n5;
        this.stuffPosInt(n6);
        if (this.m_isUnicode && this.isWide(string)) {
            for (int i = 1; i <= n6; ++i) {
                n4 = n3 + n5;
                n4 = n4 > n2 ? n2 : n4;
                this.stuffUnicode(string.substring(n3, n4));
                n3 = n4;
            }
        } else {
            for (int i = 1; i <= n6; ++i) {
                n4 = n3 + n5;
                n4 = n4 > n2 ? n2 : n4;
                this.stuffAscii(string.substring(n3, n4));
                n3 = n4;
            }
        }
    }

    protected synchronized void setServerType(boolean bl, String string) {
        this.m_isUnicode = bl;
        this.serverLocale = !this.m_isUnicode ? (string == null ? defaultEncoding : string) : "ISO8859_1";
    }

    protected synchronized boolean wasNull() {
        return this.isNull;
    }

    private void setList(byte[] byArray, int n, int n2) {
        if (null == this.m_aData) {
            this.m_aData = new byte[n + 256 - 1 & 0xFFFFFF00];
        } else if (n > this.m_aData.length) {
            this.ensureBuffer(n);
        }
        System.arraycopy(byArray, n2, this.m_aData, 0, n);
        this.m_iLength = n;
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    private synchronized void setList(byte[] byArray) {
        this.m_aData = byArray;
        this.m_iLength = byArray.length;
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    protected synchronized void setNull() {
        if (this.m_iLength + 2 > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + 2);
        }
        this.m_aData[this.m_iLastOffset] = 2;
        this.m_aData[this.m_iLastOffset + 1] = 1;
        this.m_iLength += 2;
        this.m_iLastOffset += 2;
        ++this.m_iLastIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int setParameter(OutputStream outputStream, CacheConnection cacheConnection, int n, Object object) throws SQLException {
        this.setParameter(object);
        if (this.m_iLength > 32014) {
            try {
                if (n == -1) {
                    n = cacheConnection.messageCount.getCount();
                }
                int n2 = this.m_iLength - 32014;
                int n3 = SysList.read4ByteInt(this.m_aData, 8);
                SysList.write4ByteInt(this.m_aData, 0, 32000);
                SysList.write4ByteInt(this.m_aData, 4, n);
                SysList.write4ByteInt(this.m_aData, 8, n3 | Integer.MIN_VALUE);
                OutputStream outputStream2 = outputStream;
                synchronized (outputStream2) {
                    outputStream.write(this.m_aData, 0, 32014);
                    outputStream.flush();
                }
                if (cacheConnection.logFile != null) {
                    cacheConnection.logFile.dump(this.m_aData, 0, 32014, 1, null);
                }
                System.arraycopy(this.m_aData, 32014, this.m_aData, 14, n2);
                this.m_iLastOffset = this.m_iLength = n2 + 14;
                this.m_iLastIndex = 1;
                SysList.write4ByteInt(this.m_aData, 8, n3);
            }
            catch (Exception exception) {
                throw new SQLException("Error writing parameters " + exception.getMessage());
            }
        }
        return n;
    }

    protected synchronized void setParameter(Object object) throws SQLException {
        if (object == null) {
            this.setNull();
            return;
        }
        if (object instanceof String) {
            if (this.maxItemSize != 0 && ((String)object).length() > this.maxItemSize) {
                throw new SQLException("Max item size (" + this.maxItemSize + ") exceeded");
            }
            if (((String)object).length() == 0) {
                char[] cArray = new char[]{'\u0000'};
                this.stuffAscii(new String(cArray));
                return;
            }
            if (this.m_isUnicode && this.isWide((String)object)) {
                this.stuffUnicode((String)object);
            } else {
                this.stuffAscii((String)object);
            }
            return;
        }
        if (object instanceof Integer) {
            if ((Integer)object < 0) {
                this.stuffNegInt((Integer)object);
            } else {
                this.stuffPosInt((Integer)object);
            }
            return;
        }
        if (object instanceof Double) {
            if (useIEEEDouble) {
                this.setIEEEDouble((Double)object);
            } else {
                this.stuffAscii(ListUtil.canonizeFloatingPointString(String.valueOf((Double)object), true));
            }
            return;
        }
        if (object instanceof Float) {
            this.stuffAscii(ListUtil.canonizeFloatingPointString(String.valueOf(((Float)object).floatValue()), true));
            return;
        }
        if (object instanceof BigDecimal) {
            this.set((BigDecimal)object);
        } else if (object instanceof Boolean) {
            this.set((Boolean)object);
        } else if (object instanceof Date) {
            this.set((Date)object);
        } else if (object instanceof Time) {
            this.set((Time)object);
        } else if (object instanceof Timestamp) {
            this.stuffAscii(ListUtil.canonizeTimestampString(String.valueOf((Timestamp)object)));
        } else if (object instanceof byte[]) {
            this.set((byte[])object);
        } else if (object instanceof Long) {
            if ((Long)object < 0L) {
                this.stuffNegLong((Long)object);
            } else {
                this.stuffPosLong((Long)object);
            }
        } else if (object instanceof BigInteger) {
            this.set((BigInteger)object);
        } else if (object instanceof Byte) {
            this.set(((Byte)object).byteValue());
        } else if (object instanceof Short) {
            if (((Short)object).intValue() < 0) {
                this.stuffNegInt(((Short)object).intValue());
            } else {
                this.stuffPosInt(((Short)object).intValue());
            }
        } else if (object instanceof Character) {
            this.set(object.toString());
        } else if (object instanceof SysList) {
            this.set((SysList)object);
        } else {
            throw new SQLException("Type out of range: " + object.getClass().getName(), "S1003");
        }
    }

    protected synchronized void setIntegerWrapper(Integer n) throws SQLException {
        if (n == null) {
            this.setNull();
        } else if (n < 0) {
            this.stuffNegInt(n);
        } else {
            this.stuffPosInt(n);
        }
    }

    protected synchronized void setByte(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull();
        } else {
            this.set(byArray);
        }
    }

    protected synchronized void setBooleanWrapper(Boolean bl) throws SQLException {
        if (bl == null) {
            this.setNull();
        } else {
            this.set(bl);
        }
    }

    protected synchronized void setDoubleWrapper(Double d) throws SQLException {
        if (d == null) {
            this.setNull();
        } else if (useIEEEDouble) {
            this.setIEEEDouble(d);
        } else {
            this.stuffAscii(String.valueOf(d));
        }
    }

    protected synchronized void setFloatWrapper(Float f) throws SQLException {
        if (f == null) {
            this.setNull();
        } else {
            this.stuffAscii(String.valueOf(f.floatValue()));
        }
    }

    protected synchronized void setString(String string) throws SQLException {
        this.set(string);
    }

    protected synchronized void setDate(Date date) throws SQLException {
        if (date == null) {
            this.setNull();
        } else {
            this.set(date);
        }
    }

    protected synchronized void setTime(Time time) throws SQLException {
        if (time == null) {
            this.setNull();
        } else {
            this.set(time);
        }
    }

    protected synchronized void setTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull();
        } else {
            this.set(timestamp);
        }
    }

    protected synchronized void setLongWrapper(Long l) throws SQLException {
        if (l == null) {
            this.setNull();
        } else if (l < 0L) {
            this.stuffNegLong(l);
        } else {
            this.stuffPosLong(l);
        }
    }

    protected synchronized void setShortWrapper(Short s) throws SQLException {
        if (s == null) {
            this.setNull();
        } else if (s.intValue() < 0) {
            this.stuffNegInt(s.intValue());
        } else {
            this.stuffPosInt(s.intValue());
        }
    }

    protected synchronized void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.set(bigDecimal);
        }
    }

    protected synchronized SysList getListEx() throws SQLException {
        if (this.m_iLastOffset == this.m_iLength) {
            throw new NoMoreDataException();
        }
        return this.getList();
    }

    protected synchronized SysList getList(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getList();
    }

    protected synchronized SysList getList() throws SQLException {
        if (this.eltLength()) {
            SysList sysList = new SysList(false, new byte[0]);
            sysList.setServerType(this.m_isUnicode, this.serverLocale);
            return sysList;
        }
        if (this.m_aData[this.m_pos] != 1) {
            throw new SQLException("Incorrect list format: item <> ITEM_ASCII", "S1000");
        }
        byte[] byArray = new byte[this.m_len];
        System.arraycopy(this.m_aData, this.m_pos + 1, byArray, 0, this.m_len);
        SysList sysList = new SysList(false, byArray);
        sysList.setServerType(this.m_isUnicode, this.serverLocale);
        return sysList;
    }

    protected synchronized byte[] getByte(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getByte();
    }

    protected synchronized byte[] getByte() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        if (this.m_len == 1 && this.m_aData[this.m_pos + 1] == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.m_len];
        System.arraycopy(this.m_aData, this.m_pos + 1, byArray, 0, this.m_len);
        return byArray;
    }

    protected synchronized String getStringEx() throws SQLException {
        if (this.m_iLastOffset == this.m_iLength) {
            throw new NoMoreDataException();
        }
        return this.getString();
    }

    protected synchronized String getString(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getString();
    }

    protected byte[] getByte(Descriptor descriptor, int n) throws SQLException {
        this.setReadPosition(n);
        return this.getByte(descriptor);
    }

    protected byte[] getByte(Descriptor descriptor) throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        if (this.m_len == 1 && this.m_aData[this.m_pos + 1] == 0) {
            return new byte[0];
        }
        int n = -1;
        if (this.maxFieldSize > 0 && (descriptor.type == -2 || descriptor.type == -3 || descriptor.type == -4 || descriptor.type == 1 || descriptor.type == 12 || descriptor.type == -1)) {
            n = this.maxFieldSize;
        }
        if (this.m_aData[this.m_pos] == 2) {
            byte[] byArray = ListUtil.getUTF8Bytes(this.m_aData, this.m_pos + 1, this.m_len, n);
            return byArray;
        }
        if (this.m_aData[this.m_pos] == 4) {
            byte[] byArray = new byte[]{ListUtil.dblbyte(0, this.grabPosLong(this.m_pos, this.m_len))};
            return byArray;
        }
        if (this.m_aData[this.m_pos] == 5) {
            byte[] byArray = new byte[]{ListUtil.dblbyte(0, this.grabNegLong(this.m_pos, this.m_len))};
            return byArray;
        }
        if (this.m_aData[this.m_pos] != 1) {
            throw new SQLException("Element cannot be read as byte[]", "S1000");
        }
        if (n > 0 && this.m_len > n) {
            this.m_len = n;
        }
        byte[] byArray = new byte[this.m_len];
        System.arraycopy(this.m_aData, this.m_pos + 1, byArray, 0, this.m_len);
        return byArray;
    }

    protected String getString(Descriptor descriptor, int n) throws SQLException {
        this.setReadPosition(n);
        return this.getString(descriptor);
    }

    protected double getDouble(Descriptor descriptor, int n) throws SQLException {
        this.setReadPosition(n);
        return this.getDouble(descriptor);
    }

    protected synchronized String getString(Descriptor descriptor) throws SQLException {
        if (descriptor.type == 2 || descriptor.type == 3) {
            BigDecimal bigDecimal = this.getBigDecimalScale(descriptor.scale);
            if (bigDecimal == null) {
                return null;
            }
            return bigDecimal.toString();
        }
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len == 1 && this.m_aData[this.m_pos] == 0) {
                    return new String("");
                }
                try {
                    String string = new String(this.m_aData, this.m_pos, this.m_len, this.serverLocale);
                    if (this.maxFieldSize > 0 && (descriptor.type == -2 || descriptor.type == -3 || descriptor.type == -4 || descriptor.type == 1 || descriptor.type == 12 || descriptor.type == -1)) {
                        if (string.length() > this.maxFieldSize / 2) {
                            return string.substring(0, this.maxFieldSize / 2);
                        }
                        return string;
                    }
                    return string;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + this.serverLocale, "S2208");
                }
            }
            case 2: {
                String string = this.grabUnicode();
                if (this.maxFieldSize > 0 && (descriptor.type == -2 || descriptor.type == -3 || descriptor.type == -4 || descriptor.type == 1 || descriptor.type == 12 || descriptor.type == -1)) {
                    if (string.length() > this.maxFieldSize / 2) {
                        return string.substring(0, this.maxFieldSize / 2);
                    }
                    return string;
                }
                return string;
            }
            case 4: {
                return this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] > 0 ? ListUtil.lngstr(this.grabPosLong(this.m_pos, this.m_len)) : this.grabBigInteger(this.m_pos, this.m_len, false).toString();
            }
            case 5: {
                return this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] < 0 ? ListUtil.lngstr(this.grabNegLong(this.m_pos, this.m_len)) : this.grabBigInteger(this.m_pos, this.m_len, true).toString();
            }
            case 6: {
                return this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] > 0 ? ListUtil.dblstr(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1)) : ListUtil.scaledDecimaltoString(this.m_aData[this.m_pos], this.grabBigInteger(this.m_pos + 1, this.m_len - 1, false));
            }
            case 7: {
                return this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] < 0 ? ListUtil.dblstr(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1)) : ListUtil.scaledDecimaltoString(this.m_aData[this.m_pos], this.grabBigInteger(this.m_pos + 1, this.m_len - 1, true));
            }
            case 8: {
                return String.valueOf(this.grabIEEEDouble(this.m_pos, this.m_len));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1003");
    }

    protected double getDouble(Descriptor descriptor) throws SQLException {
        return this.getDouble();
    }

    protected Double getDoubleWrapper(Descriptor descriptor, int n) throws SQLException {
        this.setReadPosition(n);
        double d = this.getDouble(descriptor);
        if (this.isNull) {
            return null;
        }
        return new Double(d);
    }

    protected synchronized BigDecimal getBigDecimal(Descriptor descriptor) throws SQLException {
        return this.getBigDecimalScale(descriptor.scale);
    }

    protected synchronized BigDecimal getBigDecimal(Descriptor descriptor, int n) throws SQLException {
        this.setReadPosition(n);
        return this.getBigDecimalScale(descriptor.scale);
    }

    protected synchronized BigDecimal getBigDecimalAutoScale(Descriptor descriptor) throws SQLException {
        return this.getBigDecimalAutoScale();
    }

    protected synchronized BigDecimal getBigDecimalAutoScale(Descriptor descriptor, int n) throws SQLException {
        this.setReadPosition(n);
        return this.getBigDecimalAutoScale();
    }

    protected synchronized String getString() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len == 1 && this.m_aData[this.m_pos] == 0) {
                    return new String("");
                }
                try {
                    return new String(this.m_aData, this.m_pos, this.m_len, this.serverLocale);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + this.serverLocale, "S2208");
                }
            }
            case 2: {
                return this.grabUnicode();
            }
            case 4: {
                return this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] > 0 ? ListUtil.lngstr(this.grabPosLong(this.m_pos, this.m_len)) : this.grabBigInteger(this.m_pos, this.m_len, false).toString();
            }
            case 5: {
                return this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] < 0 ? ListUtil.lngstr(this.grabNegLong(this.m_pos, this.m_len)) : this.grabBigInteger(this.m_pos, this.m_len, true).toString();
            }
            case 6: {
                return this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] > 0 ? ListUtil.dblstr(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1)) : ListUtil.scaledDecimaltoString(this.m_aData[this.m_pos], this.grabBigInteger(this.m_pos + 1, this.m_len - 1, false));
            }
            case 7: {
                return this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] < 0 ? ListUtil.dblstr(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1)) : ListUtil.scaledDecimaltoString(this.m_aData[this.m_pos], this.grabBigInteger(this.m_pos + 1, this.m_len - 1, true));
            }
            case 8: {
                return String.valueOf(this.grabIEEEDouble(this.m_pos, this.m_len));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1003");
    }

    protected synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getTimestamp(m_defaultCalendar);
    }

    protected synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.setReadPosition(n);
        return this.getTimestamp(calendar);
    }

    protected synchronized Timestamp getTimestamp() throws SQLException {
        return this.getTimestamp(m_defaultCalendar);
    }

    protected synchronized Timestamp getTimestamp(Calendar calendar) throws SQLException {
        int[] nArray = new int[3];
        int[] nArray2 = new int[4];
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len >= 19) {
                    ListUtil.readTimestampb(this.m_aData, this.m_pos, this.m_len, nArray, nArray2);
                    Calendar calendar2 = (Calendar)calendar.clone();
                    calendar2.set(nArray[0], nArray[1] - 1 + 0, nArray[2], nArray2[0], nArray2[1], nArray2[2]);
                    Timestamp timestamp = new Timestamp(calendar2.getTime().getTime());
                    timestamp.setNanos(nArray2[3]);
                    return timestamp;
                }
                if (this.m_len >= 10) {
                    ListUtil.readDateb(this.m_aData, this.m_pos, this.m_len, nArray);
                    Calendar calendar3 = (Calendar)calendar.clone();
                    calendar3.set(nArray[0], nArray[1] - 1 + 0, nArray[2], 0, 0, 0);
                    Timestamp timestamp = new Timestamp(calendar3.getTime().getTime());
                    timestamp.setNanos(0);
                    return timestamp;
                }
                throw new SQLException("Invalid Timestamp", "22008", 22008);
            }
            case 2: {
                throw new SQLException("Invalid Timestamp", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized Date getDate(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getDate(m_defaultCalendar);
    }

    protected synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        this.setReadPosition(n);
        return this.getDate(calendar);
    }

    protected synchronized Date getDate() throws SQLException {
        return this.getDate(m_defaultCalendar);
    }

    protected synchronized Date getDate(Calendar calendar) throws SQLException {
        int[] nArray = new int[3];
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len < 10) {
                    throw new SQLException("Invalid Date", "22008", 22008);
                }
                this.m_pos = ListUtil.readDateb(this.m_aData, this.m_pos, this.m_len, nArray);
                Calendar calendar2 = (Calendar)calendar.clone();
                calendar2.set(nArray[0], nArray[1] - 1 + 0, nArray[2], 0, 0, 0);
                calendar2.set(14, 0);
                return new Date(calendar2.getTime().getTime());
            }
            case 2: {
                throw new SQLException("Invalid Date", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized Time getTime(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getTime(false, m_defaultCalendar);
    }

    protected synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        this.setReadPosition(n);
        return this.getTime(true, calendar);
    }

    protected synchronized Time getTime() throws SQLException {
        return this.getTime(false, m_defaultCalendar);
    }

    protected synchronized Time getTime(Calendar calendar) throws SQLException {
        return this.getTime(true, calendar);
    }

    protected synchronized Time getTime(boolean bl, Calendar calendar) throws SQLException {
        int[] nArray = new int[4];
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len >= 19) {
                    if (this.m_aData[this.m_pos + 10] != 32) {
                        throw new SQLException("Invalid Timestamp", "22008", 22008);
                    }
                    this.m_len -= 11;
                    this.m_pos += 11;
                }
                if (this.m_len >= 8) {
                    this.m_pos = ListUtil.readTimeb(this.m_aData, this.m_pos, this.m_len, nArray);
                    Calendar calendar2 = (Calendar)calendar.clone();
                    calendar2.clear();
                    calendar2.set(11, nArray[0]);
                    calendar2.set(12, nArray[1]);
                    calendar2.set(13, nArray[2]);
                    calendar2.set(14, nArray[3] / 1000000);
                    return new Time(calendar2.getTime().getTime());
                }
                throw new SQLException("Invalid Time", "22008", 22008);
            }
            case 2: {
                throw new SQLException("Invalid Date", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized boolean getBoolean(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getBoolean();
    }

    protected synchronized boolean getBoolean() throws SQLException {
        if (this.eltLength()) {
            return false;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] lArray = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, lArray);
                return lArray[0] != 0L;
            }
            case 4: {
                if (this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] > 0) {
                    return this.grabPosLong(this.m_pos, this.m_len) != 0L;
                }
                BigInteger bigInteger = this.grabBigInteger(this.m_pos, this.m_len, false);
                return !bigInteger.equals(new BigInteger("0"));
            }
            case 5: 
            case 7: {
                return true;
            }
            case 6: {
                return this.grabPosLong(this.m_pos, this.m_len) != 0L;
            }
            case 8: {
                throw new SQLException("Invalid boolean: item = IEEE DOUBLE", "22008", 22008);
            }
            case 2: {
                throw new SQLException("Invalid boolean: item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized Boolean getBooleanWrapper(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getBooleanWrapper();
    }

    protected synchronized Boolean getBooleanWrapper() throws SQLException {
        boolean bl = this.getBoolean();
        if (this.isNull) {
            return null;
        }
        return new Boolean(bl);
    }

    protected synchronized short getShort(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getShort();
    }

    protected synchronized short getShort() throws SQLException {
        if (this.eltLength()) {
            return 0;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] lArray = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, lArray);
                return ListUtil.dblshort(this.m_pos, lArray[0]);
            }
            case 4: {
                return ListUtil.dblshort(0, this.grabPosLong(this.m_pos, this.m_len));
            }
            case 5: {
                return ListUtil.dblshort(0, this.grabNegLong(this.m_pos, this.m_len));
            }
            case 6: {
                return ListUtil.dblshort(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dblshort(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
            case 8: {
                return (short)this.grabIEEEDouble(this.m_pos, this.m_len);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized Short getShortWrapper(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getShortWrapper();
    }

    protected synchronized Short getShortWrapper() throws SQLException {
        short s = this.getShort();
        if (this.isNull) {
            return null;
        }
        return new Short(s);
    }

    protected synchronized BigDecimal getBigDecimalScale(int n, int n2) throws SQLException {
        this.setReadPosition(n);
        return this.getBigDecimalScale(n2);
    }

    protected synchronized BigDecimal getBigDecimalScale(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(n, 5);
    }

    protected synchronized BigDecimal getBigDecimalAutoScale(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getBigDecimalAutoScale();
    }

    protected synchronized BigDecimal getBigDecimalAutoScale() throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return null;
        }
        try {
            while (true) {
                bigDecimal = bigDecimal.setScale(bigDecimal.scale() - 1);
            }
        }
        catch (ArithmeticException arithmeticException) {
            return bigDecimal;
        }
    }

    protected synchronized byte getOneByte(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getOneByte();
    }

    protected synchronized byte getOneByte() throws SQLException {
        if (this.eltLength()) {
            return 0;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] lArray = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, lArray);
                return ListUtil.dblbyte(this.m_pos, lArray[0]);
            }
            case 4: {
                return ListUtil.dblbyte(0, this.grabPosLong(this.m_pos, this.m_len));
            }
            case 5: {
                return ListUtil.dblbyte(0, this.grabNegLong(this.m_pos, this.m_len));
            }
            case 6: {
                return ListUtil.dblbyte(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dblbyte(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 8: {
                return (byte)this.grabIEEEDouble(this.m_pos, this.m_len);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized int getInt(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getInt();
    }

    protected synchronized int getInt() throws SQLException {
        if (this.eltLength()) {
            return 0;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] lArray = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, lArray);
                return ListUtil.dblint(this.m_pos, lArray[0]);
            }
            case 4: {
                return ListUtil.dblint(0, this.grabPosLong(this.m_pos, this.m_len));
            }
            case 5: {
                return ListUtil.dblint(0, this.grabNegLong(this.m_pos, this.m_len));
            }
            case 6: {
                return ListUtil.dblint(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dblint(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 8: {
                return (int)this.grabIEEEDouble(this.m_pos, this.m_len);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized Integer getIntegerWrapper(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getIntegerWrapper();
    }

    protected synchronized Integer getIntegerWrapper() throws SQLException {
        int n = this.getInt();
        if (this.isNull) {
            return null;
        }
        return new Integer(n);
    }

    protected synchronized long getLong(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getLong();
    }

    protected synchronized long getLong() throws SQLException {
        if (this.eltLength()) {
            return 0L;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] lArray = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, lArray);
                return ListUtil.dbllong(this.m_pos, lArray[0]);
            }
            case 4: {
                return this.grabPosLong(this.m_pos, this.m_len);
            }
            case 5: {
                return this.grabNegLong(this.m_pos, this.m_len);
            }
            case 6: {
                return ListUtil.dbllong(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dbllong(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 8: {
                return (long)this.grabIEEEDouble(this.m_pos, this.m_len);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized Long getLongWrapper(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getLongWrapper();
    }

    protected synchronized Long getLongWrapper() throws SQLException {
        long l = this.getLong();
        if (this.isNull) {
            return null;
        }
        return new Long(l);
    }

    protected synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getBigDecimal();
    }

    protected synchronized BigDecimal getBigDecimal() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                return ListUtil.parsedecb(this.m_aData, this.m_pos, this.m_len);
            }
            case 4: {
                return this.grabBigDecimal(this.m_pos, this.m_len, 0, false);
            }
            case 5: {
                return this.grabBigDecimal(this.m_pos, this.m_len, 0, true);
            }
            case 6: {
                return this.grabBigDecimal(this.m_pos + 1, this.m_len - 1, this.m_aData[this.m_pos], false);
            }
            case 7: {
                return this.grabBigDecimal(this.m_pos + 1, this.m_len - 1, this.m_aData[this.m_pos], true);
            }
            case 8: {
                return new BigDecimal(this.grabIEEEDouble(this.m_pos, this.m_len));
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    protected synchronized double getDouble(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getDouble();
    }

    protected synchronized double getDouble() throws SQLException {
        if (this.eltLength()) {
            return 0.0;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                return ListUtil.parsedblb(this.m_aData, this.m_pos, this.m_len);
            }
            case 2: {
                return Double.parseDouble(this.grabUnicode());
            }
            case 4: {
                return this.grabPosLong(this.m_pos, this.m_len);
            }
            case 5: {
                return this.grabNegLong(this.m_pos, this.m_len);
            }
            case 6: {
                return ListUtil.dbl2dbl(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dbl2dbl(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 8: {
                return this.grabIEEEDouble(this.m_pos, this.m_len);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    private double grabIEEEDouble(int n, int n2) throws SQLException {
        byte by = this.m_aData[n + n2 - 1];
        boolean bl = by < 0;
        long l = bl ? this.grabNegLong(n, n2) : this.grabPosLong(n, n2);
        return Double.longBitsToDouble(l);
    }

    protected synchronized Double getDoubleWrapper(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getDoubleWrapper();
    }

    protected synchronized Double getDoubleWrapper() throws SQLException {
        double d = this.getDouble();
        if (this.isNull) {
            return null;
        }
        return new Double(d);
    }

    protected synchronized float getFloat(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getFloat();
    }

    protected synchronized float getFloat() throws SQLException {
        Float f = this.getFloatWrapper();
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    protected synchronized Float getFloatWrapper(int n) throws SQLException {
        this.setReadPosition(n);
        return this.getFloatWrapper();
    }

    protected synchronized Float getFloatWrapper() throws SQLException {
        double d = this.getDouble();
        if (this.isNull) {
            return null;
        }
        return new Float(d);
    }

    private long grabPosLong(int n, int n2) throws SQLException {
        long l = 0L;
        switch (n2) {
            case 8: {
                l = (long)this.m_aData[n + 7] << 56;
                if (l < 0L) break;
            }
            case 7: {
                l |= ((long)this.m_aData[n + 6] & 0xFFL) << 48;
            }
            case 6: {
                l |= ((long)this.m_aData[n + 5] & 0xFFL) << 40;
            }
            case 5: {
                l |= ((long)this.m_aData[n + 4] & 0xFFL) << 32;
            }
            case 4: {
                l |= ((long)this.m_aData[n + 3] & 0xFFL) << 24;
            }
            case 3: {
                l |= (long)((this.m_aData[n + 2] & 0xFF) << 16);
            }
            case 2: {
                l |= (long)((this.m_aData[n + 1] & 0xFF) << 8);
            }
            case 1: {
                return l |= (long)(this.m_aData[n] & 0xFF);
            }
            case 0: {
                return 0L;
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private synchronized long grabNegLong(int n, int n2) throws SQLException {
        switch (n2) {
            case 8: {
                n2 = this.m_aData[n + 7] << 24 | (this.m_aData[n + 6] & 0xFF) << 16 | (this.m_aData[n + 5] & 0xFF) << 8 | this.m_aData[n + 4] & 0xFF;
                if (n2 < 0) break;
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            case 7: {
                n2 = 0xFF000000 | (this.m_aData[n + 6] & 0xFF) << 16 | (this.m_aData[n + 5] & 0xFF) << 8 | this.m_aData[n + 4] & 0xFF;
                break;
            }
            case 6: {
                n2 = 0xFFFF0000 | (this.m_aData[n + 5] & 0xFF) << 8 | this.m_aData[n + 4] & 0xFF;
                break;
            }
            case 5: {
                n2 = 0xFFFFFF00 | this.m_aData[n + 4] & 0xFF;
                break;
            }
            case 4: {
                return (long)((this.m_aData[n + 3] & 0xFF) << 24 | (this.m_aData[n + 2] & 0xFF) << 16 | (this.m_aData[n + 1] & 0xFF) << 8 | this.m_aData[n] & 0xFF) | 0xFFFFFFFF00000000L;
            }
            case 3: {
                return (long)((this.m_aData[n + 2] & 0xFF) << 16 | (this.m_aData[n + 1] & 0xFF) << 8 | this.m_aData[n] & 0xFF) | 0xFFFFFFFFFF000000L;
            }
            case 2: {
                return (long)((this.m_aData[n + 1] & 0xFF) << 8 | this.m_aData[n] & 0xFF) | 0xFFFFFFFFFFFF0000L;
            }
            case 1: {
                return (long)(this.m_aData[n] & 0xFF) | 0xFFFFFFFFFFFFFF00L;
            }
            case 0: {
                return -1L;
            }
            default: {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
        }
        n = (this.m_aData[n + 3] & 0xFF) << 24 | (this.m_aData[n + 2] & 0xFF) << 16 | (this.m_aData[n + 1] & 0xFF) << 8 | this.m_aData[n] & 0xFF;
        return (long)n2 << 32 | (long)n & 0xFFFFFFFFL;
    }

    private synchronized BigInteger grabBigInteger(int n, int n2, boolean bl) {
        byte[] byArray;
        if (n2 == 0 || bl ^ this.m_aData[n + n2 - 1] < 0) {
            byArray = new byte[n2 + 1];
            byArray[0] = bl ? -1 : 0;
            for (int i = n2; i > 0; --i) {
                byArray[i] = this.m_aData[n++];
            }
        } else {
            byArray = new byte[n2];
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[i] = this.m_aData[n++];
            }
        }
        return new BigInteger(byArray);
    }

    private BigDecimal grabBigDecimal(int n, int n2, int n3, boolean bl) {
        return ListUtil.remainingPositiveScale(this.grabBigInteger(n, n2, bl), n3);
    }

    protected synchronized SysList set(SysList sysList) throws SQLException {
        if (this.maxItemSize != 0 && sysList.getLength() > this.maxItemSize) {
            throw new SQLException("Max item size (" + this.maxItemSize + ") exceeded");
        }
        this.stuffList(sysList);
        return this;
    }

    protected synchronized SysList set(int n) throws SQLException {
        if (n < 0) {
            this.stuffNegInt(n);
        } else {
            this.stuffPosInt(n);
        }
        return this;
    }

    protected synchronized SysList set(long l) throws SQLException {
        if (l < 0L) {
            this.stuffNegLong(l);
        } else {
            this.stuffPosLong(l);
        }
        return this;
    }

    protected synchronized SysList set(double d) throws SQLException {
        if (useIEEEDouble) {
            this.setIEEEDouble(d);
        } else {
            this.stuffAscii(String.valueOf(d));
        }
        return this;
    }

    protected synchronized SysList set(String string) throws SQLException {
        if (string == null) {
            this.setNull();
            return this;
        }
        if (this.maxItemSize != 0 && string.length() > this.maxItemSize) {
            throw new SQLException("Max item size (" + this.maxItemSize + ") exceeded");
        }
        if (string.length() == 0) {
            char[] cArray = new char[]{'\u0000'};
            this.stuffAscii(new String(cArray));
            return this;
        }
        if (this.m_isUnicode && this.isWide(string)) {
            this.stuffUnicode(string);
        } else {
            this.stuffAscii(string);
        }
        return this;
    }

    protected synchronized SysList set(Date date) throws SQLException {
        return this.set(m_sdfDateDefault.format(new java.util.Date(date.getTime())));
    }

    protected synchronized SysList set(Date date, Calendar calendar) throws SQLException {
        m_sdfDate.setCalendar(calendar);
        return this.set(m_sdfDate.format(new java.util.Date(date.getTime())));
    }

    protected synchronized SysList set(Time time) throws SQLException {
        return this.set(m_sdfTimeDefault.format(new java.util.Date(time.getTime())));
    }

    protected synchronized SysList set(Time time, Calendar calendar) throws SQLException {
        m_sdfTime.setCalendar(calendar);
        return this.set(m_sdfTime.format(new java.util.Date(time.getTime())));
    }

    protected synchronized SysList set(Timestamp timestamp) throws SQLException {
        return this.set(m_sdfTimestampDefault.format(timestamp));
    }

    protected synchronized SysList set(Timestamp timestamp, Calendar calendar) throws SQLException {
        m_sdfTimestamp.setCalendar(calendar);
        return this.set(m_sdfTimestamp.format(timestamp));
    }

    protected synchronized SysList set(boolean bl) throws SQLException {
        if (bl) {
            this.stuffPosInt(1);
        } else {
            this.stuffPosInt(0);
        }
        return this;
    }

    protected void setMapOfDatatypes(Map map) throws SQLException {
        SysList sysList = SysList.wrapMapOfDatatypes(map, this.m_isUnicode, this.serverLocale);
        this.set(sysList);
    }

    protected static SysList wrapMapOfDatatypes(Map map, boolean bl, String string) throws SQLException {
        SysList sysList = new SysList();
        sysList.setServerType(bl, string);
        SysList sysList2 = new SysList();
        sysList2.setServerType(bl, string);
        for (Object k : map.keySet()) {
            sysList2.set((String)k);
            sysList2.setParameter(map.get(k));
            sysList.set(sysList2);
            sysList2.clearList();
        }
        return sysList;
    }

    protected void setListOfDatatypes(List list) throws SQLException {
        SysList sysList = SysList.wrapListOfDatatypes(list, this.m_isUnicode, this.serverLocale);
        this.set(sysList);
    }

    protected static SysList wrapListOfDatatypes(List list, boolean bl, String string) throws SQLException {
        SysList sysList = new SysList();
        sysList.setServerType(bl, string);
        for (int i = 0; i < list.size(); ++i) {
            sysList.setParameter(list.get(i));
        }
        return sysList;
    }

    protected void setMapOfReferences(Map map) throws SQLException {
        SysList sysList = SysList.wrapMapOfReferences(map, this.m_isUnicode, this.serverLocale);
        this.set(sysList);
    }

    protected static SysList wrapMapOfReferences(Map map, boolean bl, String string) throws SQLException {
        SysList sysList = new SysList();
        sysList.setServerType(bl, string);
        SysList sysList2 = new SysList();
        sysList2.setServerType(bl, string);
        SysList sysList3 = new SysList();
        sysList3.setServerType(bl, string);
        for (Object k : map.keySet()) {
            sysList2.setParameter(map.get(k));
            sysList3.set((String)k);
            sysList3.set(sysList2);
            sysList.set(sysList3);
            sysList2.clearList();
            sysList3.clearList();
        }
        return sysList;
    }

    protected synchronized void setListOfReferences(List list) throws SQLException {
        SysList sysList = SysList.wrapListOfReferences(list, this.m_isUnicode, this.serverLocale);
        this.set(sysList);
    }

    protected static SysList wrapListOfReferences(List list, boolean bl, String string) throws SQLException {
        SysList sysList = new SysList();
        sysList.setServerType(bl, string);
        SysList sysList2 = new SysList();
        sysList2.setServerType(bl, string);
        for (int i = 0; i < list.size(); ++i) {
            sysList2.setParameter(list.get(i));
            sysList.set(sysList2);
            sysList2.clearList();
        }
        return sysList;
    }

    protected int setReadPosition(int n) throws SQLException {
        int n2;
        int n3;
        block13: {
            if (n == 0) {
                if (this.m_iLength == 0) {
                    throw new NoMoreDataException();
                }
                this.m_iLastOffset = 0;
                this.m_iLastIndex = 0;
                return 0;
            }
            if (n == this.m_iLastIndex) {
                if (this.m_iLastOffset == this.m_iLength) {
                    throw new NoMoreDataException();
                }
                return this.m_iLastIndex;
            }
            if (n > this.m_iLastIndex) {
                n3 = this.m_iLastIndex;
                n2 = this.m_iLastOffset;
            } else {
                n3 = 0;
                n2 = 0;
            }
            while (n2 < this.m_iLength) {
                if (this.m_aData[n2] == 0) {
                    if (n2 + 3 > this.m_iLength) {
                        throw new SQLException("Incorrect list format: " + (n2 + 3) + " > " + this.m_iLength, "S1000");
                    }
                    n2 += (this.m_aData[n2 + 1] & 0xFF | (this.m_aData[n2 + 2] & 0xFF) << 8) + 3;
                } else {
                    n2 += this.m_aData[n2] & 0xFF;
                }
                if (++n3 != n) continue;
                if (n2 > this.m_iLength) {
                    throw new SQLException("Incorrect list format: " + n2 + " > " + this.m_iLength, "S1000");
                }
                break block13;
            }
            if (n2 != this.m_iLength) {
                throw new SQLException("Incorrect list format: " + n2 + " > " + this.m_iLength, "S1000");
            }
            if (n3 < n) {
                throw new NoMoreDataException();
            }
        }
        this.m_iLastIndex = n3;
        this.m_iLastOffset = n2;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void dumpData(OutputStream outputStream, int n) throws IOException {
        int n2 = this.m_iLength - 14;
        SysList.write4ByteInt(this.m_aData, 0, n2);
        SysList.write4ByteInt(this.m_aData, 4, n);
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            outputStream.write(this.m_aData, 0, this.m_iLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void dumpData(OutputStream outputStream, int n, LogFileStream logFileStream) throws IOException {
        int n2;
        int n3;
        SysList.write4ByteInt(this.m_aData, 4, n);
        if (n3 < 32000) {
            SysList.write4ByteInt(this.m_aData, 0, n3);
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                outputStream.write(this.m_aData, 0, this.m_iLength);
            }
            if (logFileStream != null) {
                logFileStream.dump(this, 0, 1, null);
            }
            return;
        }
        byte[] byArray = new byte[14];
        System.arraycopy(this.m_aData, 0, byArray, 0, 14);
        int n4 = 14;
        int n5 = SysList.read4ByteInt(byArray, 8);
        for (n3 = this.m_iLength - 14; n3 > 0; n3 -= n2) {
            if (n3 > 32000) {
                n2 = 32000;
                n5 |= Integer.MIN_VALUE;
            } else {
                n2 = n3;
                n5 &= Integer.MAX_VALUE;
            }
            SysList.write4ByteInt(byArray, 0, n2);
            SysList.write4ByteInt(byArray, 8, n5);
            OutputStream outputStream3 = outputStream;
            synchronized (outputStream3) {
                outputStream.write(byArray, 0, 14);
                outputStream.write(this.m_aData, n4, n2);
            }
            if (logFileStream != null) {
                logFileStream.dump(this.m_aData, n4, n2, 1, byArray);
            }
            n4 += n2;
        }
    }

    protected synchronized void writeData(OutputStream outputStream) throws IOException {
        int n = this.m_iLength - 14;
        SysList.write4ByteInt(this.m_aData, 0, n);
        outputStream.write(this.m_aData, 0, this.m_iLength);
    }

    protected synchronized int getCurrentOffset() {
        return this.m_iLastOffset;
    }

    protected synchronized SysList getOutputParameterList(int n, int n2) {
        if (0 == n2) {
            SysList sysList = new SysList(this.m_aData, this.m_iLastOffset - n, n);
            sysList.setServerType(this.m_isUnicode, this.serverLocale);
            return sysList;
        }
        SysList sysList = new SysList(this.m_aData, this.m_iLastOffset - n, n);
        sysList.setServerType(this.m_isUnicode, this.serverLocale);
        sysList.stuffAscii(new String(""));
        return sysList;
    }

    protected synchronized void setUndefined() {
        if (this.m_iLength + 1 > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + 1);
        }
        this.m_aData[this.m_iLastOffset] = 1;
        ++this.m_iLength;
        ++this.m_iLastIndex;
        ++this.m_iLastOffset;
    }

    protected synchronized boolean isEnd() {
        return this.m_iLength == this.m_iLastOffset;
    }

    protected synchronized void isEndEx() throws NoMoreDataException {
        if (this.m_iLength == this.m_iLastOffset) {
            throw new NoMoreDataException();
        }
    }

    protected synchronized SysList getWire() {
        SysList sysList = new SysList(this.m_aData, this.m_iLength);
        sysList.setServerType(this.m_isUnicode, this.serverLocale);
        return sysList;
    }

    protected synchronized SysList getSubWire() {
        SysList sysList = new SysList(this.m_aData, this.m_iLength - this.m_iLastOffset, this.m_iLastOffset);
        sysList.setServerType(this.m_isUnicode, this.serverLocale);
        return sysList;
    }

    protected synchronized SysList setParameter(Object object, Object object2) throws SQLException {
        if (object == null) {
            this.setNull();
            return this;
        }
        if (object instanceof Date) {
            this.set((Date)object, (Calendar)object2);
            return this;
        }
        if (object instanceof Time) {
            this.set((Time)object, (Calendar)object2);
            return this;
        }
        if (object instanceof Timestamp) {
            this.set((Timestamp)object, (Calendar)object2);
            return this;
        }
        if (object2 instanceof Integer) {
            if (object instanceof Number) {
                this.setNumberWithScale((Number)object, (Integer)object2);
                return this;
            }
            if (object instanceof String) {
                this.setNumberWithScale(new Double((String)object), (Integer)object2);
                return this;
            }
            throw new SQLException("Type out of range", "S1003");
        }
        throw new SQLException("Type out of range " + object.getClass().getName() + " " + object2.getClass().getName(), "S1003");
    }

    protected synchronized void setNumberWithScale(Number number, int n) throws SQLException {
        this.set(new BigDecimal(number.toString()).setScale(n, 1));
    }

    protected synchronized int get2ByteInt() {
        this.m_iLastOffset += 2;
        ++this.m_iLastIndex;
        return this.m_aData[this.m_iLastOffset - 2] & 0xFF | (this.m_aData[this.m_iLastOffset - 1] & 0xFF) << 8;
    }

    protected synchronized void set2ByteInt(int n) {
        this.m_aData[this.m_iLastOffset] = (byte)n;
        this.m_aData[this.m_iLastOffset + 1] = (byte)(n >> 8);
        this.m_iLastOffset += 2;
        this.m_iLength += 2;
    }

    protected synchronized int get4ByteInt() {
        this.m_iLastOffset += 4;
        ++this.m_iLastIndex;
        return this.m_aData[this.m_iLastOffset - 4] & 0xFF | (this.m_aData[this.m_iLastOffset - 3] & 0xFF) << 8 | (this.m_aData[this.m_iLastOffset - 2] & 0xFF) << 16 | (this.m_aData[this.m_iLastOffset - 1] & 0xFF) << 24;
    }

    protected synchronized void setMessageCount(int n) {
        SysList.write4ByteInt(this.m_aData, 4, n);
    }

    protected synchronized void writeHeader(byte[] byArray) {
        SysList.write4ByteInt(this.m_aData, 8, 0);
        this.m_aData[12] = byArray[0];
        this.m_aData[13] = byArray[1];
        this.m_iLastOffset = 14;
        this.m_iLength = 14;
    }

    protected synchronized void writeHeader(int n, byte[] byArray) {
        SysList.write4ByteInt(this.m_aData, 8, n);
        this.m_aData[12] = byArray[0];
        this.m_aData[13] = byArray[1];
        this.m_iLastOffset = 14;
        this.m_iLength = 14;
    }

    protected synchronized void writeContinuationHeader(int n, byte[] byArray, boolean bl) {
        int n2 = this.m_iLength - 14;
        SysList.write4ByteInt(this.m_aData, 0, n2);
        if (bl) {
            SysList.write4ByteInt(this.m_aData, 8, n | Integer.MIN_VALUE);
        } else {
            SysList.write4ByteInt(this.m_aData, 8, n);
        }
        this.m_aData[12] = byArray[0];
        this.m_aData[13] = byArray[1];
    }

    protected synchronized void writeHeader(int n, int n2, int n3) {
        int n4 = this.m_iLength - 14;
        SysList.write4ByteInt(this.m_aData, 0, n4);
        SysList.write4ByteInt(this.m_aData, 4, n);
        SysList.write4ByteInt(this.m_aData, 8, n2);
        this.m_aData[12] = (byte)n3;
        this.m_aData[13] = (byte)(n3 >> 8);
    }

    protected synchronized void reserveHeader() {
        this.m_aData[0] = 0;
        this.m_aData[1] = 0;
        this.m_aData[2] = 0;
        this.m_aData[3] = 0;
        this.m_aData[4] = 0;
        this.m_aData[5] = 0;
        this.m_aData[6] = 0;
        this.m_aData[7] = 0;
        this.m_aData[8] = 0;
        this.m_aData[9] = 0;
        this.m_aData[10] = 0;
        this.m_aData[11] = 0;
        this.m_aData[12] = 0;
        this.m_aData[13] = 0;
        this.m_iLastOffset = 14;
        this.m_iLength = 14;
    }

    protected synchronized void clearList() {
        this.m_iLength = 0;
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    protected synchronized Object next() throws SQLException {
        if (this.m_iLastOffset == this.m_iLength) {
            throw new NoMoreDataException();
        }
        int n = this.m_iLastOffset;
        if (this.m_aData[n] != 0) {
            n += this.m_aData[n] & 0xFF;
        } else if (n + 2 < this.m_iLength) {
            n += (this.m_aData[n + 1] & 0xFF | (this.m_aData[n + 2] & 0xFF) << 8) + 3;
        }
        this.m_iLastOffset = n;
        ++this.m_iLastIndex;
        return null;
    }

    protected synchronized Object nextUnlessUndefined() throws SQLException {
        if (this.m_iLastOffset == this.m_iLength) {
            throw new NoMoreDataException();
        }
        if (this.m_aData[this.m_iLastOffset] == 1) {
            throw new SQLException("Output/Default parameter not assigned a value", "S1000");
        }
        return this.next();
    }

    protected synchronized int advance(int n, int n2) {
        int n3 = this.m_iLastOffset;
        while (n < n2) {
            if (n3 == this.m_iLength) {
                this.m_iLastOffset = n3;
                return n;
            }
            if (this.m_aData[n3] != 0) {
                n3 += this.m_aData[n3] & 0xFF;
            } else if (n3 + 2 < this.m_iLength) {
                n3 += (this.m_aData[n3 + 1] & 0xFF | (this.m_aData[n3 + 2] & 0xFF) << 8) + 3;
            }
            ++this.m_iLastIndex;
            ++n;
        }
        this.m_iLastOffset = n3;
        return n2;
    }

    protected synchronized boolean skip(int n) throws SQLException {
        int n2 = this.m_iLastOffset;
        for (int i = 0; i < n; ++i) {
            if (n2 == this.m_iLength) {
                this.m_iLastOffset = n2;
                return false;
            }
            if (this.m_aData[n2] != 0) {
                n2 += this.m_aData[n2] & 0xFF;
            } else if (n2 + 2 < this.m_iLength) {
                n2 += (this.m_aData[n2 + 1] & 0xFF | (this.m_aData[n2 + 2] & 0xFF) << 8) + 3;
            } else {
                throw new SQLException("Incorrect List Format", "S1000");
            }
            ++this.m_iLastIndex;
        }
        this.m_iLastOffset = n2;
        return true;
    }

    protected synchronized void readData(InputStream inputStream, int n) throws IOException {
        if (n + this.m_iLength > this.m_aData.length) {
            this.ensureBuffer(n + this.m_iLength);
        }
        int n2 = this.m_iLength;
        this.m_iLength += n;
        while (n > 0) {
            int n3 = inputStream.read(this.m_aData, n2, n);
            n2 += n3;
            n -= n3;
        }
    }

    protected synchronized int resetFDRead() {
        int n = this.m_iLength - this.currentRowOffset;
        System.arraycopy(this.m_aData, this.currentRowOffset, this.m_aData, 0, n);
        this.m_iLength = n;
        this.m_iLastIndex -= this.currentRowIndex;
        this.m_iLastOffset = n;
        this.currentRowIndex = 0;
        this.currentRowOffset = 0;
        return n;
    }

    protected synchronized void resetRead() {
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
        this.m_iLength = 0;
    }

    protected synchronized void saveCurrentRowPosition() {
        this.currentRowIndex = this.m_iLastIndex;
        this.currentRowOffset = this.m_iLastOffset;
    }

    protected synchronized void resetRow() {
        this.m_iLastIndex = this.currentRowIndex;
        this.m_iLastOffset = this.currentRowOffset;
    }

    protected synchronized void writeBatchCount(int n) {
        if (n == -1) {
            if (this.m_iLength + 4 > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + 4);
            }
            this.m_iLastOffset = 18;
            this.m_iLength = 18;
            return;
        }
        SysList.write4ByteInt(this.m_aData, 14, n);
    }

    protected final synchronized void writeInputStream(InputStream inputStream, int n, int n2, int n3, int n4, int n5, int n6) throws SQLException {
        if (n6 != -1) {
            this.writeInputStream(n6, inputStream, n, n2, n3, n5);
            return;
        }
        int n7 = -1;
        try {
            int n8;
            if (n2 == 1) {
                this.writeHeader(n5, CacheConnection.STORE_BINARY_STREAM);
            } else {
                this.writeHeader(n5, CacheConnection.STORE_CHARACTER_STREAM);
                if (n4 >= 25) {
                    n7 = this.m_iLastOffset;
                    this.m_iLength += 4;
                    this.m_iLastOffset += 4;
                }
            }
            int n9 = n8 = n2 == 0 ? this.m_iLength + n * 2 : this.m_iLength + n;
            if (n8 > this.m_aData.length) {
                this.ensureBuffer(n8);
            }
            String string = this.m_isUnicode ? null : this.serverLocale;
            int n10 = ListUtil.writeStream(inputStream, n2, n3, this.m_aData, n, this.m_iLastOffset, n7, string);
            this.m_iLastOffset += n10;
            this.m_iLength += n10;
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing stream: " + iOException.getMessage());
        }
    }

    protected final synchronized void writeInputStream(InputStream inputStream, int n, int n2, int n3) throws SQLException {
        int n4 = -1;
        try {
            int n5;
            n4 = this.m_iLastOffset;
            this.m_iLength += 4;
            this.m_iLastOffset += 4;
            int n6 = n5 = n2 == 0 ? this.m_iLength + n * 2 : this.m_iLength + n;
            if (n5 > this.m_aData.length) {
                this.ensureBuffer(n5);
            }
            String string = this.m_isUnicode ? null : this.serverLocale;
            int n7 = ListUtil.writeStream(inputStream, n2, n3, this.m_aData, n, this.m_iLastOffset, n4, string);
            this.m_iLastOffset += n7;
            this.m_iLength += n7;
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing stream: " + iOException.getMessage());
        }
    }

    protected final synchronized void writeInputStream(int n, InputStream inputStream, int n2, int n3, int n4, int n5) throws SQLException {
        int n6 = 0;
        try {
            if (n3 == 1) {
                this.writeHeader(n5, CacheConnection.STORE_BINARY_STREAM);
            } else {
                this.writeHeader(n5, CacheConnection.STORE_CHARACTER_STREAM);
            }
            if (this.m_iLength + n2 + 4 > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + n2 + 4);
            }
            SysList.write4ByteInt(this.m_aData, 14, n);
            this.m_iLastOffset = 18;
            this.m_iLength = 18;
            while (n2 > 0) {
                n6 = inputStream.read(this.m_aData, this.m_iLastOffset, n2);
                if (n6 == -1) {
                    return;
                }
                n2 -= n6;
                this.m_iLastOffset += n6;
                this.m_iLength += n6;
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing stream: " + iOException.getMessage());
        }
    }

    protected final synchronized void writeReader(Reader reader, int n) throws SQLException {
        int n2 = this.m_iLastOffset;
        this.m_iLength += 4;
        this.m_iLastOffset += 4;
        try {
            int n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = n3 = this.m_isUnicode ? n * 3 : n * 2;
            if (this.m_iLength + n3 > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + n3);
            }
            char[] cArray = new char[32768];
            while (n > 0) {
                int n7 = n > 32768 ? 32768 : n;
                if ((n7 = reader.read(cArray, 0, n7)) == -1) break;
                n4 += n7;
                n -= n7;
                for (int i = 0; i < n7; ++i) {
                    char c = cArray[i];
                    int n8 = ListUtil.getUTFBytes(c, this.m_aData, this.m_iLastOffset, this.m_aData.length - this.m_iLastOffset);
                    n5 += n8;
                    this.m_iLastOffset += n8;
                    if (n8 > 0) continue;
                    throw new SQLException("Buffer length is not enough", "S1000");
                }
            }
            this.m_iLength += n5;
            this.m_aData[n2++] = (byte)n4;
            this.m_aData[n2++] = (byte)(n4 >> 8);
            this.m_aData[n2++] = (byte)(n4 >> 16);
            this.m_aData[n2++] = (byte)(n4 >> 24);
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing stream: " + iOException.getMessage());
        }
    }

    protected final synchronized void writeReader(Reader reader, int n, int n2, int n3, int n4) throws SQLException {
        this.writeHeader(n3, CacheConnection.STORE_CHARACTER_STREAM);
        if (n4 != -1) {
            SysList.write4ByteInt(this.m_aData, 14, n4);
            this.m_iLength += 4;
            this.m_iLastOffset += 4;
        }
        try {
            int n5;
            int n6 = 0;
            int n7 = 0;
            int n8 = this.m_iLastOffset;
            if (n2 >= 25) {
                this.m_iLength += 4;
                this.m_iLastOffset += 4;
            }
            int n9 = n5 = this.m_isUnicode ? n * 3 : n * 2;
            if (this.m_iLength + n5 > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + n5);
            }
            char[] cArray = new char[32768];
            while (n > 0) {
                int n10 = n > 32768 ? 32768 : n;
                if ((n10 = reader.read(cArray, 0, n10)) == -1) break;
                n6 += n10;
                n -= n10;
                for (int i = 0; i < n10; ++i) {
                    char c = cArray[i];
                    int n11 = ListUtil.getUTFBytes(c, this.m_aData, this.m_iLastOffset, this.m_aData.length - this.m_iLastOffset);
                    n7 += n11;
                    this.m_iLastOffset += n11;
                    if (n11 > 0) continue;
                    throw new SQLException("Buffer length is not enough", "S1000");
                }
            }
            this.m_iLength += n7;
            if (n2 >= 25) {
                this.m_aData[n8++] = (byte)n6;
                this.m_aData[n8++] = (byte)(n6 >> 8);
                this.m_aData[n8++] = (byte)(n6 >> 16);
                this.m_aData[n8++] = (byte)(n6 >> 24);
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing stream: " + iOException.getMessage());
        }
    }

    protected synchronized void setRawBytes(byte[] byArray) throws IOException {
        if (byArray.length + 14 > this.m_aData.length) {
            this.ensureBuffer(byArray.length + 14);
        }
        System.arraycopy(byArray, 0, this.m_aData, 14, byArray.length);
        this.m_iLastOffset += byArray.length;
        this.m_iLength += byArray.length;
    }

    protected int getLength() {
        return this.m_iLength;
    }

    protected byte[] getm_aData() {
        return this.m_aData;
    }

    protected byte[] getData() {
        byte[] byArray = new byte[this.m_iLength];
        System.arraycopy(this.m_aData, 0, byArray, 0, this.m_iLength);
        return byArray;
    }

    protected void addRawBytes(byte[] byArray) {
        int n = this.m_iLength + byArray.length;
        if (n > this.m_aData.length) {
            this.ensureBuffer(n);
        }
        System.arraycopy(byArray, 0, this.m_aData, this.m_iLength, byArray.length);
        this.m_iLastOffset = n;
        this.m_iLength = n;
    }

    protected void addRawBytes(SysList sysList) {
        byte[] byArray = sysList.m_aData;
        int n = sysList.m_iLength;
        int n2 = this.m_iLength + n;
        if (n2 > this.m_aData.length) {
            this.ensureBuffer(n2);
        }
        System.arraycopy(byArray, 0, this.m_aData, this.m_iLength, n);
        this.m_iLastOffset = n2;
        this.m_iLength = n2;
    }

    protected void setMaxFieldSize(int n) {
        this.maxFieldSize = n;
    }

    protected int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    protected SysList append(SysList sysList) throws SQLException {
        int n = sysList.m_iLength;
        if (this.m_iLength + n > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + n);
        }
        System.arraycopy(sysList.m_aData, 0, this.m_aData, this.m_iLength, n);
        this.m_iLastOffset += n;
        this.m_iLength += n;
        return this;
    }

    protected SysList appendBytes(byte[] byArray) throws SQLException {
        int n = byArray.length;
        if (this.m_iLength + n > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + n);
        }
        System.arraycopy(byArray, 0, this.m_aData, this.m_iLength, n);
        this.m_iLastOffset += n;
        this.m_iLength += n;
        return this;
    }

    protected synchronized SysList getWrappedItem() throws SQLException {
        return this.getSubList(1);
    }

    protected final synchronized SysList getSubList(int n) throws SQLException {
        int n2;
        int n3 = this.m_iLastOffset;
        for (n2 = 0; n2 < n; ++n2) {
            this.eltLength();
        }
        n2 = this.m_iLastOffset - n3;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_aData, n3, byArray, 0, n2);
        SysList sysList = new SysList(false, byArray);
        sysList.setServerType(this.m_isUnicode, this.serverLocale);
        return sysList;
    }

    protected Object getParameter() throws SQLException {
        Object object = this.grabParameter();
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0 && byArray[0] == 0) {
                return new String("");
            }
            try {
                return new String(byArray, this.serverLocale);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + this.serverLocale, "S2208");
            }
        }
        return object;
    }

    private Object grabParameter() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                byte[] byArray = new byte[this.m_len];
                System.arraycopy(this.m_aData, this.m_pos, byArray, 0, this.m_len);
                return byArray;
            }
            case 2: {
                return this.grabUnicode();
            }
            case 4: {
                if (this.m_len < 4 || this.m_len == 4 && this.m_aData[this.m_pos + 3] > 0) {
                    return new Integer((int)this.grabPosLong(this.m_pos, this.m_len));
                }
                if (this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] > 0) {
                    return new Long(this.grabPosLong(this.m_pos, this.m_len));
                }
                return this.grabBigInteger(this.m_pos, this.m_len, false);
            }
            case 5: {
                if (this.m_len < 4 || this.m_len == 4 && this.m_aData[this.m_pos + 3] < 0) {
                    return new Integer((int)this.grabNegLong(this.m_pos, this.m_len));
                }
                if (this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] < 0) {
                    return new Long(this.grabNegLong(this.m_pos, this.m_len));
                }
                return this.grabBigInteger(this.m_pos, this.m_len, true);
            }
            case 6: {
                if (this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] > 0) {
                    return new Double(ListUtil.dbl2dbl(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1)));
                }
                return this.grabBigDecimal(this.m_pos + 1, this.m_len - 1, this.m_aData[this.m_pos], false);
            }
            case 7: {
                if (this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] < 0) {
                    return new Double(ListUtil.dbl2dbl(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1)));
                }
                return this.grabBigDecimal(this.m_pos + 1, this.m_len - 1, this.m_aData[this.m_pos], true);
            }
            case 8: {
                return new Double(this.grabIEEEDouble(this.m_pos, this.m_len));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1003");
    }

    public boolean equals(Object object) {
        if (!(object instanceof SysList)) {
            return false;
        }
        SysList sysList = (SysList)object;
        if (this.m_iLength != sysList.m_iLength) {
            return false;
        }
        for (int i = 0; i < this.m_iLength; ++i) {
            if (this.m_aData[i] == sysList.m_aData[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n = this.m_iLastIndex;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("$lb(");
        if (this.m_iLength == 0) {
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        try {
            this.setReadPosition(0);
            if (!this.isEnd()) {
                this.toStringBuffer(stringBuffer);
            }
            while (!this.isEnd()) {
                stringBuffer.append(',');
                this.toStringBuffer(stringBuffer);
            }
            stringBuffer.append(")");
        }
        catch (SQLException sQLException) {
            stringBuffer.append("! Exception: " + sQLException.getMessage());
        }
        try {
            this.setReadPosition(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private void toStringBuffer(StringBuffer stringBuffer) throws SQLException {
        Object object = this.grabParameter();
        if (object instanceof byte[]) {
            SysList sysList = new SysList((byte[])object);
            StringBuffer stringBuffer2 = new StringBuffer("$lb(");
            try {
                if (!sysList.isEnd()) {
                    sysList.toStringBuffer(stringBuffer2);
                }
                while (!sysList.isEnd()) {
                    stringBuffer2.append(',');
                    sysList.toStringBuffer(stringBuffer2);
                }
                stringBuffer2.append(')');
                stringBuffer.append(stringBuffer2);
            }
            catch (SQLException sQLException) {
                try {
                    stringBuffer.append(new String((byte[])object, this.serverLocale));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    stringBuffer.append(new String((byte[])object));
                }
            }
        } else {
            stringBuffer.append(object);
        }
    }

    protected void moveToEnd() throws SQLException {
        int n = this.m_iLastOffset;
        while (n < this.m_iLength) {
            if (this.m_aData[n] == 0) {
                if (n + 3 > this.m_iLength) {
                    throw new SQLException("Incorrect list format: " + (n + 3) + " > " + this.m_iLength, "S1000");
                }
                n += (this.m_aData[n + 1] & 0xFF | (this.m_aData[n + 2] & 0xFF) << 8) + 3;
            } else {
                n += this.m_aData[n] & 0xFF;
            }
            ++this.m_iLastIndex;
        }
        if (n != this.m_iLength) {
            throw new SQLException("Incorrect list format: " + n + " > " + this.m_iLength, "S1000");
        }
        this.m_iLastOffset = this.m_iLength;
    }

    protected SysList cloneMe() throws SQLException {
        SysList sysList = new SysList();
        sysList = this;
        return sysList;
    }

    protected synchronized void reset() {
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    protected synchronized void resetHeader() {
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 14;
        this.m_iLength = 14;
    }

    protected static int read4ByteInt(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        n2 |= (byArray[n + 1] & 0xFF) << 8;
        n2 |= (byArray[n + 2] & 0xFF) << 16;
        return n2 |= (byArray[n + 3] & 0xFF) << 24;
    }

    protected static void write4ByteInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n + 2] = (byte)(n2 >> 16);
        byArray[n + 3] = (byte)(n2 >> 24);
    }

    protected void setMaxItemSize(int n) {
        this.maxItemSize = n;
    }

    protected int getMaxItemSize() {
        return this.maxItemSize;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.m_iLength; ++i) {
            n += 29 * this.m_aData[i];
        }
        return n;
    }

    static {
        useIEEEDouble = true;
        defaultEncoding = new InputStreamReader(System.in).getEncoding();
        if (defaultEncoding.equals("Cp1252")) {
            defaultEncoding = "ISO8859_1";
        }
        m_defaultCalendar = Calendar.getInstance();
        m_sdfDate = new SimpleDateFormat("yyyy-MM-dd");
        m_sdfTime = new SimpleDateFormat("HH:mm:ss.SSS");
        m_sdfTimestamp = new TimestampFormat();
        m_sdfDateDefault = new SimpleDateFormat("yyyy-MM-dd");
        m_sdfDateDefault.setCalendar(m_defaultCalendar);
        m_sdfTimeDefault = new SimpleDateFormat("HH:mm:ss.SSS");
        m_sdfTimeDefault.setCalendar(m_defaultCalendar);
        m_sdfTimestampDefault = new TimestampFormat();
        m_sdfTimestampDefault.setCalendar(m_defaultCalendar);
    }

    protected class NoMoreDataException
    extends SQLException {
        NoMoreDataException() {
            super("Invalid column number", "S1002");
        }
    }
}

