/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbcgateway;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class JDBCGateway {
    ArrayList connList = new ArrayList();
    ArrayList stmtList = new ArrayList();
    ArrayList rsList = new ArrayList();
    HashMap connToSt = new HashMap();
    HashMap connToRs = new HashMap();
    HashMap stToRs = new HashMap();
    HashMap stToMd = new HashMap();
    SQLException sqlEx = null;

    public String getErrorText() {
        if (this.sqlEx == null) {
            return "";
        }
        return this.sqlEx.getMessage();
    }

    public String getString(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            return resultSet.getString(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public int setString(int n, int n2, String string) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            preparedStatement.setString(n2, string);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int setValue(int n, int n2, String string, int n3) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                int n4 = parameterMetaData.getParameterType(n2);
                if (string == null) {
                    preparedStatement.setNull(n2, n4);
                    return 0;
                }
                switch (n4) {
                    case 93: {
                        preparedStatement.setTimestamp(n2, Timestamp.valueOf(string));
                        break;
                    }
                    case 91: {
                        preparedStatement.setDate(n2, Date.valueOf(string));
                        break;
                    }
                    default: {
                        preparedStatement.setString(n2, string);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                switch (n3) {
                    case 11: 
                    case 93: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 93);
                            break;
                        }
                        preparedStatement.setTimestamp(n2, Timestamp.valueOf(string));
                        break;
                    }
                    case 9: 
                    case 91: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 91);
                            break;
                        }
                        preparedStatement.setDate(n2, Date.valueOf(string.substring(0, 10)));
                        break;
                    }
                    case -5: {
                        if (string == null) {
                            preparedStatement.setNull(n2, -5);
                            break;
                        }
                        preparedStatement.setLong(n2, Long.parseLong(string));
                        break;
                    }
                    case 6: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 6);
                            break;
                        }
                        preparedStatement.setFloat(n2, Float.parseFloat(string));
                        break;
                    }
                    case 4: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 4);
                            break;
                        }
                        preparedStatement.setInt(n2, Integer.parseInt(string));
                        break;
                    }
                    case 2: 
                    case 8: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 2);
                            break;
                        }
                        preparedStatement.setDouble(n2, Double.parseDouble(string));
                        break;
                    }
                    case 5: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 5);
                            break;
                        }
                        preparedStatement.setShort(n2, Short.parseShort(string));
                        break;
                    }
                    case -7: 
                    case 16: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 16);
                            break;
                        }
                        boolean bl = true;
                        if (string.equals("") || string.equals("0")) {
                            bl = false;
                        }
                        preparedStatement.setBoolean(n2, bl);
                        break;
                    }
                    default: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 1);
                            break;
                        }
                        preparedStatement.setString(n2, string);
                    }
                }
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int registerOutParameter(int n, int n2, int n3) {
        this.sqlEx = null;
        if (n3 == 0) {
            n3 = 12;
        }
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            callableStatement.registerOutParameter(n2, n3);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public boolean wasError() {
        return this.sqlEx != null;
    }

    public boolean next(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            return resultSet.next();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return false;
        }
    }

    public boolean cnext(int n) {
        this.sqlEx = null;
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            return resultSet.next();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return false;
        }
    }

    public String cgetString(int n, int n2) {
        this.sqlEx = null;
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            return resultSet.getString(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public int execUpdate(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            return preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int connect(String string, String string2, String string3) {
        int n = -1;
        this.sqlEx = null;
        try {
            Connection connection = DriverManager.getConnection(string, string2, string3);
            if (connection == null) {
                return n;
            }
            n = this.addConnection(connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n;
    }

    public int connectWithPropString(String string, String string2) {
        int n = -1;
        this.sqlEx = null;
        try {
            Object object;
            Properties properties = new Properties();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).indexOf(61) == -1) continue;
                String string3 = ((String)object).substring(0, ((String)object).indexOf(61));
                String string4 = ((String)object).substring(((String)object).indexOf(61) + 1);
                properties.put(string3, string4);
            }
            object = DriverManager.getConnection(string, properties);
            if (object == null) {
                return n;
            }
            n = this.addConnection(object);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n;
    }

    public int execQuery(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = preparedStatement.executeQuery();
            this.addRsToMap((Object)preparedStatement, resultSet);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.addMdToMap(preparedStatement, resultSetMetaData);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getTables(int n, String string, String string2, String string3, String[] stringArray) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(string, string2, string3, stringArray);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getColumns(int n, String string, String string2, String string3, String string4) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(string, string2, string3, string4);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getPrimaryKeys(int n, String string, String string2, String string3) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getPrimaryKeys(string, string2, string3);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getProcedureColumns(int n, String string, String string2, String string3, String string4) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, string4);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getProcedures(int n, String string, String string2, String string3) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getProcedures(string, string2, string3);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int columnCount(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getColumnType(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnType(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getPrecision(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getPrecision(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getScale(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getScale(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public String getColumnName(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnName(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public String columnTypeName(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnTypeName(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public int removeStatement(int n) {
        try {
            this.sqlEx = null;
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            this.stToRs.remove(preparedStatement);
            this.stToMd.remove(preparedStatement);
            this.stmtList.set(n, null);
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int removeResultSet(int n) {
        try {
            this.sqlEx = null;
            this.rsList.set(n, null);
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int closeAll() {
        for (int i = 0; i < this.connList.size(); ++i) {
            if (this.connList.get(i) == null) continue;
            Connection connection = (Connection)this.connList.get(i);
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeConnection(i);
        }
        return 0;
    }

    public int removeConnection(int n) {
        try {
            Connection connection = (Connection)this.connList.get(n);
            ArrayList arrayList = (ArrayList)this.connToSt.get(connection);
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i) == null) continue;
                Integer n2 = (Integer)arrayList.get(i);
                this.removeStatement(n2);
            }
            ArrayList arrayList2 = (ArrayList)this.connToRs.get(connection);
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (arrayList2.get(i) == null) continue;
                Integer n3 = (Integer)arrayList2.get(i);
                this.removeResultSet(n3);
            }
            this.connList.set(n, null);
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getColumnCount(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int prepareStatement(int n, String string) {
        this.sqlEx = null;
        int n2 = -1;
        try {
            Connection connection = (Connection)this.connList.get(n);
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            n2 = this.addStatement(preparedStatement, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n2;
    }

    public int prepareCall(int n, String string) {
        this.sqlEx = null;
        int n2 = -1;
        try {
            Connection connection = (Connection)this.connList.get(n);
            CallableStatement callableStatement = connection.prepareCall(string);
            n2 = this.addStatement(callableStatement, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n2;
    }

    private int addConnection(Object object) {
        for (int i = 1; i < this.connList.size(); ++i) {
            if (this.connList.get(i) != null) continue;
            this.connList.set(i, object);
            return i;
        }
        this.connList.add(object);
        return this.connList.size() - 1;
    }

    private void addStToMap(Object object, int n) {
        ArrayList arrayList;
        if (!this.connToSt.containsKey(object)) {
            arrayList = new ArrayList();
            this.connToSt.put(object, arrayList);
        } else {
            arrayList = (ArrayList)this.connToSt.get(object);
        }
        arrayList.add(new Integer(n));
    }

    private void addRsToMap(Object object, int n) {
        ArrayList arrayList;
        if (!this.connToRs.containsKey(object)) {
            arrayList = new ArrayList();
            this.connToRs.put(object, arrayList);
        } else {
            arrayList = (ArrayList)this.connToRs.get(object);
        }
        arrayList.add(new Integer(n));
    }

    private void addRsToMap(Object object, Object object2) {
        this.stToRs.put(object, object2);
    }

    private void addMdToMap(Object object, Object object2) {
        this.stToMd.put(object, object2);
    }

    private int addStatement(Object object, Object object2) {
        for (int i = 1; i < this.stmtList.size(); ++i) {
            if (this.stmtList.get(i) != null) continue;
            this.stmtList.set(i, object);
            this.addStToMap(object2, i);
            return i;
        }
        this.stmtList.add(object);
        this.addStToMap(object2, this.stmtList.size() - 1);
        return this.stmtList.size() - 1;
    }

    private int addResultSet(Object object, Object object2) {
        for (int i = 1; i < this.stmtList.size(); ++i) {
            if (this.stmtList.get(i) != null) continue;
            this.stmtList.set(i, object);
            this.addRsToMap(object2, i);
            return i;
        }
        this.rsList.add(object);
        this.addRsToMap(object2, this.stmtList.size() - 1);
        return this.rsList.size() - 1;
    }
}

