/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo;

import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheDriver;
import com.intersys.pojo.ObjectManager;
import com.intersys.pojo.ObjectManagerFactory;
import com.intersys.pojo.Settings;
import com.intersys.pojo.runtime.ApplicationSettings;
import com.intersys.pojo.runtime.CacheObjectManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class ApplicationContext
implements ObjectManagerFactory {
    private boolean mIsOpen = false;
    private Properties mProperties;
    private DataSource mDataSource;
    private String mURL;
    private String mUsername;
    private String mPassword;
    private Settings mSettings = new ApplicationSettings();
    Map mPool;

    public static ObjectManager createObjectManager(Connection connection) throws Exception {
        return new CacheObjectManager(connection, null);
    }

    public static ObjectManager createObjectManager(Connection connection, String string) throws Exception {
        return new CacheObjectManager(connection, string, false, null);
    }

    public static ObjectManager createObjectManager(String string, String string2, String string3) throws Exception {
        return new CacheObjectManager(string, string2, string3, (Settings)null);
    }

    public static ObjectManager createObjectManager(String string, String string2, String string3, String string4) throws Exception {
        return new CacheObjectManager(string, string2, string3, string4);
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    public void close() throws Exception {
        this.mIsOpen = false;
        this.mURL = null;
        this.mUsername = null;
        this.mPassword = null;
        this.mProperties = null;
        this.mDataSource = null;
        this.clearPool();
    }

    public void setProperties(Properties properties) {
        if (this.mDataSource != null) {
            throw new IllegalStateException("This Application context has already been initialized using DataSource");
        }
        if (this.mUsername != null) {
            throw new IllegalStateException("This Application context has already been initialized using username and password");
        }
        this.mURL = properties.getProperty("url");
        if (this.mURL == null) {
            this.mURL = properties.getProperty("URL");
        }
        if (this.mURL == null) {
            throw new IllegalArgumentException("Properties do not comtain URL.");
        }
        this.mProperties = properties;
        this.mIsOpen = true;
    }

    public Settings defaultSettings() {
        return this.mSettings;
    }

    public void setConnectionOptions(String string, String string2, String string3) {
        if (this.mProperties != null) {
            throw new IllegalStateException("This Application context has already been initialized using Properties");
        }
        if (this.mDataSource != null) {
            throw new IllegalStateException("This Application context has already been initialized using DataSource");
        }
        this.mURL = string;
        this.mUsername = string2;
        this.mPassword = string3;
        this.mIsOpen = true;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.mProperties != null) {
            throw new IllegalStateException("This Application context has already been initialized using Properties");
        }
        if (this.mURL != null) {
            throw new IllegalStateException("This Application context has already been initialized using username and password");
        }
        this.mDataSource = dataSource;
        this.mIsOpen = true;
    }

    public ObjectManager createObjectManager() throws Exception {
        return this.createObjectManager(null);
    }

    public ObjectManager createObjectManager(String string) throws Exception {
        Connection connection;
        if (!this.mIsOpen) {
            throw new IllegalStateException("ObjectManagerFactory is not open.");
        }
        new CacheDriver();
        if (this.mProperties != null) {
            connection = DriverManager.getConnection(this.mURL, this.mProperties);
        } else if (this.mUsername != null) {
            connection = DriverManager.getConnection(this.mURL, this.mUsername, this.mPassword);
        } else if (this.mDataSource != null) {
            connection = this.mDataSource.getConnection();
        } else {
            throw new IllegalStateException("Application Persistent context is not initialized");
        }
        return this.createPooledObjectManager(connection, string);
    }

    private ObjectManager createPooledObjectManager(Connection connection, String string) throws Exception {
        this.checkPool(connection, string);
        CacheObjectManager cacheObjectManager = new CacheObjectManager(connection, string, true, this.mSettings);
        return cacheObjectManager;
    }

    private void checkPool(Connection connection, String string) throws Exception {
        CacheConnection cacheConnection;
        CacheObjectManager cacheObjectManager;
        if (this.mPool == null) {
            this.mPool = new HashMap();
        }
        if ((cacheObjectManager = (CacheObjectManager)this.mPool.get(cacheConnection = JDBCAdapter.getCacheConnection(connection))) != null && cacheObjectManager.isOpen()) {
            return;
        }
        cacheObjectManager = new CacheObjectManager(connection, string, false, this.mSettings);
        this.mPool.put(cacheConnection, cacheObjectManager);
    }

    private void clearPool() throws Exception {
        if (this.mPool == null) {
            return;
        }
        for (CacheObjectManager cacheObjectManager : this.mPool.values()) {
            if (!cacheObjectManager.isOpen()) continue;
            cacheObjectManager.close();
        }
    }
}

