/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.runtime;

import com.intersys.classes.CacheRootObject;
import com.intersys.classes.SerialObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.pojo.runtime.dynamic.Proxy;
import com.intersys.pojo.runtime.dynamic.ProxyGenerator;
import com.intersys.pojo.runtime.dynamic.Shadow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectFactory {
    private int mPolicy;
    private ProxyGenerator mProxyGenerator;
    public static boolean dynamicProxyFactoryInitialized = false;

    public ObjectFactory() {
        this.determineDefaultPolicy();
        this.mProxyGenerator = null;
    }

    public Object newPOJO(Class clazz, CacheClass cacheClass, CacheRootObject cacheRootObject, boolean bl) throws IllegalAccessException, InstantiationException, CacheException {
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        if (cacheRootObject instanceof SerialObject) {
            bl2 = true;
        }
        if (cacheClass.eagerFetchRequiredForPOJO()) {
            bl2 = true;
        }
        if (bl2) {
            return clazz.newInstance();
        }
        switch (this.mPolicy) {
            case 1: {
                return clazz.newInstance();
            }
            case 2: {
                return this.proxyGenerator().getDynamicProxy(clazz, cacheRootObject);
            }
        }
        throw new IllegalStateException("Policy is undefined.");
    }

    public List newList(Class clazz) throws IllegalAccessException {
        try {
            return (List)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return new ArrayList();
        }
    }

    public Map newMap(Class clazz) throws IllegalAccessException {
        try {
            return (Map)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return new HashMap();
        }
    }

    public static boolean isProxy(Object object) {
        if (!dynamicProxyFactoryInitialized) {
            return false;
        }
        return Proxy.isProxy(object);
    }

    public static Class getOriginalClass(Object object) {
        if (ObjectFactory.isProxy(object)) {
            return object.getClass().getSuperclass();
        }
        return object.getClass();
    }

    public static Class getOriginalClass(Class clazz) {
        if (Shadow.class.isAssignableFrom(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    protected int getPolicy() {
        return this.mPolicy;
    }

    protected int setPolicy(int n) {
        int n2 = this.mPolicy;
        this.mPolicy = n;
        return n2;
    }

    private final void determineDefaultPolicy() {
        String string = System.getProperty("com.intersys.pojo.fetch_policy");
        this.mPolicy = "EAGER".equalsIgnoreCase(string) ? 1 : ("LAZY".equalsIgnoreCase(string) ? 2 : 1);
    }

    private ProxyGenerator proxyGenerator() {
        if (this.mProxyGenerator == null) {
            this.mProxyGenerator = new ProxyGenerator();
        }
        return this.mProxyGenerator;
    }
}

