/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.runtime;

import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.pojo.runtime.DetachedObjectsManager;
import com.intersys.pojo.runtime.ObjectFactory;
import com.intersys.pojo.runtime.dynamic.Shadow;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PojoOperations {
    private static final String DEFAULT_ROW_ID_FIELD = "rowId";

    public static Object getValue(Object object, String string, DetachedObjectsManager detachedObjectsManager) throws IllegalAccessException, InvocationTargetException, CacheException {
        try {
            Method method = PojoOperations.getGetter(object, string, detachedObjectsManager);
            return method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Field field = PojoOperations.getField(object, string);
                field.setAccessible(true);
                return field.get(object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (string.equals("Id")) {
                    return null;
                }
                if (string.equals("_Version")) {
                    return PojoOperations.getConcurrencyControlVersion(object);
                }
                throw new CacheException("Neither accessor method nor field is found for property " + string);
            }
        }
    }

    public static Long getConcurrencyControlVersion(Object object) {
        return new Long(-1L);
    }

    public static void setConcurrencyControlVersion(Object object, Object object2) {
    }

    public static Method getGetter(Object object, String string, DetachedObjectsManager detachedObjectsManager) throws NoSuchMethodException {
        Class<?> clazz = object.getClass();
        String string2 = "get" + string;
        Method method = detachedObjectsManager.getMethod(clazz, string2, new Class[0]);
        return method;
    }

    public static Field getField(Object object, String string) throws NoSuchFieldException {
        Field field;
        Class<?> clazz = object.getClass();
        try {
            field = clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = PojoOperations.getPrivateField(clazz, string);
        }
        return field;
    }

    public static Field getPrivateField(Class clazz, String string) throws NoSuchFieldException {
        Field field;
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                throw noSuchFieldException;
            }
            field = PojoOperations.getPrivateField(clazz2, string);
        }
        return field;
    }

    public static Serializable getPojoId(Object object, CacheClass cacheClass) throws CacheException {
        Class<?> clazz = object.getClass();
        String string = cacheClass.getIdPlaceholder();
        if (string != null) {
            return PojoOperations.getPojoId(object, string);
        }
        try {
            Method method = clazz.getMethod("getId", new Class[0]);
            return (Serializable)method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return PojoOperations.getPojoId(object, DEFAULT_ROW_ID_FIELD);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Class " + clazz.getName() + " does not allow access to internal Id.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CacheException(invocationTargetException.getTargetException());
        }
    }

    private static Serializable getPojoId(Object object, String string) throws CacheException {
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            if (ObjectFactory.isProxy(object)) {
                ((Shadow)object).shadowObject_fetchData();
            }
            return (Serializable)field.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Class " + clazz.getName() + " does not allow access to internal Id.");
        }
    }

    public static boolean idPlaceHolderAvailable(Object object, CacheClass cacheClass) {
        String string = cacheClass.getIdPlaceholder();
        if (string != null) {
            return true;
        }
        Class<?> clazz = object.getClass();
        try {
            clazz.getMethod("getId", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                clazz.getDeclaredField(DEFAULT_ROW_ID_FIELD);
                return true;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
        }
    }

    public static Id toId(Object object) {
        Id id = object instanceof Id ? (Id)object : (object instanceof String ? new Id((String)object) : (object instanceof Integer ? new Id((Integer)object) : new Id(object.toString())));
        return id;
    }

    public static void setPojoId(Object object, Serializable serializable, CacheClass cacheClass, DetachedObjectsManager detachedObjectsManager) throws CacheException {
        Member member = detachedObjectsManager.getIdSetter(object.getClass(), cacheClass);
        if (member == null) {
            return;
        }
        if (member instanceof Field) {
            PojoOperations.setPojoIdAsField(object, serializable, (Field)member);
        } else {
            PojoOperations.setPojoIdAsMethod(object, serializable, (Method)member);
        }
    }

    public static Member lookupPojoIdSetter(Class clazz, CacheClass cacheClass) {
        AccessibleObject accessibleObject;
        String string = cacheClass.getIdPlaceholder();
        if (string == null) {
            string = DEFAULT_ROW_ID_FIELD;
        }
        if (string.startsWith("get")) {
            accessibleObject = PojoOperations.lookupPojoIdSetterMethod(clazz, string);
            if (accessibleObject == null) {
                accessibleObject = PojoOperations.lookupPojoIdField(clazz, string);
            }
        } else {
            accessibleObject = PojoOperations.lookupPojoIdField(clazz, string);
            if (accessibleObject == null) {
                accessibleObject = PojoOperations.lookupPojoIdField(clazz, string);
            }
        }
        return accessibleObject;
    }

    private static Field lookupPojoIdField(Class clazz, String string) {
        try {
            Field field = PojoOperations.getPrivateField(clazz, string);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static Method lookupPojoIdSetterMethod(Class clazz, String string) {
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            method.setAccessible(true);
            Class<?> clazz2 = method.getReturnType();
            if (!string.startsWith("get")) {
                return null;
            }
            String string2 = "set" + string.substring(3);
            Method method2 = clazz.getMethod(string2, clazz2);
            return method2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static boolean setPojoIdAsField(Object object, Serializable object2, Field field) throws CacheException {
        Class<Object> clazz = field.getType();
        try {
            if (clazz.isAssignableFrom(String.class)) {
                object2 = object2.toString();
            } else if (PojoOperations.isNumberField(clazz) && !(object2 instanceof Number)) {
                if (clazz.equals(Integer.TYPE) || clazz.isAssignableFrom(Integer.class)) {
                    object2 = Integer.valueOf(object2.toString());
                } else if (clazz.equals(Long.TYPE) || clazz.isAssignableFrom(Long.class)) {
                    object2 = Long.valueOf(object2.toString());
                }
            }
            field.set(object, object2);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Insufficeint permissions to set Id in instance of " + object.getClass().getName());
        }
    }

    private static boolean isNumberField(Class clazz) {
        if (clazz.isAssignableFrom(Number.class)) {
            return true;
        }
        return clazz.isPrimitive();
    }

    public static List arrayToList(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.getComponentType().isPrimitive()) {
            int n = Array.getLength(object);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(Array.get(object, i));
            }
            return arrayList;
        }
        return Arrays.asList((Object[])object);
    }

    private static boolean setPojoIdAsMethod(Object object, Serializable object2, Method method) throws CacheException {
        try {
            Class<Object> clazz = method.getParameterTypes()[0];
            if (clazz.isAssignableFrom(String.class)) {
                object2 = object2.toString();
            } else if (object2 instanceof Id) {
                if (clazz.isAssignableFrom(Integer.class)) {
                    object2 = Integer.valueOf(object2.toString());
                } else if (clazz.isAssignableFrom(Long.class)) {
                    object2 = Long.valueOf(object2.toString());
                }
            }
            method.invoke(object, object2);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Insufficeint permissions to set Id in instance of " + object.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CacheException(invocationTargetException.getTargetException(), "Failed to set Id in instance of " + object.getClass().getName());
        }
    }
}

