/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.tools.objects;

import com.intersys.cache.SysDatabase;
import com.intersys.classes.Dictionary.ClassDefinition;
import com.intersys.classes.Dictionary.PropertyDefinition;
import com.intersys.classes.RelationshipObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheIndexData;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.TypeModifiers;
import com.intersys.pojo.tools.objects.DefaultMappingTool;
import com.intersys.pojo.tools.objects.Java2DBMapping;
import com.intersys.pojo.tools.objects.MappingToolInterface;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassMergeTool
implements MappingToolInterface,
TypeModifiers {
    private Database mDB;
    private Map mCollectedData;
    private Map mOriginMap;
    private Map mRelationships;
    private Set mNotFoundClasses;
    private static Object EmptyObject = new Object();
    private final MappingToolInterface mMappingProvider;

    public ClassMergeTool(Database database, MappingToolInterface mappingToolInterface) {
        this.mDB = database;
        this.mMappingProvider = mappingToolInterface;
        this.mCollectedData = new HashMap();
        this.mNotFoundClasses = new HashSet();
        this.mOriginMap = new HashMap();
        this.mRelationships = new HashMap();
    }

    public Java2DBMapping getCollectedDataProvider() {
        return new CollectedDataProvider();
    }

    private Set collectUnmappedFields(Class clazz) throws CacheException {
        CacheClass cacheClass = this.findCacheClass(clazz);
        if (cacheClass == null) {
            return null;
        }
        ClassData classData = (ClassData)this.mCollectedData.get(clazz);
        classData.createUnmappedFieldSet(cacheClass, this.mCollectedData, this.mDB, this);
        return null;
    }

    private Set getUnmappedFields(Class clazz) {
        if (this.findCacheClass(clazz) == null) {
            return new HashSet();
        }
        ClassData classData = (ClassData)this.mCollectedData.get(clazz);
        return classData.getUnmappedFields();
    }

    private void collectFieldDataNoException(Object object) {
        if (this.mCollectedData.containsKey(object)) {
            return;
        }
        try {
            this.collectFieldData(object);
        }
        catch (CacheException cacheException) {
            Member member = (Member)object;
            String string = member.getDeclaringClass() + ":" + member.getName();
            System.out.println("Cache Field for " + string + " is invalid in Cache");
        }
    }

    private FieldData getCollectedData(Object object) {
        Object v = this.mCollectedData.get(object);
        if (v == EmptyObject) {
            return null;
        }
        return (FieldData)v;
    }

    private void collectClassData(Class clazz) throws CacheException {
        CacheClass[] cacheClassArray;
        CacheClass cacheClass = this.findCacheClass(clazz);
        if (cacheClass == null) {
            return;
        }
        CandidateKeyInfo candidateKeyInfo = cacheClass.getBestCandidateKey();
        String string = candidateKeyInfo != null ? candidateKeyInfo.getSQLName() : null;
        ClassData classData = new ClassData(cacheClass.getIndexInfo(), string);
        classData.cacheClassName = cacheClass.getName();
        classData.sqlTableName = cacheClass.getSQLTableName();
        classData.isSerial = cacheClass.isSerial();
        classData.javaProjectionPackage = cacheClass.getJavaPackage();
        classData.javaProjectionClassName = cacheClass.getJavaClassName();
        int n = classData.javaProjectionClassName.lastIndexOf(46);
        if (n >= 0) {
            classData.javaProjectionClassName = classData.javaProjectionClassName.substring(n + 1);
        }
        if ((cacheClassArray = cacheClass.getCacheSuperclasses()).length > 1) {
            classData.secondarySupers = new String[cacheClassArray.length - 1];
        }
        for (int i = 0; i < cacheClassArray.length; ++i) {
            String string2 = cacheClassArray[i].getName();
            if (i == 0) {
                classData.primarySuper = string2;
            } else {
                classData.secondarySupers[i - 1] = string2;
            }
            if ("%Library.Populate".equals(string2)) {
                classData.isPopulatable = true;
            }
            if (!"%XML.Adaptor".equals(string2)) continue;
            classData.isXMLAdapter = true;
        }
        Map map = ClassMergeTool.getParameters(this.mDB, cacheClass);
        if (!map.isEmpty()) {
            classData.classParameters = map;
        }
        this.mCollectedData.put(clazz, classData);
    }

    private void collectFieldData(Object object) throws CacheException {
        CacheField cacheField = this.cacheFieldFor(object);
        if (cacheField == null) {
            this.mCollectedData.put(object, EmptyObject);
            return;
        }
        Member member = (Member)object;
        Class<?> clazz = member.getDeclaringClass();
        ClassData classData = (ClassData)this.mCollectedData.get(clazz);
        if (classData != null) {
            classData.fieldMapped(cacheField);
        }
        FieldData fieldData = new FieldData(cacheField, this.mDB);
        this.mCollectedData.put(object, fieldData);
        this.mOriginMap.put(cacheField, object);
        if (cacheField.isRelationship()) {
            int n = this.mMappingProvider.getPropertyKind(object);
            boolean bl = n != 0;
            this.collectRelationshipData(cacheField, bl);
        }
    }

    private CacheField cacheFieldFor(Object object) throws CacheException {
        Member member = (Member)object;
        Class<?> clazz = member.getDeclaringClass();
        CacheClass cacheClass = this.findCacheClass(clazz);
        if (cacheClass == null) {
            return null;
        }
        String string = this.mMappingProvider.cacheFieldNameFor(object, new HashSet());
        CacheField cacheField = cacheClass.getField(string);
        return cacheField;
    }

    private static String fieldId(CacheField cacheField) throws CacheException {
        String string = cacheField.getDeclaringCacheClass().getName();
        String string2 = cacheField.getName();
        return string + "||" + string2;
    }

    private static Map getParameters(Database database, CacheField cacheField) throws CacheException {
        String string = ClassMergeTool.fieldId(cacheField);
        PropertyDefinition propertyDefinition = (PropertyDefinition)PropertyDefinition._open(database, new Id(string));
        Map map = propertyDefinition.getParameters();
        Map map2 = ClassMergeTool.convertParametersMap(map);
        return map2;
    }

    private static Map getParameters(Database database, CacheClass cacheClass) throws CacheException {
        ClassDefinition classDefinition = (ClassDefinition)ClassDefinition._open(database, new Id(cacheClass.getName()));
        RelationshipObject relationshipObject = classDefinition.getParameters();
        Map map = ClassMergeTool.convertParametersMap(relationshipObject);
        return map;
    }

    private static Map convertParametersMap(Map map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private void collectRelationshipData(CacheField cacheField, boolean bl) throws CacheException {
        CacheRelationshipInfo cacheRelationshipInfo = new CacheRelationshipInfo();
        cacheRelationshipInfo.inverseClass = bl ? cacheField.getElementTypeName() : cacheField.getTypeName();
        cacheRelationshipInfo.inverseField = cacheField.getInverseFieldName();
        if (cacheField.isParentChildRelationship()) {
            cacheRelationshipInfo.parentChild = true;
        }
        cacheRelationshipInfo.pointsToManyOrChildren = bl;
        this.mRelationships.put(ClassMergeTool.fieldId(cacheField), cacheRelationshipInfo);
        CacheClass cacheClass = this.mDB.getCacheClass(cacheRelationshipInfo.inverseClass);
        CacheField cacheField2 = cacheClass.getField(cacheRelationshipInfo.inverseField);
        String string = ClassMergeTool.fieldId(cacheField2);
        if (this.mRelationships.containsKey(string)) {
            return;
        }
        cacheRelationshipInfo = new CacheRelationshipInfo();
        cacheRelationshipInfo.inverseClass = cacheField.getDeclaringCacheClass().getName();
        cacheRelationshipInfo.inverseField = cacheField.getName();
        if (cacheField.isParentChildRelationship()) {
            cacheRelationshipInfo.parentChild = true;
        }
        cacheRelationshipInfo.pointsToManyOrChildren = !bl;
        this.mRelationships.put(string, cacheRelationshipInfo);
    }

    private CacheClass findCacheClass(Class clazz) {
        if (this.mNotFoundClasses.contains(clazz)) {
            return null;
        }
        try {
            String string = this.cacheClassNameFor(clazz);
            return this.mDB.getCacheClass(string);
        }
        catch (CacheException cacheException) {
            if (cacheException.getCode() == 5351) {
                System.out.println("Cache Class for " + clazz.getName() + " not found in Cache");
            } else {
                cacheException.printFullTrace(System.out);
            }
            this.mNotFoundClasses.add(clazz);
            return null;
        }
    }

    public void addMetadataProvider(Java2DBMapping java2DBMapping) {
        this.mMappingProvider.addMetadataProvider(java2DBMapping);
    }

    public boolean testForExclusion(String string) {
        return this.mMappingProvider.testForExclusion(string);
    }

    public void setDependecies(Set set) {
    }

    public void setDefaultAccessLevel(int n) {
        this.mMappingProvider.setDefaultAccessLevel(n);
    }

    public void setDefaultAccessType(int n) {
        this.mMappingProvider.setDefaultAccessType(n);
    }

    public void setDefaultJavaProjectionPackage(String string) {
        this.mMappingProvider.setDefaultJavaProjectionPackage(string);
    }

    public void setIgnoreNestedGenerics(boolean bl) {
        this.mMappingProvider.setIgnoreNestedGenerics(bl);
    }

    public String cacheFieldNameFor(Object object, Set set) {
        this.collectFieldDataNoException(object);
        return null;
    }

    public String cacheFieldNameFor(Object object) {
        this.collectFieldDataNoException(object);
        return null;
    }

    public boolean isSerial(Class clazz) {
        return false;
    }

    public String getVersionID(Class clazz) {
        return null;
    }

    public int getPropertyKind(Object object) {
        this.collectFieldDataNoException(object);
        return -1;
    }

    public boolean isFetchTypeEager(Object object) {
        return false;
    }

    public boolean isClassTransient(Class clazz) {
        return false;
    }

    public boolean isMemberTransient(Object object) {
        return false;
    }

    public Map getPropertyParameters(Object object) {
        return null;
    }

    public String getDatabaseID(Class clazz) {
        return null;
    }

    public int getDatabaseIDType(Class clazz) {
        return -1;
    }

    public void close() {
    }

    public boolean isPopulatable(Class clazz) {
        return false;
    }

    public boolean isXMLSerializable(Class clazz) {
        return false;
    }

    public Map getClassParameters(Class clazz) {
        return null;
    }

    public String getExtendedClass(Class clazz) {
        return null;
    }

    public String[] getImplementedClasses(Class clazz) {
        return null;
    }

    public Set listUnmappedFields(Class clazz) {
        try {
            return this.collectUnmappedFields(clazz);
        }
        catch (CacheException cacheException) {
            return null;
        }
    }

    public String cacheMappedClassNameFor(String string) {
        return this.mMappingProvider.cacheMappedClassNameFor(string);
    }

    public void classMapped(String string, String string2, boolean bl) {
        this.mMappingProvider.classMapped(string, string2, bl);
        if (bl) {
            try {
                this.collectClassData(Class.forName(string, true, ((SysDatabase)this.mDB).getClassLoader()));
            }
            catch (CacheException cacheException) {
                throw new IllegalArgumentException(cacheException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Class not found: " + string);
            }
        }
    }

    public Map getTypemap() {
        return this.mMappingProvider.getTypemap();
    }

    public void addExclusions(Collection collection) {
        this.mMappingProvider.addExclusions(collection);
    }

    public boolean registerDependency(Class clazz) {
        return this.mMappingProvider.registerDependency(clazz);
    }

    public String cacheFieldTypeFor(Object object) {
        this.collectFieldDataNoException(object);
        return null;
    }

    public CacheRelationshipInfo relationshipFor(Object object) {
        return null;
    }

    public String cacheClassNameFor(Class clazz) {
        return this.mMappingProvider.cacheClassNameFor(clazz);
    }

    public String sqlTableNameFor(Class clazz) {
        return null;
    }

    public String primaryKeyNameFor(Class clazz) {
        return null;
    }

    public CacheIndexInfo[] allIndicesFor(Class clazz) {
        return null;
    }

    public int getAccessLevel(Class clazz) {
        return this.mMappingProvider.getAccessLevel(clazz);
    }

    public String getJavaProjectionPackage(Class clazz) {
        return null;
    }

    public String getJavaProjectionClassName(Class clazz) {
        return null;
    }

    public int getAccessType(Class clazz) {
        return this.mMappingProvider.getAccessType(clazz);
    }

    public void setDefaultReplacement(char c, String string) {
        this.mMappingProvider.setDefaultReplacement(c, string);
    }

    public void setUseGettersOnly(boolean bl) {
        this.mMappingProvider.setUseGettersOnly(bl);
    }

    private class CollectedDataProvider
    implements DefaultMappingTool.ClassMerger {
        private CollectedDataProvider() {
        }

        public String cacheFieldNameFor(Object object) {
            FieldData fieldData = ClassMergeTool.this.getCollectedData(object);
            if (fieldData != null) {
                return fieldData.name;
            }
            return null;
        }

        public String cacheFieldTypeFor(Object object) {
            FieldData fieldData = ClassMergeTool.this.getCollectedData(object);
            if (fieldData != null) {
                return fieldData.type;
            }
            return null;
        }

        public Set listUnmappedFields(Class clazz) {
            return ClassMergeTool.this.getUnmappedFields(clazz);
        }

        public CacheRelationshipInfo relationshipFor(Object object) {
            CacheField cacheField = null;
            try {
                if (object instanceof Member) {
                    cacheField = ClassMergeTool.this.cacheFieldFor(object);
                    if (cacheField == null) {
                        return null;
                    }
                    object = ClassMergeTool.fieldId(cacheField);
                }
                return (CacheRelationshipInfo)ClassMergeTool.this.mRelationships.get(object);
            }
            catch (CacheException cacheException) {
                return null;
            }
        }

        public String cacheClassNameFor(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.cacheClassName;
        }

        public String sqlTableNameFor(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.sqlTableName;
        }

        public String primaryKeyNameFor(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.bestKey;
        }

        public CacheIndexInfo[] allIndicesFor(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.allIndices;
        }

        public int getAccessLevel(Class clazz) {
            return -1;
        }

        public int getAccessType(Class clazz) {
            return -1;
        }

        public String getJavaProjectionPackage(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.javaProjectionPackage;
        }

        public String getJavaProjectionClassName(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.javaProjectionClassName;
        }

        public boolean isSerial(Class clazz) {
            return false;
        }

        public String getVersionID(Class clazz) {
            return null;
        }

        public int getPropertyKind(Object object) {
            FieldData fieldData = ClassMergeTool.this.getCollectedData(object);
            if (fieldData != null) {
                return fieldData.collectionType;
            }
            return -1;
        }

        public boolean isFetchTypeEager(Object object) {
            return false;
        }

        public boolean isClassTransient(Class clazz) {
            return false;
        }

        public boolean isMemberTransient(Object object) {
            return false;
        }

        public Map getPropertyParameters(Object object) {
            FieldData fieldData = ClassMergeTool.this.getCollectedData(object);
            if (fieldData != null) {
                return fieldData.parameters;
            }
            return null;
        }

        public String getDatabaseID(Class clazz) {
            return null;
        }

        public int getDatabaseIDType(Class clazz) {
            return -1;
        }

        public void close() {
        }

        public boolean isPopulatable(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return false;
            }
            return classData.isPopulatable;
        }

        public boolean isXMLSerializable(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return false;
            }
            return classData.isXMLAdapter;
        }

        public Map getClassParameters(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.classParameters;
        }

        public String getExtendedClass(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.primarySuper;
        }

        public String[] getImplementedClasses(Class clazz) {
            ClassData classData = (ClassData)ClassMergeTool.this.mCollectedData.get(clazz);
            if (classData == null) {
                return null;
            }
            return classData.secondarySupers;
        }
    }

    private static class ClassData {
        CacheIndexInfo[] allIndices;
        String bestKey;
        String cacheClassName;
        String sqlTableName;
        String javaProjectionPackage;
        String javaProjectionClassName;
        boolean isPopulatable;
        boolean isXMLAdapter;
        Map classParameters;
        String primarySuper;
        String[] secondarySupers;
        boolean isSerial;
        private Set unMappedFields;
        private Set mappedFields;

        public ClassData(CacheIndexInfo[] cacheIndexInfoArray, String string) throws CacheException {
            if (cacheIndexInfoArray == null || cacheIndexInfoArray.length == 0) {
                return;
            }
            ArrayList<CacheIndexData> arrayList = new ArrayList<CacheIndexData>(cacheIndexInfoArray.length);
            for (int i = 0; i < cacheIndexInfoArray.length; ++i) {
                String string2 = cacheIndexInfoArray[i].getName();
                if (string2 == null || string2.startsWith("$")) continue;
                arrayList.add(new CacheIndexData(cacheIndexInfoArray[i]));
            }
            this.allIndices = new CacheIndexInfo[arrayList.size()];
            this.allIndices = arrayList.toArray(this.allIndices);
            this.bestKey = string;
            this.isPopulatable = false;
            this.isXMLAdapter = false;
            this.classParameters = null;
            this.primarySuper = null;
            this.secondarySupers = null;
        }

        public void fieldMapped(CacheField cacheField) throws CacheException {
            if (this.mappedFields == null) {
                this.mappedFields = new HashSet();
            }
            this.mappedFields.add(ClassMergeTool.fieldId(cacheField));
        }

        public void createUnmappedFieldSet(CacheClass cacheClass, Map map, Database database, ClassMergeTool classMergeTool) throws CacheException {
            this.unMappedFields = new HashSet();
            CacheField[] cacheFieldArray = cacheClass.getFields();
            for (int i = 0; i < cacheFieldArray.length; ++i) {
                FieldData fieldData;
                String string;
                block4: {
                    CacheClass cacheClass2 = cacheFieldArray[i].getDeclaringCacheClass();
                    if (!cacheClass.equals(cacheClass2)) continue;
                    string = ClassMergeTool.fieldId(cacheFieldArray[i]);
                    if (this.mappedFields != null && this.mappedFields.contains(string)) continue;
                    fieldData = null;
                    try {
                        boolean bl;
                        fieldData = new FieldData(cacheFieldArray[i], database);
                        boolean bl2 = bl = fieldData.collectionType != 0;
                        if (cacheFieldArray[i].getInverseFieldName() == null) break block4;
                        classMergeTool.collectRelationshipData(cacheFieldArray[i], bl);
                    }
                    catch (CacheException cacheException) {
                        continue;
                    }
                }
                this.unMappedFields.add(string);
                map.put(string, fieldData);
            }
            if (this.mappedFields != null) {
                this.mappedFields.clear();
            }
        }

        public Set getUnmappedFields() {
            return this.unMappedFields;
        }
    }

    private static class FieldData {
        public String name;
        public String type;
        public int collectionType;
        public Map parameters;

        public FieldData(CacheField cacheField, Database database) throws CacheException {
            this.name = cacheField.getName();
            this.collectionType = cacheField.getCollectionType();
            this.type = this.collectionType == 0 ? cacheField.getTypeName() : cacheField.getElementTypeName();
            this.parameters = ClassMergeTool.getParameters(database, cacheField);
        }
    }
}

