/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.tools.objects;

import com.intersys.cache.ClassAnalizer;
import com.intersys.pojo.tools.objects.DefaultMappingProvider;
import com.intersys.pojo.tools.objects.DefaultMappingTool;
import com.intersys.pojo.tools.objects.MappingToolInterface;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JavaCacheClassMapper {
    protected MappingToolInterface mMappingTool;
    protected Set mDependencies = new HashSet();
    protected Class mInitialClass;

    public JavaCacheClassMapper() {
        this.mMappingTool = new DefaultMappingTool(this.mDependencies);
    }

    public void setORMTool(MappingToolInterface mappingToolInterface) {
        this.mMappingTool = mappingToolInterface;
        this.mMappingTool.setDependecies(this.mDependencies);
    }

    public void setDefaultReplacement(char c, String string) {
        this.mMappingTool.setDefaultReplacement(c, string);
    }

    public void setDefaultAccessLevel(int n) {
        int n2;
        if (Modifier.isPrivate(n)) {
            n2 = 2;
        } else if (Modifier.isProtected(n)) {
            n2 = 4;
        } else if (Modifier.isPublic(n)) {
            n2 = 1;
        } else {
            throw new IllegalArgumentException("Invalid value for access level:" + n);
        }
        this.mMappingTool.setDefaultAccessLevel(n2);
    }

    public void addExclusions(Collection collection) {
        this.mMappingTool.addExclusions(collection);
    }

    public void ignoreNestedGenerics() {
        this.mMappingTool.setIgnoreNestedGenerics(true);
    }

    public void mapClass(Class clazz) throws Exception {
        int n = this.mMappingTool.getAccessType(clazz);
        switch (n) {
            case 12001: {
                this.mapClassByFields(clazz);
                break;
            }
            case 12002: {
                this.mapInterface(clazz, true);
                break;
            }
            case 12006: {
                this.mapInterface(clazz, false);
                break;
            }
            case 12004: {
                throw new IllegalArgumentException("Setters Only are not implemented.");
            }
            default: {
                throw new IllegalArgumentException("Unknown access type: " + n);
            }
        }
    }

    private void mapClassByFields(Class clazz) throws Exception {
        Set set = ClassAnalizer.getPersistableFields(clazz, null, this.mMappingTool.getAccessLevel(clazz), false);
        this.mapInternal(clazz, set);
    }

    private void mapInterface(Class clazz, boolean bl) throws Exception {
        Set set = ClassAnalizer.getGetSetPairs(clazz, this.mMappingTool.getAccessLevel(clazz), bl);
        this.mapInternal(clazz, set);
    }

    public void mapBean(Class clazz) throws Exception {
        this.mapInterface(clazz, false);
    }

    private void mapInternal(Class clazz, Set set) throws Exception {
        this.mInitialClass = clazz;
        Package package_ = clazz.getPackage();
        String string = package_ == null ? null : package_.getName();
        String string2 = clazz.getName();
        if (string != null && string2.startsWith(string)) {
            string2 = string2.substring(string.length() + 1);
        }
        this.mapClass(set, clazz);
    }

    protected void mapClass(Set set, Class clazz) throws Exception {
        this.mapClassName(clazz);
        this.mapAllFields(set, new HashSet(), clazz);
        this.mapUnmappedFields(clazz);
    }

    public Set getDependencies(boolean bl) {
        if (bl && this.mInitialClass != null) {
            Set set = ClassAnalizer.getMethodDependentTypes(this.mInitialClass, this.mMappingTool.getAccessLevel(this.mInitialClass));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                if (!this.mMappingTool.isClassTransient(clazz) && DefaultMappingProvider.testForPrimitiveType(clazz) == null && !this.mMappingTool.testForExclusion(clazz.getName())) continue;
                iterator.remove();
            }
            set.addAll(this.mDependencies);
            return set;
        }
        return this.mDependencies;
    }

    public Map getTypeMap() {
        HashMap hashMap = new HashMap();
        Map map = this.mMappingTool.getTypemap();
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    protected String mapClassName(Class clazz) throws Exception {
        String string = clazz.getName();
        String string2 = this.mMappingTool.cacheMappedClassNameFor(string);
        if (string2 != null) {
            return string;
        }
        string2 = this.mMappingTool.cacheClassNameFor(clazz);
        if (this.mInitialClass == null) {
            this.mInitialClass = clazz;
        }
        this.mMappingTool.classMapped(string, string2, true);
        return string;
    }

    protected void mapField(Object object, Set set, Set set2) throws Exception {
        Class clazz = DefaultMappingProvider.typeOfField(object);
        String string = this.mMappingTool.cacheFieldTypeFor(object);
        String string2 = clazz.getName();
        if (!(Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || clazz.isArray())) {
            this.mMappingTool.classMapped(string2, string, false);
        }
        this.generateField(object, set, set2, clazz, string, string2);
    }

    protected void generateField(Object object, Set set, Set set2, Class clazz, String string, String string2) throws Exception {
    }

    protected void mapUnmappedFields(Class clazz) throws Exception {
        this.mMappingTool.listUnmappedFields(clazz);
    }

    protected void enableVersionChecking(Field field, Set set, Set set2) throws Exception {
    }

    protected boolean mapAllFields(Set set, Set set2, Class clazz) throws Exception {
        String string;
        Object object;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>(set.size());
        String string2 = this.mMappingTool.getVersionID(clazz);
        if (string2 != null) {
            object = clazz.getDeclaredField(string2);
            this.enableVersionChecking((Field)object, hashSet, set2);
        }
        if (this.handleIdField(clazz, (String)(object = this.mMappingTool.getDatabaseID(clazz)))) {
            object = null;
        }
        for (Member member : set) {
            string = member.getName();
            if (string.equals(string2) || string.equals(object)) continue;
            hashSet.add(string);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Member member;
            bl = true;
            member = (Member)iterator.next();
            string = member.getName();
            if (string.equals(string2) || string.equals(object)) continue;
            this.mapField(member, hashSet, set2);
        }
        return bl;
    }

    private boolean handleIdField(Class clazz, String string) throws Exception {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        int n = this.mMappingTool.getDatabaseIDType(clazz);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ID type: " + n + " for class " + clazz.getName());
            }
        }
        this.handleIdField(clazz, string, n);
        return bl;
    }

    protected void handleIdField(Class clazz, String string, int n) throws Exception {
    }
}

