/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.HashMap;
import java.util.Map;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class ApplicationCommandInputValidator {
    static final String TIMEOUT = "-timeout";
    static final String GRACEFUL = "-graceful";
    private static String DEFAULT_TIMEOUT_VAL = "0";
    private static String DEFAULT_GRACEFUL_VAL = "true";

    static void validateTimeout(String timeout, String command) throws AdminCommandException {
        try {
            if (timeout != null && Integer.valueOf(timeout) < 0) {
                throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("invalid_parameter_value", new String[]{TIMEOUT, command, "Valid value is time in seconds >= 0."}), command);
            }
        }
        catch (NumberFormatException e) {
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("invalid_parameter_value", new String[]{TIMEOUT, command, "Valid value is time in seconds."}), command);
        }
    }

    static void validateGracefulMode(String graceful, String command) throws AdminCommandException {
        if (graceful != null && !graceful.equalsIgnoreCase("true") && !graceful.equalsIgnoreCase("false")) {
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("invalid_parameter_value", new String[]{GRACEFUL, command, "Valid values are [true|false]."}), command);
        }
    }

    static Map addToParamsMap(String timeout, String graceful) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (timeout == null) {
            params.put(TIMEOUT.substring(1, TIMEOUT.length()), DEFAULT_TIMEOUT_VAL);
        } else {
            params.put(TIMEOUT.substring(1, TIMEOUT.length()), timeout);
        }
        if (graceful == null) {
            params.put(GRACEFUL.substring(1, GRACEFUL.length()), DEFAULT_GRACEFUL_VAL);
        } else {
            params.put(GRACEFUL.substring(1, GRACEFUL.length()), graceful);
        }
        return params;
    }
}

